/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class HeteroChain
extends Structure {
    protected String atom;
    protected String atom2 = null;
    protected int multiplicity;

    public HeteroChain(String atom, int multiplicity) {
        this.atom = atom;
        this.multiplicity = multiplicity;
    }

    public HeteroChain(String atom1, String atom2, int multiplicity) {
        this.atom = atom1;
        this.atom2 = atom2;
        this.multiplicity = multiplicity;
    }

    public String getAtom() {
        return this.atom;
    }

    public void setAtom(String value) {
        this.atom = value;
    }

    public String getAtom2() {
        return this.atom2;
    }

    public void setAtom2(String atom2) {
        this.atom2 = atom2;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(int multiplicity) {
        this.multiplicity = multiplicity;
    }

    @Override
    protected String printValue() {
        String atom2 = this.atom2 == null ? "" : " " + this.atom2;
        return '\"' + this.atom + atom2 + " " + this.multiplicity + '\"';
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        HeteroChain newStructure = new HeteroChain(this.atom, this.atom2, this.multiplicity);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected Molecule getMol() {
        Molecule mol1 = this.readMol(this.atom);
        Molecule mol = new Molecule();
        mol.fuse(this.atom2 == null ? this.readMol(this.atom) : this.readMol(this.atom2));
        if (this.atom2 != null) {
            Molecule mol2 = this.readMol(this.atom2);
            mol1.fuse(mol2);
            mol1.add(new MolBond(mol1.getAtom(0), mol2.getAtom(0)));
        }
        for (int i = 0; i < this.multiplicity - 1; ++i) {
            mol.add(new MolBond(mol.getAtom(mol.getAtomCount() - 1), mol1.getAtom(0)));
            mol.fuse(mol1);
            mol1 = mol1.cloneMolecule();
        }
        return mol;
    }

    @Override
    protected String toSmiles() {
        this.atom = this.removeHydrogens(this.atom);
        this.atom2 = this.removeHydrogens(this.atom2);
        String smiles = this.atom2 == null ? this.atom : this.atom2;
        for (int i = 0; i < this.multiplicity - 1; ++i) {
            smiles = this.atom2 != null ? smiles + this.atom + this.atom2 : smiles + this.atom;
        }
        return smiles;
    }

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    @Override
    protected void connectSuffixes(ArrayList<Suffix> suffixList) {
        super.connectSuffixes(suffixList);
    }

    @Override
    public boolean hasLocant(Locant loc) {
        if (loc instanceof AtomLocant) {
            return this.hasAtom(((AtomLocant)loc).getAtomSymbol(), true);
        }
        return Util.locantToInt(loc) <= (this.atom2 == null ? this.multiplicity : this.multiplicity * 2);
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return this.atom.equals(atomSymbol) || this.atom2 != null && this.atom2.equals(atomSymbol);
    }
}

