/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.RingNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.RingUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class MonoCyclicSpiroSytem
extends Structure {
    protected LocantList numbering;
    protected String atom;
    protected String atom2 = null;

    public MonoCyclicSpiroSytem(LocantList numbering, String atom) {
        this.numbering = numbering;
        this.atom = atom;
        if (this.atom.endsWith("|")) {
            this.atom = this.atom.substring(0, this.atom.length() - 1);
        }
    }

    public MonoCyclicSpiroSytem(LocantList numbering, String atom, String atom2) {
        this.numbering = numbering;
        this.atom = atom;
        this.atom2 = atom2;
        if (this.atom.endsWith("|")) {
            this.atom = this.atom.substring(0, this.atom.length() - 1);
        }
    }

    public LocantList getNumbering() {
        return this.numbering;
    }

    public String getAtom2() {
        return this.atom2;
    }

    public void setAtom2(String atom2) {
        this.atom2 = atom2;
    }

    @Override
    protected String printValue() {
        String atom2 = this.atom2 == null ? "" : " " + this.atom2;
        return '\"' + this.numbering.toString() + " " + this.atom + atom2 + '\"';
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenList) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        MonoCyclicSpiroSytem newStructure = new MonoCyclicSpiroSytem(this.numbering, this.atom);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected Molecule getMol() {
        return this.readMol(this.toSmiles());
    }

    @Override
    protected String toSmiles() {
        String smiles = "";
        IntVector v = new IntVector();
        if (this.numbering.size() == 2) {
            smiles = this.getSimpleRing(this.numbering, this.atom, this.atom2);
        } else if (this.numbering.size() > 2) {
            smiles = this.getComplexRing(this.numbering, this.atom, this.atom2, v);
        }
        this.setAtomMap(v);
        return smiles;
    }

    private String getSimpleRing(LocantList numbering, String atom, String atom2) {
        int num2;
        int num1 = numbering.getLocant(0).getValue();
        if (num1 > (num2 = numbering.getLocant(1).getValue())) {
            int tmp = num1;
            num1 = num2;
            num2 = tmp;
        }
        String chain = atom + "1";
        if (atom2 == null) {
            int i;
            for (i = 0; i < num1; ++i) {
                chain = chain + atom;
            }
            chain = chain + "12";
            for (i = 0; i < num2; ++i) {
                chain = chain + atom;
            }
            chain = chain + "2";
        } else {
            int i;
            for (i = 0; i < num1; ++i) {
                chain = chain + (i % 2 == 0 ? atom2 : atom);
            }
            chain = chain + "12";
            for (i = 0; i < num2; ++i) {
                chain = chain + ((num1 + i) % 2 == 0 ? atom2 : atom);
            }
            chain = chain + "2";
        }
        return chain;
    }

    private String getComplexRing(LocantList numbering, String atom, String atom2, IntVector atomnumbers) {
        String retVal = atom2 != null ? this.build(numbering, atom, atom2, atomnumbers) : this.build(numbering, atom, atomnumbers);
        return retVal;
    }

    private String build(LocantList numbering, String atom, IntVector atomnumbers) {
        StringBuffer retVal = new StringBuffer();
        int locant = 0;
        int tmploc = 0;
        int ringIndex = 0;
        for (int i = 0; i < numbering.size(); ++i) {
            RingNumber ringnum = (RingNumber)numbering.getLocant(i);
            if (ringnum.getFirst() == 0) {
                this.realign(retVal, tmploc);
                for (int j = 0; j <= ringnum.getValue(); ++j) {
                    RingUtil.appendAtom(retVal, atomnumbers, atom, ++locant);
                }
                tmploc = locant;
                continue;
            }
            RingUtil.appendBridge(retVal, atomnumbers, tmploc, ringnum.getFirst(), ringnum.getValue(), ++ringIndex, atom, ++locant);
            locant += ringnum.getValue() - 1;
            tmploc = ringnum.getFirst();
        }
        RingUtil.appendBridge(retVal, atomnumbers, 1, numbering.getLocant(0).getValue() + 1, 0, ++ringIndex, atom, 0);
        return retVal.toString();
    }

    private String build(LocantList numbering, String atom1, String atom2, IntVector atomnumbers) {
        StringBuffer retVal = new StringBuffer();
        int locant = 0;
        int tmploc = 0;
        int shift = 0;
        int sh = 0;
        int ringIndex = 0;
        String[] atoms = new String[]{atom2, atom1};
        for (int i = 0; i < numbering.size(); ++i) {
            RingNumber ringnum = (RingNumber)numbering.getLocant(i);
            if (ringnum.getFirst() == 0) {
                this.realign(retVal, tmploc);
                for (int j = 0; j <= ringnum.getValue(); ++j) {
                    RingUtil.appendAtom(retVal, atomnumbers, atoms[sh++ % 2], ++locant);
                }
                tmploc = locant;
                continue;
            }
            RingUtil.appendBridge(retVal, atomnumbers, tmploc, ringnum.getFirst(), ringnum.getValue(), ++ringIndex, atoms, ++locant, sh % 2);
            locant += ringnum.getValue() - 1;
            tmploc = ringnum.getFirst();
        }
        String tmp = retVal.substring(0, numbering.getLocant(0).getValue() + 1);
        shift = tmp.indexOf(atom1) > tmp.indexOf(atom2) ? 1 : 0;
        RingUtil.appendBridge(retVal, atomnumbers, 1, numbering.getLocant(0).getValue() + 1, 0, ++ringIndex, atoms, 0, shift);
        return retVal.toString();
    }

    private void realign(StringBuffer strbuff, int atomnumber) {
        int pos = Util.getLastIndexOfElement(strbuff.toString(), atomnumber);
        if (pos < strbuff.length() - 1 && pos > 0) {
            strbuff.insert(pos + 1, '(').append(')');
        }
    }

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    @Override
    public boolean hasLocant(Locant loc) {
        if (loc instanceof AtomLocant) {
            return this.hasAtom(((AtomLocant)loc).getAtomSymbol(), true);
        }
        MonoCyclicSpiroSytem clone = (MonoCyclicSpiroSytem)this.cloneStructure();
        Molecule mol = null;
        mol = clone.getMol();
        return clone.atomMap.containsKey(Util.locantToInt(loc)) || clone.atomMap.isEmpty() && mol.getAtomCount() >= Util.locantToInt(loc);
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return this.getHeteroAtomCountOf(atomSymbol) > 0 || atomSymbol.equals(this.atom) || this.atom2 != null && atomSymbol.equals(this.atom2);
    }
}

