/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class NucleoBase
extends SimpleStructure {
    public NucleoBase(String value, String name) {
        super(value, name);
    }

    public NucleoBase(String value, String name, LocantList locants) {
        super(value, name, locants);
    }

    @Override
    protected Molecule buildMolecule() {
        if (this.molecule == null) {
            this.stereoLocants.tryAddLocant(this.defaultStereo);
            if (!IUPACParserCore.revolution) {
                this.handleMultipliedPhosphates();
            }
            this.addHydroxyGroups();
            return super.buildMolecule();
        }
        return this.molecule;
    }

    protected void addHydroxyGroups() {
        SimpleStructure oxy1 = new SimpleStructure("O", "hydroxy");
        oxy1.setLocantInParent(new SimpleLocant(2, 1));
        this.addHydroxyGroup(oxy1);
        SimpleStructure oxy2 = new SimpleStructure("O", "hydroxy");
        oxy2.setLocantInParent(new SimpleLocant(3, 1));
        this.addHydroxyGroup(oxy2);
        SimpleStructure oxy3 = new SimpleStructure("O", "hydroxy");
        oxy3.setLocantInParent(new SimpleLocant(5, 1));
        this.addHydroxyGroup(oxy3);
    }

    protected void addHydroxyGroup(SimpleStructure oxy) {
        if (this.ignoredBySuffix(oxy)) {
            return;
        }
        ArrayList<Structure> addToOxy = new ArrayList<Structure>();
        Locant locant = oxy.getLocantInParent().getLocant(0);
        for (int i = 0; i < this.substituentCount(); ++i) {
            Locant l;
            Structure s = this.getSubstituent(i);
            if (!s.hasLocant() || !((l = s.getLocantInParent().getLocant(0)) instanceof SimpleLocant) || l.getParent() != locant.getParent() || l.getValue() != locant.getValue()) continue;
            if (s instanceof SimpleStructure && ((SimpleStructure)s).getName().equals("deoxy")) {
                this.removeSubstituent(i);
                return;
            }
            addToOxy.add(s);
        }
        while (!addToOxy.isEmpty()) {
            Structure s = (Structure)addToOxy.remove(0);
            if (Util.isAcetate(s)) {
                this.setOxyToAttach(s);
            }
            oxy.addSubstituent(s);
            s.setLocantInParent(1);
            this.removeSubstituent(s);
        }
        this.addSubstituent(oxy);
    }

    protected boolean ignoredBySuffix(SimpleStructure oxy) {
        Locant locant = oxy.getLocantInParent().getLocant(0);
        for (int i = 0; i < this.suffixCount(); ++i) {
            Locant l;
            Suffix s = this.getSuffix(i);
            if (!s.hasLocant() || !((l = s.getLocant().getLocant(0)) instanceof SimpleLocant) || l.getParent() != locant.getParent() || l.getValue() != locant.getValue()) continue;
            if (s.getType() == 4) {
                return true;
            }
            if (s.getType() != 2 || this.parent == null) continue;
            return true;
        }
        return false;
    }

    protected void handleMultipliedPhosphates() {
        for (int i = 0; i < this.substituentCount(); ++i) {
            SimpleStructure ss;
            if (!(this.getSubstituent(i) instanceof SimpleStructure) || !(ss = (SimpleStructure)this.getSubstituent(i)).getName().equals("phosphate")) continue;
            this.createPhosphateChain(i);
            return;
        }
    }

    private void setOxyToAttach(Structure s) {
        if (s.spaceAttach.isEmpty() || s.spaceSeparated) {
            return;
        }
        int index = s.spaceAttach.remove(0);
        s.buildMolecule();
        index = s.getAtomIndex(index);
        s.molecule.getAtom(index).setAliasstr("toremove");
    }

    private void createPhosphateChain(int subIndex) {
        StringBuffer smi;
        Structure struc = this.getSubstituent(subIndex);
        int mul = this.getPhosphateChain(struc, smi = new StringBuffer(""));
        if (mul == 1) {
            return;
        }
        StringBuffer numbering = new StringBuffer("");
        IntVector spaceAttach = new IntVector();
        this.getPhosphateChainNumbering(numbering, mul, spaceAttach);
        smi.append(numbering);
        System.out.println("SMI " + smi);
        SimpleStructure newStructure = new SimpleStructure(smi.toString(), mul + "phosphate", struc.getLocantInParent());
        struc.cloneProperties(newStructure);
        newStructure.spaceAttach = spaceAttach;
        newStructure.setSpaceSeparated(true);
        newStructure.locantsBefore = null;
        this.removeSubstituent(struc);
        this.addSubstituent(newStructure);
    }

    private int getPhosphateChain(Structure struc, StringBuffer smi) {
        int mul = 1;
        smi.append("P(=O)([O-])O");
        String P = "P(=O)([O-])O";
        while (struc.substituentCount() > 0 && struc.getSubstituent(0).isCloneOf(struc.getCloneOf())) {
            ++mul;
            struc.removeSubstituent(0);
            smi.append(P);
        }
        smi.delete(smi.length() - 1, smi.length());
        smi.append("[O-]");
        return mul;
    }

    private void getPhosphateChainNumbering(StringBuffer numbering, int mul, IntVector spaceAttach) {
        numbering.append(" |$");
        int sp = 2 * mul + 1;
        spaceAttach.add(2 * mul);
        for (int i = 0; i < 2 * mul; i += 2) {
            String s = i + 1 + ";;" + sp + ";" + (i + 2);
            numbering.append(s);
            if (i + 2 < 2 * mul) {
                numbering.append(";");
            }
            spaceAttach.add(sp++);
        }
        numbering.append("$|");
    }
}

