/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyRingSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;

public class PolyCane
extends PolyRingSystem {
    public PolyCane(int mul, boolean isAromatic) {
        super(mul, isAromatic);
    }

    @Override
    public Structure cloneStructure() {
        PolyCane newStructure = new PolyCane(this.multiplier, this.isAromatic);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected String build() {
        int i;
        char C = this.isAromatic ? (char)'c' : 'C';
        int locant = 1;
        int ring = 2;
        StringBuffer value = new StringBuffer();
        StringBuffer numbering = new StringBuffer("|$");
        value.append(C + "1");
        numbering.append(locant);
        for (i = 0; i < 3; ++i) {
            this.addAtom(value, numbering, -1, C, ++locant, -1);
        }
        for (i = 0; i < this.multiplier - 1; ++i) {
            this.addAtom(value, numbering, ring++, C, locant, 1);
            this.addAtom(value, numbering, -1, C, ++locant, -1);
        }
        for (i = 0; i < 2; ++i) {
            this.addAtom(value, numbering, -1, C, ++locant, -1);
        }
        for (i = 0; i < this.multiplier - 1; ++i) {
            this.addAtom(value, numbering, -1, C, ++locant, -1);
            this.addAtom(value, numbering, --ring, C, locant, 1);
        }
        value.append("1 ");
        numbering.append("$|");
        return value.toString() + numbering.toString();
    }

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    @Override
    protected boolean isMultiplierValid() {
        return this.multiplier > 1;
    }
}

