/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public abstract class PolyRingSystem
extends Structure {
    int multiplier;
    boolean isAromatic = false;

    public PolyRingSystem(int mul, boolean isAromatic) {
        this.multiplier = mul;
        this.isAromatic = isAromatic;
        if (!this.isMultiplierValid()) {
            throw new NameImportException("Invalid ringsystem definition in name.");
        }
    }

    @Override
    protected String printValue() {
        return this.multiplier + " " + this.isAromatic + " " + this.build();
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public abstract Structure cloneStructure();

    @Override
    protected Molecule getMol() {
        return this.readMol(this.toSmiles());
    }

    @Override
    protected String toSmiles() {
        String smi = this.build();
        this.setAtomMap(smi);
        return smi.indexOf(32) > 0 ? smi.substring(0, smi.indexOf(32)) : smi;
    }

    protected abstract String build();

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    protected void addAtom(StringBuffer smi, StringBuffer numbering, int ring, char atom, int locant, int a) {
        String percent;
        String string = percent = ring > 9 ? "%" : "";
        if (ring > 0) {
            String num = "0" + a;
            smi.append(atom + percent + ring);
            numbering.append(";" + locant + num);
        } else {
            smi.append(atom);
            numbering.append(";" + locant);
        }
    }

    @Override
    public boolean hasLocant(Locant loc) {
        if (loc instanceof AtomLocant) {
            return this.hasAtom(((AtomLocant)loc).getAtomSymbol(), true);
        }
        PolyRingSystem clone = (PolyRingSystem)this.cloneStructure();
        clone.getMol();
        return clone.atomMap.containsKey(Util.locantToInt(loc));
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return this.getHeteroAtomCountOf(atomSymbol) > 0;
    }

    protected boolean isMultiplierValid() {
        return true;
    }
}

