/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyRingSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;

public class PolyaLene
extends PolyRingSystem {
    public PolyaLene(int mul) {
        super(mul, false);
    }

    @Override
    protected String build() {
        int i;
        char C = 'C';
        int locant = 1;
        StringBuffer value = new StringBuffer();
        StringBuffer numbering = new StringBuffer("|$");
        boolean doublebond = false;
        value.append(C + "1=");
        numbering.append(locant);
        for (i = 0; i < this.multiplier - 3; ++i) {
            this.addAtom(value, numbering, -1, C, ++locant, -1);
            if (doublebond) {
                value.append('=');
            }
            doublebond = !doublebond;
        }
        this.addAtom(value, numbering, 2, C, locant, 1);
        if (doublebond) {
            value.append('=');
        }
        doublebond = !doublebond;
        for (i = 0; i < this.multiplier - 2; ++i) {
            this.addAtom(value, numbering, -1, C, ++locant, -1);
            if (doublebond) {
                value.append('=');
            }
            doublebond = !doublebond;
        }
        this.addAtom(value, numbering, 2, C, locant, 1);
        if (doublebond) {
            value.append('=');
        }
        value.append("1 ");
        numbering.append("$|");
        return value.toString() + numbering.toString();
    }

    @Override
    public Structure cloneStructure() {
        PolyaLene newStructure = new PolyaLene(this.multiplier);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected boolean isMultiplierValid() {
        return this.multiplier > 2;
    }
}

