/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyRingSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;

public class PolyaPhene
extends PolyRingSystem {
    public PolyaPhene(int mul, boolean isAromatic) {
        super(mul, isAromatic);
    }

    @Override
    public Structure cloneStructure() {
        PolyaPhene newStructure = new PolyaPhene(this.multiplier, this.isAromatic);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected String build() {
        int i;
        char C = this.isAromatic ? (char)'c' : 'C';
        int locant = 1;
        int ring = 2;
        StringBuffer value = new StringBuffer();
        StringBuffer numbering = new StringBuffer("|$");
        value.append(C + "1");
        numbering.append(locant);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.addAtom(value, numbering, -1, C, ++locant, -1);
        }
        int mul = this.multiplier % 2 == 0 ? (this.multiplier - 2) / 2 : (this.multiplier - 1) / 2;
        for (int i3 = 0; i3 < mul - 1; ++i3) {
            this.addAtom(value, numbering, ring++, C, locant, 1);
            this.addAtom(value, numbering, -1, C, ++locant, -1);
        }
        this.addAtom(value, numbering, ring++, C, locant, 1);
        this.addAtom(value, numbering, -1, C, ++locant, -1);
        this.addAtom(value, numbering, -1, C, ++locant, -1);
        this.addAtom(value, numbering, ring++, C, locant, 1);
        int mul2 = this.multiplier % 2 == 0 ? mul + 1 : mul;
        for (i = 0; i < mul2 - 1; ++i) {
            this.addAtom(value, numbering, -1, C, ++locant, -1);
            this.addAtom(value, numbering, ring++, C, locant, 1);
        }
        for (i = 0; i < 4; ++i) {
            this.addAtom(value, numbering, -1, C, ++locant, -1);
        }
        for (i = 0; i < mul2 - 1; ++i) {
            this.addAtom(value, numbering, --ring, C, locant, 1);
            this.addAtom(value, numbering, -1, C, ++locant, -1);
        }
        this.addAtom(value, numbering, --ring, C, locant, 1);
        this.addAtom(value, numbering, --ring, C, locant, 2);
        for (i = 0; i < mul - 1; ++i) {
            this.addAtom(value, numbering, -1, C, ++locant, -1);
            this.addAtom(value, numbering, --ring, C, locant, 1);
        }
        value.append("1 ");
        numbering.append("$|");
        return value.toString() + numbering.toString();
    }
}

