/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BondNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.NonStdValenceLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Amine;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.RingUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SaltEnding;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class SimpleStructure
extends Structure {
    public static final int NOT_SET = 0;
    public static final int CARBOXY = 1;
    public static final int SULFINYL = 2;
    public static final int AMINO_ACID = 3;
    public static final int REPLACEMENT = 4;
    protected String name;
    protected String value;
    protected int type = 0;
    LocantList locantsBefore;
    protected boolean salt = false;

    protected SimpleStructure() {
    }

    public SimpleStructure(String value, String name, LocantList locants) {
        this(value, name, 0);
        String sname;
        if (locants == null) {
            return;
        }
        if (!this.suffixList.isEmpty() && (sname = ((Suffix)this.suffixList.get(0)).getName()) != null && sname.equals("on") && this.getSuffix(0).setLocantIfExpectedSize(locants)) {
            this.setLocantsOfToluquinone(locants);
            return;
        }
        if (!this.substituentList.isEmpty()) {
            for (int i = 0; i < locants.size(); ++i) {
                if (i >= this.substituentList.size()) {
                    throw new NameImportException("Too many locants: " + locants);
                }
                Structure substituent = (Structure)this.substituentList.get(this.substituentList.size() - i - 1);
                Locant locant = locants.getLocant(i);
                if (locant instanceof NonStdValenceLocant) {
                    this.nonStdValence.tryAddLocant(locant);
                    locant = new SimpleLocant(locant.getValue(), ((NonStdValenceLocant)locant).getParent());
                }
                substituent.setLocantInParent(locant);
            }
            return;
        }
        if (!this.suffixList.isEmpty() && this.getSuffix(0).setLocantIfExpectedSize(locants)) {
            return;
        }
        if (!this.rgroups.isEmpty()) {
            for (int i = 0; i < locants.size() && i < this.rgroups.size(); ++i) {
                this.getRGroup(this.rgroups.size() - 1 - i).setNeighbour(locants.getLocant(i).getValue());
            }
            return;
        }
        if (IUPACParserCore.revolution) {
            this.locantsBefore = locants;
        }
    }

    public SimpleStructure(String value, String name) {
        this(value, name, 0);
    }

    public SimpleStructure(String value, String name, int type) {
        this.name = name;
        this.handleValue(value, type);
        this.setType(name);
        this.isConnectionPointDefaultForSuffix = name != null && name.contains("iso");
    }

    protected void handleValue(String value, int type) {
        String[] flags = this.getFlags(value);
        value = flags == null ? value : value.substring(0, value.indexOf(123));
        String suff = null;
        this.type = type;
        this.handleFlags(this, flags);
        if (value.startsWith("=")) {
            suff = "|=";
            value = value.substring(1);
        } else if (value.startsWith("#")) {
            suff = "|#";
            value = value.substring(1);
        } else if (value.startsWith("&")) {
            value = value.substring(1);
        }
        if (value.endsWith("|") && value.indexOf(32) < 0) {
            value = value.substring(0, value.length() - 1);
        }
        this.value = value;
        if (suff != null) {
            Suffix s = SuffixFactory.createSuffix(suff, "yl", (LocantList)null, 1, 2);
            this.addSuffix(s);
        }
    }

    private void setType(String name) {
        if (this.type > 0 || name == null) {
            return;
        }
        if (name.indexOf("sulfinyl") > -1) {
            this.type = 2;
        } else if (name.matches("(thi|selen|tellur)[o]?")) {
            this.type = 4;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public boolean isCyclic() {
        return Util.basicSmiles(this.value).indexOf(49) != -1;
    }

    @Override
    public void addSubstituent(Structure structure) {
        if (!this.canHasSubstituent()) {
            this.parent.addSubstituent(structure);
        } else {
            super.addSubstituent(structure);
            if (this.type == 4) {
                this.setType(0);
            }
        }
    }

    @Override
    public void addSubstituent(ArrayList<Structure> strucList) {
        if (!this.canHasSubstituent()) {
            this.parent.addSubstituent(strucList);
        } else {
            super.addSubstituent(strucList);
            if (this.type == 4) {
                this.setType(0);
            }
        }
    }

    private boolean canHasSubstituent() {
        if (this.type != 4 || this.isSpaceSeparated() || this.parent == null || !(this.parent instanceof SimpleStructure)) {
            return true;
        }
        String smi = ((SimpleStructure)this.parent).getValue();
        return smi == null || !smi.contains("O");
    }

    private String[] getFlags(String flags) {
        if (flags.indexOf(123) < 0) {
            return null;
        }
        return flags.substring(flags.indexOf(123) + 1, flags.indexOf(125)).split(";");
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    protected String printValue() {
        return this.value + '\t' + this.type() + (this.locantsBefore == null || !this.locantsBefore.hasLocant() ? "" : " locsBefore:" + this.locantsBefore);
    }

    private String type() {
        switch (this.type) {
            case 3: {
                return "AMINO ACID";
            }
            case 1: {
                return "CARBOXY";
            }
            case 2: {
                return "SULFINYL";
            }
        }
        return "";
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        SimpleStructure newStructure = new SimpleStructure(this.value, this.name);
        this.cloneProperties(newStructure);
        newStructure.setType(this.type);
        return newStructure;
    }

    @Override
    protected Molecule getMol() {
        String smi = RingUtil.dictFormatToSmiles(this.value);
        this.setAtomMap(smi);
        String smiles = this.cutNumbering(smi);
        Molecule mol = this.readMol(smiles);
        if (smiles.indexOf("|$") > 0) {
            this.setAtomMap(smi, mol);
            this.setRgroups(mol);
        }
        this.handleAlphaBeta(mol);
        return mol;
    }

    private void handleAlphaBeta(Molecule mol) {
        if (this.locantInParent == null) {
            return;
        }
        if (this.parent != null) {
            return;
        }
        SimpleLocant l = this.locantInParent.getSimpleLocant();
        if (l == null) {
            return;
        }
        if (l.greekLetter == 'b') {
            int a = l.getValue();
            int chirality = mol.getChirality(a = ((Integer)this.atomMap.get(a)).intValue());
            if (chirality == 8) {
                mol.setChirality(a, 16);
            } else if (chirality == 8) {
                mol.setChirality(a, 16);
            }
        }
    }

    @Override
    protected String toSmiles() {
        String smiles = RingUtil.dictFormatToSmiles(this.value);
        this.setAtomMap(smiles);
        return this.cutNumbering(smiles);
    }

    protected void setAtomMap(String smiles, Molecule mol) {
        if (smiles.indexOf(32) < 0) {
            return;
        }
        String map = smiles.substring(smiles.lastIndexOf("|$") + 2, smiles.length() - 2);
        String[] locants = map.split(";");
        int index = 0;
        int numbering = 90;
        for (int i = 0; i < locants.length; ++i) {
            if (locants[i].length() > 0) {
                if (locants[i].equals("_")) {
                    this.atomMap.put(numbering++, index);
                } else {
                    this.atomMap.put(new Integer(Util.stringToLocant(locants[i])), index);
                }
            }
            if (Util.isRGroup(mol.getAtom(i))) continue;
            ++index;
        }
    }

    protected void setRgroups(Molecule mol) {
        mol.implicitizeHydrogens(2047);
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            if (!Util.isRGroup(atom)) continue;
            this.addRgroup(mol, atom);
            mol.removeAtom(atom);
            --i;
        }
    }

    protected void addRgroup(Molecule mol, MolAtom rAtom) {
        Structure.RGroup rgroup = new Structure.RGroup(this.rgroups.size());
        for (int i = 0; i < rAtom.getBondCount(); ++i) {
            MolAtom otherAtom = rAtom.getBond(i).getOtherAtom(rAtom);
            int nindex = mol.indexOf(otherAtom);
            nindex = nindex < mol.indexOf(rAtom) ? nindex : nindex - 1;
            nindex = this.getMappedIndex(nindex);
            rgroup.addNeighbour(nindex, rAtom.getBond(i).getType());
        }
        this.rgroups.add(rgroup);
    }

    private String cutNumbering(String smiles) {
        if (smiles.indexOf("_R") > 0 && smiles.lastIndexOf("_R") > smiles.lastIndexOf("|$")) {
            return smiles;
        }
        int index = smiles.lastIndexOf("|$");
        if (index > 0) {
            return smiles.substring(0, index);
        }
        return smiles;
    }

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    @Override
    protected void getAtomNumbers(IntVector vec, int radMul) {
        super.getAtomNumbers(vec, radMul);
        this.changeAtomNumbers(vec);
    }

    private void changeAtomNumbers(IntVector vec) {
        if (this.atomMap.isEmpty() && this.basicAtomCount == 0) {
            vec.clear();
            int atomCount = Util.atomCount(this.value);
            for (int i = 0; i < atomCount; ++i) {
                vec.add(i + 1);
            }
        }
        if (this.type == 1 && vec.size() >= Util.atomCount(this.getValue())) {
            vec.remove(vec.size() - 1);
        } else if (this.type == 2 && vec.size() > 2) {
            vec.remove(vec.size() - 1);
            vec.remove(vec.size() - 1);
        }
    }

    private boolean hasLigandOnIndex(int index) {
        for (Structure ligand : this.substituentList) {
            if (!ligand.hasLocant() || ligand.getLocantInParent().getLocant(0).getValue() != index) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getMaxLocant() {
        int ret = super.getMaxLocant();
        if (this.type == 1) {
            --ret;
        } else if (this.type == 2) {
            ret -= 2;
        }
        return ret;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.locantInParent + " " + this.name + (this.molecule == null ? "" : " " + this.molecule.toFormat("cxsmiles")) + (this.isExplicitSingle() ? " explicitSingle" : "") + (this.locantsBefore == null ? "" : "locBefore:" + this.locantsBefore);
    }

    protected boolean addSuffix(Molecule mol, Suffix s, SimpleLocant locant1, int locant2) {
        return super.addSuffix(mol, s, locant1, locant2);
    }

    @Override
    protected void calcLocants(Suffix suffix) {
        super.calcLocants(suffix);
        if (suffix.getType() == 2 && Util.isCharbonChain(this.getValue())) {
            int number = suffix.getLocant().getLocant(0).getValue();
            if (this.molecule.getAtom(this.getAtomIndex(number)).getImplicitHcount() == 0) {
                number = this.basicAtomCount - number + 1;
                SimpleLocant loc = new SimpleLocant(number, 0);
                LocantList ll = new LocantList();
                ll.tryAddLocant(loc);
                suffix.setLocant(ll);
            }
        } else if (this.getType() == 1 && suffix.getMultiplicity() == 1) {
            LocantList ll = new LocantList();
            ll.tryAddLocant(new SimpleLocant(this.basicAtomCount, 0));
            suffix.setLocant(ll);
        }
    }

    @Override
    public boolean hasLocant(Locant loc) {
        if (loc instanceof AtomLocant) {
            return this.hasAtom(((AtomLocant)loc).getAtomSymbol(), true);
        }
        int locant = Util.locantToInt(loc);
        if (this.getType() == 1) {
            return locant <= Util.atomCount(this.getValue()) - 1;
        }
        if (this.atomMap.containsKey(locant)) {
            return true;
        }
        if (!this.atomMap.isEmpty()) {
            return false;
        }
        if (this.getValue().indexOf("|$") > 0) {
            if (loc instanceof BondNumber) {
                loc = ((BondNumber)loc).getFirstLocant();
            }
            return this.getValue().indexOf(loc.toString()) > -1;
        }
        if (this.getValue().indexOf(58) < 0) {
            return Util.atomCount(this.getValue()) >= locant;
        }
        return this.getValue().indexOf(":" + locant + "]") > -1;
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return this.getHeteroAtomCountOf(atomSymbol) + this.atomCountOf(atomSymbol) > 0;
    }

    protected int atomCountOf(String atomSymbol) {
        int index;
        String lowerValue = this.getValue().toLowerCase();
        int mul = 0;
        while ((index = lowerValue.indexOf(atomSymbol.toLowerCase())) > -1) {
            ++mul;
            lowerValue = lowerValue.substring(index + 1);
        }
        return mul;
    }

    @Override
    protected int getAtomIndex(int mappedIndex, int molindex) throws NameImportException {
        int index = -1;
        try {
            index = super.getAtomIndex(mappedIndex, molindex);
            if (index == -1) {
                index = Integer.MAX_VALUE;
            }
        }
        catch (NameImportException e) {
            index = Integer.MAX_VALUE;
        }
        if (index < 0x7FFFFFF5) {
            return index;
        }
        switch (mappedIndex) {
            case 0x7FFFFFFE: 
            case 0x7FFFFFFF: {
                mappedIndex = Util.greekLetterToNumbering(mappedIndex);
                MolAtom atom1 = this.molecule.getAtom(this.getAtomIndex(1, molindex));
                if (atom1.getImplicitHcount() != 0 || this.hasLigandOn(atom1)) break;
                ++mappedIndex;
                break;
            }
            case 0x7FFFFFFD: {
                mappedIndex = Util.atomCount(this.value);
                break;
            }
        }
        return super.getAtomIndex(mappedIndex, molindex);
    }

    private boolean hasLigandOn(MolAtom atom) {
        if (!this.isBasicAtom(atom)) {
            return false;
        }
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolAtom other = atom.getBond(i).getOtherAtom(atom);
            if (this.isBasicAtom(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void connectLigands(ArrayList<Structure> ligands) {
        int charge;
        Structure ligand;
        if (ligands.isEmpty()) {
            return;
        }
        if (this.is("borate") && ligands.size() == 1 && (ligand = ligands.get(0)).isSpaceSeparated() && ligand.multiplicity == 1) {
            ligands.add(ligand.cloneStructure());
            ligands.add(ligand.cloneStructure());
        }
        if (this.getName() != null && this.getName().startsWith("iminometh")) {
            MolAtom carbon = this.molecule.getAtom(0);
            for (int i = 0; i < carbon.getBondCount(); ++i) {
                if (carbon.getBond(i).getType() != 3) continue;
                carbon.getBond(i).setType(2);
            }
        }
        Structure structure = ligand = ligands.size() == 1 ? ligands.get(0) : null;
        if (this.salt && ligands.size() == 1 && ligand.isSpaceSeparated() && (charge = this.getMoleculeCharge(ligand)) > 0) {
            int mul = Math.abs(this.molecule.getAtom(0).getCharge() / charge);
            for (int i = 0; i < mul - 1; ++i) {
                ligands.add(ligand.cloneStructure());
            }
        }
        super.connectLigands(ligands);
    }

    @Override
    protected void connectSuffix(Suffix suffix) {
        SimpleStructure s;
        if (suffix.getType() == 3 && this.getMolecule().getAtomCount() == 1 && this.hasIonLigand()) {
            suffix.setMultiplicity(this.molecule.getImplicitHcount());
            this.salt = true;
        }
        if (!suffix.hasLocant() && this.locantsBefore != null) {
            suffix.setLocant(this.locantsBefore);
            this.locantsBefore = null;
        }
        if (this.isYlene() && !suffix.hasLocant() && suffix.getMultiplicity() == 1 && !suffix.getName().equals("ylene") && (s = suffix.buildStructure()) != null) {
            Molecule m = s.buildMolecule();
            MolAtom connectionPoint = m.getAtom(s.getAtomIndex(1));
            if (connectionPoint.getImplicitHcount() == 1) {
                if ((suffix instanceof SaltEnding || "cyanide".equals(suffix.getName())) && this.substituentList.isEmpty() && (this.suffixList.size() == 1 || this.suffixList.size() == 2 && this.hasSuffix("ylene"))) {
                    suffix.setMultiplicity(2);
                }
            } else {
                Molecule parentMol = this.buildMolecule();
                parentMol.fuse(m);
                parentMol.add(new MolBond(connectionPoint, parentMol.getAtom(this.getAtomIndex(1))));
                parentMol.add(new MolBond(connectionPoint, parentMol.getAtom(this.getAtomIndex(this.value.length()))));
                return;
            }
        }
        super.connectSuffix(suffix);
    }

    protected boolean hasIonLigand() {
        for (Structure s : this.getSubstituentList()) {
            if (this.getMoleculeCharge(s) <= 0) continue;
            return true;
        }
        return false;
    }

    private void setLocantsOfToluquinone(LocantList locants) {
        if (!this.name.startsWith("toluquinon")) {
            return;
        }
        if (locants.size() > 2) {
            this.getSubstituent(0).setLocantInParent(locants.getLocant(2));
            return;
        }
        for (int i = 0; i < locants.size(); ++i) {
            if (locants.getLocant(i).getValue() != 2) continue;
            this.getSubstituent(0).setLocantInParent(1);
            return;
        }
    }

    @Override
    protected void preProcess() {
        this.checkBorateGroup();
        this.methylenecheck();
        this.cloneLigandCheck();
        if (this.getName() != null && this.getName().equals("hemihydrate") && this.substituentCount() == 1) {
            Structure clone = this.getSubstituent(0).cloneStructure();
            this.addSubstituent(clone);
            return;
        }
        if (this.value.equals("CC") && this.hasSuffix("ylene") && this.removeEthyleneDoubleBond()) {
            this.removeSuffix("ylene");
        }
    }

    private boolean removeEthyleneDoubleBond() {
        if (this.getParent() instanceof Amine && ((Amine)this.getParent()).getMultiplicity() > 1) {
            return true;
        }
        for (int i = 0; i < this.suffixCount(); ++i) {
            Suffix s = this.getSuffix(i);
            if (s.getMultiplicity() > 2) {
                return false;
            }
            if (s.getMultiplicity() == 2 && s.getType() != 0 && s.getType() != 4) {
                return true;
            }
            if (s.getMultiplicity() != 1 || s.getType() != 8) continue;
            boolean isDoubleSuffix = false;
            if (i < this.suffixCount() - 1) {
                Suffix next = this.getSuffix(i + 1);
                boolean bl = isDoubleSuffix = next.getType() == 8;
            }
            if (i < this.suffixCount() - 2) {
                Suffix nextnext = this.getSuffix(i + 2);
                boolean bl = isDoubleSuffix = nextnext.getType() != 8;
            }
            if (!isDoubleSuffix) continue;
            return true;
        }
        return false;
    }

    private void cloneLigandCheck() {
        if (this.parent == null || Util.atomCount(this.getValue()) != 1 || this.substituentCount() < 2 || !this.hasCloneLigands() || this.hasCharge()) {
            return;
        }
        Molecule mol = this.readMol(this.getValue());
        if (mol.getImplicitHcount() == 0) {
            return;
        }
        for (int i = 0; i < this.substituentCount() + 1; ++i) {
            Molecule tmpC = this.readMol("C");
            mol.fuse(tmpC);
            mol.add(new MolBond(mol.getAtom(0), tmpC.getAtom(0)));
        }
        mol.valenceCheck();
        if (mol.hasValenceError()) {
            this.parent.addSubstituent(this.substituentList);
            this.substituentList = new ArrayList();
        }
    }

    private boolean hasCharge() {
        if (this.getValue().contains("-") || this.getValue().contains("+")) {
            return true;
        }
        for (int i = 0; i < this.suffixCount(); ++i) {
            if (this.getSuffix(i).getType() != 7) continue;
            return true;
        }
        return false;
    }

    private boolean hasCloneLigands() {
        if (this.substituentCount() < 2) {
            return false;
        }
        Structure first = this.getSubstituent(0);
        for (int i = 1; i < this.substituentCount(); ++i) {
            if (this.getSubstituent(i).isCloneOf(first)) continue;
            return false;
        }
        return true;
    }

    private void methylenecheck() {
        if (this.value == null && Util.atomCount(this.value) != 1) {
            return;
        }
        if (this.parent == null || this.getFirstSuffixWithStructureProp() < 0) {
            return;
        }
        for (Suffix s : this.suffixList) {
            if (s.getName() == null || !s.getName().startsWith("ylen")) continue;
            this.suffixList.remove(s);
            break;
        }
    }

    private void checkBorateGroup() {
        if (!"bor".equals(this.getName())) {
            return;
        }
        if (this.substituentCount() == 0 || this.suffixCount() != 1 || this.getSuffix(0).getType() != 4 || !"at".equals(this.getSuffix(0).getName())) {
            return;
        }
        Structure ligand = this.getSubstituent(0);
        int index = 1;
        while (index < this.substituentCount() && this.getSubstituent(index).isCloneOf(ligand)) {
            this.addAcetGroup(index++);
        }
        if (index > 1) {
            this.removeSuffix(0);
            this.addAcetGroup(index);
        }
    }

    private void addAcetGroup(int index) {
        this.value = this.value + "([O-])";
        this.spaceAttach.add(index);
        this.atomMap.put(index, index);
    }

    @Override
    public boolean isChain() {
        return super.isChain() || Util.isChain(this.value);
    }
}

