/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;

public class Suffix {
    public static final int NOT_SET = -1;
    public static final int ACID = 0;
    public static final int AMINE = 1;
    public static final int RADICAL = 2;
    public static final int SALT = 3;
    public static final int ACETATE = 4;
    public static final int AMIDE = 5;
    public static final int POLYRINGSYSTEM = 6;
    public static final int ION = 7;
    public static final int FROMSTRUCTURE = 8;
    protected int type;
    protected String value;
    protected LocantList locant = new LocantList();
    protected int multiplicity;
    protected int tokenCount;
    protected boolean locantCalculated = false;
    protected String name;
    protected Structure structure = null;
    protected int radical = 1;
    protected boolean spaceSeparated = false;

    public Suffix(String value, LocantList locant, int mul, int type, int tokenCount) {
        this.value = value;
        if (locant != null) {
            this.locant.tryAddLocant(locant);
        }
        this.multiplicity = mul;
        this.type = type;
        this.tokenCount = tokenCount;
    }

    public Suffix(String value, LocantList locant, int mul, int type, int tokenCount, int radical) {
        this(value, locant, mul, type, tokenCount);
        this.radical = radical;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public LocantList getLocant() {
        return this.locant;
    }

    public void setLocant(LocantList locant) {
        this.locant = locant;
    }

    public boolean setLocantIfExpectedSize(LocantList locant) {
        if ((locant = locant.expandOMP(this.locant.size())).size() == this.locant.size()) {
            this.locant = locant;
            return true;
        }
        return false;
    }

    public void setLocant(Locant locant) {
        this.locant = new LocantList();
        this.locant.addLocant(locant);
    }

    public void addLocant(Locant locant) {
        this.locant.tryAddLocant(locant);
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(int mul) {
        this.multiplicity = mul;
    }

    public boolean isLocantCalculated() {
        return this.locantCalculated;
    }

    public void setLocantCalculated(boolean locantCalculated) {
        this.locantCalculated = locantCalculated;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean is(String name) {
        return name.equals(this.name);
    }

    public boolean is(String name, int multiplicity) {
        return this.is(name) && this.multiplicity == multiplicity;
    }

    public int tokenCount() {
        return this.tokenCount;
    }

    public int getRadical() {
        return this.radical;
    }

    public void setRadical(int radical) {
        this.radical = radical;
    }

    public boolean isSpaceSeparated() {
        return this.spaceSeparated;
    }

    public void setSpaceSeparated(boolean spaceSeparated) {
        this.spaceSeparated = spaceSeparated;
    }

    public Suffix cloneSuffix() {
        Suffix suffix = new Suffix(this.value, this.locant, this.multiplicity, this.type, this.tokenCount, this.radical);
        suffix.setName(this.getName());
        return suffix;
    }

    public boolean hasLocant() {
        return this.getLocant() != null && this.getLocant().size() != 0;
    }

    public int getLocantCount() {
        if (this.getLocant() == null) {
            return 0;
        }
        return this.getLocant().size();
    }

    public String toString() {
        if (this.type == 8) {
            return this.locant + " " + this.structure;
        }
        return this.locant + " " + this.name + " " + this.value;
    }

    protected int getRadicalMultiplicity() {
        int mul = this.getRadical();
        if (this.value.startsWith("=") || this.value.startsWith("|=")) {
            mul = 2;
        } else if (this.value.startsWith("#") || this.value.startsWith("|#")) {
            mul = 3;
        } else if (this.value.startsWith("&")) {
            mul = 0;
        } else if (this.type == 7) {
            mul = -1;
        }
        return mul;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    SimpleStructure buildStructure() {
        String value = this.getValue();
        if (value == null || value.startsWith("|")) {
            return null;
        }
        return new SimpleStructure(value, this.getName());
    }

    public void parentIsCyclic() {
        if (this.is("oyl")) {
            this.value = "C(=O)";
            this.radical = 1;
        }
    }
}

