/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Atom;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BracketToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.EndingToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Hydro;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.IonNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Number;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Separator;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StructureToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AcidGenerator;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SaltEnding;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import java.util.ArrayList;

public class SuffixFactory {
    public static Suffix createSuffix(ArrayList<Token> tokens, int index, int firstIndex) {
        Suffix suffix = null;
        Token token = tokens.get(index);
        if (token instanceof EndingToken) {
            int radical;
            boolean step = false;
            String value = token.getValue();
            String name = token.getName();
            Token tokenBefore = index > 0 ? tokens.get(index - 1) : null;
            int type = SuffixFactory.getSuffixType(token, tokenBefore, index - firstIndex - 1);
            ArrayList<Token> t = new ArrayList<Token>();
            t.add(0, token);
            int mul = 1;
            String atom = null;
            boolean hydro = false;
            token = SuffixFactory.getNextToken(tokens, --index, firstIndex);
            if (token != null && type == 3) {
                atom = token.getValue();
                t.add(0, token);
                hydro = index - 1 > firstIndex && tokens.get(index - 1) instanceof Hydro;
                step = true;
                --index;
                if (hydro) {
                    t.add(0, tokens.get(index - 1));
                    --index;
                }
            } else if (token != null && type == 0) {
                int i = t.size();
                t.remove(0);
                value = token.getValue().equalsIgnoreCase("carbonic acid") ? AcidGenerator.createPolyCarbonicAcid(tokens, index + 1, t) : AcidGenerator.createAcid(tokens, index + 1, t);
                index -= t.size() - i;
                step = t.size() - i > 0;
            } else if (value.equalsIgnoreCase("[ION]") || name.endsWith("ion") && type == 7) {
                Token token1;
                boolean validToken = index > 0 && index > firstIndex;
                Token token2 = token1 = validToken ? tokens.get(index - 1) : null;
                if (token instanceof Separator && token.getType() == 3 && Util.isIonNumbering(token1)) {
                    LocantList numbering = (LocantList)((BracketToken)token1).getInside().get(0);
                    IonNumber ionNumber = (IonNumber)numbering.getLocant(0);
                    mul = ionNumber.getValue();
                    value = ionNumber.getCharge() > 0 ? "+" : "-";
                    t.add(token);
                    t.add(token1);
                    index -= 2;
                } else if (index > firstIndex) {
                    value = "";
                    t.add(token);
                    --index;
                }
            } else if (name.equalsIgnoreCase("peroxol")) {
                Token t0;
                Token token3 = t0 = index > 0 ? tokens.get(index) : null;
                if (index > -1 && t0 != null && (t0.getName().equals("thio") || t0.getName().equals("seleno") || t0.getName().equals("telluro"))) {
                    Token t3;
                    t.add(0, t0);
                    boolean validToken = --index > 2 && index > firstIndex;
                    Token t1 = validToken ? tokens.get(index) : null;
                    Token t2 = validToken ? tokens.get(index - 1) : null;
                    Token token4 = t3 = validToken ? tokens.get(index - 2) : null;
                    if (index > 1 && t1 instanceof Separator && t2 instanceof Atom && t3 instanceof Atom) {
                        value = t3.getValue() + t2.getValue();
                        t.add(0, t1);
                        t.add(0, t2);
                        t.add(0, t3);
                        index -= 3;
                    }
                }
            }
            if (step) {
                token = SuffixFactory.getNextToken(tokens, index, firstIndex);
                step = false;
            }
            if (token != null && token instanceof Number && token.getType() != 2) {
                mul = ((Number)token).getData();
                t.add(0, token);
                --index;
                step = true;
            }
            if ((token = SuffixFactory.getNextToken(tokens, index, firstIndex)) instanceof Separator && token.getType() == 2) {
                t.add(0, token);
                --index;
            }
            token = SuffixFactory.getNextToken(tokens, index, firstIndex);
            LocantList locant = null;
            if (Util.isNumbering(token)) {
                t.add(0, token);
                --index;
                LocantList locantList = locant = token instanceof LocantList ? (LocantList)token : (LocantList)((BracketToken)token).getInside().get(0);
            }
            if ((radical = SuffixFactory.getRadical(value)) != 1) {
                value = SuffixFactory.remRadicalFlag(value);
            }
            token = SuffixFactory.getNextToken(tokens, index, firstIndex);
            boolean spaceSep = index > 0 && SuffixFactory.isSpace(token);
            Suffix suffix2 = suffix = atom == null || tokens.size() == 2 ? new Suffix(value, locant, mul, type, t.size(), radical) : new SaltEnding(value, mul, atom, t.size(), hydro, radical);
            if (name.endsWith("e")) {
                name = name.substring(0, name.length() - 1);
            }
            suffix.setName(name);
            suffix.setSpaceSeparated(spaceSep);
        }
        return suffix;
    }

    public static int getRadical(String value) {
        int index = -1;
        index = value.indexOf("Radical:");
        if (index > 0) {
            return Integer.parseInt(value.substring(index + 8, index + 9));
        }
        if (value.startsWith("&") || value.startsWith("|&")) {
            return 0;
        }
        if (value.startsWith("=") || value.startsWith("|=")) {
            return 2;
        }
        if (value.startsWith("#") || value.startsWith("|#")) {
            return 3;
        }
        return 1;
    }

    public static String remRadicalFlag(String value) {
        int flagStart = value.indexOf(123) + 1;
        if (flagStart < 1) {
            return value;
        }
        String begin = value.substring(0, flagStart);
        if (value.indexOf(59, flagStart) < 0) {
            return value.substring(0, flagStart - 1).trim();
        }
        String end = value.substring(value.indexOf(59, flagStart) + 1);
        return begin + end;
    }

    private static Token getNextToken(ArrayList<Token> tokens, int index, int first) {
        return index > -1 && index > first ? tokens.get(index) : null;
    }

    public static int getSuffixType(Token actToken, Token tokenBefore, int maxlen) {
        int type = -1;
        if (actToken.getValue().startsWith("|")) {
            type = 2;
        } else if (actToken.getName().endsWith("ate") && !actToken.getName().equals("hydrate")) {
            type = 4;
        } else if (actToken.getName().indexOf("amid") > -1 || actToken.getName().indexOf("hydrazide") > -1) {
            type = 5;
        } else if (actToken.getName().indexOf("imin") > -1 || actToken.getName().indexOf("amin") > -1) {
            type = 1;
        } else if (SuffixFactory.isPolyRingSystemEnding(actToken)) {
            type = 6;
        } else if (actToken.getValue().matches("([+|-]h[+|-])|\\+|-") || actToken.getName().equals("[ION]")) {
            type = 7;
        }
        if (maxlen > 0 && actToken.getValue().equalsIgnoreCase("[SALT]") && (IUPACParserCore.revolution || tokenBefore != null && tokenBefore instanceof StructureToken)) {
            type = 3;
        } else if (actToken.getName().endsWith("acid")) {
            type = 0;
        }
        return type;
    }

    public static Suffix createSuffix(String value, String name, LocantList locant, int mul, int type) {
        Suffix suffix = new Suffix(value, locant, mul, type, 1);
        suffix.setName(name);
        suffix.setRadical(SuffixFactory.getRadical(value));
        return suffix;
    }

    public static Suffix createSuffix(String value, String name, LocantList locant, int mul, int type, int radical) {
        Suffix suffix = new Suffix(value, locant, mul, type, 1, radical);
        suffix.setName(name);
        return suffix;
    }

    public static Suffix createSuffix(String value, String name, Locant locant, int mul, int type) {
        LocantList locants = new LocantList();
        locants.addLocant(locant);
        Suffix suffix = new Suffix(value, locants, mul, type, 1);
        suffix.setName(name);
        suffix.setRadical(SuffixFactory.getRadical(value));
        return suffix;
    }

    public static boolean isPolyCane(String s) {
        return s.equals("can") || s.equals("cane") || s.equals("cen") || s.equals("cene");
    }

    public static boolean isPolyRingSystemEnding(Token token) {
        if (token == null || !(token instanceof EndingToken)) {
            return false;
        }
        String value = token.getValue();
        return value.startsWith("[POLY_");
    }

    private static boolean isSpace(Token token) {
        if (token == null) {
            return false;
        }
        return token instanceof Separator && token.getType() == 3;
    }
}

