/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import java.util.ArrayList;

public class TertChain
extends SimpleStructure {
    public TertChain(String value, String name) {
        super(value.substring(1), name);
        SimpleStructure s = new SimpleStructure("C", "tert");
        s.addLocant(new SimpleLocant(2, 0));
        this.addSubstituent(s);
    }

    @Override
    protected void connectSuffixes(ArrayList<Suffix> suffixList) {
        super.connectSuffixes(suffixList);
        LocantList l = new LocantList();
        l.tryAddLocant(new SimpleLocant(2, 0));
        if (this.radicals.isEmpty()) {
            this.radicals.add(SuffixFactory.createSuffix("|", "yl", l, 1, 2));
        } else {
            Suffix s = (Suffix)this.radicals.get(0);
            s.setLocant(l);
        }
    }

    @Override
    protected void setAtomMap(String smiles) {
        for (int i = 0; i < this.value.length(); ++i) {
            this.atomMap.put(i + 1, i);
        }
        this.atomMap.put(0x7FFFFFFE, 0);
    }

    @Override
    public Structure cloneStructure() {
        TertChain newStructure = new TertChain(this.value + "C", this.name);
        newStructure.removeSubstituent(0);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected int getMinLocant() {
        return 2;
    }

    @Override
    protected void getAtomNumbers(IntVector vec) {
        super.getAtomNumbers(vec);
        vec.removeElement(2);
        vec.add(0, 2);
    }

    @Override
    protected void getAtomNumbers(IntVector vec, int radMul) {
        super.getAtomNumbers(vec, radMul);
        vec.removeElement(2);
        vec.add(0, 2);
    }

    @Override
    protected boolean needRadical(int index) {
        if (index == 2) {
            return false;
        }
        return super.needRadical(index);
    }

    @Override
    public boolean isChain() {
        return true;
    }
}

