/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.RingNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.FusedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.RingUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class VonBaeyerSystem
extends Structure {
    protected LocantList numbering;
    protected String atom;
    protected String atom2 = null;
    protected boolean aromatic = false;

    public VonBaeyerSystem(LocantList numbering, String atom, String atom2) {
        this.numbering = numbering;
        this.atom = atom;
        this.atom2 = atom2;
        if (this.atom.endsWith("|")) {
            this.atom = this.atom.substring(0, this.atom.length() - 1);
        }
    }

    public VonBaeyerSystem(LocantList numbering, String atom) {
        this.numbering = numbering;
        this.atom = atom;
        if (this.atom.endsWith("|")) {
            this.atom = this.atom.substring(0, this.atom.length() - 1);
        }
    }

    public LocantList getNumbering() {
        return this.numbering;
    }

    @Override
    protected String printValue() {
        String atom2 = this.atom2 == null ? "" : " " + this.atom2;
        return '\"' + this.numbering.toString() + " " + this.atom + atom2 + '\"';
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenList) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        VonBaeyerSystem newStructure = new VonBaeyerSystem(this.numbering, this.atom);
        newStructure.aromatic = this.aromatic;
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected Molecule getMol() {
        return this.readMol(this.toSmiles());
    }

    @Override
    protected String toSmiles() {
        int numindex;
        this.atom = this.removeHydrogens(this.atom);
        this.atom2 = this.removeHydrogens(this.atom2);
        String smiles = "";
        smiles = this.numbering.size() == 1 ? this.getSimpleRing() : this.getComplexRing();
        this.setAtomMap(smiles);
        if (this.aromatic) {
            smiles = smiles.toLowerCase();
        }
        if ((numindex = smiles.indexOf(" |$")) > 0) {
            smiles = smiles.substring(0, numindex);
        }
        return smiles;
    }

    @Override
    protected void dearomatize() {
        if (this.parent instanceof FusedSystem) {
            return;
        }
        super.dearomatize();
    }

    private String getSimpleRing() {
        int length = this.numbering.getLocant(0).getValue();
        if (length < 3) {
            throw new NameImportException("Invalid ring definition in name.");
        }
        String chain = this.atom + "1";
        if (this.atom2 == null) {
            for (int i = 1; i < length; ++i) {
                chain = chain + this.atom;
            }
            chain = chain + "1";
        } else {
            for (int i = 1; i < length; ++i) {
                chain = chain + this.atom2 + this.atom;
            }
            chain = chain + this.atom2 + "1";
        }
        return chain;
    }

    private String getComplexRing() {
        String exmsg = "Invalid ring-numbering";
        try {
            String retVal = this.atom2 != null ? this.buildSmiles(this.numbering, this.atom2, this.atom) : this.buildSmiles(this.numbering, this.atom);
            return retVal;
        }
        catch (Exception e) {
            throw new NameImportException(exmsg);
        }
    }

    private String buildSmiles(LocantList numbering, String atom) {
        int i;
        StringBuffer retVal = new StringBuffer();
        StringBuffer numbers = new StringBuffer("|$");
        int locant = 0;
        int ringIndex = 1;
        RingUtil.appendAtom(retVal, numbers, atom, ++locant);
        retVal.append(ringIndex);
        for (i = 0; i < numbering.getLocant(0).getValue(); ++i) {
            RingUtil.appendAtom(retVal, numbers, atom, ++locant);
        }
        RingUtil.appendAtom(retVal, numbers, atom, ++locant);
        for (i = 0; i < numbering.getLocant(1).getValue(); ++i) {
            RingUtil.appendAtom(retVal, numbers, atom, ++locant);
        }
        retVal.append(ringIndex);
        RingUtil.appendBridge(retVal, numbers, 1, numbering.getLocant(0).getValue() + 2, numbering.getLocant(2).getValue(), ++ringIndex, atom, ++locant);
        locant += numbering.getLocant(2).getValue() - 1;
        for (i = 3; i < numbering.size(); ++i) {
            RingNumber ringnum = (RingNumber)numbering.getLocant(i);
            RingUtil.appendBridge(retVal, numbers, ringnum.getSecond(), ringnum.getFirst(), ringnum.getValue(), ++ringIndex, atom, ++locant);
            locant += ringnum.getValue() - 1;
        }
        numbers.deleteCharAt(numbers.length() - 1);
        numbers.append("$|");
        return retVal.toString() + " " + numbers.toString();
    }

    private String buildSmiles(LocantList numbering, String atom1, String atom2) {
        int i;
        StringBuffer retVal = new StringBuffer();
        StringBuffer numbers = new StringBuffer("|$");
        int locant = 0;
        int shift = 1;
        int ringIndex = 1;
        String[] atoms = new String[]{atom1, atom2};
        RingUtil.appendAtom(retVal, numbers, atoms[0], ++locant);
        retVal.append(ringIndex);
        for (i = 0; i < numbering.getLocant(0).getValue(); ++i) {
            RingUtil.appendAtom(retVal, numbers, atoms[locant % 2], ++locant);
        }
        RingUtil.appendAtom(retVal, numbers, atoms[locant % 2], ++locant);
        for (i = 0; i < numbering.getLocant(1).getValue(); ++i) {
            RingUtil.appendAtom(retVal, numbers, atoms[locant % 2], ++locant);
        }
        retVal.append(ringIndex);
        RingUtil.appendBridge(retVal, numbers, 1, numbering.getLocant(0).getValue() + 2, numbering.getLocant(2).getValue(), ++ringIndex, atoms, ++locant, shift);
        locant += numbering.getLocant(2).getValue() - 1;
        for (i = 3; i < numbering.size(); ++i) {
            RingNumber ringnum = (RingNumber)numbering.getLocant(i);
            String tmp = retVal.toString();
            shift = tmp.lastIndexOf(atom1) > tmp.lastIndexOf(atom2) ? 0 : 1;
            RingUtil.appendBridge(retVal, numbers, ringnum.getSecond(), ringnum.getFirst(), ringnum.getValue(), ++ringIndex, atoms, ++locant, shift);
            locant += ringnum.getValue() - 1;
        }
        numbers.deleteCharAt(numbers.length() - 1);
        numbers.append("$|");
        return retVal.toString() + " " + numbers.toString();
    }

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    public boolean isAromatic() {
        return this.aromatic;
    }

    public void setAromatic(boolean aromatic) {
        this.aromatic = aromatic;
    }

    @Override
    protected void calcLocants(Suffix suffix) {
        IntVector vec = new IntVector();
        if (suffix.getValue().matches("[+|-]h[+|-]")) {
            this.getAtomNumbersForCharge(vec);
        } else {
            this.getAtomNumbers(vec);
        }
        if (this.numbering.size() == 1 && (suffix.getLocant() == null || suffix.getLocant().size() == 0) && suffix.getMultiplicity() == vec.size() / 2) {
            for (int i = 0; i < suffix.getMultiplicity(); ++i) {
                suffix.addLocant(new SimpleLocant(vec.get(2 * i % vec.size()), 0));
            }
        } else {
            super.calcLocants(suffix);
        }
    }

    @Override
    public boolean hasLocant(Locant loc) {
        if (loc instanceof AtomLocant) {
            return this.hasAtom(((AtomLocant)loc).getAtomSymbol(), true);
        }
        VonBaeyerSystem clone = (VonBaeyerSystem)this.cloneStructure();
        Molecule mol = clone.getMol();
        return clone.atomMap.containsKey(Util.locantToInt(loc)) || clone.atomMap.isEmpty() && mol.getAtomCount() >= Util.locantToInt(loc);
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return atomSymbol.equals(this.atom) || this.atom2 != null && atomSymbol.equals(this.atom2) || this.getHeteroAtomCountOf(atomSymbol) > 0;
    }
}

