/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.tools;

import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class GetField {
    public static void main(String[] args) throws IOException {
        String line;
        InputStream rawIn;
        int field = 1;
        String fieldName = null;
        String filename = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].intern();
            if (arg == "-f") {
                fieldName = args[++i];
                continue;
            }
            if (arg.startsWith("-")) {
                try {
                    field = Integer.parseInt(arg.substring(1));
                    continue;
                }
                catch (NumberFormatException e) {
                    System.err.println("Unknown option: " + arg);
                    System.exit(1);
                }
            }
            if (filename == null) {
                filename = arg;
                continue;
            }
            System.err.println("I support only one file argument for now");
            System.exit(1);
        }
        if (filename == null) {
            rawIn = System.in;
        } else if (filename.endsWith("smi")) {
            rawIn = new FileInputStream(filename);
        } else {
            GetField.processWithMolImporter(filename, fieldName);
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(rawIn));
        while ((line = in.readLine()) != null) {
            if (fieldName != null) {
                field = GetField.findField(fieldName, line);
                fieldName = null;
                continue;
            }
            String value = GetField.get(line, field);
            if (value == null || value.length() <= 0) continue;
            System.out.println(value);
        }
    }

    private static void processWithMolImporter(String filename, String fieldName) throws IOException {
        Molecule m;
        MolImporter imp = new MolImporter(filename);
        while ((m = imp.read()) != null) {
            GetField.printNames(GetField.getName(m, fieldName));
        }
    }

    private static String getName(Molecule m, String fieldName) {
        if (fieldName == null) {
            return m.getName();
        }
        return m.getProperty(fieldName);
    }

    private static void printNames(String names) {
        if (names == null || names.equals("")) {
            return;
        }
        for (String name : GetField.splitNames(names)) {
            System.out.println(name);
        }
    }

    private static int findField(String fieldName, String line) {
        String f;
        for (int field = 0; field < 1000 && (f = GetField.get(line, field)) != null; ++field) {
            if (!fieldName.equals(f)) continue;
            return field;
        }
        throw new RuntimeException("Could not find field '" + fieldName + "'.\nHeader line: '" + line + "'");
    }

    static String get(String line, int field) {
        if (line.startsWith("\"")) {
            int end = line.indexOf(34, 1);
            if (end == -1) {
                throw new RuntimeException("Missing closing quote: " + line);
            }
            if (field == 0) {
                return line.substring(1, end);
            }
            String after = line.substring(end + 1);
            if (after.equals("")) {
                return null;
            }
            if (Character.isWhitespace(after.charAt(0))) {
                return GetField.get(after.substring(1), field - 1);
            }
            throw new RuntimeException("Could not parse field in line '" + line + "'");
        }
        int tab = line.indexOf(9);
        if (tab != -1) {
            if (field == 0) {
                return line.substring(0, tab);
            }
            return GetField.get(line.substring(tab + 1), field - 1);
        }
        if (field == 0) {
            return line;
        }
        return null;
    }

    public static String[] splitNames(String nameList) {
        if (nameList == null) {
            return new String[0];
        }
        String[] names = nameList.split("\n");
        ArrayList<String> kept = new ArrayList<String>(names.length);
        for (String name : names) {
            if (GetField.ignoreName(name)) continue;
            kept.add(name);
        }
        if (kept.size() == names.length) {
            return names;
        }
        return kept.toArray(new String[kept.size()]);
    }

    private static boolean ignoreName(String name) {
        if (name.equals("")) {
            return true;
        }
        if (name.equals("(none)")) {
            return true;
        }
        return name.startsWith("WLN:") || name.startsWith("NCI-");
    }
}

