/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CachedMap<K, V> {
    private final File cacheFile;
    private Writer cacheWriter;
    private HashMap<K, V> cache = null;
    private static final Logger logger = Logger.getLogger(CachedMap.class.getName());

    public abstract V compute(K var1) throws Exception;

    public String representKey(K key) {
        return key.toString();
    }

    public String representValue(V value) {
        return String.valueOf(value);
    }

    public abstract K parseKey(String var1);

    public abstract V parseValue(String var1);

    public CachedMap(File cacheFile) {
        this.cacheFile = cacheFile;
        this.loadCache();
    }

    public synchronized V get(K key) {
        V value;
        V cached;
        if (this.cache == null) {
            this.loadCache();
        }
        if ((cached = this.cache.get(key)) != null) {
            return cached;
        }
        if (this.cache.containsKey(key)) {
            return cached;
        }
        try {
            value = this.compute(key);
        }
        catch (Exception e) {
            return null;
        }
        this.cache.put(key, value);
        this.storeOnDisk(key, value);
        return value;
    }

    private void storeOnDisk(K key, V value) {
        String repKey = this.representKey(key);
        String repVal = this.representValue(value);
        if (repKey.indexOf(9) != -1 || repKey.indexOf(10) != -1 || repVal.indexOf(9) != -1 || repVal.indexOf(10) != -1) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Not caching mapping '" + repKey + "' -> '" + repVal + "'");
            }
            return;
        }
        try {
            this.cacheWriter.append(repKey + "\t" + repVal + "\n");
            this.cacheWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadCache() {
        this.cache = new HashMap();
        BufferedReader r = null;
        try {
            String line;
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cacheFile), "UTF-8"));
            while ((line = r.readLine()) != null) {
                int tab = line.indexOf(9);
                if (tab == -1) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.warning("Invalid cache line in " + this.cacheFile.getAbsolutePath() + ": " + line);
                    continue;
                }
                String key = line.substring(0, tab);
                String value = line.substring(tab + 1);
                this.cache.put(this.parseKey(key), this.parseValue(value));
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (r != null) {
            try {
                r.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.prepareAddingToCacheFile();
    }

    private void prepareAddingToCacheFile() {
        try {
            FileOutputStream file = new FileOutputStream(this.cacheFile, true);
            this.cacheWriter = new OutputStreamWriter((OutputStream)file, "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static abstract class CachedStringMap
    extends CachedMap<String, String> {
        public CachedStringMap(File cacheFile) {
            super(cacheFile);
        }

        @Override
        public String parseKey(String keyRepresentation) {
            return keyRepresentation;
        }

        @Override
        public String parseValue(String valueRepresentation) {
            if (valueRepresentation.equals("null")) {
                return null;
            }
            return valueRepresentation;
        }
    }
}

