/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.util;

import chemaxon.formats.MolImporter;
import chemaxon.naming.NameFormatException;
import chemaxon.naming.n2s.NameImportException;
import chemaxon.naming.n2s.Standardize;
import chemaxon.naming.n2s.UnknownTokenException;
import chemaxon.naming.n2s.lex.NameLexer;
import chemaxon.naming.n2s.lex.data.BracketToken;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.Number;
import chemaxon.naming.n2s.lex.data.Separator;
import chemaxon.naming.n2s.lex.data.SpecialStr;
import chemaxon.naming.n2s.lex.data.Token;
import chemaxon.struc.Molecule;
import chemaxon.util.IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CountTokens {
    private IntMap<String> tokens = new IntMap();

    CountTokens() {
    }

    public static void main(String[] args) throws IOException {
        String in = args[0];
        CountTokens counter = new CountTokens();
        counter.loadFile(in);
        counter.writeTokens();
    }

    void loadFile(String file) throws IOException {
        Molecule m;
        MolImporter imp = new MolImporter(file);
        while ((m = imp.read()) != null) {
            this.processName(m.getName());
        }
    }

    public void processName(String name) {
        String[] names;
        if (name == null || name.length() == 0) {
            return;
        }
        for (String n : names = name.split(";")) {
            this.processNamePart(n.trim());
        }
    }

    void processNamePart(String name) {
        for (Token t : CountTokens.listTextTokens(name)) {
            this.processToken(t);
        }
    }

    private void processToken(Token t) {
        this.tokens.inc(t.getName());
    }

    public List<Map.Entry<String, Integer>> getTokens() {
        return this.tokens.getSortedEntriesDescending();
    }

    private void writeTokens() {
        for (Map.Entry<String, Integer> token : this.tokens.getSortedEntriesDescending()) {
            System.out.println(token.getValue() + "\t" + token.getKey());
        }
    }

    public static List<String> listTextTokensNames(String name) {
        List<Token> tokens = CountTokens.listTextTokens(name);
        ArrayList<String> res = new ArrayList<String>(tokens.size());
        for (Token t : tokens) {
            res.add(t.getName());
        }
        return res;
    }

    public static List<Token> listTextTokens(String name) {
        ArrayList<Token> res = new ArrayList<Token>();
        name = Standardize.get(name);
        try {
            ArrayList<Token> tokens = NameLexer.parse(name, false);
            for (Token t : tokens) {
                CountTokens.addTokens(t, res);
            }
        }
        catch (UnknownTokenException e) {
            res.add(new SpecialStr(e.getUnknownToken()));
        }
        catch (NameFormatException e) {
        }
        catch (NameImportException e) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return res;
    }

    static void addTokens(Token t, List<Token> res) {
        if (t instanceof BracketToken) {
            for (Token subtoken : ((BracketToken)t).inside) {
                CountTokens.addTokens(subtoken, res);
            }
            return;
        }
        if (t instanceof Separator || t instanceof Number || t instanceof LocantList) {
            return;
        }
        res.add(t);
    }
}

