/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RateList<K> {
    private HashMap<K, Stats> map = new HashMap();

    public void increment(K key) {
        ++this.get(key).value;
    }

    public void incrementCases(K key) {
        ++this.get(key).cases;
    }

    public List<Map.Entry<K, Stats>> sort() {
        Set<Map.Entry<K, Stats>> elements = this.map.entrySet();
        ArrayList<Map.Entry<K, Stats>> res = new ArrayList<Map.Entry<K, Stats>>(elements);
        Collections.sort(res, new Comparator<Map.Entry<K, Stats>>(){

            @Override
            public int compare(Map.Entry<K, Stats> arg0, Map.Entry<K, Stats> arg1) {
                double diff = arg1.getValue().getRate() - arg0.getValue().getRate();
                if (diff > 0.0) {
                    return 1;
                }
                if (diff < 0.0) {
                    return -1;
                }
                return 0;
            }
        });
        return res;
    }

    public List<Map.Entry<K, Stats>> sortTheoreticalImprovement(final double targetRate) {
        Set<Map.Entry<K, Stats>> elements = this.map.entrySet();
        ArrayList<Map.Entry<K, Stats>> res = new ArrayList<Map.Entry<K, Stats>>(elements);
        Collections.sort(res, new Comparator<Map.Entry<K, Stats>>(){

            @Override
            public int compare(Map.Entry<K, Stats> arg0, Map.Entry<K, Stats> arg1) {
                double diff = arg1.getValue().getTheoreticalImprovement(targetRate) - arg0.getValue().getTheoreticalImprovement(targetRate);
                if (diff > 0.0) {
                    return 1;
                }
                if (diff < 0.0) {
                    return -1;
                }
                return 0;
            }
        });
        return res;
    }

    private Stats get(K key) {
        Stats res = this.map.get(key);
        if (res == null) {
            res = new Stats();
            this.map.put(key, res);
        }
        return res;
    }

    public static class Stats {
        int value;
        int cases;

        public int getValue() {
            return this.value;
        }

        public double getTheoreticalImprovement(double targetRate) {
            double theoreticalImprovement = (double)this.cases * (this.getRate() - targetRate);
            return theoreticalImprovement;
        }

        public int getCases() {
            return this.cases;
        }

        public double getRate() {
            return (double)this.value / (double)this.cases;
        }
    }
}

