/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.pdb;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.pdb.PDBReader;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.Molecule;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class PDBImport
extends MolImportModule {
    private PDBReader pdbReader = new PDBReader();

    @Override
    public void initMolImport(MolInputStream is) throws IOException {
        this.pdbReader.setInput(is);
    }

    @Override
    public void setOptions(String opts) {
        if (opts != null) {
            StringTokenizer tokenizeOpts = new StringTokenizer(opts, ",");
            while (tokenizeOpts.hasMoreTokens()) {
                String tok = tokenizeOpts.nextToken();
                if (tok.equals("c")) {
                    this.pdbReader.setOmitConnect(true);
                }
                if (tok.equals("b")) {
                    this.pdbReader.setFixBondTypes(false);
                    continue;
                }
                if (tok.equals("H") || tok.equals("+H")) {
                    this.pdbReader.setHydrogenize(3);
                    continue;
                }
                if (!tok.equals("-H")) continue;
                this.pdbReader.setHydrogenize(16);
            }
        }
    }

    @Override
    public boolean readMol(Molecule mol) throws IOException {
        mol.clearForImport("pdb");
        try {
            MacroMolecule mm = this.read();
            if (mm == null) {
                return false;
            }
            this.convert(mm, mol);
        }
        catch (MacroMolecule.BadMoleculeException e) {
            throw new MolFormatException(e.getMessage());
        }
        return true;
    }

    @Override
    public Molecule createMol() {
        return new Molecule();
    }

    public MacroMolecule read() throws IOException, MacroMolecule.BadMoleculeException {
        return this.pdbReader.read();
    }

    public void convert(MacroMolecule mm, Molecule mol) {
        this.pdbReader.convert(mm, mol);
    }

    public static MacroMolecule read(String fileName) throws IOException, MacroMolecule.BadMoleculeException {
        PDBReader pdbReader = new PDBReader();
        pdbReader.setInput(new MolInputStream(new BufferedInputStream(new FileInputStream(fileName))));
        return pdbReader.read();
    }
}

