/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.peptide;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.formats.recognizer.PeptideRecognizer;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.peptide.AminoAcidSource;
import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.SgroupAtom;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class PeptideReader {
    public static final int STEREO_D = 2;
    public static final int STEREO_L = 1;
    public static final int STEREO_DL = 0;

    public SgroupAtom[] threeLetterStrToSgroup(Molecule molecule, String peptideStr) throws MolFormatException {
        Molecule mol = new Molecule();
        this.convert(mol, peptideStr, false);
        SgroupAtom[] atomlist = new SgroupAtom[mol.getAtomCount() - 2];
        for (int i = 1; i < mol.getAtomCount() - 1; ++i) {
            atomlist[i - 1] = (SgroupAtom)mol.getAtom(i);
        }
        molecule.fuse(mol);
        return atomlist;
    }

    public SgroupAtom threeLetterStrToSgroup(Molecule molecule, String peptideStr, int configuration) throws MolFormatException {
        Molecule mol = this.buildSinglePeptide(peptideStr, false);
        mol.expandSgroups();
        this.setConfiguration(mol, 1, configuration);
        mol.contractSgroups();
        SgroupAtom atom = (SgroupAtom)mol.getAtom(0);
        molecule.fuse(mol);
        return atom;
    }

    private static int indexOf(String[] array, String str) {
        if (str == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!str.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    private Molecule buildSinglePeptide(String abbrev, boolean isOneLetter) throws MolFormatException {
        int aaIdx;
        AminoAcidSource aas = AminoAcidSource.getInstance();
        int n = aaIdx = isOneLetter ? PeptideReader.indexOf(aas.getImportNamesWithOneLetter(), abbrev) : PeptideReader.indexOf(aas.getImportNamesWithThreeLetters(), abbrev);
        if (aaIdx < 0) {
            throw new MolFormatException("Incorrect peptide format: " + abbrev + "\n Use " + "all uppercase for one letter peptides and \"AlaTyrGly\"" + " format for three-letter notation.");
        }
        int firstLink = aas.getImportFirtsAttachPoints()[aaIdx];
        int secondLink = aas.getImportSecondAttachPoints()[aaIdx];
        String abbrevStr = aas.getImportNamesWithThreeLetters()[aaIdx] + "\t" + aas.getSMILESVector().get(aaIdx) + "\t" + firstLink + "\t" + secondLink;
        Molecule mol = PeptideReader.readAbbrev(abbrevStr);
        mol.clean(2, null);
        return mol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convert(Molecule mol, String peptideStr, boolean isOneLetter) throws MolFormatException {
        boolean isCorrectFormat;
        boolean bl = isCorrectFormat = peptideStr != null && !peptideStr.equals("");
        if (isCorrectFormat) {
            isCorrectFormat = isOneLetter ? PeptideRecognizer.canBe1LetterPeptide(peptideStr) : PeptideRecognizer.canBe3LetterPeptide(peptideStr);
        }
        if (isCorrectFormat) {
            Vector<String> aaStr;
            boolean orderOK;
            boolean bl2 = orderOK = (peptideStr = this.OrderName(peptideStr, isOneLetter)) != null;
            if (!orderOK) throw new MolFormatException("Could not reorder peptide string " + peptideStr);
            try {
                aaStr = this.findAminoAcids(peptideStr, isOneLetter);
            }
            catch (IOException ioex) {
                throw new MolFormatException("Could not find aminacid in peptide string " + peptideStr, ioex);
            }
            if (aaStr == null) return;
            this.build(mol, aaStr, isOneLetter);
            return;
        }
        int maxReportLength = 50;
        if (peptideStr == null || peptideStr.length() <= maxReportLength) throw new MolFormatException("Incorrect peptide format: " + peptideStr + "\n Use " + "all uppercase for one letter peptides and \"AlaTyrGly\"" + " format for three-letter notation.");
        peptideStr = peptideStr.substring(0, maxReportLength) + "...";
        throw new MolFormatException("Incorrect peptide format: " + peptideStr + "\n Use " + "all uppercase for one letter peptides and \"AlaTyrGly\"" + " format for three-letter notation.");
    }

    private String OrderName(String name, boolean isOneLetter) {
        int start;
        int letterNum = isOneLetter ? 1 : 3;
        boolean reversed = false;
        if (name.startsWith("H-") || name.startsWith("h-")) {
            name = name.substring(2);
        }
        if (name.startsWith("OH-") || name.startsWith("oh-") || name.startsWith("HO-") || name.startsWith("ho-")) {
            name = name.substring(3);
            reversed = true;
        }
        if (name.endsWith("-H") || name.endsWith("-h")) {
            name = name.substring(0, name.length() - 2);
            reversed = true;
        }
        if (name.endsWith("-OH") || name.endsWith("-oh") || name.endsWith("-HO") || name.endsWith("-ho")) {
            name = name.substring(0, name.length() - 3);
        }
        String orderedName = name;
        if (reversed) {
            orderedName = "";
            try {
                int i = name.length();
                while (i > 0) {
                    orderedName = orderedName + name.substring(i - letterNum, i);
                    if ((i -= letterNum) <= 0 || name.charAt(i - 1) != '-') continue;
                    orderedName = orderedName + "-";
                    --i;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        orderedName = PeptideReader.CreateEndings(orderedName);
        if (letterNum == 1) {
            start = orderedName.indexOf(45) + 1;
            int end = orderedName.lastIndexOf(45);
            String newName = orderedName.substring(0, start);
            StringCharacterIterator cit = new StringCharacterIterator(orderedName, start, end, start);
            char ch = cit.first();
            while (ch != '\uffff') {
                if (ch == 'X') {
                    do {
                        newName = newName + ch;
                    } while (ch != ')' && (ch = cit.next()) != '\uffff');
                    newName = newName + "-";
                } else {
                    newName = ch != '-' ? newName + ch + "-" : newName + ch;
                }
                ch = cit.next();
            }
            orderedName = newName + orderedName.substring(end + 1);
        } else {
            start = orderedName.indexOf(45) + 1;
            int end = orderedName.lastIndexOf(45);
            String newName = orderedName.substring(0, start);
            StringCharacterIterator cit = new StringCharacterIterator(orderedName, start, end, start);
            char ch = cit.first();
            while (ch != '\uffff') {
                if (ch == 'X') {
                    newName = newName + ch;
                    do {
                        ch = cit.next();
                        newName = newName + ch;
                    } while (ch != ')' && ch != '\uffff');
                    newName = newName + "-";
                } else if (ch != '-') {
                    newName = newName + ch;
                    newName = newName + cit.next();
                    newName = newName + cit.next() + "-";
                } else {
                    newName = newName + ch;
                }
                ch = cit.next();
            }
            orderedName = newName + orderedName.substring(end + 1);
        }
        return orderedName;
    }

    private static String CreateEndings(String str) {
        String ret = str;
        if (str.length() < 3 || !str.substring(str.length() - 3).equals("-OH")) {
            ret = ret + "-OH";
        }
        if (str.length() < 2 || !str.substring(0, 2).equals("H-")) {
            ret = "H-" + ret;
        }
        return ret;
    }

    private Vector<String> findAminoAcids(String str, boolean oneLetter) throws MolFormatException {
        String[] NAMES;
        Vector<String> abbrevStr = new Vector<String>();
        str = this.escapeCustomAminoAcids(str);
        StringTokenizer st = new StringTokenizer(str, "-");
        String[] stringArray = NAMES = oneLetter ? AminoAcidSource.getInstance().getImportNamesWithOneLetter() : AminoAcidSource.getInstance().getImportNamesWithThreeLetters();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 1) {
                token = token.toUpperCase();
            }
            if (!(oneLetter || token.length() <= 2 || token.startsWith("X(") || token.startsWith("x("))) {
                token = token.toLowerCase();
                String first = token.substring(0, 1);
                first = first.toUpperCase();
                token = first + token.substring(1);
            }
            if (PeptideReader.indexOf(NAMES, token = token.replace('.', '-')) > -1 || token.equals("OH") || token.equals("H")) {
                abbrevStr.add(token);
                continue;
            }
            throw new MolFormatException("Unknown amino acid " + token);
        }
        return abbrevStr;
    }

    private String escapeCustomAminoAcids(String str) {
        if (!str.contains("x(") && !str.contains("X(")) {
            return str;
        }
        int start = str.indexOf(45) + 1;
        int end = str.lastIndexOf(45) + 1;
        StringBuilder newName = new StringBuilder(str.substring(0, start));
        StringCharacterIterator cit = new StringCharacterIterator(str, start, end, start);
        char ch = cit.first();
        while (ch != '\uffff') {
            if (ch == 'X') {
                newName.append(ch);
                do {
                    if ((ch = cit.next()) == '-') {
                        newName.append('.');
                        continue;
                    }
                    newName.append(ch);
                } while (ch != ')' && ch != '\uffff');
            } else {
                newName.append(ch);
            }
            ch = cit.next();
        }
        str = newName.append(str.substring(end + 1)).toString();
        return str;
    }

    private Molecule build(Molecule mol, Vector<String> aaStr, boolean oneLetter) throws MolFormatException {
        String[] NAMES;
        AminoAcidSource aas = AminoAcidSource.getInstance();
        String[] stringArray = NAMES = oneLetter ? aas.getImportNamesWithOneLetter() : aas.getImportNamesWithThreeLetters();
        if (aaStr.size() > 2) {
            MolImporter.importMol("[H]", mol);
            MolAtom rightAtom = mol.getAtom(0);
            for (int i = 1; i < aaStr.size(); ++i) {
                Molecule aa = new Molecule();
                int firstLink = -1;
                int secondLink = -1;
                if (i != 0 && i != aaStr.size() - 1) {
                    String abbrev = aaStr.elementAt(i);
                    int aaIdx = PeptideReader.indexOf(NAMES, abbrev);
                    firstLink = aas.getImportFirtsAttachPoints()[aaIdx];
                    secondLink = aas.getImportSecondAttachPoints()[aaIdx];
                    String abbrevStr = aas.getImportNamesWithThreeLetters()[aaIdx] + "\t" + aas.getSMILESVector().get(aaIdx) + "\t" + firstLink + "\t" + secondLink;
                    aa = PeptideReader.readAbbrev(abbrevStr);
                    block5: for (int j = 0; j < aa.getAtomCount(); ++j) {
                        MolAtom a = aa.getAtom(j);
                        switch (a.getAttach()) {
                            case 1: {
                                firstLink = j + 1;
                                continue block5;
                            }
                            case 2: {
                                secondLink = j + 1;
                                continue block5;
                            }
                        }
                    }
                } else if (i == aaStr.size() - 1) {
                    PeptideReader.readMol(aa, "O");
                    firstLink = 1;
                    secondLink = 1;
                }
                MolAtom leftAtom = aa.getAtom(firstLink - 1);
                mol.fuse(aa);
                if (leftAtom != null && rightAtom != null) {
                    mol.add(new MolBond(leftAtom, rightAtom));
                }
                rightAtom = aa.getAtom(secondLink - 1);
            }
        }
        mol.contractSgroups();
        return mol;
    }

    private static Molecule readAbbrev(String str) throws MolFormatException {
        Molecule mol = new Molecule();
        String name = str.substring(0, str.indexOf(9));
        mol = AminoAcidSource.getInstance().getFromCache(name);
        if (mol != null) {
            return mol.cloneMolecule();
        }
        mol = MolImporter.importMol(str, "abbrevgroup");
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            mol.getAtom(i).clearQProps();
        }
        AminoAcidSource.getInstance().storePeptide(str.substring(0, 3), mol.cloneMolecule());
        return mol;
    }

    private static void readMol(Molecule mol, String str) {
        try {
            MolInputStream mis = new MolInputStream((InputStream)new ByteArrayInputStream(str.getBytes()), "cxsmiles");
            SmilesImport mii = new SmilesImport();
            ((MolImportModule)mii).initMolImport(mis);
            ((MolImportModule)mii).readMol(mol);
        }
        catch (Exception e) {
            System.out.println("Exception in readMol");
        }
    }

    private void setConfiguration(Molecule mol, int oldConfig, int newConfig) {
        if (oldConfig == newConfig) {
            return;
        }
        if (newConfig != 1 && newConfig != 2 && newConfig != 0) {
            return;
        }
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            int stereo;
            if (mol.getChirality(i) == 8) {
                stereo = newConfig == 0 ? 0 : 16;
                mol.setChirality(i, stereo);
                continue;
            }
            if (mol.getChirality(i) != 16) continue;
            stereo = newConfig == 0 ? 0 : 8;
            mol.setChirality(i, stereo);
        }
    }
}

