/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.skc.skcimport.SkcImportHelper;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.io.DataInputStream;
import java.io.IOException;

public class SkcImport
extends MolImportModule {
    private MolInputStream istream;

    @Override
    public Molecule createMol() {
        return new Molecule();
    }

    @Override
    public void initMolImport(MolInputStream mis) throws MolFormatException, IOException {
        this.istream = mis;
    }

    @Override
    public boolean readMol(Molecule mol) throws MolFormatException, IOException {
        return true;
    }

    @Override
    public boolean isDocumentImporter() {
        return true;
    }

    @Override
    public MDocument readDocument(MDocument paramMDocument) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.istream);
        SkcImportHelper sk = new SkcImportHelper();
        try {
            Molecule mol = sk.readSkcFile(dataInputStream);
            mol.setInputFormat("skc");
            mol.getDocument().setInputFormat("skc");
            mol.valenceCheck();
            return mol.getDocument();
        }
        catch (Exception e) {
            throw new IOException("Error in Skc import.", e);
        }
    }
}

