/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.skcexport;

import chemaxon.marvin.io.formats.skc.skcexport.SkcWriterHelper;
import chemaxon.marvin.io.formats.skc.utils.ChemUtil;
import chemaxon.marvin.io.formats.skc.utils.Coordinate;
import chemaxon.marvin.io.formats.skc.utils.MolBondInfo;
import chemaxon.marvin.io.formats.skc.utils.Segment;
import chemaxon.marvin.io.formats.skc.utils.SgroupBeanInfo;
import chemaxon.marvin.io.formats.skc.utils.SgroupUtil;
import chemaxon.marvin.io.formats.skc.utils.SuperatomSgroupUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MEFlow;
import chemaxon.struc.graphics.MEllipse;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MRoundedRectangle;
import chemaxon.struc.graphics.MTextAttributes;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.graphics.MTextDocument;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SkcExportHelper {
    private Map<Sgroup, Boolean> sgroupContractOrExpandedFlagMap = new HashMap<Sgroup, Boolean>();
    private Map<MultipleSgroup, Integer> multiplieres;
    private Map<Integer, List<MolAtom>> groupsOfConnectedAtoms = new HashMap<Integer, List<MolAtom>>();
    private Map<Integer, Segment> fragmentMap = new HashMap<Integer, Segment>();
    private SkcWriterHelper output;
    private int atomCount = 0;
    private Map<MolAtom, Integer> atomMap = new HashMap<MolAtom, Integer>();
    private MDocument document;
    private Molecule cmolClone;
    private final List<String> pseudoAtoms = ChemUtil.pseudoAtoms;
    private List<String> superSubStringList = new ArrayList<String>();
    private Map<Object, List<Object>> superAtomMap = new HashMap<Object, List<Object>>();
    private Map<MolAtom, List<MolBond>> superAtomBondMap = new HashMap<MolAtom, List<MolBond>>();
    private SuperatomSgroupUtil sgroupUtil = null;
    private Map<Segment, Boolean> sgBoolMap = new HashMap<Segment, Boolean>();
    private static int atomNumber = 33;
    private Map<Object, DPoint3> originalDPoint3Map = new HashMap<Object, DPoint3>();
    private List<DataSgroup> stereoDataSgroups = new ArrayList<DataSgroup>();
    private Map<DataSgroup, MolAtom> atomStereoMap = new HashMap<DataSgroup, MolAtom>();

    public OutputStream write(Molecule mol) {
        this.cmolClone = mol.cloneMoleculeWithDocument();
        this.rebuildSgroupState(this.cmolClone);
        this.sgroupUtil = new SuperatomSgroupUtil(this.sgroupContractOrExpandedFlagMap, this.originalDPoint3Map);
        this.document = mol.getDocument();
        if (this.document == null) {
            this.document = new MDocument(mol);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(ChemUtil.getFactorValue(10));
        this.output = new SkcWriterHelper(stream);
        this.exportFileHeadData();
        this.exportSegments(this.cmolClone);
        this.exportRgroups(this.cmolClone);
        this.exportReactions(this.cmolClone);
        this.exportTextBoxes(this.cmolClone);
        this.exportGraphicsAndLines(this.cmolClone);
        this.output.outputFlagAndShortData(20);
        return stream;
    }

    private void exportFileHeadData() {
        this.output.outputPropertyArrayData(1, new Object[]{this.output.convertIntToByte(4)});
        this.output.outputShortAndFlagData(2, this.output.convertIntToShort(1));
    }

    private void exportAtom(MolAtom atom) {
        this.atomMap.put(atom, this.atomCount++);
        ++atomNumber;
        this.output.outputFeatureFlagData(33);
        this.output.outputPropertyArrayData(22, new Object[]{Float.valueOf(Coordinate.getXOfSkc(atom.getX())), Float.valueOf(Coordinate.getYOfSkc(atom.getY()))});
        int atno = atom.getAtno();
        String alliasName = atom.getAliasstr();
        String symbol = atom.getSymbol();
        if (this.superAtomMap.containsKey(atom)) {
            atno = 272;
        }
        this.exportAtomBaseData(atom, atno, alliasName, symbol);
        this.exportAtomIsotope(atom, atno);
        this.exportAtomCharge(atom);
        this.exportAtomValence(atom);
        this.exportAtomRadical(atom);
        this.exportAtomSubstitution(atom);
        this.exportAtomValue(atom);
        this.exportAtomUnsaturated(atom);
        this.exportAtomRingBondCount(atom);
        this.exportAtomImplicitNumber(atom);
        this.exportAtomRetention(atom);
        this.exportAtomAttachData(atom);
        this.exportAtomListData(atom, atno);
        this.exportAtomMapNumber(atom);
        this.exportAtomFormat(atom.getSetSeq());
    }

    private void exportAtomBaseData(MolAtom atom, int atno, String alliasName, String symbol) {
        String atomName = ChemUtil.getAtomSymbolByType(atno);
        if (alliasName != null || atomName != null) {
            this.output.outputShortAndFlagData(23, this.output.convertIntToShort(atno));
        }
        if (this.pseudoAtoms.contains(alliasName)) {
            if (!this.superSubStringList.contains(alliasName)) {
                this.output.outputSymbolData(232, alliasName);
            } else {
                this.output.outputSymbolData(25, alliasName);
            }
        } else if (symbol.equals("R#")) {
            int rgroup = atom.getRgroup();
            if (rgroup != 0) {
                ArrayList<Short> rgroupAttachList = new ArrayList<Short>();
                rgroupAttachList.add(this.output.convertIntToShort(275));
                rgroupAttachList.add(this.output.convertIntToShort(1));
                rgroupAttachList.add(this.output.convertIntToShort(rgroup));
                this.output.outputPropertyArrayData(23, rgroupAttachList.toArray());
            } else {
                this.output.outputSymbolData(232, "R");
            }
            if (alliasName != null) {
                this.output.outputSymbolData(25, alliasName);
            }
        } else {
            if (atno != 272) {
                this.output.outputSymbolData(232, symbol);
            }
            if (alliasName != null) {
                this.output.outputSymbolData(25, alliasName);
            }
        }
        this.output.outputShortAndFlagData(26, this.output.convertIntToShort(atomNumber));
        this.output.outputShortAndFlagData(37, this.output.convertIntToShort(4));
        this.output.outputShortAndFlagData(208, this.output.convertIntToShort(15));
    }

    private void exportAtomIsotope(MolAtom atom, int atno) {
        int isotope = atom.getMassno();
        if (isotope != 0) {
            int mass = atno * 2;
            isotope = isotope == mass ? 0 : isotope - mass + 19;
            this.output.outputFlagAndShortAndByteData(29, this.output.convertIntToByte(isotope));
        }
    }

    private void exportAtomCharge(MolAtom atom) {
        if (atom.getCharge() != 0) {
            this.output.outputFlagAndShortAndByteData(27, this.output.convertIntToByte(16 + atom.getCharge()));
        }
    }

    private void exportAtomValence(MolAtom atom) {
        int valence = atom.getValenceProp();
        if (valence != -1) {
            if (valence == 0) {
                valence = 15;
            }
            this.output.outputFlagAndShortAndByteData(30, this.output.convertIntToByte(valence));
        }
    }

    private void exportAtomRadical(MolAtom atom) {
        int radical = 0;
        if (atom.getRadical() != 0) {
            if (atom.getRadical() == 1) {
                radical = 2;
            } else if (atom.getRadical() == 6) {
                radical = 1;
            } else if (atom.getRadical() == 10) {
                radical = 3;
            }
        }
        if (radical > 0 && radical < 4) {
            this.output.outputFlagAndShortAndByteData(28, this.output.convertIntToByte(radical));
        }
    }

    private void exportAtomSubstitution(MolAtom atom) {
        int substitution = atom.getQPropAsInt("s");
        if (substitution != -1) {
            if (substitution == 0) {
                substitution = -1;
            }
            this.output.outputFlagAndShortAndByteData(32, this.output.convertIntToByte(substitution + 3));
        }
    }

    private void exportAtomValue(MolAtom atom) {
        String value = atom.getExtraLabel();
        if (value != null && !value.equals("")) {
            this.output.outputSymbolData(36, value);
        }
    }

    private void exportAtomUnsaturated(MolAtom atom) {
        int unsaturated = atom.getQPropAsInt("u");
        if (unsaturated != -1) {
            this.output.outputFlagAndShortData(35);
        }
    }

    private void exportAtomRingBondCount(MolAtom atom) {
        int ringBond = atom.getQPropAsInt("rb");
        if (ringBond != -1) {
            if (ringBond == 0) {
                ringBond = -1;
            }
            this.output.outputFlagAndShortAndByteData(31, this.output.convertIntToByte(ringBond + 3));
        } else if (ringBond == -4) {
            this.output.outputFlagAndShortAndByteData(31, this.output.convertIntToByte(ringBond + 3));
        }
    }

    private void exportAtomImplicitNumber(MolAtom atom) {
        int hydrogen = atom.getQPropAsInt("h");
        if (hydrogen != -1 && hydrogen == 0) {
            this.output.outputFlagAndShortData(34);
        }
    }

    private void exportAtomRetention(MolAtom atom) {
        int reaction = atom.getReactionStereo();
        if (reaction != 0) {
            this.output.outputFlagAndShortAndByteData(80, this.output.convertIntToByte(reaction));
        }
    }

    private void exportAtomAttachData(MolAtom atom) {
        int attach = atom.getAttach();
        if (attach == 1) {
            this.output.outputFlagAndShortAndByteData(53, this.output.convertIntToByte(1));
        } else if (attach == 2) {
            this.output.outputFlagAndShortAndByteData(53, this.output.convertIntToByte(2));
        } else if (attach == 3) {
            this.output.outputFlagAndShortAndByteData(53, this.output.convertIntToByte(3));
        }
    }

    private void exportAtomListData(MolAtom atom, int atno) {
        int[] list = atom.getList();
        if (list != null) {
            if (atno == 129) {
                this.output.outputShortAndFlagData(23, this.output.convertIntToShort(ChemUtil.getFactorValue(7, -15)));
            } else {
                this.output.outputShortAndFlagData(23, this.output.convertIntToShort(ChemUtil.getFactorValue(7, -14)));
            }
            this.output.outputFlagAndShortAndByteData(24, this.output.convertIntToByte(list.length));
            for (int s : list) {
                this.output.outputShortData(this.output.convertIntToShort(s));
            }
        }
    }

    private void exportAtomMapNumber(MolAtom atom) {
        int mapNo = atom.getAtomMap();
        if (mapNo != 0) {
            this.output.outputShortAndFlagData(96, this.output.convertIntToShort(mapNo));
        }
    }

    private void exportAtomFormat(int seqNo) {
        MFont mfont;
        int rgb = this.document.getAtomSetRGB(seqNo);
        if (rgb != -1) {
            this.output.outputFlagAndColorData(88, new Color(rgb));
        }
        if ((mfont = this.document.getAtomSetFont(seqNo)) != null) {
            double size;
            String fontName = mfont.getFamily();
            fontName = fontName == null ? "Arial" : fontName;
            int value = 0;
            if (mfont.isBold()) {
                value |= 1;
            }
            if (mfont.isItalic()) {
                value |= 2;
            }
            if ((size = mfont.getSizeDouble()) == 0.0) {
                size = 12.0;
            }
            if (size > 72.0) {
                size = 72.0;
            }
            this.output.outputPropertyArrayData(11, new Object[]{fontName, this.output.convertDoubleToShort(size * 10.0), this.output.convertIntToByte(value)});
        }
    }

    private void exportBondFormat(int seqNo) {
        int rgb = this.document.getBondSetRGB(seqNo);
        if (rgb != -1) {
            this.output.outputFlagAndColorData(88, new Color(rgb));
        }
        if (this.document.getBondSetThickness(seqNo) != 0.0) {
            int thickness = (int)Math.round(this.document.getBondSetThickness(seqNo) / 0.009142857142857144);
            thickness = thickness > 255 ? 255 : thickness;
            thickness = thickness < 1 ? 1 : thickness;
            this.output.outputFlagAndShortAndByteData(5, this.output.convertIntToByte(thickness));
        }
    }

    private void exportSegments(Molecule mol) {
        MoleculeGraph[] fragments = mol.getFragCount() == 1 ? new Molecule[]{mol} : mol.findFrags();
        Map<MoleculeGraph, List<List<MolAtom>>> selecMolMap = this.sgroupUtil.getComponentsOfSeleMolecule(fragments, mol);
        for (MoleculeGraph fragment : fragments) {
            Segment segment = this.getSegment(fragment, selecMolMap.get(fragment), mol);
            if (!this.sgBoolMap.isEmpty()) {
                this.superAtomBondMap = this.sgroupUtil.getSuperatomAndAcrossBondMap();
                this.superAtomMap = this.sgroupUtil.getSuperAtomMap();
                this.exportSegmentWithSuperSgroup(segment, mol);
            } else {
                this.exportSingleSegment(segment, mol);
            }
            this.sgBoolMap.clear();
        }
    }

    private Segment getSegment(MoleculeGraph sm, List<List<MolAtom>> components, Molecule mol) {
        Segment segment = this.rebuildSegments(sm, mol);
        this.sgroupUtil.rebuildSpecialSuperSgroup(segment, components);
        this.buildFinalSegment(segment);
        this.buildSegmentForDataSgroup(segment);
        return segment;
    }

    private void buildSegmentForDataSgroup(Segment segment) {
        List<Object> objects = segment.getObjects();
        List<Sgroup> dataSgroups = this.getDataSgroupsFromCurrentObjects(objects);
        if (dataSgroups != null && !dataSgroups.isEmpty()) {
            ArrayList<Sgroup> needRemoveSgroups = new ArrayList<Sgroup>();
            for (int i = 0; i < dataSgroups.size(); ++i) {
                Sgroup sgroup = dataSgroups.get(i);
                for (int j = 0; j < objects.size(); ++j) {
                    List<Object> objs;
                    Object obj = objects.get(i);
                    if (!(obj instanceof Segment) || (objs = ((Segment)obj).getObjects()) == null || objs.isEmpty() || objs.contains(sgroup) || !this.isSegmentContainDataSgroupAtoms(objs, sgroup)) continue;
                    objs.add(sgroup);
                    needRemoveSgroups.add(sgroup);
                }
            }
            objects.removeAll(needRemoveSgroups);
        } else {
            for (int i = 0; i < objects.size(); ++i) {
                Object object = objects.get(i);
                if (!(object instanceof Segment)) continue;
                this.buildSegmentForDataSgroup((Segment)object);
            }
        }
    }

    private boolean isSegmentContainDataSgroupAtoms(List<Object> objects, Sgroup dataSgroup) {
        boolean flag = false;
        List<MolAtom> dataSgroupAtoms = Arrays.asList(dataSgroup.getAtomArray());
        int sameCount = 0;
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            if (!(o instanceof MolAtom) || !dataSgroupAtoms.contains(o)) continue;
            ++sameCount;
        }
        if (sameCount != 0) {
            flag = true;
        }
        return flag;
    }

    private List<Sgroup> getDataSgroupsFromCurrentObjects(List<Object> objects) {
        ArrayList<Sgroup> sgroups = new ArrayList<Sgroup>();
        for (Object ob : objects) {
            Sgroup sg;
            if (!(ob instanceof Sgroup) || (sg = (Sgroup)ob).getType() != 10) continue;
            sgroups.add(sg);
        }
        return sgroups;
    }

    private void buildFinalSegment(Segment segment) {
        List<Object> objects = segment.getObjects();
        List<Sgroup> superSgroups = this.getSuperSgroupsFromCurrentObjects(objects);
        if (superSgroups != null && !superSgroups.isEmpty()) {
            this.sgBoolMap.put(segment, true);
            this.createNewRelationOfSegment(segment, superSgroups);
        } else {
            for (int i = 0; i < objects.size(); ++i) {
                Object object = objects.get(i);
                if (!(object instanceof Segment)) continue;
                Segment sg = (Segment)object;
                List<Object> childObjects = sg.getObjects();
                List<Sgroup> insideSuperSgroups = this.getSuperSgroupsFromCurrentObjects(childObjects);
                if (superSgroups != null && !insideSuperSgroups.isEmpty()) {
                    this.sgBoolMap.put(sg, true);
                    this.createNewRelationOfSegment(sg, insideSuperSgroups);
                    continue;
                }
                this.buildFinalSegment(sg);
            }
        }
    }

    private List<Sgroup> getSuperSgroupsFromCurrentObjects(List<Object> objects) {
        ArrayList<Sgroup> sgroups = new ArrayList<Sgroup>();
        for (Object ob : objects) {
            Sgroup sg;
            if (!(ob instanceof Sgroup) || (sg = (Sgroup)ob).getType() != 0) continue;
            sgroups.add(sg);
        }
        return sgroups;
    }

    private void createNewRelationOfSegment(Segment segment, List<Sgroup> superSgroups) {
        List<Object> objects = segment.getObjects();
        List<Sgroup> insideOtherSgroups = this.getOtherSgroupsFromCurrentObjects(objects);
        List<List<MolAtom>> components = this.sgroupUtil.getAllComponentsFromObjects(objects);
        List<Object> newObjects = this.sgroupUtil.getFinalTopObjectsOfSegment(components, superSgroups, segment.getObjects());
        if (insideOtherSgroups != null && !insideOtherSgroups.isEmpty()) {
            newObjects.addAll(insideOtherSgroups);
        }
        segment.setObjects(newObjects);
    }

    private List<Sgroup> getOtherSgroupsFromCurrentObjects(List<Object> objects) {
        ArrayList<Sgroup> sgroups = new ArrayList<Sgroup>();
        for (Object ob : objects) {
            Sgroup sg;
            if (!(ob instanceof Sgroup) || (sg = (Sgroup)ob).getType() == 0) continue;
            sgroups.add(sg);
        }
        return sgroups;
    }

    private void exportSegmentWithSuperSgroup(Segment segment, Molecule mol) {
        this.output.outputFeatureFlagData(12);
        this.output.outputPropertyArrayData(48, new Object[]{this.output.convertIntToShort(-1), this.output.convertIntToShort(-1)});
        this.output.outputFlagAndShortData(19);
        List<Object> objectList = segment.getObjects();
        this.output.outputShortAndFlagData(2, this.output.convertIntToShort(objectList.size()));
        for (Object currentObject : objectList) {
            if (currentObject instanceof MolAtom) {
                MolAtom molAtom = (MolAtom)currentObject;
                this.exportAtom(molAtom);
                if (this.superAtomBondMap.containsKey(molAtom)) {
                    this.exportSuperAtomProperties(this.superAtomBondMap.get(molAtom), objectList);
                    Segment insideSegment = new Segment();
                    insideSegment.setObjects(this.superAtomMap.get(molAtom));
                    this.exportSuperAtomObjects(mol, insideSegment);
                }
            }
            if (currentObject instanceof MolBond) {
                this.exportSingleBond((MolBond)currentObject, objectList);
            }
            if (currentObject instanceof Segment) {
                this.exportSegmentWithSuperSgroup((Segment)currentObject, mol);
            }
            if (currentObject instanceof Sgroup) {
                this.exportSgroup(mol, (Sgroup)currentObject, segment);
            }
            if (!(currentObject instanceof MolAtom) || !((MolAtom)currentObject).isLinkNode()) continue;
            this.exportLinkNodeSgroup(this.cmolClone, (MolAtom)currentObject, segment);
        }
        this.output.outputFlagAndShortData(20);
    }

    private void exportSuperAtomProperties(List<MolBond> mbs, List<Object> objectList) {
        if (mbs != null && !mbs.isEmpty()) {
            int bondCount = mbs.size();
            ArrayList<Number> list = new ArrayList<Number>(bondCount + 1);
            list.add(this.output.convertIntToByte(bondCount));
            for (int i = bondCount - 1; i >= 0; --i) {
                list.add(this.output.convertIntToShort(objectList.indexOf(mbs.get(i))));
            }
            this.output.outputPropertyArrayData(60, list.toArray());
        } else {
            this.output.outputPropertyArrayData(60, new Object[]{this.output.convertIntToByte(0)});
        }
    }

    private void exportSuperAtomObjects(Molecule mol, Segment segment) {
        List<Object> objectList = segment.getObjects();
        if (objectList != null) {
            this.output.outputFlagAndShortData(19);
            this.output.outputShortAndFlagData(2, this.output.convertIntToShort(objectList.size()));
            for (Object currentObject : objectList) {
                if (currentObject instanceof MolAtom) {
                    MolAtom molAtom = (MolAtom)currentObject;
                    this.exportAtom(molAtom);
                }
                if (currentObject instanceof MolBond) {
                    this.exportSingleBond((MolBond)currentObject, objectList);
                }
                if (currentObject instanceof Segment) {
                    this.exportSegmentWithSuperSgroup((Segment)currentObject, mol);
                }
                if (currentObject instanceof Sgroup) {
                    this.exportSgroup(mol, (Sgroup)currentObject, segment);
                }
                if (!(currentObject instanceof MolAtom) || !((MolAtom)currentObject).isLinkNode()) continue;
                this.exportLinkNodeSgroup(this.cmolClone, (MolAtom)currentObject, segment);
            }
            this.output.outputFlagAndShortData(20);
        }
    }

    private void exportSingleSegment(Segment segment, Molecule mol) {
        this.output.outputFeatureFlagData(12);
        this.output.outputPropertyArrayData(48, new Object[]{this.output.convertIntToShort(-1), this.output.convertIntToShort(-1)});
        this.output.outputFlagAndShortData(19);
        List<Object> objects = segment.getObjects();
        this.output.outputShortAndFlagData(2, this.output.convertIntToShort(objects.size()));
        for (Object currentObject : objects) {
            if (!(currentObject instanceof MolAtom)) continue;
            this.exportAtom((MolAtom)currentObject);
        }
        this.exportBonds(segment.getMolBonds(), segment);
        for (Object currentObject : objects) {
            if (currentObject instanceof Segment) {
                this.exportSingleSegment((Segment)currentObject, mol);
            }
            if (currentObject instanceof Sgroup) {
                this.exportSgroup(mol, (Sgroup)currentObject, segment);
            }
            if (!(currentObject instanceof MolAtom) || !((MolAtom)currentObject).isLinkNode()) continue;
            this.exportLinkNodeSgroup(this.cmolClone, (MolAtom)currentObject, segment);
        }
        this.output.outputFlagAndShortData(20);
    }

    private Segment rebuildSegments(MoleculeGraph sm, Molecule cmol) {
        Sgroup[] sgroupsOfTotal = cmol.getSgroupArray();
        ArrayList<Sgroup> sgroups = new ArrayList<Sgroup>();
        for (Sgroup s : sgroupsOfTotal) {
            MolAtom[] atomsOfSgroup;
            for (MolAtom a : atomsOfSgroup = s.getAtomArray()) {
                if (!sm.contains(a)) continue;
                sgroups.add(s);
                break;
            }
            if (atomsOfSgroup.length != 0) continue;
            sgroups.add(s);
        }
        if (sgroups.size() == 0) {
            return new Segment(sm);
        }
        this.groupsOfConnectedAtoms = new HashMap<Integer, List<MolAtom>>();
        this.fragmentMap = new HashMap<Integer, Segment>();
        Segment fragment = null;
        MoleculeGraph[] segments = sm.findFrags(MoleculeGraph.class);
        for (int i = 0; i < segments.length; ++i) {
            Segment segment = new Segment(segments[i]);
            this.groupsOfConnectedAtoms.put(i, Arrays.asList(segments[i].getAtomArray()));
            this.fragmentMap.put(i, segment);
        }
        ArrayList<Sgroup> needProcessed = new ArrayList<Sgroup>();
        HashMap<Sgroup, SgroupBeanInfo> sgroupInfos = new HashMap<Sgroup, SgroupBeanInfo>();
        if (sgroups != null && sgroups.size() > 0) {
            for (Sgroup sgroup : sgroups) {
                needProcessed.add(sgroup);
                SgroupBeanInfo sgroupInfo = new SgroupBeanInfo();
                sgroupInfo.setSgroup(sgroup);
                MolAtom[] cAtomsOfSgroup = sgroup.getAtomArray();
                HashMap<Integer, List<MolAtom>> pathes = new HashMap<Integer, List<MolAtom>>();
                Set<Integer> connectedPathes = this.groupsOfConnectedAtoms.keySet();
                for (Integer ci : connectedPathes) {
                    List<MolAtom> atoms = this.groupsOfConnectedAtoms.get(ci);
                    ArrayList<MolAtom> atomsInSgroup = new ArrayList<MolAtom>();
                    for (MolAtom cAtom : cAtomsOfSgroup) {
                        if (!atoms.contains(cAtom)) continue;
                        atomsInSgroup.add(cAtom);
                    }
                    if (atomsInSgroup.isEmpty()) continue;
                    pathes.put(ci, atomsInSgroup);
                }
                sgroupInfo.setPathes(pathes);
                sgroupInfos.put(sgroup, sgroupInfo);
            }
            for (Sgroup sgroup : sgroups) {
                SgroupBeanInfo sgroupInfo = (SgroupBeanInfo)sgroupInfos.get(sgroup);
                int childrenCount = sgroup.getChildSgroupCount();
                for (int i = 0; i < childrenCount; ++i) {
                    Sgroup child = sgroup.getChildSgroup(i);
                    sgroupInfo.addChildSgroupInfo((SgroupBeanInfo)sgroupInfos.get(child));
                }
            }
            while (!needProcessed.isEmpty()) {
                for (Sgroup s : sgroups) {
                    SgroupBeanInfo si = (SgroupBeanInfo)sgroupInfos.get(s);
                    if (si.isProcessed() || !si.isChildrenProcessed()) continue;
                    si.setProcessed(true);
                    needProcessed.remove(s);
                    Map<Integer, List<MolAtom>> indexes = this.getSgroupPathesOfPart(si);
                    Segment sgroupFragment = null;
                    for (Integer i : indexes.keySet()) {
                        if (sgroupFragment == null) {
                            sgroupFragment = this.fragmentMap.get(i);
                            continue;
                        }
                        Segment remove = this.fragmentMap.get(i);
                        if (remove.getMolAtoms() != null) {
                            for (MolAtom a : (ArrayList)remove.getMolAtoms()) {
                                sgroupFragment.addAtom(a);
                            }
                        }
                        if (remove.getMolBonds() == null) continue;
                        for (MolBond b : (ArrayList)remove.getMolBonds()) {
                            sgroupFragment.addBond(b);
                        }
                    }
                    indexes = this.getSgroupPathes(si);
                    for (Integer i : indexes.keySet()) {
                        if (sgroupFragment == null) {
                            sgroupFragment = new Segment();
                        }
                        sgroupFragment.addChildSegment(this.fragmentMap.get(i));
                        this.fragmentMap.put(i, sgroupFragment);
                    }
                    if (sgroupFragment != null) {
                        sgroupFragment.addSgroup(s);
                        this.addChildDataSgroupWithoutAtom(s, sgroupFragment);
                        fragment = sgroupFragment;
                    }
                    int max = this.getMax(this.groupsOfConnectedAtoms.keySet());
                    if (indexes.size() <= 1) continue;
                    this.connectPathes(indexes.keySet(), max + 1);
                    for (Sgroup ss : needProcessed) {
                        ((SgroupBeanInfo)sgroupInfos.get(ss)).connectPathes(indexes.keySet(), max + 1);
                    }
                    this.fragmentMap.put(max + 1, sgroupFragment);
                }
            }
        }
        return fragment;
    }

    private void addChildDataSgroupWithoutAtom(Sgroup s, Segment sgroupFragment) {
        int childSgroupCount = s.getChildSgroupCount();
        if (childSgroupCount != 0) {
            for (int i = 0; i < childSgroupCount; ++i) {
                Sgroup childSgroup = s.getChildSgroup(i);
                if (childSgroup.getType() != 10 || childSgroup.getAtomCount() != 0) continue;
                sgroupFragment.addSgroup(childSgroup);
            }
        }
    }

    private void exportBonds(List<MolBond> bonds, Segment segment) {
        for (int i = 0; i < bonds.size(); ++i) {
            MolBond bond = bonds.get(i);
            List<Object> objects = segment.getObjects();
            this.exportSingleBond(bond, objects);
        }
    }

    private void exportSingleBond(MolBond bond, List<Object> objects) {
        this.output.outputFeatureFlagData(32);
        this.exportBondFormat(bond.getSetSeq());
        MolAtom atom1 = bond.getAtom1();
        MolAtom atom2 = bond.getAtom2();
        int index1 = objects.indexOf(atom1);
        int index2 = objects.indexOf(atom2);
        this.output.outputPropertyArrayData(39, new Object[]{this.output.convertIntToShort(index1), this.output.convertIntToShort(index2)});
        this.output.outputFlagAndFeatureData(43, MolBondInfo.getTopology(bond.getFlags()));
        if (atom1.getStereoCare() && atom2.getStereoCare()) {
            this.output.outputFlagAndShortData(45);
        }
        if (bond.isBold()) {
            this.output.outputFlagAndShortAndByteData(82, this.output.convertIntToByte(1));
            this.output.outputFlagAndFeatureData(41, 1);
        } else {
            this.output.outputFlagAndFeatureData(41, MolBondInfo.getBondStereo(bond.getFlags()));
            this.output.outputFlagAndFeatureData(40, MolBondInfo.getBondOrder(bond.getType()));
        }
        int reactingCenter = MolBondInfo.getSkcBondReactionStatus(bond.getFlags());
        if (reactingCenter != 0) {
            this.output.outputFlagAndFeatureData(44, this.output.convertIntToShort(reactingCenter));
        }
    }

    private void exportReactions(Molecule mol) {
        Molecule molecule;
        Molecule molecule2 = mol instanceof RxnMolecule ? mol : (molecule = mol instanceof RgMolecule ? ((RgMolecule)mol).getRoot() : null);
        if (molecule != null && molecule instanceof RxnMolecule) {
            RxnMolecule rxnMol = (RxnMolecule)molecule;
            this.exportReactionReactant(rxnMol);
            this.exportReactionProuct(rxnMol);
            this.exportReactionArrow(rxnMol);
        }
    }

    private void exportReactionArrow(RxnMolecule rxnMol) {
        DPoint3[] ps = rxnMol.getReactionArrow();
        this.output.outputFeatureFlagData(14);
        this.output.outputPropertyArrayData(48, new Object[]{this.output.convertIntToShort(-1), this.output.convertIntToShort(-1)});
        short x1 = this.output.convertFloatToShort(Coordinate.getXOfSkc(ps[0].x));
        short y1 = this.output.convertFloatToShort(Coordinate.getYOfSkc(ps[0].y));
        short x2 = this.output.convertFloatToShort(Coordinate.getXOfSkc(ps[1].x));
        short y2 = this.output.convertFloatToShort(Coordinate.getYOfSkc(ps[1].y));
        this.output.outputPropertyArrayData(13, new Object[]{x1, y1, x2, y2});
        int arrowDir = 0;
        int arrowStyle = 0;
        double widthValue = 30.0;
        double lengthValue = 66.0;
        if (rxnMol.getReactionArrowType() == 0) {
            arrowDir = 1;
            arrowStyle = 1;
        } else if (rxnMol.getReactionArrowType() == 2) {
            arrowDir = 1;
            arrowStyle = 17;
            widthValue = 108.0;
            lengthValue = 62.0;
        } else if (rxnMol.getReactionArrowType() == 1) {
            arrowDir = 3;
            arrowStyle = 1;
        } else if (rxnMol.getReactionArrowType() == 3) {
            arrowDir = 4;
            arrowStyle = 14;
            widthValue = 100.0;
            lengthValue = 50.0;
        }
        this.output.outputPropertyArrayData(56, new Object[]{this.output.convertIntToByte(arrowDir)});
        this.output.outputPropertyArrayData(57, new Object[]{this.getSkcArrowStyle(arrowStyle)});
        Object[] arrowSizeArray = new Object[]{this.output.convertDoubleToShort(lengthValue), this.output.convertDoubleToShort(widthValue), this.output.convertIntToByte(0), this.output.convertIntToByte(0)};
        this.output.outputPropertyArrayData(229, arrowSizeArray);
        byte byte1 = arrowStyle == 17 ? this.output.convertIntToByte(2) : this.output.convertIntToByte(0);
        byte byte2 = arrowStyle == 15 || arrowStyle == 16 ? this.output.convertIntToByte(3) : byte1;
        byte resultByte = arrowDir == 4 ? this.output.convertIntToByte(4) : byte2;
        this.output.outputFlagAndShortAndByteData(220, resultByte);
        if (arrowStyle == 16) {
            this.output.outputFlagAndShortAndByteData(9, this.output.convertIntToByte(1));
        }
        if (this.isArrowNeededShaftSpace(arrowDir, arrowStyle)) {
            this.output.outputPropertyArrayData(230, new Object[]{Float.valueOf(50.0f), this.output.convertIntToByte(0)});
        }
    }

    private byte getSkcArrowStyle(int arrowStyle) {
        switch (arrowStyle) {
            case 15: 
            case 16: {
                return this.output.convertIntToByte(4);
            }
            case 17: {
                return this.output.convertIntToByte(3);
            }
        }
        return this.output.convertIntToByte(arrowStyle);
    }

    private void exportReactionReactant(RxnMolecule rxnMol) {
        int rc = rxnMol.getReactantCount();
        if (rc >= 2) {
            for (int i = 0; i < rc - 1; ++i) {
                Coordinate p1 = this.getMolCenter(rxnMol.getReactant(i));
                Coordinate p2 = this.getMolCenter(rxnMol.getReactant(i + 1));
                this.exportReactantOrProduct(p1, p2);
            }
            this.output.outputFlagAndShortData(8);
        }
    }

    private void exportReactionProuct(RxnMolecule rxnMol) {
        int pc = rxnMol.getProductCount();
        if (pc >= 2) {
            for (int i = 0; i < pc - 1; ++i) {
                Coordinate p1 = this.getMolCenter(rxnMol.getProduct(i));
                Coordinate p2 = this.getMolCenter(rxnMol.getProduct(i + 1));
                this.exportReactantOrProduct(p1, p2);
            }
            this.output.outputFlagAndShortData(8);
        }
    }

    private void exportReactantOrProduct(Coordinate p1, Coordinate p2) {
        Coordinate coordinate = new Coordinate((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
        this.output.outputFeatureFlagData(9);
        this.output.outputPropertyArrayData(48, new Object[]{this.output.convertIntToShort(-1), this.output.convertIntToShort(-1)});
        short x1 = this.output.convertDoubleToShort(this.convertCoordinateForX(coordinate.getX()));
        short y1 = this.output.convertDoubleToShort(this.convertCoordinateForY(coordinate.getY() * -1.0));
        short x2 = this.output.convertDoubleToShort(this.convertCoordinateForX(coordinate.getX()));
        short y2 = this.output.convertDoubleToShort(this.convertCoordinateForY(coordinate.getY() * -1.0));
        this.output.outputPropertyArrayData(13, new Object[]{x1, y1, x2, y2});
        this.exportReactionBaseData();
    }

    private void exportReactionBaseData() {
        byte[] byteArrayData = ChemUtil.baseReactionData;
        short size = this.output.convertIntToShort(180);
        int v1 = size & ChemUtil.getFactorValue(7, 1);
        byteArrayData[ChemUtil.getFactorValue((int)5, (int)3)] = this.output.convertIntToByte(v1);
        int v2 = (size & ChemUtil.getFactorValue(15, ChemUtil.getFactorValue(7))) >> ChemUtil.getFactorValue(2);
        byteArrayData[ChemUtil.getFactorValue((int)5, (int)2)] = this.output.convertIntToByte(v2);
        this.output.outputFlagAndByteArrayData(21, byteArrayData);
    }

    private boolean isArrowNeededShaftSpace(int type, int flag) {
        if (type != 4 && type != 5 && flag != 15 && flag != 16) {
            return flag == 17;
        }
        return true;
    }

    private void exportSgroup(Molecule mol, Sgroup currentSgroup, Segment segment) {
        switch (currentSgroup.getType()) {
            case 1: {
                this.exportMultipleSgroup(currentSgroup, segment);
                this.exportSgroupBreaketFormat(currentSgroup);
                break;
            }
            case 0: {
                this.exportSuperatomSgroup(currentSgroup, segment);
                break;
            }
            case 10: {
                this.exportDataSgroup(currentSgroup, segment);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                this.exportBaseSgroup(currentSgroup, segment);
                this.exportSgroupConnectivity(currentSgroup);
                this.exportComSgroupOrder(currentSgroup);
                this.exportSruSgroupLabel(currentSgroup);
                this.exportSgroupBreaketFormat(currentSgroup);
            }
        }
    }

    private void exportDataSgroup(Sgroup currentSgroup, Segment segment) {
        DataSgroup dataSgroup = (DataSgroup)currentSgroup;
        short pointX = this.output.convertFloatToShort(Coordinate.getXOfSkc(dataSgroup.getX()) + 0.5f);
        short pointY = this.output.convertFloatToShort(Coordinate.getYOfSkc(dataSgroup.getY()) + 0.5f);
        String fieldName = dataSgroup.getFieldName();
        ArrayList<Short> shortList = new ArrayList<Short>();
        this.output.outputFeatureFlagData(35);
        if (this.stereoDataSgroups.contains(dataSgroup)) {
            MolAtom ma = this.atomStereoMap.get(dataSgroup);
            pointX = this.output.convertFloatToShort(Coordinate.getXOfSkc(ma.getX()) - 100.5f);
            pointY = this.output.convertFloatToShort(Coordinate.getYOfSkc(ma.getY()) + 1.5f);
            int stereoGroupNumber = ma.getStereoGroupNumber();
            int stereoType = ma.getStereoGroupType();
            switch (stereoType) {
                case 1: {
                    this.output.outputTextContentData("abs", 1, 1.0f);
                    break;
                }
                case 2: {
                    this.output.outputTextContentData("or" + stereoGroupNumber, 1, 1.0f);
                    break;
                }
                case 3: {
                    this.output.outputTextContentData("&" + stereoGroupNumber, 1, 1.0f);
                }
            }
            switch (stereoType) {
                case 1: {
                    fieldName = "MDL_STEABS";
                    this.output.outputSymbolData(252, fieldName);
                    break;
                }
                case 2: {
                    fieldName = "MDL_STEREL" + stereoGroupNumber;
                    this.output.outputSymbolData(252, fieldName);
                    break;
                }
                case 3: {
                    fieldName = "MDL_STERAC" + stereoGroupNumber;
                    this.output.outputSymbolData(252, fieldName);
                }
            }
            shortList.add(this.output.convertIntToShort(segment.getObjects().indexOf(ma)));
            this.output.outputShortAndFlagData(250, this.output.convertIntToShort(shortList.size()));
            this.output.outputShortArrayData(251, shortList);
            this.output.outputFlagAndShortAndByteData(253, this.output.convertIntToByte(0));
            this.output.outputSymbolData(254, "");
            this.output.outputFlagAndShortAndByteData(255, this.output.convertIntToByte(1));
        } else {
            List<MolAtom> dataSgroupAtoms;
            String data = dataSgroup.getData();
            String dataOperator = dataSgroup.getQueryOp();
            String dataText = "";
            dataText = dataOperator != null ? dataOperator + " " + data : data;
            char tagText = dataSgroup.getTag();
            if (tagText != ' ') {
                dataText = String.valueOf(tagText) + "=" + dataText;
            }
            if ((dataSgroupAtoms = Arrays.asList(dataSgroup.getAtomArray())) != null) {
                ArrayList<MolBond> dataSgroupBonds = new ArrayList<MolBond>();
                for (MolAtom atom : dataSgroupAtoms) {
                    shortList.add(this.output.convertIntToShort(segment.getObjects().indexOf(atom)));
                    for (int i = 0; i < atom.getBondCount(); ++i) {
                        MolBond mb = atom.getBond(i);
                        if (dataSgroupBonds.contains(mb)) continue;
                        dataSgroupBonds.add(mb);
                    }
                }
                for (MolBond bond : dataSgroupBonds) {
                    MolAtom ma1 = bond.getAtom1();
                    MolAtom ma2 = bond.getAtom2();
                    if (!dataSgroupAtoms.contains(ma1) || !dataSgroupAtoms.contains(ma2)) continue;
                    shortList.add(this.output.convertIntToShort(segment.getObjects().indexOf(bond)));
                }
            }
            this.output.outputTextContentData(dataText, 1, 1.0f);
            this.output.outputShortAndFlagData(250, this.output.convertIntToShort(shortList.size()));
            this.output.outputShortArrayData(251, shortList);
            this.output.outputSymbolData(252, fieldName);
            this.output.outputFlagAndShortAndByteData(253, this.output.convertIntToByte(4));
            this.output.outputSymbolData(254, "");
            this.output.outputFlagAndShortAndByteData(255, this.output.convertIntToByte(1));
        }
        this.output.outputPropertyArrayData(13, new Object[]{pointX, pointY, pointX, pointY});
    }

    private void exportMultipleSgroup(Sgroup currentSgroup, Segment segment) {
        ArrayList<Number> brackets = new ArrayList<Number>();
        ArrayList<Coordinate> pointList1 = this.getBracketPointList(currentSgroup).get(1);
        ArrayList<Coordinate> pointList2 = this.getBracketPointList(currentSgroup).get(0);
        brackets.add(this.output.convertIntToByte(pointList1.size()));
        for (int i = 0; i < pointList1.size(); ++i) {
            Coordinate p3d1 = pointList1.get(i);
            Coordinate p3d2 = pointList2.get(i);
            brackets.add(this.output.convertDoubleToShort(p3d1.getX()));
            brackets.add(this.output.convertDoubleToShort(p3d1.getY()));
            brackets.add(this.output.convertDoubleToShort(p3d2.getX()));
            brackets.add(this.output.convertDoubleToShort(p3d2.getY()));
        }
        ArrayList<Number> valueList = new ArrayList<Number>();
        MolBond[] crossingBonds = currentSgroup.findCrossingBonds();
        MolAtom[] crossingAtoms = currentSgroup.getCrossingAtoms(crossingBonds);
        List<Object> objectList = segment.getObjects();
        if (crossingBonds != null && crossingBonds.length > 0) {
            valueList.add(crossingAtoms != null ? this.output.convertIntToByte(crossingAtoms.length) : (byte)0);
            valueList.add(crossingBonds != null ? this.output.convertIntToByte(crossingBonds.length) : (byte)0);
            for (int i = 0; i < crossingBonds.length; ++i) {
                valueList.add(this.output.convertIntToShort(objectList.indexOf(crossingBonds[i])));
                valueList.add(this.output.convertIntToShort(objectList.indexOf(crossingAtoms[i])));
                valueList.add(this.output.convertIntToByte(0));
                valueList.add(this.output.convertIntToByte(0));
                valueList.add(this.output.convertIntToByte(0));
            }
        } else {
            valueList.add(this.output.convertIntToByte(segment.getChildren().size()));
            valueList.add(this.output.convertIntToByte(0));
            for (Object currentObject : objectList) {
                if (!(currentObject instanceof Segment)) continue;
                valueList.add(this.output.convertIntToShort(-1));
                valueList.add(this.output.convertIntToShort(objectList.indexOf(currentObject)));
                valueList.add(this.output.convertIntToByte(0));
                valueList.add(this.output.convertIntToByte(0));
                valueList.add(this.output.convertIntToByte(1));
            }
        }
        MultipleSgroup msg = (MultipleSgroup)currentSgroup;
        this.output.outputFeatureFlagData(34);
        this.output.outputPropertyArrayData(164, valueList.toArray());
        this.output.outputFlagAndShortAndByteData(54, this.output.convertIntToByte(16));
        this.output.outputShortAndFlagData(249, this.output.convertIntToShort(10));
        this.output.outputPropertyArrayData(242, brackets.toArray());
        this.output.outputShortAndFlagData(244, this.output.convertIntToShort(this.multiplieres.get(msg)));
        this.output.outputFlagAndShortAndByteData(247, this.output.convertIntToByte(currentSgroup.getBrackets().get(0).getType() == 1 ? 0 : 1));
    }

    private void exportBaseSgroup(Sgroup currentSgroup, Segment segment) {
        byte groupType = SgroupUtil.getSkcGroupType(currentSgroup);
        this.output.outputFeatureFlagData(34);
        this.output.outputShortAndFlagData(249, this.output.convertIntToShort(10));
        this.output.outputFlagAndShortAndByteData(247, this.output.convertIntToByte(currentSgroup.getBrackets().get(0).getType() == 1 ? 0 : 1));
        this.output.outputFlagAndShortAndByteData(54, groupType);
        if (groupType >= 3 && groupType <= 18) {
            ArrayList<Number> brackets = new ArrayList<Number>();
            ArrayList<Coordinate> pointList1 = this.getBracketPointList(currentSgroup).get(1);
            ArrayList<Coordinate> pointList2 = this.getBracketPointList(currentSgroup).get(0);
            brackets.add(this.output.convertIntToByte(pointList1.size()));
            for (int i = 0; i < pointList1.size(); ++i) {
                Coordinate pointd2 = pointList1.get(i);
                Coordinate pointd3 = pointList2.get(i);
                brackets.add(this.output.convertDoubleToShort(pointd2.getX()));
                brackets.add(this.output.convertDoubleToShort(pointd2.getY()));
                brackets.add(this.output.convertDoubleToShort(pointd3.getX()));
                brackets.add(this.output.convertDoubleToShort(pointd3.getY()));
            }
            this.output.outputPropertyArrayData(242, brackets.toArray());
        }
        MolBond[] crossingBonds = currentSgroup.findCrossingBonds();
        MolAtom[] crossingAtoms = currentSgroup.getCrossingAtoms(crossingBonds);
        List<Segment> childrenSegment = segment.getChildren();
        ArrayList<Number> sgroupDataList = new ArrayList<Number>();
        sgroupDataList.add(this.output.convertIntToByte(crossingAtoms.length + (childrenSegment != null ? childrenSegment.size() : 0)));
        sgroupDataList.add(this.output.convertIntToByte(crossingBonds.length));
        int size = crossingAtoms.length;
        List<Object> objectList = segment.getObjects();
        for (int count = 0; count < size; ++count) {
            MolAtom currentAtom = crossingAtoms[count];
            MolBond currentBond = count >= crossingBonds.length ? null : crossingBonds[count];
            sgroupDataList.add(this.getBondIndexOfObjectList(objectList, currentBond));
            sgroupDataList.add(this.getAtomIndexOfObjectList(objectList, currentAtom));
            sgroupDataList.add(this.output.convertIntToByte(0));
            sgroupDataList.add(this.output.convertIntToByte(0));
            sgroupDataList.add(this.getByteValueForLinkNode(currentBond));
        }
        if (childrenSegment != null) {
            for (Segment child : childrenSegment) {
                sgroupDataList.add(this.output.convertIntToShort(-1));
                sgroupDataList.add(this.output.convertIntToShort(segment.getObjects().indexOf(child)));
                sgroupDataList.add(this.output.convertIntToByte(0));
                sgroupDataList.add(this.output.convertIntToByte(0));
                sgroupDataList.add(this.output.convertIntToByte(1));
            }
        }
        this.output.outputPropertyArrayData(164, sgroupDataList.toArray());
    }

    private void exportSgroupConnectivity(Sgroup currentSgroup) {
        String connectivity = SgroupUtil.getSkcConnectivity(currentSgroup);
        int v = -1;
        if (connectivity.equals("HT")) {
            v = 0;
        } else if (connectivity.equals("HH")) {
            v = 1;
        } else if (connectivity.equals("EU")) {
            v = 2;
        }
        if (v > -1) {
            this.output.outputPropertyArrayData(241, new Object[]{this.output.convertIntToByte(v)});
        }
    }

    private void exportComSgroupOrder(Sgroup currentSgroup) {
        if (currentSgroup.getType() == 13) {
            String order = currentSgroup.getSubscript().replace("c", "");
            int v = 0;
            if (!order.equals("")) {
                v = Integer.parseInt(order);
            }
            this.output.outputShortAndFlagData(245, this.output.convertIntToShort(v));
        }
    }

    private void exportSruSgroupLabel(Sgroup currentSgroup) {
        if (currentSgroup.getType() == 2) {
            String label = currentSgroup.getSubscript();
            this.output.outputSymbolData(248, label);
        }
    }

    private void exportSgroupBreaketFormat(Sgroup currentSgroup) {
        if (currentSgroup.getBrackets() != null && currentSgroup.isBracketVisible()) {
            MBracket mb = currentSgroup.getBrackets().get(0);
            if (mb == null) {
                return;
            }
            int thickness = (int)(mb.getThickness() / 0.009142857142857144);
            if (thickness != 17) {
                thickness = thickness > 255 ? 55 : thickness;
                this.output.outputFlagAndShortAndByteData(5, this.output.convertIntToByte(thickness));
            }
            int style = mb.getType() == 1 ? 0 : 1;
            this.output.outputFlagAndShortAndByteData(247, this.output.convertIntToByte(style));
            this.output.outputFlagAndColorData(88, mb.getLineColor());
        }
    }

    private void exportSuperatomSgroup(Sgroup currentSgroup, Segment segment) {
        SuperatomSgroup superSgroup = (SuperatomSgroup)currentSgroup;
        this.output.outputFeatureFlagData(34);
        byte groupType = SgroupUtil.getSkcGroupType(currentSgroup);
        this.output.outputFlagAndShortAndByteData(54, groupType);
        this.output.outputSymbolData(52, superSgroup.getSubscript());
        if (!this.sgroupContractOrExpandedFlagMap.get(currentSgroup).booleanValue()) {
            this.output.outputFlagAndShortData(61);
        }
        MolBond[] crossingBondsTemp = currentSgroup.findCrossingBonds();
        MolAtom[] crossingAtomsTemp = currentSgroup.getCrossingAtoms(crossingBondsTemp);
        List<MolBond> crossingBonds = Arrays.asList(crossingBondsTemp);
        List<MolAtom> crossingAtoms = Arrays.asList(crossingAtomsTemp);
        List<Segment> childrenSegment = segment.getChildren();
        List<Object> objectList = segment.getObjects();
        ArrayList<Number> valueList = new ArrayList<Number>();
        if (crossingAtoms.size() > 0 || childrenSegment.size() > 0) {
            int size;
            valueList.add(this.output.convertIntToByte(crossingAtoms.size() + childrenSegment.size()));
            valueList.add(this.output.convertIntToByte(crossingBonds.size()));
            for (int count = size = crossingAtoms.size() - 1; count >= 0; --count) {
                MolBond currentBond;
                MolAtom currentAtom = crossingAtoms.get(count);
                MolBond molBond = currentBond = count >= crossingBonds.size() ? null : crossingBonds.get(count);
                if (currentBond != null && crossingBonds.size() >= 2) {
                    currentBond = this.sgroupUtil.getAbbreviationBond(currentBond) != null ? this.sgroupUtil.getAbbreviationBond(currentBond) : currentBond;
                }
                valueList.add(this.getBondIndexOfObjectList(objectList, currentBond));
                valueList.add(this.getAtomIndexOfObjectList(objectList, currentAtom));
                valueList.add(this.output.convertIntToByte(0));
                valueList.add(this.output.convertIntToByte(0));
                valueList.add(this.getByteValueForLinkNode(currentBond));
            }
            for (Segment childSegment : childrenSegment) {
                valueList.add(this.output.convertIntToShort(-1));
                valueList.add(this.output.convertIntToShort(objectList.indexOf(childSegment)));
                valueList.add(this.output.convertIntToByte(0));
                valueList.add(this.output.convertIntToByte(0));
                valueList.add(this.output.convertIntToByte(1));
            }
        }
        if (crossingAtoms.size() == 0 && childrenSegment.size() == 0) {
            valueList.add(this.output.convertIntToByte(1));
            valueList.add(this.output.convertIntToByte(crossingBonds.size()));
            valueList.add(this.output.convertIntToShort(-1));
            valueList.add(this.output.convertIntToShort(0));
            valueList.add(this.output.convertIntToByte(0));
            valueList.add(this.output.convertIntToByte(0));
            valueList.add(this.output.convertIntToByte(1));
        }
        this.output.outputPropertyArrayData(164, valueList.toArray());
    }

    private void exportRgroups(Molecule mol) {
        RgMolecule rgMol;
        if (mol instanceof RgMolecule && (rgMol = (RgMolecule)mol).getRgroupCount() > 0) {
            this.output.outputFeatureFlagData(20);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.output.convertIntToByte(rgMol.getRgroupCount()));
            MPoint rlogicPoint = null;
            for (int i = 0; i < rgMol.getRgroupCount(); ++i) {
                int rgroupNumber = rgMol.getRgroupId(i);
                list.add(this.output.convertIntToByte(rgroupNumber));
                String occurence = rgMol.getRlogicRange(i);
                if (occurence == null || occurence.length() <= 0) {
                    occurence = ">0";
                }
                list.add(occurence);
                int restH = 0;
                int f = rgMol.getRlogic(i);
                restH = (f & Integer.MIN_VALUE) != 0 ? 1 : 0;
                list.add(this.output.convertIntToByte(restH));
                int thenR = 0;
                if ((f & 0x8000) != 0) {
                    thenR = f >> 16 & Short.MAX_VALUE;
                }
                list.add(this.output.convertIntToByte(thenR));
                Molecule tempRgroup = null;
                int rmc = rgMol.getRgroupMemberCount(i);
                for (int j = 0; j < rmc; ++j) {
                    tempRgroup = rgMol.getRgroupMember(i, j);
                    ArrayList<MolAtom> tempMolAtomsInAllRgroup = new ArrayList<MolAtom>();
                    for (int k = 0; k < tempRgroup.getAtomArray().length; ++k) {
                        tempMolAtomsInAllRgroup.add(tempRgroup.getAtomArray()[k]);
                    }
                    rlogicPoint = this.getPoint3DForRgoup(tempMolAtomsInAllRgroup);
                }
            }
            this.exportRgroupInforData(rgMol, list, rlogicPoint);
        }
    }

    private void exportRgroupInforData(RgMolecule rgMol, List list, MPoint rlogicPoint) {
        this.output.outputPropertyArrayData(13, new Object[]{this.output.convertDoubleToShort(Coordinate.getXOfSkc(rlogicPoint.getLocation().x + 5.0)), this.output.convertDoubleToShort(Coordinate.getYOfSkc(rlogicPoint.getLocation().y - 5.0)), this.output.convertDoubleToShort(Coordinate.getXOfSkc(rlogicPoint.getLocation().x + 5.0)), this.output.convertDoubleToShort(Coordinate.getYOfSkc(rlogicPoint.getLocation().y - 5.0))});
        this.output.outputPropertyArrayData(50, list.toArray(), true);
        for (int i = 0; i < rgMol.getRgroupCount(); ++i) {
            this.output.outputFeatureFlagData(12);
            this.output.outputPropertyArrayData(48, new Object[]{this.output.convertIntToShort(-1), this.output.convertIntToShort(-1)});
            this.output.outputPropertyArrayData(59, new Object[]{this.output.convertIntToByte(2)});
            this.output.outputFlagAndShortData(19);
            int rmc = rgMol.getRgroupMemberCount(i);
            Molecule rgroup = null;
            ArrayList<MolAtom> molAtomsInAllRgroup = new ArrayList<MolAtom>();
            this.output.outputPropertyArrayData(2, new Object[]{this.output.convertIntToShort(rmc + 1)});
            for (int j = 0; j < rmc; ++j) {
                rgroup = rgMol.getRgroupMember(i, j);
                this.exportSegments(rgroup);
                for (int k = 0; k < rgroup.getAtomArray().length; ++k) {
                    molAtomsInAllRgroup.add(rgroup.getAtomArray()[k]);
                }
            }
            this.output.outputFeatureFlagData(17);
            this.output.outputPropertyArrayData(48, new Object[]{this.output.convertIntToShort(-1), this.output.convertIntToShort(0)});
            MPoint xyz = this.getPoint3DForRgoup(molAtomsInAllRgroup);
            this.output.outputPropertyArrayData(13, new Object[]{this.output.convertDoubleToShort(Coordinate.getXOfSkc(xyz.getLocation().x)), this.output.convertDoubleToShort(Coordinate.getYOfSkc(xyz.getLocation().y)), this.output.convertDoubleToShort(Coordinate.getXOfSkc(xyz.getLocation().x)), this.output.convertDoubleToShort(Coordinate.getYOfSkc(xyz.getLocation().y))});
            this.output.outputFlagAndShortAndByteData(49, this.output.convertIntToByte(rgMol.getRgroupId(i)));
            this.output.outputFlagAndShortData(20);
        }
    }

    private MPoint getPoint3DForRgoup(List<MolAtom> matoms) {
        double y;
        double x;
        int size = matoms.size();
        double[] xarr = new double[size];
        double[] yarr = new double[size];
        HashMap<Double, MolAtom> xmap = new HashMap<Double, MolAtom>();
        HashMap<Double, MolAtom> ymap = new HashMap<Double, MolAtom>();
        for (int i = 0; i < size; ++i) {
            MolAtom molAtom = matoms.get(i);
            xarr[i] = x = molAtom.getX();
            xmap.put(x, molAtom);
            yarr[i] = y = molAtom.getY();
            ymap.put(y, molAtom);
        }
        Arrays.sort(xarr);
        Arrays.sort(yarr);
        MolAtom ml = (MolAtom)xmap.get(xarr[0]);
        MolAtom mt = (MolAtom)ymap.get(yarr[size - 1]);
        x = ml.getX();
        y = (ml.getY() + mt.getY()) / 2.0;
        double z = ml.getZ();
        MPoint mPoint = new MPoint(x - 2.5, y, z);
        return mPoint;
    }

    private void exportGraphicsAndLines(Molecule mol) {
        MDocument mDocument = mol.getDocument();
        if (mDocument == null) {
            mDocument = new MDocument(mol);
        }
        for (int i = 0; i < mDocument.getObjectCount(); ++i) {
            MObject o = mol.getDocument().getObject(i);
            if (!(o instanceof MPolyline)) continue;
            MPolyline mPolyline = (MPolyline)o;
            Color color = mPolyline.getLineColor() == null ? mPolyline.getColor() : mPolyline.getLineColor();
            int mPolylineThickness = this.output.convertDoubleToInt(mPolyline.getThickness() / 0.009142857142857144);
            if (mPolylineThickness != 17) {
                int n = mPolylineThickness = mPolylineThickness > 255 ? 255 : mPolylineThickness;
            }
            if (o instanceof MRectangle) {
                this.processRectangle(o);
                continue;
            }
            if (o instanceof MEFlow) {
                MEFlow meFlow = (MEFlow)o;
                this.exportMEFlow(meFlow);
                continue;
            }
            this.processFlow(mPolyline, color, mPolylineThickness);
        }
    }

    private void processFlow(MPolyline mPolyline, Color color, int mPolylineThickness) {
        if (mPolyline.getArcAngle() == 0.0) {
            MPoint[] mPoints = mPolyline.getPoints();
            for (int j = 0; j < mPoints.length; ++j) {
                Coordinate top = new Coordinate().getSkcPoint3d(mPoints[j].getLocation().x, mPoints[j].getLocation().y, mPoints[j].getLocation().z);
                Coordinate bottom = new Coordinate().getSkcPoint3d(mPoints[j + 1].getLocation().x, mPoints[j + 1].getLocation().y, mPoints[j + 1].getLocation().z);
                this.output.outputFeatureFlagData(4);
                this.output.outputFlagAndColorData(88, color);
                this.output.outputFlagAndShortAndByteData(5, this.output.convertIntToByte(mPolylineThickness));
                this.exportArrowProperties(mPolyline);
                this.output.outputPropertyArrayData(48, new Object[]{this.output.convertIntToShort(-1), this.output.convertIntToShort(-1)});
                Object[] propArray = new Object[]{this.output.convertDoubleToShort(top.getX()), this.output.convertDoubleToShort(top.getY()), this.output.convertDoubleToShort(bottom.getX()), this.output.convertDoubleToShort(bottom.getY())};
                this.output.outputPropertyArrayData(13, propArray);
                if (j != mPoints.length - 2) {
                    continue;
                }
                break;
            }
        } else {
            this.exportMEFlow(mPolyline);
        }
    }

    private void processRectangle(MObject o) {
        MRectangle mRectangle = (MRectangle)o;
        MPoint[] mPoints = mRectangle.getPoints();
        Coordinate top = new Coordinate().getSkcPoint3d(mPoints[0].getLocation().x, mPoints[0].getLocation().y, mPoints[0].getLocation().z);
        Coordinate bottom = new Coordinate().getSkcPoint3d(mPoints[2].getLocation().x, mPoints[2].getLocation().y, mPoints[2].getLocation().z);
        if (o instanceof MBracket) {
            this.exportBracket(o);
        } else if (!(o instanceof MTextBox)) {
            if (o instanceof MEllipse) {
                this.exprotEllipse(mRectangle, top, bottom);
            } else if (o instanceof MRoundedRectangle) {
                this.exportRoundedRectangle(o, mRectangle, top, bottom);
            } else {
                this.exportRectangleFormat(mRectangle, top, bottom);
            }
        }
    }

    private void exportRectangleFormat(MRectangle mRectangle, Coordinate top, Coordinate bottom) {
        this.output.outputFeatureFlagData(2);
        if (mRectangle.getLineColor() != null || mRectangle.getColor() != null) {
            this.output.outputFlagAndColorData(88, mRectangle.getLineColor() == null ? mRectangle.getColor() : mRectangle.getLineColor());
        }
        if (mRectangle.getBackground() != null) {
            this.output.outputFlagAndColorData(89, mRectangle.getBackground());
        }
        int fillStyle = 0;
        fillStyle = mRectangle.getBackground() != null ? 1 : 0;
        this.output.outputFlagAndShortAndByteData(9, this.output.convertIntToByte(fillStyle));
        int thickness = (int)(mRectangle.getThickness() / 0.009142857142857144);
        if (thickness != 17) {
            int n = thickness = thickness > 255 ? 255 : thickness;
        }
        if (thickness > 0) {
            this.output.outputFlagAndShortAndByteData(5, this.output.convertIntToByte(thickness));
        }
        if (top != null && bottom != null) {
            Object[] coordinateArray = new Object[]{this.output.convertDoubleToShort(top.getX()), this.output.convertDoubleToShort(top.getY()), this.output.convertDoubleToShort(bottom.getX()), this.output.convertDoubleToShort(bottom.getY())};
            this.output.outputPropertyArrayData(13, coordinateArray);
        }
    }

    private void exportRoundedRectangle(MObject o, MRectangle mRectangle, Coordinate top, Coordinate bottom) {
        MRoundedRectangle mRoundedRectangle = (MRoundedRectangle)o;
        this.output.outputFeatureFlagData(3);
        this.output.outputFlagAndColorData(88, mRectangle.getLineColor() == null ? mRectangle.getColor() : mRectangle.getLineColor());
        if (mRectangle.getBackground() != null) {
            this.output.outputFlagAndColorData(89, mRectangle.getBackground());
        }
        int fillStyle = 0;
        fillStyle = mRectangle.getBackground() != null ? 1 : 0;
        this.output.outputFlagAndShortAndByteData(9, this.output.convertIntToByte(fillStyle));
        int thickness = this.output.convertDoubleToInt(mRectangle.getThickness() / 0.009142857142857144);
        if (thickness != 17) {
            int n = thickness = thickness > 255 ? 255 : thickness;
        }
        if (thickness > 0) {
            this.output.outputFlagAndShortAndByteData(5, this.output.convertIntToByte(thickness));
        }
        if (top != null && bottom != null) {
            Object[] coordinates = new Object[]{this.output.convertDoubleToShort(top.getX()), this.output.convertDoubleToShort(top.getY()), this.output.convertDoubleToShort(bottom.getX()), this.output.convertDoubleToShort(bottom.getY())};
            this.output.outputPropertyArrayData(13, coordinates);
        }
        Coordinate roundedRectCurve = new Coordinate(new Double(mRoundedRectangle.getAttribute("arcWidth")) * 288.0, new Double(mRoundedRectangle.getAttribute("arcHeight")) * 288.0);
        this.output.outputCoordinateData(15, roundedRectCurve);
    }

    private void exprotEllipse(MRectangle mRectangle, Coordinate top, Coordinate bottom) {
        this.output.outputFeatureFlagData(6);
        this.output.outputFlagAndColorData(88, mRectangle.getLineColor() == null ? mRectangle.getColor() : mRectangle.getLineColor());
        if (mRectangle.getBackground() != null) {
            this.output.outputFlagAndColorData(89, mRectangle.getBackground());
        }
        int fillStyle = 0;
        fillStyle = mRectangle.getBackground() != null ? 1 : 0;
        this.output.outputFlagAndShortAndByteData(9, this.output.convertIntToByte(fillStyle));
        int thickness = (int)(mRectangle.getThickness() / 0.009142857142857144);
        if (thickness != 17) {
            int n = thickness = thickness > 255 ? 255 : thickness;
        }
        if (thickness > 0) {
            this.output.outputFlagAndShortAndByteData(5, this.output.convertIntToByte(thickness));
        }
        if (top != null && bottom != null) {
            Object[] coordinateList = new Object[]{this.output.convertDoubleToShort(top.getX()), this.output.convertDoubleToShort(top.getY()), this.output.convertDoubleToShort(bottom.getX()), this.output.convertDoubleToShort(bottom.getY())};
            this.output.outputPropertyArrayData(13, coordinateList);
        }
    }

    private void exportBracket(MObject o) {
        MBracket mBracket = (MBracket)o;
        this.output.outputFeatureFlagData(34);
        this.output.outputShortAndFlagData(249, this.output.convertIntToShort(10));
        this.output.outputFlagAndShortAndByteData(247, this.output.convertIntToByte(mBracket.getType() == 1 ? 0 : 1));
        this.output.outputFlagAndShortAndByteData(54, this.output.convertIntToByte(17));
        ArrayList<Coordinate> ap1 = new ArrayList<Coordinate>();
        ArrayList<Coordinate> ap2 = new ArrayList<Coordinate>();
        Coordinate pp = new Coordinate();
        if (mBracket.getBracketOrientation() == 5) {
            ap1.add(0, pp.getSkcPoint3d(mBracket.getPoints()[3].getLocation().x, mBracket.getPoints()[3].getLocation().y, 0.0));
            ap1.add(1, pp.getSkcPoint3d(mBracket.getPoints()[1].getLocation().x, mBracket.getPoints()[1].getLocation().y, 0.0));
            ap2.add(0, pp.getSkcPoint3d(mBracket.getPoints()[0].getLocation().x, mBracket.getPoints()[0].getLocation().y, 0.0));
            ap2.add(1, pp.getSkcPoint3d(mBracket.getPoints()[2].getLocation().x, mBracket.getPoints()[2].getLocation().y, 0.0));
        } else if (mBracket.getBracketOrientation() == 4) {
            ap1.add(pp.getSkcPoint3d(mBracket.getPoints()[0].getLocation().x, mBracket.getPoints()[0].getLocation().y, 0.0));
            ap2.add(pp.getSkcPoint3d(mBracket.getPoints()[3].getLocation().x, mBracket.getPoints()[3].getLocation().y, 0.0));
        }
        ArrayList<Number> brackets = new ArrayList<Number>();
        brackets.add(this.output.convertIntToByte(ap2.size()));
        for (int j = 0; j < ap2.size(); ++j) {
            Coordinate pointd2 = (Coordinate)ap2.get(j);
            Coordinate pointd3 = (Coordinate)ap1.get(j);
            brackets.add(this.output.convertDoubleToShort(pointd2.getX()));
            brackets.add(this.output.convertDoubleToShort(pointd2.getY()));
            brackets.add(this.output.convertDoubleToShort(pointd3.getX()));
            brackets.add(this.output.convertDoubleToShort(pointd3.getY()));
        }
        this.output.outputPropertyArrayData(242, brackets.toArray());
        ArrayList<Byte> newAtchList = new ArrayList<Byte>();
        newAtchList.add(this.output.convertIntToByte(0));
        newAtchList.add(this.output.convertIntToByte(0));
        this.output.outputPropertyArrayData(164, newAtchList.toArray());
    }

    private void exportMEFlow(MPolyline mPolyline) {
        Color color = mPolyline.getLineColor() == null ? mPolyline.getColor() : mPolyline.getLineColor();
        int mPolylineThickness = (int)(mPolyline.getThickness() / 0.009142857142857144);
        if (mPolylineThickness != 17) {
            mPolylineThickness = mPolylineThickness > 255 ? 255 : mPolylineThickness;
        }
        MPoint[] mPoints = mPolyline.getPoints();
        double arcRadius = mPolyline.getArcRadius(null);
        Coordinate start = new Coordinate().getSkcPoint3d(mPoints[0].getLocation().x, mPoints[0].getLocation().y, mPoints[0].getLocation().y);
        Coordinate end = new Coordinate().getSkcPoint3d(mPoints[1].getLocation().x, mPoints[1].getLocation().y, mPoints[1].getLocation().y);
        DPoint3 centerDPoint3 = MPolyline.getArcCenter(mPoints[1].getLocation(), mPoints[0].getLocation(), mPolyline.getArcAngle());
        Coordinate centerPoint3D = new Coordinate().getSkcPoint3d(centerDPoint3.x, centerDPoint3.y, centerDPoint3.y);
        Coordinate midPointOnArc = new Coordinate().getSkcPoint3d(mPolyline.getMidPointLocation((int)0, null).x, mPolyline.getMidPointLocation((int)0, null).y, mPolyline.getMidPointLocation((int)0, null).y);
        Coordinate leftOnRectangle = new Coordinate().getSkcPoint3d(centerDPoint3.x - arcRadius, centerDPoint3.y + arcRadius, centerDPoint3.y + arcRadius);
        Coordinate rightOnRectangle = new Coordinate().getSkcPoint3d(centerDPoint3.x + arcRadius, centerDPoint3.y - arcRadius, centerDPoint3.y - arcRadius);
        if (Math.abs(mPolyline.getArcAngle()) <= 360.0) {
            this.output.outputFeatureFlagData(24);
            this.output.outputFlagAndColorData(88, color);
            this.output.outputFlagAndShortAndByteData(5, this.output.convertIntToByte(mPolylineThickness));
            Object[] coordinateList1 = new Object[]{this.output.convertDoubleToShort(leftOnRectangle.getX()), this.output.convertDoubleToShort(leftOnRectangle.getY()), this.output.convertDoubleToShort(rightOnRectangle.getX()), this.output.convertDoubleToShort(rightOnRectangle.getY())};
            this.output.outputPropertyArrayData(13, coordinateList1);
            this.exportArrowProperties(mPolyline);
            this.output.outputPropertyArrayData(205, new Object[]{this.output.convertDoubleToShort(end.getX()), this.output.convertDoubleToShort(end.getY()), this.output.convertDoubleToShort(start.getX()), this.output.convertDoubleToShort(start.getY()), this.output.convertDoubleToShort(midPointOnArc.getX()), this.output.convertDoubleToShort(midPointOnArc.getY()), this.output.convertDoubleToShort(centerPoint3D.getX()), this.output.convertDoubleToShort(centerPoint3D.getY())});
        }
    }

    private void exportTextBoxes(Molecule mol) {
        MDocument doc = mol.getDocument();
        if (doc == null) {
            doc = new MDocument(mol);
        }
        for (int i = 0; i < doc.getObjectCount(); ++i) {
            MObject o = doc.getObject(i);
            if (!(o instanceof MTextBox)) continue;
            MTextBox tb = (MTextBox)o;
            String text = this.getTextContent(tb);
            int factorValue = this.getTextFactorValue(tb);
            if (text == null || text.length() <= 0) continue;
            this.output.outputFeatureFlagData(9);
            MPoint[] points = tb.getPoints();
            if (points != null && points[0] != null && points[2] != null) {
                short x1 = this.output.convertFloatToShort(Coordinate.getXOfSkc(points[0].getLocation().x));
                short y1 = this.output.convertFloatToShort(Coordinate.getYOfSkc(points[0].getLocation().y));
                short x2 = this.output.convertFloatToShort(Coordinate.getXOfSkc(points[2].getLocation().x));
                short y2 = this.output.convertFloatToShort(Coordinate.getYOfSkc(points[2].getLocation().y));
                Object[] object = new Object[]{x1, y1, x2, y2};
                this.output.outputPropertyArrayData(13, object);
            }
            this.output.outputTextContentData(text, factorValue, this.output.convertDoubleToFloat(tb.getFontScale() / 10.0));
            if (tb.getBackground() != null) {
                this.output.outputFlagAndColorData(89, tb.getBackground());
            }
            if (tb.getColor() == null) continue;
            this.output.outputFlagAndColorData(88, tb.getColor());
        }
    }

    private int getTextFactorValue(MTextBox tb) {
        int value = ChemUtil.getFactorValue(3);
        int textAlignType = 0;
        switch (tb.getHorizontalAlignment()) {
            case 0: {
                textAlignType = 3;
                break;
            }
            case 2: {
                textAlignType = 4;
                break;
            }
            case 1: {
                textAlignType = 2;
            }
        }
        switch (textAlignType) {
            case 2: {
                value |= 2;
                break;
            }
            case 4: {
                value |= 4;
                break;
            }
            default: {
                value |= 1;
            }
        }
        return value;
    }

    private String getTextContent(MTextBox tb) {
        StringBuilder baseText = new StringBuilder();
        Map<String, Integer> fontFamilies = this.populateTextHeadContent(tb, baseText);
        StringBuilder charsets = new StringBuilder();
        for (String name : fontFamilies.keySet()) {
            charsets.append(" {\\f").append(fontFamilies.get(name));
            charsets.append("\\fcharset").append(fontFamilies.get(name));
            charsets.append(" ").append(name).append(";}\n");
        }
        charsets.append("}");
        StringBuilder textSB = new StringBuilder("{\\rtf1\\defformat\\pc \n{\\fonttbl \n");
        textSB.append((CharSequence)charsets).append((CharSequence)baseText);
        textSB.append("}");
        return textSB.toString();
    }

    private Map<String, Integer> populateTextHeadContent(MTextBox tb, StringBuilder baseText) {
        MTextDocument td = tb.getTextDocument();
        MFont baseFont = td.getDefaultFont();
        int count = 0;
        HashMap<String, Integer> fontFamilies = new HashMap<String, Integer>();
        fontFamilies.put(baseFont.getFamily(), count++);
        for (int j = 0; j < td.getSectionCount(); ++j) {
            MTextDocument.Section s = tb.getTextDocument().getSection(j);
            MTextAttributes attris = s.getAttributes();
            MFont fontFamily = attris.getBaseFont();
            if (fontFamily != null && !fontFamilies.containsKey(fontFamily.getFamily())) {
                fontFamilies.put(fontFamily.getFamily(), count++);
            }
            baseText.append("\n\\plain \n");
            if (fontFamily != null) {
                baseText.append("\\f").append(fontFamilies.get(fontFamily.getFamily()));
                baseText.append("\\fs").append((int)fontFamily.getSizeDouble() * 2 + " ");
                if (fontFamily.isBold()) {
                    baseText.append("\\b ");
                }
                if (fontFamily.isItalic()) {
                    baseText.append("\\i ");
                }
            } else if (attris.getSet() == 0) {
                baseText.append("\\f").append(fontFamilies.get(baseFont.getFamily()));
                baseText.append("\\fs").append((int)baseFont.getSizeDouble() * 2 + " ");
                if (baseFont.isBold()) {
                    baseText.append("\\b ");
                }
                if (baseFont.isItalic()) {
                    baseText.append("\\i ");
                }
            }
            if (attris.getSubLevel() == -1) {
                baseText.append("\\sub ");
            }
            if (attris.getSubLevel() == 1) {
                baseText.append("\\super ");
            }
            baseText.append(s.getString().replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}").replaceAll("\\n", "\\\\par "));
        }
        return fontFamilies;
    }

    private ArrayList<ArrayList<Coordinate>> getBracketPointList(Sgroup group) {
        ArrayList<ArrayList<Coordinate>> p = new ArrayList<ArrayList<Coordinate>>();
        ArrayList<Coordinate> ap1 = new ArrayList<Coordinate>();
        ArrayList<Coordinate> ap2 = new ArrayList<Coordinate>();
        ArrayList<MBracket> mBrackets = group.getBrackets();
        if (mBrackets != null) {
            for (MBracket mBracket : mBrackets) {
                Coordinate pp = new Coordinate();
                if (mBracket.getBracketOrientation() == 5) {
                    ap1.add(0, pp.getSkcPoint3d(mBracket.getPoints()[3].getLocation().x, mBracket.getPoints()[3].getLocation().y, 0.0));
                    ap1.add(1, pp.getSkcPoint3d(mBracket.getPoints()[1].getLocation().x, mBracket.getPoints()[1].getLocation().y, 0.0));
                    ap2.add(0, pp.getSkcPoint3d(mBracket.getPoints()[0].getLocation().x, mBracket.getPoints()[0].getLocation().y, 0.0));
                    ap2.add(1, pp.getSkcPoint3d(mBracket.getPoints()[2].getLocation().x, mBracket.getPoints()[2].getLocation().y, 0.0));
                    continue;
                }
                if (mBracket.getBracketOrientation() != 4) continue;
                ap1.add(pp.getSkcPoint3d(mBracket.getPoints()[0].getLocation().x, mBracket.getPoints()[0].getLocation().y, 0.0));
                ap2.add(pp.getSkcPoint3d(mBracket.getPoints()[3].getLocation().x, mBracket.getPoints()[3].getLocation().y, 0.0));
            }
        }
        p.add(ap1);
        p.add(ap2);
        return p;
    }

    private void rebuildSgroupState(Molecule cmol) {
        Sgroup[] sgroupArray = cmol.getSgroupArray();
        for (MolAtom molAtom : cmol.getAtomArray()) {
            this.originalDPoint3Map.put(molAtom, molAtom.getLocation());
            int stereoGroupType = molAtom.getStereoGroupType();
            if (stereoGroupType != 1 && stereoGroupType != 2 && stereoGroupType != 3) continue;
            DataSgroup dataSgroup = new DataSgroup(cmol);
            this.stereoDataSgroups.add(dataSgroup);
            this.atomStereoMap.put(dataSgroup, molAtom);
            dataSgroup.setUnitDisplayed(true);
            cmol.setSgroupParent(molAtom, dataSgroup, true);
        }
        MolBond[] mbArray = cmol.getBondArray();
        if (mbArray != null && mbArray.length > 0) {
            for (int i = 0; i < mbArray.length; ++i) {
                MolBond mb = mbArray[i];
                if (mb.getType() != 9) continue;
                cmol.replaceBond(mb, new MolBond(mb.getAtom1(), mb.getAtom2()));
            }
        }
        if (sgroupArray != null && sgroupArray.length > 0) {
            for (Sgroup sgroup : sgroupArray) {
                if (!(sgroup instanceof SuperatomSgroup)) continue;
                this.sgroupContractOrExpandedFlagMap.put(sgroup, SgroupUtil.isSgroupExpanded(sgroup));
                this.superSubStringList.add(sgroup.getSubscript());
                DPoint3 dp3 = ((SuperatomSgroup)sgroup).getSuperAtom().getLocation();
                this.originalDPoint3Map.put(sgroup, dp3);
            }
            this.multiplieres = new HashMap<MultipleSgroup, Integer>();
            cmol.expandSgroups();
            for (Sgroup sg : cmol.getSgroupArray()) {
                if (!(sg instanceof MultipleSgroup)) continue;
                MultipleSgroup msg = (MultipleSgroup)sg;
                this.multiplieres.put(msg, msg.getMultiplier());
                msg.setMultiplier(1);
                msg.contract(8);
            }
        }
    }

    private Coordinate getMolCenter(Molecule mol) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (MolAtom atom : mol.getAtomArray()) {
            x = (float)((double)x + atom.getX());
            y = (float)((double)y + atom.getY());
            z = (float)((double)z + atom.getZ());
        }
        int c = mol.getAtomCount();
        return new Coordinate().getSkcPoint3d(x / (float)c, y / (float)c, z / (float)c);
    }

    private float convertCoordinateForX(double x) {
        return (float)x * 1.0f;
    }

    private float convertCoordinateForY(double y) {
        return (float)(-1.0 * y * 1.0);
    }

    private Map<Integer, List<MolAtom>> getSgroupPathes(SgroupBeanInfo si) {
        Map<Integer, List<MolAtom>> pathes = si.getPathes();
        HashMap<Integer, List<MolAtom>> pathes1 = new HashMap<Integer, List<MolAtom>>();
        for (Integer i : pathes.keySet()) {
            if (pathes.get(i).size() != this.groupsOfConnectedAtoms.get(i).size()) continue;
            pathes1.put(i, pathes.get(i));
        }
        return pathes1;
    }

    private Map<Integer, List<MolAtom>> getSgroupPathesOfPart(SgroupBeanInfo si) {
        Map<Integer, List<MolAtom>> pathes = si.getPathes();
        HashMap<Integer, List<MolAtom>> pathes1 = new HashMap<Integer, List<MolAtom>>();
        for (Integer i : pathes.keySet()) {
            if (pathes.get(i).size() == this.groupsOfConnectedAtoms.get(i).size()) continue;
            pathes1.put(i, pathes.get(i));
        }
        return pathes1;
    }

    private int getMax(Set<Integer> is) {
        int max = 0;
        for (Integer i : is) {
            if (max >= i) continue;
            max = i;
        }
        return max;
    }

    private void connectPathes(Set<Integer> pathIdes, Integer newPathId) {
        if (this.groupsOfConnectedAtoms != null && !this.groupsOfConnectedAtoms.isEmpty()) {
            ArrayList newPath = new ArrayList();
            for (Integer i : pathIdes) {
                if (!this.groupsOfConnectedAtoms.keySet().contains(i)) continue;
                newPath.addAll(this.groupsOfConnectedAtoms.get(i));
                this.groupsOfConnectedAtoms.remove(i);
            }
            this.groupsOfConnectedAtoms.put(newPathId, newPath);
        }
    }

    private void exportLinkNodeSgroup(Molecule mol, MolAtom atom, Segment segment) {
        this.output.outputFeatureFlagData(34);
        this.output.outputFlagAndShortAndByteData(54, this.output.convertIntToByte(1));
        short linkNodeMaxValue = this.output.convertIntToShort(atom.getMaxRepetitions());
        this.output.outputShortAndFlagData(244, linkNodeMaxValue);
        ArrayList<MolAtom> crossMolAtoms = new ArrayList<MolAtom>();
        crossMolAtoms.add(atom);
        crossMolAtoms.add(atom);
        ArrayList<MolBond> crossMolBonds = new ArrayList<MolBond>();
        MolBond[] molBonds = mol.getBondArray();
        int molBondCount = molBonds.length;
        for (int i = 0; i < molBondCount; ++i) {
            if (!molBonds[i].getAtom1().equals(atom) && !molBonds[i].getAtom2().equals(atom)) continue;
            crossMolBonds.add(molBonds[i]);
        }
        this.exportLinkNodeData(segment, crossMolAtoms, crossMolBonds);
    }

    private void exportLinkNodeData(Segment segment, List<MolAtom> crossMolAtoms, List<MolBond> crossMolBonds) {
        ArrayList<Number> list = new ArrayList<Number>();
        list.add(this.output.convertIntToByte(crossMolAtoms.size()));
        list.add(this.output.convertIntToByte(crossMolBonds.size()));
        int size = crossMolAtoms.size();
        List<Object> objectList = segment.getObjects();
        for (int poistion = 0; poistion < size; ++poistion) {
            MolAtom currentAtom = crossMolAtoms.get(poistion);
            MolBond currentBond = poistion >= crossMolBonds.size() ? null : crossMolBonds.get(poistion);
            list.add(this.getBondIndexOfObjectList(objectList, currentBond));
            list.add(this.getAtomIndexOfObjectList(objectList, currentAtom));
            list.add(this.output.convertIntToByte(0));
            list.add(this.output.convertIntToByte(0));
            list.add(this.getByteValueForLinkNode(currentBond));
        }
        this.output.outputPropertyArrayData(164, list.toArray());
    }

    private byte getByteValueForLinkNode(MolBond currentBond) {
        return currentBond != null ? this.output.convertIntToByte(0) : this.output.convertIntToByte(1);
    }

    private void exportArrowProperties(MPolyline mPolyline) {
        Object[] tempObjectArry;
        double headLength = mPolyline.getArrowLength(MPolyline.HEAD) * 10.0;
        double headWidth = mPolyline.getArrowWidth(MPolyline.HEAD) * 10.0;
        double tailLength = mPolyline.getArrowLength(MPolyline.TAIL) * 10.0;
        double tailWidth = mPolyline.getArrowWidth(MPolyline.TAIL) * 10.0;
        int arrowNumber = 0;
        double compValue = 0.0;
        if (headLength != compValue || headWidth != compValue) {
            if (mPolyline.getArrowFlags(MPolyline.HEAD) == 0) {
                ++arrowNumber;
                this.output.outputFlagAndShortAndByteData(56, this.output.convertIntToByte(1));
                this.output.outputFlagAndShortAndByteData(57, this.output.convertIntToByte(1));
            } else if (mPolyline.getArrowFlags(MPolyline.HEAD) == MPolyline.ARROW_HALF_LEFT || mPolyline.getArrowFlags(MPolyline.HEAD) == MPolyline.ARROW_HALF_RIGHT) {
                ++arrowNumber;
                this.output.outputFlagAndShortAndByteData(56, this.output.convertIntToByte(1));
                this.output.outputFlagAndShortAndByteData(57, this.output.convertIntToByte(11));
            } else if (mPolyline.getArrowFlags(MPolyline.HEAD) == MPolyline.ARROW_BACK_FLAG) {
                ++arrowNumber;
                this.output.outputFlagAndShortAndByteData(56, this.output.convertIntToByte(2));
                this.output.outputFlagAndShortAndByteData(57, this.output.convertIntToByte(1));
            } else {
                ++arrowNumber;
                this.output.outputFlagAndShortAndByteData(56, this.output.convertIntToByte(2));
                this.output.outputFlagAndShortAndByteData(57, this.output.convertIntToByte(11));
            }
            tempObjectArry = new Object[]{this.output.convertDoubleToShort(headLength * 10.0), this.output.convertDoubleToShort(headWidth * 10.0), this.output.convertIntToByte(0), this.output.convertIntToByte(0)};
            this.output.outputPropertyArrayData(229, tempObjectArry);
        }
        if (tailLength != compValue || tailWidth != compValue) {
            if (mPolyline.getArrowFlags(MPolyline.TAIL) == MPolyline.ARROW_BACK_FLAG) {
                if (++arrowNumber == 1) {
                    this.output.outputFlagAndShortAndByteData(56, this.output.convertIntToByte(2));
                } else if (arrowNumber == 2) {
                    this.output.outputFlagAndShortAndByteData(56, this.output.convertIntToByte(3));
                }
                this.output.outputFlagAndShortAndByteData(57, this.output.convertIntToByte(1));
            } else if (mPolyline.getArrowFlags(MPolyline.TAIL) == 3 || mPolyline.getArrowFlags(MPolyline.TAIL) == 5) {
                if (++arrowNumber == 1) {
                    this.output.outputFlagAndShortAndByteData(56, this.output.convertIntToByte(2));
                } else if (arrowNumber == 2) {
                    this.output.outputFlagAndShortAndByteData(56, this.output.convertIntToByte(3));
                }
                this.output.outputFlagAndShortAndByteData(57, this.output.convertIntToByte(11));
            } else if (mPolyline.getArrowFlags(MPolyline.TAIL) == 0) {
                if (++arrowNumber == 1) {
                    this.output.outputFlagAndShortAndByteData(56, this.output.convertIntToByte(1));
                } else if (arrowNumber == 2) {
                    this.output.outputFlagAndShortAndByteData(56, this.output.convertIntToByte(3));
                }
                this.output.outputFlagAndShortAndByteData(57, this.output.convertIntToByte(1));
            } else {
                if (++arrowNumber == 1) {
                    this.output.outputFlagAndShortAndByteData(56, this.output.convertIntToByte(1));
                } else if (arrowNumber == 2) {
                    this.output.outputFlagAndShortAndByteData(56, this.output.convertIntToByte(3));
                }
                this.output.outputFlagAndShortAndByteData(57, this.output.convertIntToByte(11));
            }
            tempObjectArry = new Object[]{this.output.convertDoubleToShort(tailLength * 10.0), this.output.convertDoubleToShort(tailWidth * 10.0), this.output.convertIntToByte(0), this.output.convertIntToByte(0)};
            this.output.outputPropertyArrayData(229, tempObjectArry);
        }
    }

    private short getAtomIndexOfObjectList(List<Object> objectList, MolAtom currentAtom) {
        return this.output.convertIntToShort(objectList.indexOf(currentAtom));
    }

    private short getBondIndexOfObjectList(List<Object> objectList, MolBond currentBond) {
        return currentBond == null ? this.output.convertIntToShort(-1) : this.output.convertIntToShort(objectList.indexOf(currentBond));
    }
}

