/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.skcexport;

import chemaxon.marvin.io.formats.skc.utils.ChemUtil;
import chemaxon.marvin.io.formats.skc.utils.Coordinate;
import chemaxon.marvin.io.formats.skc.utils.text.TextStyleMark;
import chemaxon.marvin.io.formats.skc.utils.text.TextUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class SkcWriterHelper {
    private static final byte PZ_BYTE_VALUE = 0;
    private static final byte PO_BYTE_VALUE = 1;
    private static final byte PT_BYTE_VALUE = 2;
    private static final byte BASIC_BYTE_VALUE = 3;
    private static final byte PF_BYTE_VALUE = 4;
    private static final byte PFV_BYTE_VALUE = 5;
    private OutputStream os;

    public SkcWriterHelper(OutputStream dos) {
        this.os = dos;
    }

    protected final void outputByteData(byte b) {
        this.baseOutput(b);
    }

    protected final void outputBooleanData(boolean b) {
        try {
            this.os.write(b ? 1 : 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void outputCharArrayData(char[] charArray) {
        int factor = ChemUtil.getFactorValue(2);
        for (char c : charArray) {
            this.baseOutput(this.getFinalIntValue(c >>> 0));
            this.baseOutput(this.getFinalIntValue(c >>> factor));
        }
    }

    protected final void outputFloatData(float f) {
        this.outputIntData(Float.floatToIntBits(f));
    }

    protected final void outputByteArrayData(byte[] byteArray) {
        try {
            this.os.write(byteArray);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void outputSpecialFlag(int flag) {
        if (flag > 254) {
            int bit = 7;
            this.outputByteData(this.convertIntToByte(ChemUtil.getFactorValue(bit, 1)));
            this.outputByteData(this.convertIntToByte(flag - ChemUtil.getFactorValue(bit, 2)));
        } else {
            this.outputByteData(this.convertIntToByte(flag));
        }
    }

    protected final void outputSymbolData(int flag, String symbol) {
        this.outputSpecialFlag(flag);
        byte[] bytes = null;
        try {
            bytes = symbol.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        this.outputShortData(this.getShortValue((short)3, this.convertIntToShort(bytes.length)));
        this.outputByteData(this.convertIntToByte(bytes.length));
        this.outputByteArrayData(bytes);
    }

    protected final void outputShortArrayData(int flag, List<Short> shortList) {
        this.outputSpecialFlag(flag);
        this.outputShortData(this.getAndShortValue(2 * shortList.size()));
        if (shortList != null) {
            for (Short s : shortList) {
                this.outputShortData(s);
            }
        }
    }

    protected final void outputIntData(int i) {
        int secondFactor = ChemUtil.getFactorValue(2);
        this.baseOutput(this.getFinalIntValue(i >>> 0));
        this.baseOutput(this.getFinalIntValue(i >>> secondFactor));
        this.baseOutput(this.getFinalIntValue(i >>> ChemUtil.getFactorValue(3)));
        this.baseOutput(this.getFinalIntValue(i >>> ChemUtil.getMinContrastValue(1, 0) + secondFactor));
    }

    protected final void outputShortAndFlagData(int flag, short s) {
        this.outputSpecialFlag(flag);
        this.outputShortData(this.convertIntToShort(4));
        this.outputShortData(s);
    }

    protected final void outputPropertyArrayData(int property, Object[] propertyArray) {
        this.outputPropertyArrayData(property, propertyArray, true);
    }

    protected final void outputPropertyArrayData(int flag, Object[] propertyArray, boolean processFlag) {
        this.outputSpecialFlag(flag);
        this.outputHeadShortData(propertyArray, processFlag);
        this.outputCorrespondingPropertyData(propertyArray);
    }

    protected final void outputTextContentData(String content, int position, float fontValue) {
        TextUtil lib = new TextUtil();
        lib.parseTextContent(content);
        this.outputTextHeadData(position, lib);
        this.outputTextBodyData(fontValue, lib);
        this.outputTextTailData(lib);
    }

    protected final void outputFeatureFlagData(int featureFlag) {
        this.outputFlagAndShortAndByteData(3, this.convertIntToByte(featureFlag));
    }

    protected final void outputFlagAndShortAndByteData(int flag, byte b) {
        this.outputSpecialFlag(flag);
        this.outputShortData((short)3);
        this.outputByteData(b);
    }

    protected final void outputShortData(short s) {
        this.baseOutput(this.getFinalIntValue(s >>> 0));
        this.baseOutput(this.getFinalIntValue(s >>> ChemUtil.getFactorValue(2)));
    }

    protected final void outputFlagAndFeatureData(int type, Object object) {
        switch (type) {
            case 40: {
                this.outputFlagAndShortAndByteData(40, Byte.parseByte(object.toString()));
                return;
            }
            case 41: {
                this.outputFlagAndShortAndByteData(41, Byte.parseByte(object.toString()));
                return;
            }
            case 42: {
                this.outputFlagAndShortAndByteData(42, Byte.parseByte(object.toString()));
                return;
            }
            case 43: {
                this.outputFlagAndShortAndByteData(43, Byte.parseByte(object.toString()));
                return;
            }
            case 44: {
                this.outputFlagAndShortAndByteData(44, Byte.parseByte(object.toString()));
                return;
            }
            case 84: {
                this.outputFlagAndShortAndByteData(84, Byte.parseByte(object.toString()));
                return;
            }
        }
    }

    protected final void outputFlagAndShortData(int flag) {
        this.outputSpecialFlag(flag);
        this.outputShortData(this.convertIntToShort(2));
    }

    protected final void outputFlagAndColorData(int flag, Color color) {
        if (color != null) {
            this.outputSpecialFlag(flag);
            this.outputShortData(this.getAndShortValue(3));
            this.outputByteData(this.convertIntToByte(color.getRed()));
            this.outputByteData(this.convertIntToByte(color.getGreen()));
            this.outputByteData(this.convertIntToByte(color.getBlue()));
        }
    }

    protected final void outputCoordinateData(int flag, Coordinate p3d) {
        if (p3d != null) {
            this.outputSpecialFlag(flag);
            this.outputShortData(this.convertIntToShort(6));
            this.outputShortData(this.convertDoubleToShort(p3d.getX()));
            this.outputShortData(this.convertDoubleToShort(p3d.getY()));
        }
    }

    protected final void outputFlagAndByteArrayData(int flag, byte[] byteArray) {
        this.outputSpecialFlag(flag);
        this.outputShortData(this.getAndShortValue(byteArray.length));
        this.outputByteArrayData(byteArray);
    }

    private void outputTextTailData(TextUtil lib) {
        Short[] letters = lib.getCharacterList();
        int initValue = ChemUtil.getFactorValue(3) - ChemUtil.getFactorValue(0);
        int baseFactorValue = this.getBaseFactorValue();
        int resultValue = ChemUtil.getFactorValue(2) + 2;
        int maxResultValue = ChemUtil.getFactorValue(initValue);
        for (int i = 0; i < letters.length; ++i) {
            short v = letters[i];
            short sv = (v & baseFactorValue) == resultValue ? this.convertIntToShort(maxResultValue) : this.convertIntToShort(0);
            this.outputShortData(this.convertIntToShort(sv | v));
        }
        this.outputByteArrayData(this.getNewByteArray(initValue));
    }

    private int getBaseFactorValue() {
        return ChemUtil.getMinContrastValue(5, 1);
    }

    private void outputTextBodyData(float fontValue, TextUtil lib) {
        int comValue = ChemUtil.getFactorValue(4);
        int size = lib.getTextStyleMarkList().length;
        for (int i = 0; i < size; ++i) {
            TextStyleMark[] tsmList = lib.getTextStyleMarkList();
            byte[] fontNameByteArray = tsmList[i].getFontNameByteArray();
            int count = 0;
            if (fontNameByteArray != null) {
                count = this.outputByteHeadData(comValue, fontNameByteArray, count);
            }
            this.outputByteTailData(comValue, count);
            this.outputByteData(tsmList[i].getFontCoefficient());
            this.outputShortData(this.convertFloatToShort((float)tsmList[i].getFontSize() * fontValue));
        }
    }

    private void outputTextHeadData(int position, TextUtil lib) {
        int length = lib.getCharacterList().length;
        int size = lib.getTextStyleMarkList().length;
        short baseValue = this.convertIntToShort(ChemUtil.getFactorValue(3) + 1);
        int times = ChemUtil.getFactorValue(4) + 3;
        int arrayLenth = ChemUtil.getFactorValue(3) - ChemUtil.getFactorValue(1);
        int factorValue = ChemUtil.getFactorValue(4) + ChemUtil.getFactorValue(2);
        short s1 = position == 0 ? baseValue : this.convertIntToShort(position);
        short s2 = this.convertIntToShort(factorValue + size * times + length * 2);
        this.outputSpecialFlag(21);
        this.outputShortData(this.convertIntToShort(4 + s2));
        this.outputShortData(s2);
        this.outputByteArrayData(this.getNewByteArray(arrayLenth));
        this.outputIntData(length);
        this.outputIntData(size);
        this.outputIntData(ChemUtil.getFactorValue(arrayLenth + 2) + ChemUtil.getFactorValue(arrayLenth + 1));
        this.outputShortData(s1);
    }

    private void outputByteTailData(int comValue, int count) {
        while (count < comValue) {
            this.outputByteData(this.convertIntToByte(0));
            ++count;
        }
    }

    private int outputByteHeadData(int comValue, byte[] fontNameByteArray, int count) {
        while (count < fontNameByteArray.length && count < comValue) {
            this.outputByteData(fontNameByteArray[count]);
            ++count;
        }
        return count;
    }

    private String convertObjectToString(Object p) {
        return p instanceof String ? (String)p : null;
    }

    private void baseOutput(int b) {
        try {
            this.os.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private short getAndShortValue(int arrayLength) {
        return (short)(2 + arrayLength);
    }

    protected final short convertDoubleToShort(double d) {
        return (short)d;
    }

    protected final int convertDoubleToInt(double d) {
        return (int)d;
    }

    protected final short convertIntToShort(int i) {
        return (short)i;
    }

    private byte[] getNewByteArray(int size) {
        return new byte[size];
    }

    private short getShortValue(short addend, short summand) {
        return (short)(addend + summand);
    }

    protected final short convertFloatToShort(float f) {
        return (short)f;
    }

    protected final byte convertIntToByte(int i) {
        return (byte)i;
    }

    protected final float convertDoubleToFloat(double d) {
        return (float)d;
    }

    private byte convertCharToBtye(char c) {
        return (byte)c;
    }

    private int getFinalIntValue(int value) {
        return value & this.getBaseFactorValue();
    }

    private int getIntValueByType(Object type) {
        int v = 0;
        if (type instanceof Boolean) {
            v = 1;
        } else if (type instanceof Integer) {
            v = 4;
        } else if (type instanceof Short) {
            v = 2;
        } else if (type instanceof Float) {
            v = 4;
        } else if (type instanceof Byte) {
            v = 1;
        }
        return v;
    }

    private void outputCorrespondingPropertyData(Object[] propertyArray) {
        for (Object property : propertyArray) {
            if (property instanceof Boolean) {
                this.outputBooleanData((Boolean)property);
                continue;
            }
            if (property instanceof Short) {
                this.outputShortData((Short)property);
                continue;
            }
            if (property instanceof Integer) {
                this.outputIntData((Integer)property);
                continue;
            }
            if (property instanceof Float) {
                this.outputFloatData(((Float)property).floatValue());
                continue;
            }
            if (property instanceof Byte) {
                this.outputByteData((Byte)property);
                continue;
            }
            if (!(property instanceof String)) continue;
            String value = (String)property;
            this.outputByteData(this.convertIntToByte(value.length()));
            for (int i = 0; i < value.length(); ++i) {
                this.outputByteData(this.convertCharToBtye(value.charAt(i)));
            }
        }
    }

    private void outputHeadShortData(Object[] propertyArray, boolean processFlag) {
        if (processFlag) {
            int shortValue = 0;
            for (Object p : propertyArray) {
                String property = this.convertObjectToString(p);
                shortValue = property != null ? (int)this.convertIntToShort(shortValue + 1 + property.length()) : (int)this.convertIntToShort(this.getIntValueByType(p) + shortValue);
            }
            this.outputShortData(this.convertIntToShort(2 + shortValue));
        }
    }
}

