/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.skcimport;

import chemaxon.marvin.io.formats.skc.skcimport.SkcReaderHelper;
import chemaxon.marvin.io.formats.skc.utils.ChemUtil;
import chemaxon.marvin.io.formats.skc.utils.ComponentHelp;
import chemaxon.marvin.io.formats.skc.utils.Coordinate;
import chemaxon.marvin.io.formats.skc.utils.MPolylineInfo;
import chemaxon.marvin.io.formats.skc.utils.MTextBoxInfo;
import chemaxon.marvin.io.formats.skc.utils.MolBondInfo;
import chemaxon.marvin.io.formats.skc.utils.ObjectManager;
import chemaxon.marvin.io.formats.skc.utils.ReactionArrowInfo;
import chemaxon.marvin.io.formats.skc.utils.RgroupInfo;
import chemaxon.marvin.io.formats.skc.utils.Segment;
import chemaxon.marvin.io.formats.skc.utils.SgroupInfo;
import chemaxon.marvin.io.formats.skc.utils.SgroupUtil;
import chemaxon.marvin.io.formats.skc.utils.SuperatomSgroupUtil;
import chemaxon.marvin.io.formats.skc.utils.text.TextBaseData;
import chemaxon.marvin.io.formats.skc.utils.text.TextUtil;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.MoleculeUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MEllipse;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MRoundedRectangle;
import chemaxon.struc.graphics.MTextAttributes;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.awt.Color;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SkcImportHelper
extends SkcReaderHelper {
    private ObjectManager objectManager = new ObjectManager();
    private List<DataSgroup> dataSgroups = new ArrayList<DataSgroup>();
    private boolean isAbsStereo = false;
    private final List<String> beilsteinGenericsAtoms = ChemUtil.beilsteinGenericsAtoms;
    private final List<String> pseudoAtoms = ChemUtil.pseudoAtoms;
    private static final int ROUND_RECTANGLE_PROPORTION = 288;
    private final String GENERALMPOLYLINE = "GeneralMPolyline";
    private final String MRECTANGLE = "MRECTANGLE";
    private List<MolAtom> molAtoms = new ArrayList<MolAtom>();
    private List<MolBondInfo> molBondxes = new ArrayList<MolBondInfo>();
    private List<ReactionArrowInfo> reactionArrowInfos = new ArrayList<ReactionArrowInfo>();
    private List<RgroupInfo> rgroupxes = new ArrayList<RgroupInfo>();
    private List<RgroupInfo> orderRgroupInfoList = new ArrayList<RgroupInfo>();
    private Map<String, List<Object>> mPolylineMap = new HashMap<String, List<Object>>();
    private Map<MPolyline, MPolylineInfo> mPolylineInfoMap = new HashMap<MPolyline, MPolylineInfo>();
    private Map<MTextBox, MTextBoxInfo> mTextBoxInfoMap = new HashMap<MTextBox, MTextBoxInfo>();
    private Map<MolAtom, MolAtom> molAtomMap = new HashMap<MolAtom, MolAtom>();
    private List<Object> currentObjectList;
    private Object currentObject;
    private int currentObjectType;
    private int objectCount;
    private int version = 0;
    private int molAtomNumber = 0;
    private List<SgroupInfo> sgroupInfoList = new ArrayList<SgroupInfo>();
    private static int[] propertiesArray = ChemUtil.skcDataArray;
    private static int[] dataSectionArray = ChemUtil.getSkcDataSectionArray();
    private int dataSectionLength = dataSectionArray.length;

    public Molecule readSkcFile(DataInputStream dataInputStream) throws Exception {
        super.parseInitialization(dataInputStream);
        Segment segment = new Segment();
        this.parsePortal(segment);
        Molecule cmol = this.buildMolecule();
        MDocument document = new MDocument(cmol);
        this.processGraphics(document);
        this.processBondThicknessAndColor(document, cmol);
        this.processFormatForAtomAndSupergroup(document);
        this.processChiral(cmol);
        this.processSgroup(cmol);
        this.cleanMolecule(cmol);
        return cmol;
    }

    private Molecule buildMolecule() {
        Molecule cmol = null;
        cmol = this.reactionArrowInfos.size() == 1 ? this.processRxnMolecule() : (this.rgroupxes.size() > 0 ? this.processRgMolecule() : this.processMolecule());
        return cmol;
    }

    private void processChiral(Molecule cmol) {
        if (this.isAbsStereo) {
            cmol.setAbsStereo(true);
        }
    }

    private void cleanMolecule(Molecule cmol) {
        SuperatomSgroupUtil ssu = new SuperatomSgroupUtil();
        if (ssu.isNeedCleanMolecule(cmol)) {
            cmol.clean(2, "");
        }
    }

    private void processGraphics(MDocument mDocument) {
        for (List<Object> mPolylines : this.mPolylineMap.values()) {
            if (mPolylines == null) continue;
            for (Object mPolyline : mPolylines) {
                if (this.reactionArrowInfos.size() == 1 && mPolyline instanceof MTextBox && ((MTextBox)mPolyline).getText().equals("+")) continue;
                MPolylineInfo mPolylineInfo = this.mPolylineInfoMap.get((MPolyline)mPolyline);
                MPolyline mpline = (MPolyline)mPolyline;
                if (mPolylineInfo != null) {
                    mPolylineInfo.handleGraphicsGenericLines(mpline);
                }
                mDocument.addObject(mpline);
            }
        }
    }

    private Molecule processMolecule() {
        Molecule cmol = new Molecule();
        MDocument mDocument = new MDocument(cmol);
        for (int i = 0; i < this.reactionArrowInfos.size(); ++i) {
            MPoint mp1 = new MPoint(this.reactionArrowInfos.get((int)i).getReactionArrowStartPoint().x, this.reactionArrowInfos.get((int)i).getReactionArrowStartPoint().y, 0.0);
            MPoint mp2 = new MPoint(this.reactionArrowInfos.get((int)i).getReactionArrowEndPoint().x, this.reactionArrowInfos.get((int)i).getReactionArrowEndPoint().y, 0.0);
            MPolyline mPolyline = new MPolyline(mp1, mp2);
            mDocument.addObject(mPolyline);
        }
        for (MolAtom molAtom : this.molAtoms) {
            if (molAtom == null) continue;
            cmol.add(molAtom);
            if (molAtom.getAliasstr() == null || !molAtom.getAliasstr().startsWith("RGROUPATTACH_")) continue;
            String alias = molAtom.getAliasstr();
            int attach = Integer.parseInt(alias.substring(alias.indexOf("_") + 1));
            MolAtom attachAtom = molAtom.addRgroupAttachmentPoint(attach, 1);
            CleanUtil.setBestLigandPosition(molAtom, attachAtom);
            molAtom.setAliasstr(null);
        }
        for (MolBondInfo molBondInfo : this.molBondxes) {
            try {
                MolBond mb = molBondInfo.getMolBondByMolAtoms(this.molAtoms);
                if (mb == null) continue;
                cmol.add(mb);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return cmol;
    }

    private Molecule processRgMolecule() {
        RgMolecule cmol = new RgMolecule();
        MDocument mDocument = new MDocument(cmol);
        for (int i = 0; i < this.reactionArrowInfos.size(); ++i) {
            MPoint mp1 = new MPoint(this.reactionArrowInfos.get((int)i).getReactionArrowStartPoint().x, this.reactionArrowInfos.get((int)i).getReactionArrowStartPoint().y, 0.0);
            MPoint mp2 = new MPoint(this.reactionArrowInfos.get((int)i).getReactionArrowEndPoint().x, this.reactionArrowInfos.get((int)i).getReactionArrowEndPoint().y, 0.0);
            MPolyline mPolyline = new MPolyline(mp1, mp2);
            mDocument.addObject(mPolyline);
        }
        this.processRlogic(cmol);
        for (MolAtom molAtom : this.molAtoms) {
            boolean flag = false;
            for (RgroupInfo rgroupInfo : this.rgroupxes) {
                if (!rgroupInfo.getRmol().contains(molAtom)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            ((MoleculeGraph)cmol).add(molAtom);
        }
        for (MolBondInfo molBondInfo : this.molBondxes) {
            boolean flag = false;
            MolBond molBond = molBondInfo.getMolBondByMolAtoms(this.molAtoms);
            for (RgroupInfo rgroupInfo : this.rgroupxes) {
                if (!rgroupInfo.getRmol().contains(molBond)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            ((MoleculeGraph)cmol).add(molBond);
        }
        return cmol;
    }

    private Molecule processRxnMolecule() {
        Molecule cmol;
        RxnMolecule rxnMole = new RxnMolecule();
        if (this.rgroupxes.size() > 0) {
            cmol = new RgMolecule();
            ((RgMolecule)cmol).setRoot(rxnMole);
        } else {
            cmol = rxnMole;
        }
        this.processRlogic(cmol);
        ArrayList<MolAtom> reactionMolAtoms = new ArrayList<MolAtom>();
        for (MolAtom molAtom : this.molAtoms) {
            boolean flag = false;
            for (RgroupInfo rgroupInfo : this.rgroupxes) {
                if (!rgroupInfo.getRmol().contains(molAtom)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            reactionMolAtoms.add(molAtom);
        }
        ArrayList<MolBond> reactionMolBonds = new ArrayList<MolBond>();
        for (MolBondInfo molBondInfo : this.molBondxes) {
            boolean flag = false;
            MolBond molBond = molBondInfo.getMolBondByMolAtoms(this.molAtoms);
            for (RgroupInfo rgroupInfo : this.rgroupxes) {
                if (!rgroupInfo.getRmol().contains(molBond)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            reactionMolBonds.add(molBond);
        }
        rxnMole.setReactionArrow(new DPoint3[]{this.reactionArrowInfos.get(0).getReactionArrowStartPoint(), this.reactionArrowInfos.get(0).getReactionArrowEndPoint()});
        this.processReactionLine(rxnMole, this.reactionArrowInfos.get(0));
        HashMap<MolAtom, ComponentHelp> atomMap = new HashMap<MolAtom, ComponentHelp>();
        int atomCount = reactionMolAtoms.size();
        for (int i = 0; i < atomCount; ++i) {
            MolAtom molAtom = (MolAtom)reactionMolAtoms.get(i);
            if (molAtom == null || this.isExist(atomMap, molAtom)) continue;
            ComponentHelp component = new ComponentHelp(this.reactionArrowInfos.get(0).getReactionArrowStartPoint(), this.reactionArrowInfos.get(0).getReactionArrowEndPoint(), molAtom);
            this.separateSameComponentAtom(component, molAtom);
            atomMap.put(molAtom, component);
        }
        for (ComponentHelp c : atomMap.values()) {
            Molecule molecule = new Molecule();
            ArrayList<MolBond> existMolBond = new ArrayList<MolBond>();
            for (MolAtom molAtom : c.getAtomList()) {
                molecule.add(molAtom);
                for (MolBond molBond : reactionMolBonds) {
                    if (existMolBond.contains(molBond) || !molBond.getAtom1().equals(molAtom) && !molBond.getAtom2().equals(molAtom)) continue;
                    molecule.add(molBond);
                    existMolBond.add(molBond);
                }
                rxnMole.addComponent(molecule, c.getType());
            }
        }
        return cmol;
    }

    private void processRlogic(Molecule cmol) {
        int index = 0;
        for (RgroupInfo rgroupInfo : this.rgroupxes) {
            for (MolBondInfo molBondInfo : rgroupInfo.getMolBondxes()) {
                rgroupInfo.addMolBond(molBondInfo.getMolBondByMolAtoms(this.molAtoms));
            }
            RgroupInfo newRgroupInfo = null;
            if (!this.orderRgroupInfoList.isEmpty()) {
                newRgroupInfo = this.orderRgroupInfoList.get(index);
                newRgroupInfo.setRmol(rgroupInfo.getRmol());
                rgroupInfo = newRgroupInfo;
            }
            ((RgMolecule)cmol).addRgroup(rgroupInfo.getRgroupId(), rgroupInfo.getRmol());
            this.setRlogic((RgMolecule)cmol, rgroupInfo.getRgroupId(), rgroupInfo.getThenRstr(), rgroupInfo.getRestHstr(), rgroupInfo.getRange());
            ++index;
        }
    }

    private void processSgroup(Molecule cmol) {
        for (DataSgroup dataSgroup : this.dataSgroups) {
            if (dataSgroup.getData().equals("")) continue;
            String fieldName = dataSgroup.getFieldName();
            int absType = fieldName.indexOf("STEABS");
            int orType = fieldName.indexOf("STEREL");
            int andType = fieldName.indexOf("STERAC");
            if (absType > 0 || orType > 0 || andType > 0) {
                MolAtom molAtom = dataSgroup.getAtomArray()[0];
                int stereoGroupType = 1;
                if (orType > 0 || andType > 0) {
                    stereoGroupType = orType > 0 ? 2 : 3;
                    if (stereoGroupType == 1) continue;
                    int startIndex = fieldName.indexOf("STER") + 6;
                    int orValue = Integer.valueOf(fieldName.substring(startIndex, fieldName.length()));
                    molAtom.setStereoGroupNumber(orValue);
                    molAtom.setStereoGroupType(stereoGroupType);
                    continue;
                }
                if (dataSgroup.getData() == null && dataSgroup.getQueryOp() == null && dataSgroup.getTag() == ' ') continue;
                if (!dataSgroup.getData().equals("abs")) {
                    cmol.addSgroup(dataSgroup, true);
                    MolAtom[] dataSgroupMolAtoms = dataSgroup.getAtomArray();
                    for (int i = 0; i < dataSgroupMolAtoms.length; ++i) {
                        cmol.setSgroupParent(dataSgroupMolAtoms[i], dataSgroup, true);
                    }
                    continue;
                }
                molAtom.setStereoGroupType(stereoGroupType);
                continue;
            }
            cmol.addSgroup(dataSgroup, true);
            MolAtom[] dataSgroupMolAtoms = dataSgroup.getAtomArray();
            for (int i = 0; i < dataSgroupMolAtoms.length; ++i) {
                cmol.setSgroupParent(dataSgroupMolAtoms[i], dataSgroup, true);
            }
        }
        if (this.sgroupInfoList.isEmpty()) {
            return;
        }
        ArrayList<Sgroup> allTruthSgroupList = new ArrayList<Sgroup>();
        for (SgroupInfo sgroupInfo : this.sgroupInfoList) {
            if (sgroupInfo.getMolAtoms() == null || sgroupInfo.getMolAtoms().isEmpty()) continue;
            int sgroupType = sgroupInfo.getSgroupType();
            this.replaceSgroupMolAtom(sgroupInfo);
            if (sgroupType == 1000) {
                MolAtom molAtom = sgroupInfo.getMolAtoms().get(0);
                molAtom.setMaxRepetitions((Integer)sgroupInfo.getPropertyFromCarrier("skc_sgroup_link_node_max_value_key"));
                molAtom.setLinkNodeDefaultOuters();
            }
            if (sgroupType == 0) {
                SuperatomSgroup superAtomSgroup = new SuperatomSgroup(cmol);
                allTruthSgroupList.add(superAtomSgroup);
                this.populateDataForSuperatomSgroup(cmol, superAtomSgroup, sgroupInfo);
                superAtomSgroup.setSubscript(sgroupInfo.getSuperAtomSgroupText());
                superAtomSgroup.setXState(SgroupUtil.getMrvExpandedState(sgroupInfo.isExpandedFlag()));
            }
            if (sgroupType == 2) {
                RepeatingUnitSgroup sruSgroup = new RepeatingUnitSgroup(cmol, sgroupInfo.getSgroupConnectivity(), 2);
                allTruthSgroupList.add(sruSgroup);
                sruSgroup.setSubscript(sgroupInfo.getSubscript());
                this.populateDataForSgroup(cmol, sruSgroup, sgroupInfo);
            }
            if (sgroupType == 3) {
                Sgroup monSgroup = new Sgroup(cmol, 3);
                allTruthSgroupList.add(monSgroup);
                this.populateDataForSgroup(cmol, monSgroup, sgroupInfo);
            }
            if (sgroupType == 4) {
                Sgroup merSgroup = new Sgroup(cmol, 4);
                allTruthSgroupList.add(merSgroup);
                this.populateDataForSgroup(cmol, merSgroup, sgroupInfo);
            }
            if (sgroupType == 5) {
                RepeatingUnitSgroup copSgroup = new RepeatingUnitSgroup(cmol, sgroupInfo.getSgroupConnectivity(), 5);
                allTruthSgroupList.add(copSgroup);
                this.populateDataForSgroup(cmol, copSgroup, sgroupInfo);
            }
            if (sgroupType == 6) {
                RepeatingUnitSgroup croSgroup = new RepeatingUnitSgroup(cmol, sgroupInfo.getSgroupConnectivity(), 6);
                allTruthSgroupList.add(croSgroup);
                this.populateDataForSgroup(cmol, croSgroup, sgroupInfo);
            }
            if (sgroupType == 15) {
                RepeatingUnitSgroup graSgroup = new RepeatingUnitSgroup(cmol, sgroupInfo.getSgroupConnectivity(), 15);
                allTruthSgroupList.add(graSgroup);
                this.populateDataForSgroup(cmol, graSgroup, sgroupInfo);
            }
            if (sgroupType == 7) {
                RepeatingUnitSgroup modSgroup = new RepeatingUnitSgroup(cmol, sgroupInfo.getSgroupConnectivity(), 7);
                allTruthSgroupList.add(modSgroup);
                this.populateDataForSgroup(cmol, modSgroup, sgroupInfo);
            }
            if (sgroupType == 13) {
                Sgroup comSgroup = new Sgroup(cmol, 13);
                allTruthSgroupList.add(comSgroup);
                comSgroup.setSubscript(sgroupInfo.getSubscript());
                this.populateDataForSgroup(cmol, comSgroup, sgroupInfo);
            }
            if (sgroupType == 8) {
                Sgroup mixSgroup = new Sgroup(cmol, 8);
                allTruthSgroupList.add(mixSgroup);
                this.populateDataForSgroup(cmol, mixSgroup, sgroupInfo);
            }
            if (sgroupType == 9) {
                Sgroup forSgroup = new Sgroup(cmol, 9);
                allTruthSgroupList.add(forSgroup);
                this.populateDataForSgroup(cmol, forSgroup, sgroupInfo);
            }
            if (sgroupType == 12) {
                Sgroup genSgroup = new Sgroup(cmol, 12);
                allTruthSgroupList.add(genSgroup);
                this.populateDataForSgroup(cmol, genSgroup, sgroupInfo);
            }
            if (sgroupType == 1) {
                MultipleSgroup mulSgroup = new MultipleSgroup(cmol, true);
                allTruthSgroupList.add(mulSgroup);
                mulSgroup.setXState(3);
                mulSgroup.setMultiplier((Integer)sgroupInfo.getPropertyFromCarrier("multiple_group_multiplier"));
                this.populateDataForSgroup(cmol, mulSgroup, sgroupInfo);
            }
            if (sgroupType != 11) continue;
            RepeatingUnitSgroup anySgroup = new RepeatingUnitSgroup(cmol, sgroupInfo.getSgroupConnectivity(), 11);
            allTruthSgroupList.add(anySgroup);
            this.populateDataForSgroup(cmol, anySgroup, sgroupInfo);
        }
        this.creatRelationOfSgroup(cmol, allTruthSgroupList);
    }

    private void replaceSgroupMolAtom(SgroupInfo sgroupInfo) {
        List<MolAtom> maList = sgroupInfo.getMolAtoms();
        if (maList != null && maList.size() == 1 && !this.molAtomMap.isEmpty()) {
            MolAtom key = new ArrayList<MolAtom>(this.molAtomMap.keySet()).get(0);
            if (maList.get(0) == key) {
                MolAtom newMolAtom = this.molAtomMap.get(key);
                maList.set(0, newMolAtom);
            }
        }
    }

    private void creatRelationOfSgroup(Molecule cmol, List<Sgroup> allTruthSgroupList) {
        if (allTruthSgroupList != null && !allTruthSgroupList.isEmpty() && allTruthSgroupList.size() > 1) {
            for (Sgroup baseSgroup : allTruthSgroupList) {
                Sgroup parentSgroup = this.getParentSgroup(allTruthSgroupList, baseSgroup);
                if (parentSgroup == null || parentSgroup == baseSgroup) continue;
                parentSgroup.addChildSgroup(baseSgroup);
            }
        }
    }

    private Sgroup getParentSgroup(List<Sgroup> allTruthSgroupList, Sgroup baseSgroup) {
        Sgroup resultParentSgroup = null;
        ArrayList<Sgroup> parentSgroups = new ArrayList<Sgroup>();
        for (Sgroup parentSgroup : allTruthSgroupList) {
            if (baseSgroup == parentSgroup || !this.isParentSgroup(baseSgroup, parentSgroup)) continue;
            parentSgroups.add(parentSgroup);
        }
        if (!parentSgroups.isEmpty()) {
            int parentSgroupCount = parentSgroups.size();
            int[] atomCountArray = new int[parentSgroupCount];
            HashMap<Integer, Sgroup> map = new HashMap<Integer, Sgroup>();
            int i = 0;
            Object tempResultParentSgroup = null;
            for (Sgroup parentSgroup : parentSgroups) {
                atomCountArray[i] = parentSgroup.getAtomCount();
                map.put(parentSgroup.getAtomCount(), parentSgroup);
                ++i;
            }
            Arrays.sort(atomCountArray);
            int minCount = atomCountArray[0];
            resultParentSgroup = (Sgroup)map.get(minCount);
            if (minCount == baseSgroup.getAtomCount() && (resultParentSgroup = tempResultParentSgroup) == null) {
                resultParentSgroup = this.getNearParentSgroup(baseSgroup, parentSgroups, allTruthSgroupList);
            }
        }
        return resultParentSgroup;
    }

    private Sgroup getNearParentSgroup(Sgroup baseSgroup, List<Sgroup> parentSgroups, List<Sgroup> allTruthSgroupList) {
        Sgroup nearParentSgroup = null;
        int[] indexArray = new int[parentSgroups.size()];
        for (int i = 0; i < parentSgroups.size(); ++i) {
            indexArray[i] = allTruthSgroupList.indexOf(parentSgroups.get(i));
        }
        Arrays.sort(indexArray);
        int baseIndex = allTruthSgroupList.indexOf(baseSgroup);
        for (int i : indexArray) {
            if (i <= baseIndex) continue;
            nearParentSgroup = allTruthSgroupList.get(i);
            break;
        }
        return nearParentSgroup;
    }

    private boolean isParentSgroup(Sgroup baseSgroup, Sgroup parentSgroup) {
        boolean isContainFlag = false;
        MolAtom[] baseSgroupAtoms = baseSgroup.getAtomArray();
        List<MolAtom> parentSgroupAtoms = Arrays.asList(parentSgroup.getAtomArray());
        int containedCount = 0;
        if (baseSgroupAtoms != null && parentSgroupAtoms != null) {
            for (MolAtom atom : baseSgroupAtoms) {
                if (!parentSgroupAtoms.contains(atom)) continue;
                ++containedCount;
            }
            if (containedCount != 0 && containedCount == baseSgroupAtoms.length && baseSgroupAtoms.length <= parentSgroupAtoms.size()) {
                isContainFlag = true;
            }
        }
        return isContainFlag;
    }

    private void populateDataForSgroup(Molecule cmol, Sgroup newSgroup, SgroupInfo sgroupInfo) {
        newSgroup.setSubType(sgroupInfo.getSubType());
        List<MBracket> brackets = this.getSgroupMBrackestList(sgroupInfo);
        List<MolAtom> sgroupMolAtoms = sgroupInfo.getMolAtoms();
        for (MBracket mb : brackets) {
            newSgroup.addBracket(mb);
        }
        if (brackets != null && !brackets.isEmpty() && sgroupMolAtoms.isEmpty()) {
            cmol.addSgroup(newSgroup, true);
        }
        for (MolAtom ma : sgroupMolAtoms) {
            if (ma == null || !this.molAtoms.contains(ma)) continue;
            cmol.setSgroupParent(ma, newSgroup, true);
            if (!(newSgroup instanceof MultipleSgroup)) continue;
            ((MultipleSgroup)newSgroup).setRepeatingUnitAtom(ma, true);
        }
    }

    private List<MBracket> getSgroupMBrackestList(SgroupInfo sgroupInfo) {
        int bracketPenWith = 0;
        Object penWidth = sgroupInfo.getPropertyFromCarrier("skc_sgroup_bracket_pen_width_key");
        if (penWidth != null) {
            bracketPenWith = (Integer)penWidth;
        }
        int bracketStyle = 0;
        Object style = sgroupInfo.getPropertyFromCarrier("skc_sgroup_bracket_style_key");
        if (style != null) {
            bracketStyle = (Integer)style;
        }
        Color bracketColor = null;
        Object color = sgroupInfo.getPropertyFromCarrier("skc_sgroup_bracket_color_key");
        if (color != null) {
            bracketColor = (Color)color;
        }
        List bracketList1 = (List)sgroupInfo.getPropertyFromCarrier("skc_sgroup_bracket_point3d_list1_key");
        List bracketList2 = (List)sgroupInfo.getPropertyFromCarrier("skc_sgroup_bracket_point3d_list2_key");
        return this.getMrvBrackets(bracketList1, bracketList2, bracketPenWith, bracketStyle, bracketColor);
    }

    private void populateDataForSuperatomSgroup(Molecule cmol, Sgroup newSgroup, SgroupInfo sgroupInfo) {
        List<MolAtom> sgroupMolAtoms = sgroupInfo.getMolAtoms();
        for (MolAtom ma : sgroupMolAtoms) {
            if (ma == null || !this.molAtoms.contains(ma)) continue;
            cmol.addSgroup(newSgroup, false);
            cmol.setSgroupParent(ma, newSgroup, true);
        }
    }

    private int getParserFlag(boolean f1, boolean f2) {
        int state = 0;
        if (f1) {
            state = -4;
        } else if (f2) {
            state = -1;
        }
        return state;
    }

    private int parsePortal(Object object) throws Exception {
        boolean flag = true;
        int n1 = 0;
        int n2 = 0;
        boolean f1 = false;
        boolean f2 = false;
        if (!this.isParseFileEnd()) {
            block14: while (!this.isParseFileEnd() && !f2) {
                int pv;
                int position = this.parseTypeOfData();
                switch (position) {
                    case -1: {
                        continue block14;
                    }
                    case -2: {
                        return 0;
                    }
                    case 122: {
                        do {
                            this.skipSomeDataForParsing();
                            position = this.parseTypeOfData();
                        } while (!this.isParseFileEnd() && position != 20 && !f2);
                        f2 = false;
                        continue block14;
                    }
                }
                if (this.objectCount == 0 && flag) {
                    flag = false;
                    if (position != 1) {
                        f2 = true;
                        return this.getParserFlag(f1, f2);
                    }
                }
                switch (position) {
                    case 258: {
                        this.parseByteArrayData(this.parseSingleCharacterData());
                        continue block14;
                    }
                    case 259: {
                        continue block14;
                    }
                    case 20: {
                        return this.createNewRelationForAtomAndBond(object, f1, f2);
                    }
                }
                if (position < this.dataSectionLength && (pv = dataSectionArray[position]) >= 0) {
                    n2 = propertiesArray[pv + 2];
                    if (n2 == 0) {
                        int x = this.baseParse(object, position);
                        switch (x) {
                            case -1: {
                                return -1;
                            }
                            case -4: {
                                f1 = true;
                            }
                        }
                        continue;
                    }
                    if (n2 == 1) {
                        if (!(this.currentObject instanceof MolAtom)) continue;
                        this.parseMolAtomPropertis(object, (MolAtom)this.currentObject, position);
                        continue;
                    }
                    if (n2 == 2) {
                        if (!(this.currentObject instanceof MolBondInfo)) continue;
                        this.parseMolBondPropertis(object, (MolBondInfo)this.currentObject, position);
                        continue;
                    }
                    if (n2 == 3) {
                        f2 = f2 || this.parseMoleculeProperties(object, position);
                        continue;
                    }
                    if (n2 != 4) continue;
                    return -1;
                }
                if (this.isParseFileEnd()) continue;
                if (n1++ > 100) {
                    f2 = true;
                    continue;
                }
                this.skipSomeDataForParsing();
                f2 = false;
            }
        } else {
            return -3;
        }
        return this.getParserFlag(f1, f2);
    }

    private int createNewRelationForAtomAndBond(Object object, boolean f1, boolean f2) {
        for (Object chemobject : this.currentObjectList) {
            if (!(chemobject instanceof MolBondInfo)) continue;
            MolBondInfo molBondInfo = (MolBondInfo)chemobject;
            molBondInfo.setAtom1Number(this.molAtoms.indexOf(this.currentObjectList.get(molBondInfo.getAtom1Number())));
            molBondInfo.setAtom2Number(this.molAtoms.indexOf(this.currentObjectList.get(molBondInfo.getAtom2Number())));
        }
        this.processCurrentSectionData(object);
        return this.getParserFlag(f1, f2);
    }

    private boolean parseMoleculeProperties(Object object, int currentPropertyType) {
        SgroupInfo sgroupInfo = null;
        if (this.currentObject instanceof SgroupInfo) {
            sgroupInfo = (SgroupInfo)this.currentObject;
        }
        boolean resultFlag = false;
        if (this.currentObject == null) {
            return resultFlag;
        }
        if (currentPropertyType <= 164) {
            switch (currentPropertyType) {
                case 51: {
                    return this.parseSgroupSpecialAtachInfo(sgroupInfo, resultFlag);
                }
                case 52: {
                    sgroupInfo.setSuperAtomSgroupText(this.parseStringData());
                    return resultFlag;
                }
                case 53: 
                case 56: 
                case 57: 
                case 58: 
                case 60: {
                    return resultFlag;
                }
                case 54: {
                    return this.parseSgroupTypeInfo(sgroupInfo, resultFlag);
                }
                case 55: {
                    return this.getReturnLabelFlag(resultFlag, object, currentPropertyType);
                }
                case 59: {
                    this.parseByteTypeData();
                    return resultFlag;
                }
                case 61: {
                    String sgroupType;
                    if (this.currentObject instanceof SgroupInfo && (sgroupType = sgroupInfo.getSgroupTypeStr()) != null) {
                        sgroupInfo.setExpandedFlag(false);
                    }
                    return resultFlag;
                }
                case 164: {
                    return this.parseSgroupAtachInfo(sgroupInfo, resultFlag);
                }
            }
        } else {
            resultFlag = this.getParseFlagOfSgroup(object, currentPropertyType, sgroupInfo, resultFlag);
        }
        return resultFlag;
    }

    private boolean parseSgroupSpecialAtachInfo(SgroupInfo sgroupInfo, boolean resultFlag) {
        int capacity = this.parseByteTypeData() / 2;
        ArrayList<Integer> newPropertyValue = new ArrayList<Integer>(capacity);
        ArrayList<Integer> bondAttachList = new ArrayList<Integer>(capacity);
        ArrayList<Integer> atomAttachList = new ArrayList<Integer>(capacity);
        for (int i = 0; i < capacity; ++i) {
            int v1 = this.parseSingleCharacterData();
            int v2 = this.parseSingleCharacterData();
            bondAttachList.add(v1);
            newPropertyValue.add(v1);
            atomAttachList.add(v2);
            newPropertyValue.add(v2);
        }
        this.objectManager.addKeyAndValue(this.currentObject, "skc_need_process_child", newPropertyValue);
        sgroupInfo.addPropertyToCarrier("skc_need_process_sgroup_bond_attach", bondAttachList);
        sgroupInfo.addPropertyToCarrier("skc_need_process_sgroup_atom_attach", atomAttachList);
        return resultFlag;
    }

    private boolean parseSgroupAtachInfo(SgroupInfo sgroupInfo, boolean resultFlag) {
        int countValue = this.parseByteTypeData();
        this.parseByteTypeData();
        ArrayList<Integer> childRef = new ArrayList<Integer>(countValue);
        ArrayList<Integer> attachBonds = new ArrayList<Integer>(countValue);
        ArrayList<Integer> attachAtoms = new ArrayList<Integer>(countValue);
        for (int x = 0; x < countValue; ++x) {
            int v1 = this.parseSingleCharacterData();
            int v2 = this.parseSingleCharacterData();
            if (v2 == -1) {
                resultFlag = true;
            }
            int v3 = this.parseByteTypeData();
            this.parseByteTypeData();
            int v4 = this.parseByteTypeData();
            if (v4 == 1) {
                childRef.add(v2);
                continue;
            }
            attachBonds.add(v1);
            childRef.add(v1);
            attachAtoms.add(v2);
            childRef.add(v2);
            if (v3 >= 65 && v3 > 90) continue;
        }
        sgroupInfo.addPropertyToCarrier("skc_need_process_sgroup_atom_attach", attachAtoms);
        sgroupInfo.addPropertyToCarrier("skc_need_process_sgroup_bond_attach", attachBonds);
        this.objectManager.addKeyAndValue(this.currentObject, "skc_need_process_child", childRef);
        return resultFlag;
    }

    private boolean parseSgroupTypeInfo(SgroupInfo sgroupInfo, boolean resultFlag) {
        int groupType = this.parseByteTypeData();
        switch (groupType) {
            case 1: {
                sgroupInfo.setSgroupTypeStr("LINKNODE");
                sgroupInfo.setSgroupType(1000);
                return resultFlag;
            }
            case 2: {
                sgroupInfo.setSgroupTypeStr("SUP");
                sgroupInfo.setSgroupType(0);
                sgroupInfo.setExpandedFlag(true);
                return resultFlag;
            }
            case 3: {
                sgroupInfo.setSgroupConnectivity("ht");
                sgroupInfo.setSgroupType(2);
                return resultFlag;
            }
            case 4: {
                sgroupInfo.setSgroupType(3);
                return resultFlag;
            }
            case 5: {
                sgroupInfo.setSgroupType(4);
                return resultFlag;
            }
            case 6: {
                sgroupInfo.setSgroupConnectivity("ht");
                sgroupInfo.setSgroupType(5);
                return resultFlag;
            }
            case 7: {
                sgroupInfo.setSgroupConnectivity("ht");
                sgroupInfo.setSgroupType(5);
                sgroupInfo.setSubType(SgroupUtil.getMrvSgroupSubType("ALT"));
                return resultFlag;
            }
            case 8: {
                sgroupInfo.setSgroupConnectivity("ht");
                sgroupInfo.setSgroupType(5);
                sgroupInfo.setSubType(SgroupUtil.getMrvSgroupSubType("RAN"));
                return resultFlag;
            }
            case 9: {
                sgroupInfo.setSgroupConnectivity("ht");
                sgroupInfo.setSgroupType(5);
                sgroupInfo.setSubType(SgroupUtil.getMrvSgroupSubType("BLO"));
                return resultFlag;
            }
            case 10: {
                sgroupInfo.setSgroupConnectivity("ht");
                sgroupInfo.setSgroupType(6);
                return resultFlag;
            }
            case 11: {
                sgroupInfo.setSgroupConnectivity("ht");
                sgroupInfo.setSgroupType(15);
                return resultFlag;
            }
            case 12: {
                sgroupInfo.setSgroupConnectivity("ht");
                sgroupInfo.setSgroupType(7);
                return resultFlag;
            }
            case 13: {
                sgroupInfo.setSgroupType(13);
                return resultFlag;
            }
            case 14: {
                sgroupInfo.setSgroupType(8);
                return resultFlag;
            }
            case 15: {
                sgroupInfo.setSgroupType(9);
                return resultFlag;
            }
            case 16: {
                sgroupInfo.setSgroupType(1);
                sgroupInfo.setExpandedFlag(true);
                return resultFlag;
            }
            case 17: {
                sgroupInfo.setSgroupType(12);
                return resultFlag;
            }
            case 18: {
                sgroupInfo.setSgroupConnectivity("ht");
                sgroupInfo.setSgroupType(11);
                return resultFlag;
            }
        }
        return resultFlag;
    }

    private boolean getParseFlagOfSgroup(Object object, int currentPropertyType, SgroupInfo sgroupInfo, boolean flag) {
        switch (currentPropertyType) {
            case 226: {
                this.parseSingleCharacterData();
                return flag;
            }
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 243: {
                return flag;
            }
            case 241: {
                switch (this.parseByteTypeData()) {
                    case 0: {
                        sgroupInfo.setSgroupConnectivity("ht");
                        return flag;
                    }
                    case 1: {
                        sgroupInfo.setSgroupConnectivity("hh");
                        return flag;
                    }
                    case 2: {
                        sgroupInfo.setSgroupConnectivity("eu");
                        return flag;
                    }
                }
                return flag;
            }
            case 242: {
                int bracketCount = this.parseByteTypeData();
                ArrayList<Coordinate> bracketList1 = new ArrayList<Coordinate>();
                ArrayList<Coordinate> bracketList2 = new ArrayList<Coordinate>();
                for (int i = 0; i < bracketCount; ++i) {
                    Coordinate newItem = this.parseCoordinateTypeData();
                    bracketList2.add(newItem);
                    Coordinate pointd2 = this.parseCoordinateTypeData();
                    bracketList1.add(pointd2);
                }
                sgroupInfo.addPropertyToCarrier("skc_sgroup_bracket_point3d_list1_key", bracketList1);
                sgroupInfo.addPropertyToCarrier("skc_sgroup_bracket_point3d_list2_key", bracketList2);
                return flag;
            }
            case 244: {
                return this.getReturnLabelFlag(flag, object, currentPropertyType);
            }
            case 245: {
                int compValue = this.parseSingleCharacterData();
                if (compValue == 0) {
                    sgroupInfo.setSubscript("c");
                } else {
                    sgroupInfo.setSubscript("c" + compValue);
                }
                return flag;
            }
            case 246: {
                ArrayList<Integer> list = new ArrayList<Integer>();
                this.parseByteTypeData();
                int cv1 = this.parseByteTypeData() - 1;
                int cv2 = this.parseByteTypeData() - 1;
                int cv3 = this.parseByteTypeData() - 1;
                int cv4 = this.parseByteTypeData() - 1;
                list.add(cv1);
                list.add(cv2);
                list.add(cv3);
                list.add(cv4);
                sgroupInfo.addPropertyToCarrier("skc_need_process_sgroup_corres_attach", list);
                return flag;
            }
            case 247: {
                int bracketStyle = this.parseByteTypeData();
                if (bracketStyle != 0) {
                    sgroupInfo.addPropertyToCarrier("skc_sgroup_bracket_style_key", bracketStyle);
                }
                return flag;
            }
            case 248: {
                sgroupInfo.setSubscript(this.parseStringData());
                return flag;
            }
            case 249: {
                this.parseSingleCharacterData();
                return flag;
            }
            case 250: {
                this.objectManager.addKeyAndValue(this.currentObject, "skc_need_process_basis_objs_num", this.parseSingleCharacterData());
                return flag;
            }
            case 251: {
                Object tempObject = this.objectManager.getValueByKey(this.currentObject, "skc_need_process_basis_objs_num");
                int integerProperty = 0;
                if (tempObject != null) {
                    integerProperty = (Integer)tempObject;
                }
                if (integerProperty <= 0) {
                    return flag;
                }
                ArrayList<Integer> basicObjectList = new ArrayList<Integer>(integerProperty);
                for (int j = 0; j < integerProperty; ++j) {
                    basicObjectList.add(this.parseSingleCharacterData());
                }
                this.objectManager.addKeyAndValue(this.currentObject, "skc_need_process_basis_objs", basicObjectList);
                this.objectManager.removeValueByOutsideKeyAndInsideKey(this.currentObject, "skc_need_process_basis_objs_num");
                return flag;
            }
            case 252: {
                String fieldDescription = this.parseStringData();
                if (this.currentObject instanceof DataSgroup) {
                    ((DataSgroup)this.currentObject).setFieldName(fieldDescription);
                }
                return flag;
            }
            case 253: {
                this.parseByteTypeData();
                return flag;
            }
            case 254: {
                this.parseStringData();
                return flag;
            }
            case 255: {
                this.parseByteTypeData();
                return flag;
            }
            case 256: {
                this.parseSingleCharacterData();
                return flag;
            }
            case 202: {
                this.parseStringData();
                return flag;
            }
        }
        return flag;
    }

    private boolean getReturnLabelFlag(boolean flag, Object obj, int currentProvertyType) {
        List<SgroupInfo> sgroupList;
        int value = 0;
        value = currentProvertyType == 244 ? this.parseSingleCharacterData() : this.parseByteTypeData();
        if (obj instanceof Segment && (sgroupList = ((Segment)obj).getSgroupInfoList()) != null) {
            SgroupInfo sgroupInfo = sgroupList.get(sgroupList.size() - 1);
            if (sgroupInfo.getSgroupType() == 1000) {
                sgroupInfo.addPropertyToCarrier("skc_sgroup_link_node_max_value_key", value);
            } else if (sgroupInfo.getSgroupType() == 1) {
                sgroupInfo.addPropertyToCarrier("multiple_group_multiplier", value);
            }
        }
        return flag;
    }

    private void fixCoord(Coordinate[] a) {
        if (a[0].getX() > a[1].getX() || a[0].getY() > a[1].getY()) {
            double x = a[0].getX();
            double y = a[0].getY();
            a[0].setX(Math.min(a[0].getX(), a[1].getX()));
            a[0].setY(Math.min(a[0].getY(), a[1].getY()));
            a[1].setX(Math.max(a[1].getX(), x));
            a[1].setY(Math.max(a[1].getY(), y));
        }
    }

    private int baseParse(Object object, int currentPropertyType) throws Exception {
        Integer success = 0;
        switch (currentPropertyType) {
            case 1: {
                this.version = this.parseByteTypeData();
                return success;
            }
            case 2: {
                this.currentObjectList = new ArrayList<Object>(this.parseSingleCharacterData());
                return success;
            }
            case 3: {
                this.createNewObject(object, success);
                return success;
            }
            case 48: {
                this.parseSingleCharacterData();
                this.parseSingleCharacterData();
                return success;
            }
            case 19: {
                Object currentTempObject = this.currentObject;
                List<Object> objectMapping = this.currentObjectList;
                ++this.objectCount;
                Object swapObject = null;
                swapObject = this.currentObject;
                success = this.parsePortal(swapObject);
                --this.objectCount;
                this.currentObjectList = objectMapping;
                this.currentObject = currentTempObject;
                currentTempObject = null;
                return success;
            }
            case 11: {
                this.parseFontProperty();
                return success;
            }
            case 5: {
                int penWidth = this.parseByteTypeData();
                if (this.currentObject instanceof SgroupInfo) {
                    ((SgroupInfo)this.currentObject).addPropertyToCarrier("skc_sgroup_bracket_pen_width_key", penWidth);
                } else if (this.currentObject instanceof MolBondInfo) {
                    if (penWidth != 7) {
                        double thickness = MolBondInfo.round((double)penWidth * 0.009142857142857144, 3);
                        ((MolBondInfo)this.currentObject).setThicknuess(thickness);
                    }
                } else if (this.isMPolyline(this.currentObjectType)) {
                    MPolylineInfo mPolylineInfo = this.mPolylineInfoMap.get((MPolyline)this.currentObject);
                    mPolylineInfo.setThickness(penWidth);
                }
                return success;
            }
            case 88: {
                Color color3 = this.parseColorData();
                if (this.currentObject instanceof SgroupInfo) {
                    ((SgroupInfo)this.currentObject).addPropertyToCarrier("skc_sgroup_bracket_color_key", color3);
                } else if (this.currentObject instanceof MolAtom) {
                    this.objectManager.addKeyAndValue(this.currentObject, "atom_color", color3);
                } else if (this.currentObject instanceof MolBondInfo) {
                    ((MolBondInfo)this.currentObject).setColor(color3);
                } else if (this.isMPolyline(this.currentObjectType)) {
                    MPolylineInfo mPolylineInfo = this.mPolylineInfoMap.get((MPolyline)this.currentObject);
                    mPolylineInfo.setPenColor(color3);
                } else if (this.currentObject instanceof MTextBox) {
                    ((MTextBox)this.currentObject).setColor(color3);
                }
                return success;
            }
            case 89: {
                Color color6 = this.parseColorData();
                if (this.isMPolyline(this.currentObjectType)) {
                    MPolylineInfo mPolylineInfo = this.mPolylineInfoMap.get((MPolyline)this.currentObject);
                    mPolylineInfo.setFillColor(color6);
                } else if (this.currentObject instanceof MTextBox) {
                    ((MTextBox)this.currentObject).setBackground(color6);
                }
                return success;
            }
            case 64: {
                this.parseCommentData(80);
                return success;
            }
            case 65: {
                this.parseCommentData(80);
                return success;
            }
            case 13: {
                switch (this.currentObjectType) {
                    case 17: 
                    case 19: 
                    case 20: {
                        this.parseRectangleData();
                        if (this.currentObjectType == 19) {
                            this.isAbsStereo = true;
                        }
                        return success;
                    }
                    case 21: {
                        this.parseCoordinateTypeData();
                        this.parseCoordinateTypeData();
                        return success;
                    }
                    case 35: {
                        Coordinate p3d1 = this.parseCoordinateTypeData();
                        Coordinate p3d2 = this.parseCoordinateTypeData();
                        DPoint3 dpoint3 = new Coordinate(p3d1.getX(), (p3d1.getY() + 2.0 * p3d2.getY()) / 3.0).getMrvDPoint3();
                        ((DataSgroup)this.currentObject).setAbsoluteXY(dpoint3);
                        return success;
                    }
                }
                if (this.currentObjectType == 14) {
                    Coordinate newPropertyValue = this.parseCoordinateTypeData();
                    DPoint3 p1 = new DPoint3(Coordinate.getXOfMrv(newPropertyValue.getX()), Coordinate.getYOfMrv(newPropertyValue.getY()), newPropertyValue.getZ());
                    Coordinate pointd2 = this.parseCoordinateTypeData();
                    DPoint3 p2 = new DPoint3(Coordinate.getXOfMrv(pointd2.getX()), Coordinate.getYOfMrv(pointd2.getY()), pointd2.getZ());
                    ((ReactionArrowInfo)this.currentObject).setReactionArrowStartPoint(p1);
                    ((ReactionArrowInfo)this.currentObject).setReactionArrowEndPoint(p2);
                    return success;
                }
                if (this.currentObjectType == 9 || this.currentObjectType == 2 || this.currentObjectType == 6) {
                    Coordinate[] p3ds = new Coordinate[]{this.parseCoordinateTypeData(), this.parseCoordinateTypeData()};
                    this.fixCoord(p3ds);
                    List<Object> generalMRectangles = null;
                    if (this.mPolylineMap.get("MRECTANGLE") == null) {
                        generalMRectangles = new ArrayList();
                        this.mPolylineMap.put("MRECTANGLE", generalMRectangles);
                    } else {
                        generalMRectangles = this.mPolylineMap.get("MRECTANGLE");
                    }
                    if (this.currentObjectType != 9) {
                        MRectangle mRectangle = (MRectangle)this.currentObject;
                        Coordinate pl = new Coordinate(Coordinate.getXOfMrv(p3ds[0].getX()), Coordinate.getYOfMrv(p3ds[0].getY()));
                        Coordinate pr = new Coordinate(Coordinate.getXOfMrv(p3ds[1].getX()), Coordinate.getYOfMrv(p3ds[1].getY()));
                        MPoint[] points = new MPoint[]{new MPoint(pl.getX(), pl.getY(), 0.0), new MPoint(pr.getX(), pl.getY(), 0.0), new MPoint(pr.getX(), pr.getY(), 0.0), new MPoint(pl.getX(), pr.getY(), 0.0)};
                        mRectangle.setPoints(points);
                        if (!generalMRectangles.contains((MRectangle)this.currentObject)) {
                            generalMRectangles.add((MRectangle)this.currentObject);
                        }
                    } else {
                        MTextBox mTextBox = (MTextBox)this.currentObject;
                        MPoint top = new MPoint(Coordinate.getXOfMrv(p3ds[0].getX()), Coordinate.getYOfMrv(p3ds[0].getY()));
                        MPoint bottom = new MPoint(Coordinate.getXOfMrv(p3ds[1].getX()), Coordinate.getYOfMrv(p3ds[1].getY()));
                        mTextBox.setCorners(top, bottom);
                        if (!generalMRectangles.contains((MTextBox)this.currentObject)) {
                            generalMRectangles.add((MTextBox)this.currentObject);
                        }
                    }
                    return success;
                }
                if (this.currentObjectType == 4) {
                    List<Object> generalMPolylines = null;
                    if (this.mPolylineMap.get("GeneralMPolyline") == null) {
                        generalMPolylines = new ArrayList();
                        this.mPolylineMap.put("GeneralMPolyline", generalMPolylines);
                    } else {
                        generalMPolylines = this.mPolylineMap.get("GeneralMPolyline");
                    }
                    Coordinate start = this.parseCoordinateTypeData();
                    Coordinate end = this.parseCoordinateTypeData();
                    MPoint mp1 = new MPoint(Coordinate.getXOfMrv(start.getX()), Coordinate.getYOfMrv(start.getY()), 0.0);
                    MPoint mp2 = new MPoint(Coordinate.getXOfMrv(end.getX()), Coordinate.getYOfMrv(end.getY()), 0.0);
                    ((MPolyline)this.currentObject).setPoints(new MPoint[]{mp1, mp2});
                    if (!generalMPolylines.contains((MPolyline)this.currentObject)) {
                        generalMPolylines.add((MPolyline)this.currentObject);
                    }
                    return success;
                }
                if (this.currentObjectType == 24 || this.currentObjectType == 3) {
                    Coordinate start = this.parseCoordinateTypeData();
                    Coordinate end = this.parseCoordinateTypeData();
                    Coordinate[] p3ds = new Coordinate[]{start, end};
                    Coordinate pl = new Coordinate(Coordinate.getXOfMrv(p3ds[0].getX()), Coordinate.getYOfMrv(p3ds[0].getY()));
                    Coordinate pr = new Coordinate(Coordinate.getXOfMrv(p3ds[1].getX()), Coordinate.getYOfMrv(p3ds[1].getY()));
                    if (this.currentObjectType == 3) {
                        MRoundedRectangle mRoundedRectangle = (MRoundedRectangle)this.currentObject;
                        MPoint[] points = new MPoint[]{new MPoint(pl.getX(), pl.getY(), 0.0), new MPoint(pr.getX(), pl.getY(), 0.0), new MPoint(pr.getX(), pr.getY(), 0.0), new MPoint(pl.getX(), pr.getY(), 0.0)};
                        mRoundedRectangle.setPoints(points);
                    }
                    return success;
                }
                if (this.currentObject instanceof Sgroup || this.currentObject instanceof MolBond || this.currentObject instanceof MolAtom) {
                    this.parseCoordinateTypeData();
                    this.parseCoordinateTypeData();
                    return success;
                }
                this.parseRectangleData();
                return success;
            }
            case 6: {
                this.parseByteTypeData();
                return success;
            }
            case 7: {
                Color color = this.parseBracketColor();
                if (this.currentObject instanceof Sgroup) {
                    this.objectManager.addKeyAndValue(this.currentObject, "skc_sgroup_bracket_color_key", color);
                }
                return success;
            }
            case 8: {
                return success;
            }
            case 9: {
                this.parseByteTypeData();
                return success;
            }
            case 12: {
                this.parseSingleCharacterData();
                return success;
            }
            case 15: {
                List<Object> generalMPolylines = null;
                if (this.mPolylineMap.get("GeneralMPolyline") == null) {
                    generalMPolylines = new ArrayList();
                    this.mPolylineMap.put("GeneralMPolyline", generalMPolylines);
                } else {
                    generalMPolylines = this.mPolylineMap.get("GeneralMPolyline");
                }
                Coordinate pointd = this.parseCoordinateTypeData();
                if (this.currentObjectType != 34) {
                    MRoundedRectangle mRoundedRectangle = (MRoundedRectangle)this.currentObject;
                    mRoundedRectangle.setArcHeight(pointd.getY() / 288.0);
                    mRoundedRectangle.setArcWidth(pointd.getX() / 288.0);
                    if (!generalMPolylines.contains(mRoundedRectangle)) {
                        generalMPolylines.add(mRoundedRectangle);
                    }
                }
                return success;
            }
            case 17: {
                List<Object> generalMPolylines = null;
                if (this.mPolylineMap.get("GeneralMPolyline") == null) {
                    generalMPolylines = new ArrayList();
                    this.mPolylineMap.put("GeneralMPolyline", generalMPolylines);
                } else {
                    generalMPolylines = this.mPolylineMap.get("GeneralMPolyline");
                }
                Coordinate[] c = this.getGraphicsPoint3dsArray();
                if (this.currentObjectType == 8 || this.currentObjectType == 5) {
                    ArrayList<MPoint> points = new ArrayList<MPoint>();
                    for (int i = 0; i < c.length; ++i) {
                        points.add(new MPoint(Coordinate.getXOfMrv(c[i].getX()), Coordinate.getYOfMrv(c[i].getY())));
                    }
                    if (this.currentObjectType == 5) {
                        points.add(new MPoint(Coordinate.getXOfMrv(c[0].getX()), Coordinate.getYOfMrv(c[0].getY())));
                    }
                    ((MPolyline)this.currentObject).setPoints(points.toArray(new MPoint[points.size()]));
                    if (!generalMPolylines.contains((MPolyline)this.currentObject)) {
                        generalMPolylines.add((MPolyline)this.currentObject);
                    }
                }
                return success;
            }
            case 21: {
                this.processTextData();
                return success;
            }
            case 49: {
                this.parseRgroup();
                return success;
            }
            case 50: {
                this.parseRgroupLogic();
                return success;
            }
            case 56: {
                int arrowDirection = this.parseByteTypeData();
                if (this.currentObjectType == 14) {
                    ((ReactionArrowInfo)this.currentObject).setArrowDir(arrowDirection);
                } else if (this.isMPolyline(this.currentObjectType)) {
                    MPolylineInfo mPolylineInfo = this.mPolylineInfoMap.get((MPolyline)this.currentObject);
                    mPolylineInfo.setArrowDir(arrowDirection);
                }
                return success;
            }
            case 57: {
                int arrowStyle = this.parseByteTypeData();
                if (this.currentObjectType == 14) {
                    ((ReactionArrowInfo)this.currentObject).setArrowStyle(arrowStyle);
                } else if (this.isMPolyline(this.currentObjectType)) {
                    MPolylineInfo mPolylineInfo = this.mPolylineInfoMap.get((MPolyline)this.currentObject);
                    mPolylineInfo.setArrowStyle(arrowStyle);
                }
                return success;
            }
            case 97: {
                this.parseByteTypeData();
                return success;
            }
            case 205: {
                List<Object> generalMPolylines = null;
                if (this.mPolylineMap.get("GeneralMPolyline") == null) {
                    generalMPolylines = new ArrayList();
                    this.mPolylineMap.put("GeneralMPolyline", generalMPolylines);
                } else {
                    generalMPolylines = this.mPolylineMap.get("GeneralMPolyline");
                }
                Coordinate[] p3ds = new Coordinate[]{this.parseCoordinateTypeData(), this.parseCoordinateTypeData(), this.parseCoordinateTypeData(), this.parseCoordinateTypeData()};
                Coordinate start = p3ds[1];
                Coordinate end = p3ds[0];
                Coordinate midPointOnArc = p3ds[2];
                Coordinate center = p3ds[3];
                MPoint mpPoint1 = new MPoint(Coordinate.getXOfMrv(start.getX()), Coordinate.getYOfMrv(start.getY()), 0.0);
                MPoint mpPoint2 = new MPoint(Coordinate.getXOfMrv(end.getX()), Coordinate.getYOfMrv(end.getY()), 0.0);
                double angle = Math.toDegrees(center.getArcOrCircleAngle(start, midPointOnArc)) + Math.toDegrees(center.getArcOrCircleAngle(end, midPointOnArc));
                MPolyline mPolyline = (MPolyline)this.currentObject;
                mPolyline.setPoints(new MPoint[]{mpPoint1, mpPoint2});
                boolean symbol = false;
                if (Coordinate.getYOfMrv(midPointOnArc.getY()) - Coordinate.getYOfMrv(center.getY()) >= 0.0) {
                    symbol = Coordinate.getXOfMrv(start.getX()) - Coordinate.getXOfMrv(end.getX()) < 0.0 ? true : (Coordinate.getXOfMrv(start.getX()) - Coordinate.getXOfMrv(end.getX()) > 0.0 ? false : Coordinate.getXOfMrv(midPointOnArc.getX()) - Coordinate.getXOfMrv(center.getX()) < 0.0);
                } else if (Coordinate.getXOfMrv(start.getX()) - Coordinate.getXOfMrv(end.getX()) < 0.0) {
                    symbol = false;
                } else if (Coordinate.getXOfMrv(start.getX()) - Coordinate.getXOfMrv(end.getX()) > 0.0) {
                    symbol = true;
                }
                if (symbol) {
                    mPolyline.setArcAngle(angle);
                } else {
                    mPolyline.setArcAngle(-angle);
                }
                if (!generalMPolylines.contains((MPolyline)this.currentObject)) {
                    generalMPolylines.add((MPolyline)this.currentObject);
                }
                return success;
            }
            case 220: {
                int arrowType = this.parseByteTypeData();
                if (this.currentObject instanceof MPolyline && this.mPolylineInfoMap.containsKey((MPolyline)this.currentObject)) {
                    MPolylineInfo mPolylineInfo = this.mPolylineInfoMap.get((MPolyline)this.currentObject);
                    if (arrowType == 1) {
                        mPolylineInfo.setArrowDir(arrowType);
                    }
                }
                return success;
            }
            case 229: {
                int arrowLength = this.parseSingleCharacterData();
                int arrowWidth = this.parseSingleCharacterData();
                if (this.isMPolyline(this.currentObjectType)) {
                    MPolylineInfo mPolylineInfo = this.mPolylineInfoMap.get((MPolyline)this.currentObject);
                    mPolylineInfo.setArrowLength((double)arrowLength * 0.1);
                    mPolylineInfo.setArrowWidth((double)arrowWidth * 0.1);
                }
                this.parseByteTypeData();
                this.parseByteTypeData();
                return success;
            }
            case 230: {
                double v = this.praseFloatTypeData() * 0.1;
                this.parseByteTypeData();
                if (this.currentObject instanceof ReactionArrowInfo) {
                    ((ReactionArrowInfo)this.currentObject).setArrowShaftSpace(v);
                }
                return success;
            }
            case 231: {
                this.parseByteTypeData();
                return success;
            }
            case 243: {
                this.parseByteTypeData();
                return success;
            }
        }
        return success;
    }

    private void parseFontProperty() {
        String str = this.parseStringData();
        int atomSize = this.parseSingleCharacterData();
        if (atomSize <= 0) {
            atomSize = 120;
        }
        int value = this.parseByteTypeData();
        if (this.currentObject instanceof MolAtom) {
            this.objectManager.addKeyAndValue(this.currentObject, "atom_font", str);
            this.objectManager.addKeyAndValue(this.currentObject, "atom_size", atomSize);
            if ((value & 1) != 0 && (value & 2) != 0) {
                this.objectManager.addKeyAndValue(this.currentObject, "atom_style", 3);
                return;
            }
            if ((value & 1) != 0) {
                this.objectManager.addKeyAndValue(this.currentObject, "atom_style", 1);
            }
            if ((value & 2) != 0) {
                this.objectManager.addKeyAndValue(this.currentObject, "atom_style", 2);
            }
        }
    }

    private int createNewObject(Object object, Integer retValue) {
        int value = this.parseByteTypeData();
        this.createObjectByType(value);
        if (this.currentObject != null) {
            if (this.currentObject instanceof MolAtom && object instanceof Segment) {
                ((Segment)object).addMolAtom((MolAtom)this.currentObject);
            }
            if (this.currentObject instanceof Segment && object instanceof Segment) {
                ((Segment)object).addChildSegment((Segment)this.currentObject);
            }
            if (this.currentObjectType == 17) {
                RgroupInfo rgroupInfo = (RgroupInfo)this.currentObject;
                List<Segment> segments = null;
                if (object instanceof Segment) {
                    segments = ((Segment)object).getChildren();
                }
                if (segments != null) {
                    for (Segment rgroupSegment : segments) {
                        if (rgroupSegment == null) continue;
                        for (MolAtom molAtom : rgroupSegment.getMolAtoms()) {
                            rgroupInfo.addMolAtom(molAtom);
                        }
                        for (MolBondInfo molBondInfo : rgroupSegment.getMolBondxes()) {
                            rgroupInfo.addMolBondx(molBondInfo);
                        }
                    }
                }
                this.rgroupxes.add(rgroupInfo);
            }
            if (this.currentObject instanceof SgroupInfo && object instanceof Segment) {
                ((Segment)object).addSgroupInfo((SgroupInfo)this.currentObject);
            }
            if (this.currentObject instanceof SgroupInfo && object instanceof MolAtom && this.currentObjectType != 35) {
                this.objectManager.createRelationOfMolAtomAndSupSgroup((MolAtom)object, (SgroupInfo)this.currentObject);
            }
        }
        this.currentObjectList.add(this.currentObject);
        return value;
    }

    private void createObjectByType(int type) {
        this.currentObjectType = 0;
        this.currentObject = null;
        switch (type) {
            case 33: {
                this.currentObject = new MolAtom(0.0, 0.0);
                break;
            }
            case 32: {
                this.currentObject = MolBondInfo.createMolBond();
                break;
            }
            case 34: {
                this.currentObjectType = 34;
                this.currentObject = new SgroupInfo(new Molecule(), -9999);
                this.sgroupInfoList.add((SgroupInfo)this.currentObject);
                break;
            }
            case 35: {
                this.currentObjectType = 35;
                this.currentObject = new DataSgroup(new Molecule());
                ((DataSgroup)this.currentObject).setUnitDisplayed(true);
                this.dataSgroups.add((DataSgroup)this.currentObject);
                break;
            }
            case 12: {
                this.currentObject = new Segment();
                break;
            }
            case 17: {
                this.currentObjectType = 17;
                this.currentObject = new RgroupInfo();
                break;
            }
            case 14: {
                this.currentObjectType = 14;
                this.currentObject = new ReactionArrowInfo();
                this.reactionArrowInfos.add((ReactionArrowInfo)this.currentObject);
                break;
            }
            case 9: {
                this.currentObjectType = 9;
                this.currentObject = new MTextBox();
                this.mTextBoxInfoMap.put((MTextBox)this.currentObject, new MTextBoxInfo());
                break;
            }
            case 19: {
                this.currentObjectType = 19;
                break;
            }
            case 4: {
                this.currentObjectType = 4;
                this.currentObject = new MPolyline();
                break;
            }
            case 2: {
                this.currentObjectType = 2;
                this.currentObject = new MRectangle();
                break;
            }
            case 3: {
                this.currentObjectType = 3;
                this.currentObject = new MRoundedRectangle();
                break;
            }
            case 5: {
                this.currentObjectType = 5;
                this.currentObject = new MPolyline();
                break;
            }
            case 6: {
                this.currentObjectType = 6;
                this.currentObject = new MEllipse();
                break;
            }
            case 8: {
                this.currentObjectType = 8;
                this.currentObject = new MPolyline();
                break;
            }
            case 24: {
                this.currentObjectType = 24;
                this.currentObject = new MPolyline();
                break;
            }
            case 25: {
                this.currentObjectType = 8;
                this.currentObject = new MPolyline();
                break;
            }
            case 21: {
                this.currentObject = new Sgroup(new Molecule(), 0);
                break;
            }
        }
    }

    private void parseMolAtomPropertis(Object object, MolAtom molAtom, int type) {
        if (molAtom != null) {
            if (!this.molAtoms.contains(molAtom)) {
                this.molAtoms.add(molAtom);
            }
            if (object instanceof Segment && !((Segment)object).getMolAtoms().contains(molAtom)) {
                ((Segment)object).addMolAtom(molAtom);
            }
            switch (type) {
                case 22: {
                    this.parseAtomCoordinate(molAtom);
                    return;
                }
                case 23: {
                    this.parseAtomType(molAtom);
                    return;
                }
                case 232: {
                    this.parseAtomSymol(molAtom);
                    return;
                }
                case 208: {
                    this.parseSingleCharacterData();
                    return;
                }
                case 24: {
                    this.parseAtomList(molAtom);
                    return;
                }
                case 25: {
                    this.parseAtomAlias(molAtom);
                    return;
                }
                case 26: {
                    this.molAtomNumber = this.parseSingleCharacterData();
                    return;
                }
                case 27: {
                    molAtom.setCharge(this.parseByteTypeData() - 16);
                    return;
                }
                case 28: {
                    this.parseAtomRadical(molAtom);
                    return;
                }
                case 29: {
                    this.parseAtomMassno(molAtom);
                    return;
                }
                case 30: {
                    this.setValence(this.parseByteTypeData(), molAtom);
                    return;
                }
                case 31: {
                    this.parseAtomQProp(molAtom);
                    return;
                }
                case 32: {
                    this.parseAtomSubstitution(molAtom);
                    return;
                }
                case 33: {
                    return;
                }
                case 34: {
                    molAtom.setQProp("h", 0);
                    return;
                }
                case 35: {
                    molAtom.setQProp("u", 1);
                    return;
                }
                case 36: {
                    this.parseAtomValue(molAtom);
                    return;
                }
                case 37: {
                    this.prase16HData();
                    return;
                }
                case 38: {
                    this.parseByteTypeData();
                    return;
                }
                case 53: {
                    int attach = this.parseByteTypeData();
                    molAtom.setAliasstr("RGROUPATTACH_" + attach);
                    return;
                }
                case 60: {
                    this.parseAtomAbbrevAtach(molAtom);
                    return;
                }
                case 62: {
                    this.parseByteTypeData();
                    return;
                }
                case 63: {
                    if (this.molAtomNumber != 0) {
                        molAtom.setAtomMap(this.molAtomNumber);
                    }
                    return;
                }
                case 66: {
                    this.parseByteTypeData();
                    return;
                }
                case 78: {
                    this.praseFloatTypeData();
                    return;
                }
                case 79: {
                    return;
                }
                case 80: {
                    int stereo = this.parseByteTypeData();
                    if (stereo != 0) {
                        molAtom.setReactionStereo(stereo);
                    }
                    return;
                }
                case 90: {
                    this.parseSingleCharacterData();
                    return;
                }
                case 91: {
                    return;
                }
                case 96: {
                    int mapNo = this.parseSingleCharacterData();
                    this.setAtomAtomMappingNumber(mapNo, molAtom);
                    return;
                }
                case 98: {
                    this.parseByteTypeData();
                    return;
                }
                case 223: {
                    for (int i = 0; i < 3; ++i) {
                        this.praseFloatTypeData();
                    }
                    return;
                }
                case 224: {
                    this.parseSingleCharacterData();
                    return;
                }
                case 225: {
                    this.parseSingleCharacterData();
                    return;
                }
                case 233: {
                    this.parseByteTypeData();
                    return;
                }
                case 235: {
                    return;
                }
                case 257: {
                    this.parseByteTypeData();
                    return;
                }
            }
        }
    }

    private void parseAtomCoordinate(MolAtom molAtom) {
        Coordinate p3d = this.parseCoordinateData();
        DPoint3 dp3 = new Coordinate(p3d).getMrvDPoint3();
        molAtom.setXY(dp3.x, dp3.y);
    }

    private void parseAtomAbbrevAtach(MolAtom molAtom) {
        int size = this.parseByteTypeData();
        ArrayList<Integer> list = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.parseSingleCharacterData());
        }
        this.objectManager.addKeyAndValue(molAtom, "skc_need_process_atom_abbrev_attach", list);
    }

    private void parseAtomValue(MolAtom molAtom) {
        String str = this.parseStringData();
        if (str != null && str.length() > 0) {
            molAtom.setExtraLabel(str);
        }
    }

    private void parseAtomRadical(MolAtom molAtom) {
        int radical = this.parseByteTypeData();
        if (radical != 0) {
            if (radical == 1) {
                molAtom.setRadical(6);
            }
            if (radical == 2) {
                molAtom.setRadical(1);
            }
            if (radical == 3) {
                molAtom.setRadical(10);
            }
        }
    }

    private void parseAtomList(MolAtom molAtom) {
        int size = this.parseByteTypeData();
        ArrayList<String> list = new ArrayList<String>(10);
        for (int i = 0; i < size; ++i) {
            int v = this.parseSingleCharacterData();
            list.add(ChemUtil.getAtomSymbolByType(v));
        }
        if (list != null) {
            int[] ai = new int[list.size()];
            int i = 0;
            for (String string : list) {
                ai[i++] = ChemUtil.getAtomTypeBySymbol(string);
            }
            molAtom.setList(ai);
        }
    }

    private void parseAtomAlias(MolAtom molAtom) {
        String alias = this.parseStringData();
        molAtom.setAliasstr(alias);
        if (this.beilsteinGenericsAtoms.contains(alias)) {
            molAtom.setAtno(136);
        }
    }

    private void parseAtomSymol(MolAtom molAtom) {
        String symbol = this.parseStringData();
        int atomNo = ChemUtil.getAtomTypeBySymbol(symbol);
        if (symbol.equals("LP")) {
            molAtom.setAtno(130);
        } else if (symbol.equals("*")) {
            molAtom.setAtno(133);
            molAtom.setAliasstr(symbol);
        } else if (symbol.equals("A")) {
            molAtom.setAtno(131);
        } else if (symbol.equals("Q")) {
            molAtom.setAtno(132);
        } else if (atomNo != -1 && !this.pseudoAtoms.contains(symbol)) {
            molAtom.setAtno(atomNo);
        } else if (this.pseudoAtoms.contains(symbol)) {
            molAtom.setAtno(136);
            molAtom.setAliasstr(symbol);
        } else if (atomNo == -1 && molAtom.getAtno() != 129 && molAtom.getAtno() != 128) {
            molAtom.setAliasstr(symbol);
        }
    }

    private void parseAtomSubstitution(MolAtom molAtom) {
        int sub = this.parseByteTypeData() - 3;
        if (sub != 0) {
            if (sub == -1) {
                sub = 0;
            }
            molAtom.setQProp("s", sub);
        }
    }

    private void parseAtomQProp(MolAtom molAtom) {
        int qProp = this.parseByteTypeData() - 3;
        if (qProp != 0) {
            if (qProp == -1) {
                molAtom.setQProp("rb", 0);
            } else if (qProp == 252) {
                molAtom.setQProp("rb", -4);
            } else {
                molAtom.setQProp("rb", qProp);
            }
        }
    }

    private void parseAtomMassno(MolAtom molAtom) {
        int massno = this.parseByteTypeData();
        massno = massno != 0 ? (massno -= 19) : 200;
        if (massno != 0) {
            if (massno == 200) {
                molAtom.setMassno(molAtom.getAtno() * 2);
            } else {
                molAtom.setMassno(massno + molAtom.getAtno() * 2);
            }
        }
    }

    private void parseAtomType(MolAtom molAtom) {
        int v = this.parseSingleCharacterData();
        if (v == 272) {
            this.objectManager.addKeyAndValue(molAtom, "molatom_type_number_key", v);
        }
        if (v == 271) {
            molAtom.setAtno(129);
        } else if (v == 270) {
            molAtom.setAtno(128);
        }
        if (v != 272 && v == 275) {
            molAtom.setAtno(134);
        }
        if (v == 275) {
            v = this.parseSingleCharacterData();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < v; ++i) {
                int j = this.parseSingleCharacterData();
                builder.append("R" + j);
                molAtom.setAtno(134);
                molAtom.setRgroup(j);
            }
        }
    }

    private void parseMolBondPropertis(Object object, MolBondInfo molBondInfo, int parseNumber) throws Exception {
        if (!this.molBondxes.contains(molBondInfo)) {
            this.molBondxes.add(molBondInfo);
        }
        if (object instanceof Segment && !((Segment)object).getMolBondxes().contains(molBondInfo)) {
            ((Segment)object).addMolBondx(molBondInfo);
        }
        switch (parseNumber) {
            case 39: {
                int resultNumber = this.parseSingleCharacterData();
                int num2 = this.parseSingleCharacterData();
                molBondInfo.setAtom1Number(resultNumber);
                molBondInfo.setAtom2Number(num2);
                return;
            }
            case 40: {
                int resultNumber = this.parseByteTypeData();
                molBondInfo.setType(resultNumber);
                return;
            }
            case 41: {
                int resultNumber = this.parseByteTypeData();
                molBondInfo.setStereoType(resultNumber);
                return;
            }
            case 42: {
                int resultNumber = this.parseByteTypeData();
                return;
            }
            case 43: {
                int resultNumber = this.parseByteTypeData();
                molBondInfo.setQtopo(resultNumber);
                return;
            }
            case 44: {
                int resultNumber = this.parseByteTypeData();
                molBondInfo.setRxnCenter(resultNumber == 15 ? -1 : resultNumber);
                return;
            }
            case 45: {
                molBondInfo.setStereoCare(true);
                return;
            }
            case 46: {
                this.parseByteTypeData();
                return;
            }
            case 47: {
                this.parseByteTypeData();
                return;
            }
            case 81: {
                ((MolBondInfo)this.currentObject).setBondCrossed(true);
                return;
            }
            case 82: {
                int resultNumber = this.parseByteTypeData();
                molBondInfo.setStereoBoldBondFlag(true);
                return;
            }
            case 206: {
                this.parseSingleCharacterData();
                return;
            }
            case 207: {
                this.parseSingleCharacterData();
                return;
            }
        }
    }

    private boolean isDataGroupString(String sText, DataSgroup sgroup) {
        if (sText.startsWith(">=")) {
            sgroup.setQueryOp(">=");
            sgroup.setData(sText.substring(2).trim());
        } else if (sText.startsWith("<=")) {
            sgroup.setQueryOp("<=");
            sgroup.setData(sText.substring(2).trim());
        } else if (sText.startsWith("<>")) {
            sgroup.setQueryOp("<>");
            sgroup.setData(sText.substring(2).trim());
        } else if (sText.startsWith(">")) {
            sgroup.setQueryOp(">");
            sgroup.setData(sText.substring(1).trim());
        } else if (sText.startsWith("<")) {
            sgroup.setQueryOp("<");
            sgroup.setData(sText.substring(1).trim());
        } else if (sText.startsWith("contains")) {
            sgroup.setQueryOp("contains");
            sgroup.setData(sText.substring(8).trim());
        } else if (sText.startsWith("like")) {
            sgroup.setQueryOp("like");
            sgroup.setData(sText.substring(4).trim());
        } else if (sText.startsWith("between")) {
            sgroup.setQueryOp("between");
            sgroup.setData(sText.substring(7).trim());
        } else {
            return false;
        }
        return true;
    }

    private void processTextData() {
        long fv1 = this.getParsePoint();
        int fv2 = this.parseSingleCharacterData();
        if (fv2 > 0) {
            this.parseSkip(12);
            int fv3 = this.parseSingleCharacterData();
            this.parseSingleCharacterData();
            int fv4 = this.parseSingleCharacterData();
            this.parseSingleCharacterData();
            int fv5 = this.parseLongTypeData();
            int fv6 = this.parseSingleCharacterData();
            String[] stringArray = new String[fv4];
            int[] intArray1 = new int[fv4];
            int[] intArray2 = new int[fv4];
            for (int i = 0; i < fv4; ++i) {
                byte[] buffer = this.parseByteArrayData(32);
                String strValue = "";
                if (buffer != null) {
                    strValue = new String(buffer);
                }
                stringArray[i] = strValue.substring(0, strValue.indexOf("\u0000"));
                intArray1[i] = this.parseByteTypeData();
                intArray2[i] = this.parseSingleCharacterData();
            }
            byte[] byteArray = new byte[fv3];
            char[] charArray = new char[fv3];
            if (this.version < 3) {
                this.parseSkip(14);
            }
            for (int i = 0; i < fv3; ++i) {
                byteArray[i] = (byte)this.parseByteTypeData();
                charArray[i] = (char)this.parseByteTypeData();
            }
            if (this.version >= 4) {
                this.parseSkip(14);
            }
            this.setParsePoint((int)(fv1 + (long)fv2 + 2L));
            String textValue1 = new String(byteArray).trim();
            textValue1 = textValue1.replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}");
            String plus = "+";
            if (plus.equals(textValue1)) {
                ((MTextBox)this.currentObject).setText(plus);
                return;
            }
            if (this.currentObject instanceof DataSgroup) {
                this.processDataSgroupText(textValue1);
                return;
            }
            String txtValue2 = this.processTextContent(fv3, fv4, stringArray, intArray1, intArray2, byteArray, charArray);
            this.populateMTextBoxData(txtValue2);
            this.populateTextHorizontalValue(fv6);
            this.populateTextVerticalValue(fv6);
            if ((long)fv5 == 8192L) {
                if (this.currentObject instanceof MTextBox) {
                    ((MTextBox)this.currentObject).setAutoSize(false);
                }
                return;
            }
            if (this.currentObject instanceof MTextBox) {
                ((MTextBox)this.currentObject).setAutoSize(true);
            }
        }
    }

    private void populateTextVerticalValue(int vertical) {
        int verticalAlign = 0;
        switch (vertical & 0x70) {
            case 16: {
                verticalAlign = 0;
                break;
            }
            case 32: {
                verticalAlign = 1;
                break;
            }
            case 64: {
                verticalAlign = 2;
            }
        }
        ((MTextBox)this.currentObject).setVerticalAlignment(verticalAlign);
    }

    private void populateTextHorizontalValue(int horizontal) {
        int horizontalAlign = 0;
        switch (horizontal & 0xF) {
            case 1: {
                horizontalAlign = 0;
                break;
            }
            case 2: {
                horizontalAlign = 1;
                break;
            }
            case 4: {
                horizontalAlign = 2;
            }
        }
        ((MTextBox)this.currentObject).setHorizontalAlignment(horizontalAlign);
    }

    private void populateMTextBoxData(String txtValue) {
        TextUtil textUtil = new TextUtil();
        textUtil.parseTextContent(txtValue);
        for (TextBaseData textBaseData : textUtil.getTextBaseDataList()) {
            MTextBoxInfo mTextBoxInfo = this.mTextBoxInfoMap.get((MTextBox)this.currentObject);
            mTextBoxInfo.setStyleAndStateInfo(textBaseData.getTextStyleMark());
            MTextAttributes attributes = mTextBoxInfo.handleTextBox((MTextBox)this.currentObject);
            if (((MTextBox)this.currentObject).getTextDocument() == null) {
                ((MTextBox)this.currentObject).setCurrentTextAttributes(attributes);
                ((MTextBox)this.currentObject).setText(TextUtil.replaceSignWithSpecialCharacter(textBaseData.getTextContent()));
                continue;
            }
            ((MTextBox)this.currentObject).getTextDocument().append(TextUtil.replaceSignWithSpecialCharacter(textBaseData.getTextContent()), attributes);
        }
    }

    private String processTextContent(int fv3, int fv4, String[] stringArray, int[] intArray1, int[] intArray2, byte[] byteArray, char[] charArray) {
        StringBuilder textBuffer = new StringBuilder();
        textBuffer.append("{\\rtf1\\defformat\\pc \n");
        textBuffer.append("{\\fonttbl \n");
        for (int k = 0; k < fv4; ++k) {
            textBuffer.append("   {\\f" + k);
            if (stringArray[k].equals("Symbol")) {
                textBuffer.append("\\fcharset2 ");
            } else if (stringArray[k].contains("Greek")) {
                textBuffer.append("\\fcharset161 ");
            } else if (stringArray[k].contains("CYR")) {
                textBuffer.append("\\fcharset204 ");
            } else {
                textBuffer.append("\\fcharset0 ");
            }
            textBuffer.append(stringArray[k] + ";}\n");
        }
        textBuffer.append("}");
        int intValue1 = -1;
        int n = -1;
        for (int intValue2 = 0; intValue2 < fv3; ++intValue2) {
            char c;
            if (c != charArray[intValue2]) {
                int intValue4 = charArray[intValue2] & 0x3F;
                ((MTextBox)this.currentObject).setFontScale(10.0);
                textBuffer.append("\n\\plain \n");
                textBuffer.append("\\f" + intValue4 + "\\fs" + intArray2[intValue4] / 5);
                textBuffer.append((intArray1[intValue4] & 1) != 0 ? "\\b " : "");
                textBuffer.append((intArray1[intValue4] & 2) != 0 ? "\\i " : "");
                textBuffer.append((intArray1[intValue4] & 8) != 0 ? "\\super " : "");
                textBuffer.append((intArray1[intValue4] & 0x10) != 0 ? "\\sub " : "");
                textBuffer.append((intArray1[intValue4] & 4) != 0 ? "\\ul " : "");
                if ((intArray1[intValue4] & 0x20) != 0) {
                    if (intValue1 == -1) {
                        intValue1 = 1;
                    }
                } else {
                    intValue1 = 0;
                }
                textBuffer.append(intArray1[intValue4] == 0 ? " " : "");
                c = charArray[intValue2];
            }
            if (byteArray[intValue2] == 10) {
                textBuffer.append("\\par\n");
                continue;
            }
            if (byteArray[intValue2] == 92 || byteArray[intValue2] == 123 || byteArray[intValue2] == 125) {
                textBuffer.append("\\" + (char)byteArray[intValue2]);
                continue;
            }
            if (byteArray[intValue2] >= 128) {
                textBuffer.append("\\'");
                continue;
            }
            textBuffer.append((char)byteArray[intValue2]);
        }
        textBuffer.append("\n}");
        return TextUtil.replaceSignWithSpecialCharacter(textBuffer.toString());
    }

    private void processDataSgroupText(String textValue) {
        DataSgroup sgroup = (DataSgroup)this.currentObject;
        if (!this.isDataGroupString(textValue = textValue.trim(), sgroup)) {
            int length = textValue.indexOf("=");
            if (length > 0) {
                String tempStr = textValue.substring(0, length).trim();
                if (tempStr.length() == 1) {
                    sgroup.setTag(tempStr.charAt(0));
                    textValue = textValue.substring(length + 1).trim();
                    if (!this.isDataGroupString(textValue, sgroup)) {
                        sgroup.setData(textValue);
                    }
                }
            } else {
                sgroup.setData(textValue);
            }
        }
    }

    private void reprocessCurrentMapingData() {
        if (this.currentObjectList == null) {
            return;
        }
        for (int i = 0; i < this.currentObjectList.size(); ++i) {
            List tpSpecialObjectList;
            List tpAtomList;
            Object tpObject = this.currentObjectList.get(i);
            if (tpObject == null) continue;
            Object object = this.objectManager.getValueByKey(tpObject, "skc_need_process_basis_objs");
            if (object != null) {
                List dataSgroupMolAtoms = (List)object;
                Iterator i$ = dataSgroupMolAtoms.iterator();
                while (i$.hasNext()) {
                    int molAtomNum = (Integer)i$.next();
                    Object chemObject = this.currentObjectList.get(molAtomNum);
                    if (!(tpObject instanceof DataSgroup)) continue;
                    DataSgroup dataSgroup = (DataSgroup)tpObject;
                    if (!(chemObject instanceof MolAtom)) continue;
                    dataSgroup.add((MolAtom)chemObject);
                }
            }
            if (tpObject instanceof MolAtom && (tpAtomList = (List)this.objectManager.getValueByKey(tpObject, "skc_need_process_atom_abbrev_attach")) != null && !tpAtomList.isEmpty()) {
                ArrayList<MolBondInfo> molBondxList = new ArrayList<MolBondInfo>();
                for (int k = tpAtomList.size() - 1; k >= 0; --k) {
                    int vk = (Integer)tpAtomList.get(k);
                    MolBondInfo molBondInfo = (MolBondInfo)this.currentObjectList.get(vk);
                    molBondxList.add(molBondInfo);
                }
                this.objectManager.addKeyAndValue(tpObject, "skc_need_process_atom_abbrev_attach", molBondxList);
            }
            if (tpObject instanceof SgroupInfo) {
                Object tempObject;
                SgroupInfo sgroupInfo = (SgroupInfo)tpObject;
                List tpSgroupAtomAtachList = (List)sgroupInfo.getPropertyFromCarrier("skc_need_process_sgroup_atom_attach");
                if (tpSgroupAtomAtachList != null) {
                    ArrayList<MolAtom> molAtomList = new ArrayList<MolAtom>();
                    ArrayList<MolAtom> molAtomListTemp = new ArrayList<MolAtom>();
                    for (int m = tpSgroupAtomAtachList.size() - 1; m >= 0; --m) {
                        int vm = (Integer)tpSgroupAtomAtachList.get(m);
                        if (vm < 0 || vm >= this.currentObjectList.size() || !((tempObject = this.currentObjectList.get(vm)) instanceof MolAtom)) continue;
                        MolAtom molAtom = (MolAtom)tempObject;
                        molAtomListTemp.add(molAtom);
                        molAtomList.add(molAtom);
                    }
                    if (sgroupInfo.getSgroupType() == 0) {
                        sgroupInfo.addMolAtomsToSgroup(molAtomList);
                    }
                    sgroupInfo.addPropertyToCarrier("skc_need_process_sgroup_atom_attach", molAtomListTemp);
                }
                List tpSgroupBondAtachList = (List)sgroupInfo.getPropertyFromCarrier("skc_need_process_sgroup_bond_attach");
                ArrayList<MolBondInfo> molBondxList = null;
                if (tpSgroupBondAtachList != null) {
                    molBondxList = new ArrayList<MolBondInfo>();
                    for (int n = tpSgroupBondAtachList.size() - 1; n >= 0; --n) {
                        int vn = (Integer)tpSgroupBondAtachList.get(n);
                        if (vn < 0 || vn >= this.currentObjectList.size() || !((tempObject = this.currentObjectList.get(vn)) instanceof MolBondInfo)) continue;
                        MolBondInfo molBondInfo = (MolBondInfo)tempObject;
                        molBondxList.add(molBondInfo);
                        if (sgroupInfo.getSgroupType() != 0) continue;
                        sgroupInfo.addMolBondInfoToSgroupInfo(molBondInfo);
                    }
                    sgroupInfo.addPropertyToCarrier("skc_need_process_sgroup_bond_attach", molBondxList);
                }
            }
            if ((tpSpecialObjectList = (List)this.objectManager.getValueByKey(tpObject, "skc_need_process_child")) == null) continue;
            for (int tps = 0; tps < tpSpecialObjectList.size(); ++tps) {
                int tpsValue = (Integer)tpSpecialObjectList.get(tps);
                if (tpsValue < 0 || tpsValue >= this.currentObjectList.size()) continue;
                Object parent = this.currentObjectList.get(tpsValue);
                if (parent instanceof Segment) {
                    if (!(tpObject instanceof SgroupInfo)) continue;
                    SgroupInfo sgroupInfo = (SgroupInfo)tpObject;
                    Segment seg = (Segment)parent;
                    List<MolAtom> segmentAtomList = seg.getMolAtoms();
                    if (segmentAtomList != null && !segmentAtomList.isEmpty()) {
                        sgroupInfo.addMolAtomsToSgroup(segmentAtomList);
                        continue;
                    }
                    List<SgroupInfo> sgroupInfoList = seg.getSgroupInfoList();
                    if (sgroupInfoList == null) continue;
                    for (SgroupInfo sgroup : sgroupInfoList) {
                        sgroupInfo.addMolAtomsToSgroup(sgroup.getMolAtoms());
                    }
                    continue;
                }
                if (parent instanceof MolBond) {
                    if (!(tpObject instanceof SgroupInfo)) continue;
                    SgroupInfo sgInfo = (SgroupInfo)tpObject;
                    sgInfo.addMolBondInfoToSgroupInfo((MolBondInfo)parent);
                    continue;
                }
                if (!(parent instanceof MolAtom) || !(tpObject instanceof SgroupInfo)) continue;
                this.addMolAtomToSgroupInfo((SgroupInfo)tpObject, (MolAtom)parent);
            }
        }
    }

    private void addMolAtomToSgroupInfo(SgroupInfo sgroupInfo, MolAtom molAtom) {
        int type = sgroupInfo.getSgroupType();
        if (type != 10) {
            sgroupInfo.addMolAtomToSgroup(molAtom);
        }
    }

    private boolean isNeedFinalCollection(List<SgroupInfo> segmentSgroups) {
        boolean f1 = false;
        boolean f2 = false;
        if (segmentSgroups == null || segmentSgroups.isEmpty()) {
            f1 = true;
        }
        if (this.sgroupInfoList != null && !this.sgroupInfoList.isEmpty()) {
            for (SgroupInfo sgroup : this.sgroupInfoList) {
                if (sgroup.getSgroupType() != 0) continue;
                f2 = true;
                break;
            }
        }
        return f1 && f2;
    }

    private void reprocessMolAtomsOfSgroup(Object object) {
        Segment segment = null;
        if (!(object instanceof Segment)) {
            SgroupInfo superSgroup;
            if (object instanceof MolAtom && (superSgroup = this.objectManager.getSupSgroupByMolAtom((MolAtom)object)) != null) {
                this.collectAllMolAtomsOfSupSgroup(superSgroup);
            }
            return;
        }
        segment = (Segment)object;
        List<SgroupInfo> sgroups = segment.getSgroupInfoList();
        if (this.isNeedFinalCollection(sgroups)) {
            sgroups = this.sgroupInfoList;
        }
        if (sgroups != null && !sgroups.isEmpty()) {
            block4: for (SgroupInfo sgroupInfo : sgroups) {
                int type = sgroupInfo.getSgroupType();
                switch (type) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.collectAllMolAtomsOfSgroup(sgroupInfo);
                        continue block4;
                    }
                    case 0: {
                        this.collectAllMolAtomsOfSupSgroup(sgroupInfo);
                        continue block4;
                    }
                }
            }
        }
    }

    private void collectAllMolAtomsOfSupSgroup(SgroupInfo sgroupInfo) {
        List<MolAtom> molAtomList = sgroupInfo.getMolAtoms();
        if (molAtomList != null && !molAtomList.isEmpty()) {
            for (int i = 0; i < molAtomList.size(); ++i) {
                List<MolBondInfo> bonds;
                MolAtom ma = molAtomList.get(i);
                if (ma == null || (bonds = this.getSupSgroupMolBondInfoesByMolAtom(ma, sgroupInfo)) == null) continue;
                for (int j = 0; j < bonds.size(); ++j) {
                    MolBondInfo mb = bonds.get(j);
                    if (sgroupInfo.getMolBondInfoes().contains(mb)) continue;
                    MolAtom a1 = this.molAtoms.get(mb.getAtom1Number());
                    MolAtom a2 = this.molAtoms.get(mb.getAtom2Number());
                    if (a1 == ma) {
                        this.findMolAtomsOfSupSgroup(a2, sgroupInfo);
                        continue;
                    }
                    this.findMolAtomsOfSupSgroup(a1, sgroupInfo);
                }
            }
        }
    }

    private List<MolBondInfo> getSupSgroupMolBondInfoesByMolAtom(MolAtom molAtom, SgroupInfo sgroupInfo) {
        ArrayList<MolBondInfo> bonds = new ArrayList<MolBondInfo>();
        ArrayList<MolBondInfo> molMondInfoList = new ArrayList<MolBondInfo>();
        ArrayList<MolAtom> molAtomList = new ArrayList<MolAtom>();
        for (Object object : this.currentObjectList) {
            if (object instanceof MolBondInfo) {
                molMondInfoList.add((MolBondInfo)object);
                continue;
            }
            if (!(object instanceof MolAtom)) continue;
            molAtomList.add((MolAtom)object);
        }
        for (MolBondInfo molBondInfo : molMondInfoList) {
            if (!this.isSupSgroupMolBond(molAtomList, molAtom, molBondInfo)) continue;
            bonds.add(molBondInfo);
        }
        return bonds;
    }

    private boolean isSupSgroupMolBond(List<MolAtom> molAtomsOfSupSgroup, MolAtom molAtom, MolBondInfo molBondInfo) {
        boolean flag = false;
        MolAtom ma1 = this.molAtoms.get(molBondInfo.getAtom1Number());
        MolAtom ma2 = this.molAtoms.get(molBondInfo.getAtom2Number());
        if (ma1 != null && ma2 != null && molAtomsOfSupSgroup.contains(ma1) && molAtomsOfSupSgroup.contains(ma2) && (ma1 == molAtom || ma2 == molAtom)) {
            return true;
        }
        return flag;
    }

    private void findMolAtomsOfSupSgroup(MolAtom currentAtom, SgroupInfo sgroupInfo) {
        if (!sgroupInfo.getMolAtoms().contains(currentAtom)) {
            sgroupInfo.addMolAtomToSgroup(currentAtom);
            List<MolBondInfo> bonds = this.getSupSgroupMolBondInfoesByMolAtom(currentAtom, sgroupInfo);
            if (bonds != null && !bonds.isEmpty()) {
                for (int i = 0; i < bonds.size(); ++i) {
                    MolBondInfo mb = bonds.get(i);
                    if (sgroupInfo.getMolBondInfoes().contains(mb)) continue;
                    MolAtom a1 = this.molAtoms.get(mb.getAtom1Number());
                    MolAtom a2 = this.molAtoms.get(mb.getAtom2Number());
                    if (a1 == currentAtom) {
                        this.findMolAtomsOfSupSgroup(a2, sgroupInfo);
                        continue;
                    }
                    this.findMolAtomsOfSupSgroup(a1, sgroupInfo);
                }
            }
        }
    }

    private void collectAllMolAtomsOfSgroup(SgroupInfo sgroupInfo) {
        ArrayList<MolAtom> allSgroupAtomsList = new ArrayList<MolAtom>();
        List<MolBondInfo> crossBondList = sgroupInfo.getMolBondInfoes();
        if (crossBondList == null) {
            return;
        }
        ArrayList<MolBondInfo> mbList = new ArrayList<MolBondInfo>();
        for (int i = 0; i < crossBondList.size(); ++i) {
            mbList.add(crossBondList.get(i));
        }
        List<MolAtom> molAtoms = sgroupInfo.getMolAtoms();
        for (MolAtom molAtom : molAtoms) {
            this.findAllMolAtomsOfSgroupInfo(mbList, allSgroupAtomsList, molAtom);
        }
        if (!allSgroupAtomsList.isEmpty()) {
            sgroupInfo.addMolAtomsToSgroup(allSgroupAtomsList);
        }
    }

    private void findAllMolAtomsOfSgroupInfo(List<MolBondInfo> crossBondList, List<MolAtom> allSgroupAtomsList, MolAtom baseMolAtom) {
        if (!allSgroupAtomsList.contains(baseMolAtom)) {
            allSgroupAtomsList.add(baseMolAtom);
        }
        List<MolBondInfo> molBonds = this.getMolBondInfoListByMolAtom(baseMolAtom);
        for (int i = 0; i < molBonds.size(); ++i) {
            MolBondInfo mb = molBonds.get(i);
            if (mb == null || crossBondList.contains(mb)) continue;
            crossBondList.add(mb);
            MolAtom anotherAtom = this.getOtherMolAtom(mb, baseMolAtom);
            if (allSgroupAtomsList.contains(anotherAtom)) continue;
            allSgroupAtomsList.add(anotherAtom);
            this.findAllMolAtomsOfSgroupInfo(crossBondList, allSgroupAtomsList, anotherAtom);
        }
    }

    private MolAtom getOtherMolAtom(MolBondInfo mb, MolAtom currentMolAtom) {
        int maIndex = this.molAtoms.indexOf(currentMolAtom);
        int mbIndex1 = mb.getAtom1Number();
        int mbIndex2 = mb.getAtom2Number();
        if (mbIndex1 == maIndex) {
            return this.molAtoms.get(mbIndex2);
        }
        return this.molAtoms.get(mbIndex1);
    }

    private List<MolBondInfo> getMolBondInfoListByMolAtom(MolAtom molAtom) {
        ArrayList<MolBondInfo> molBondInfoList = new ArrayList<MolBondInfo>();
        int maIndex = this.molAtoms.indexOf(molAtom);
        if (maIndex == -1) {
            return molBondInfoList;
        }
        for (int i = 0; i < this.molBondxes.size(); ++i) {
            MolBondInfo mb = this.molBondxes.get(i);
            if (mb.getAtom1Number() != maIndex && mb.getAtom2Number() != maIndex) continue;
            molBondInfoList.add(mb);
        }
        return molBondInfoList;
    }

    private void processCurrentSectionData(Object object) {
        this.reprocessCurrentMapingData();
        this.reprocessMolAtomsOfSgroup(object);
        this.processSpecialSuperSgroup(object);
    }

    private void processSpecialSuperSgroup(Object object) {
        if (object instanceof Segment) {
            Segment segment = (Segment)object;
            List<MolAtom> molAtomsList = segment.getMolAtoms();
            for (int i = molAtomsList.size() - 1; i >= 0; --i) {
                SgroupInfo ssg;
                MolAtom specialAtom = molAtomsList.get(i);
                if (!this.isSuperatomSgroupNeedToProcess(specialAtom) || (ssg = this.objectManager.getSupSgroupByMolAtom(specialAtom)) == null) continue;
                List abbrevAttachBondList = (List)this.objectManager.getValueByKey(specialAtom, "skc_need_process_atom_abbrev_attach");
                if (abbrevAttachBondList == null || abbrevAttachBondList.isEmpty()) {
                    this.molAtomMap.put(specialAtom, ssg.getMolAtoms().get(0));
                    this.molAtoms.set(this.molAtoms.indexOf(specialAtom), null);
                    continue;
                }
                List<MolBondInfo> sgroupMolBondxes = ssg.getMolBondInfoes();
                List sgroupBondAttachList = (List)ssg.getPropertyFromCarrier("skc_need_process_sgroup_bond_attach");
                List sgroupAtomAtachList = (List)ssg.getPropertyFromCarrier("skc_need_process_sgroup_atom_attach");
                List<MolAtom> sgroupMolAtoms = ssg.getMolAtoms();
                for (int j = sgroupAtomAtachList.size() - 1; j >= 0; --j) {
                    int oi;
                    MolBondInfo coreBond;
                    MolAtom coreAtom = (MolAtom)sgroupAtomAtachList.get(j);
                    MolBondInfo tempCoreBond = (MolBondInfo)sgroupBondAttachList.get(j);
                    MolBondInfo molBondInfo = coreBond = j < abbrevAttachBondList.size() ? (MolBondInfo)abbrevAttachBondList.get(j) : null;
                    if (coreBond == null || tempCoreBond == null) continue;
                    int indexOfSpecialAtom = this.molAtoms.indexOf(specialAtom);
                    int indexOfCoreAtom = this.molAtoms.indexOf(coreAtom);
                    int bi1 = coreBond.getAtom1Number();
                    int bi2 = coreBond.getAtom2Number();
                    if (bi1 == indexOfSpecialAtom) {
                        coreBond.setAtom1Number(indexOfCoreAtom);
                    } else if (bi2 == indexOfSpecialAtom) {
                        coreBond.setAtom2Number(indexOfCoreAtom);
                    }
                    int bondxIndexValue = sgroupMolBondxes.indexOf(tempCoreBond);
                    if (bondxIndexValue != -1) {
                        sgroupMolBondxes.set(bondxIndexValue, coreBond);
                    }
                    if ((oi = sgroupMolAtoms.indexOf(specialAtom)) != -1) {
                        sgroupMolAtoms.set(oi, coreAtom);
                    }
                    MolAtom tempMolAtom = null;
                    int estIndex1 = tempCoreBond.getAtom1Number();
                    int estIndex2 = tempCoreBond.getAtom2Number();
                    if (estIndex1 != indexOfCoreAtom && estIndex2 == indexOfCoreAtom) {
                        tempMolAtom = this.molAtoms.get(estIndex1);
                    }
                    if (estIndex1 == indexOfCoreAtom && estIndex2 != indexOfCoreAtom) {
                        tempMolAtom = this.molAtoms.get(estIndex2);
                    }
                    if (tempMolAtom != null) {
                        this.molAtoms.set(this.molAtoms.indexOf(tempMolAtom), null);
                    }
                    if (sgroupMolAtoms.indexOf(specialAtom) != -1) {
                        sgroupMolAtoms.set(sgroupMolAtoms.indexOf(specialAtom), coreAtom);
                    }
                    sgroupMolAtoms.remove(tempMolAtom);
                    this.molBondxes.remove(tempCoreBond);
                }
                this.molAtoms.set(this.molAtoms.indexOf(specialAtom), null);
            }
        }
    }

    private boolean isSuperatomSgroupNeedToProcess(MolAtom molAtom) {
        int typeNumber;
        boolean flag = false;
        Object object = this.objectManager.getValueByKey(molAtom, "molatom_type_number_key");
        if (object != null && (typeNumber = ((Integer)object).intValue()) == 272) {
            flag = true;
        }
        return flag;
    }

    protected final void parseRgroup() {
        int propertyVal = this.parseByteTypeData();
        if (this.currentObjectType == 17) {
            ((RgroupInfo)this.currentObject).setRgroupId(propertyVal);
        }
    }

    private void parseRgroupLogic() {
        int num = this.parseByteTypeData();
        block0: for (int i = 0; i < num; ++i) {
            int rgroupNumber = this.parseByteTypeData();
            String occurence = this.parseStringData();
            int restH = this.parseByteTypeData();
            int ifThenRgroupNumber = this.parseByteTypeData();
            String thenRstr = String.valueOf(ifThenRgroupNumber);
            String restHstr = String.valueOf(restH);
            String range = occurence;
            if (!this.rgroupxes.isEmpty()) {
                for (RgroupInfo rgroupInfo : this.rgroupxes) {
                    if (rgroupNumber != rgroupInfo.getRgroupId()) continue;
                    rgroupInfo.setThenRstr(thenRstr);
                    rgroupInfo.setRestHstr(restHstr);
                    rgroupInfo.setRange(range);
                    continue block0;
                }
                continue;
            }
            RgroupInfo rgroupInfo = new RgroupInfo();
            rgroupInfo.setRgroupId(rgroupNumber);
            rgroupInfo.setThenRstr(thenRstr);
            rgroupInfo.setRestHstr(restHstr);
            rgroupInfo.setRange(range);
            this.orderRgroupInfoList.add(rgroupInfo);
        }
    }

    private boolean isExist(Map<MolAtom, ComponentHelp> atomMap, MolAtom molAtom) {
        for (ComponentHelp c : atomMap.values()) {
            if (!c.contains(molAtom)) continue;
            return true;
        }
        return false;
    }

    private void separateSameComponentAtom(ComponentHelp component, MolAtom molAtom) {
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        for (int i = 0; i < molAtom.getBondCount(); ++i) {
            bonds.add(molAtom.getBond(i));
        }
        for (MolBondInfo molBondInfo : this.molBondxes) {
            MolBond molBond = molBondInfo.getMolBondByMolAtoms(this.molAtoms);
            if (!molBond.getAtom1().equals(molAtom) && !molBond.getAtom2().equals(molAtom)) continue;
            bonds.add(molBond);
        }
        int bondCount = bonds.size();
        for (int i = 0; i < bondCount; ++i) {
            MolBond bond = (MolBond)bonds.get(i);
            for (int j = 0; j < 2; ++j) {
                MolAtom tempAtom = null;
                tempAtom = j == 0 ? bond.getAtom1() : bond.getAtom2();
                if (tempAtom == null || component.contains(tempAtom)) continue;
                component.addAtom(tempAtom);
                if (tempAtom == molAtom) continue;
                this.separateSameComponentAtom(component, tempAtom);
            }
        }
    }

    private void setValence(int valence, MolAtom molAtom) {
        if (valence != 0) {
            if (valence == 15) {
                valence = 0;
            }
            molAtom.setValenceProp(valence);
        }
    }

    private void setAtomAtomMappingNumber(int mapNo, MolAtom molAtom) {
        if (mapNo != 0) {
            molAtom.setAtomMap(mapNo);
        }
    }

    private void setRlogic(RgMolecule m, int r1, String thenRstr, String restHstr, String range) {
        r1 &= Short.MAX_VALUE;
        int r2 = -1;
        if (thenRstr != null) {
            try {
                r2 = Integer.parseInt(thenRstr);
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("invalid thenR value");
            }
        }
        int restH = 0;
        if (restHstr != null && (restHstr.equalsIgnoreCase("on") || restHstr.equals("1") || restHstr.equalsIgnoreCase("true"))) {
            restH = Integer.MIN_VALUE;
        }
        int f = r1 | restH;
        if (r2 >= 0) {
            f |= 0x8000 | (r2 & Short.MAX_VALUE) << 16;
        }
        int i = m.findRgroupIndex(r1);
        m.setRlogic(i, f);
        if (range != null) {
            m.setRlogicRange(i, range);
        }
    }

    private void processReactionLine(RxnMolecule rxn, ReactionArrowInfo raw) {
        int ad = raw.getArrowDir();
        int as = raw.getArrowStyle();
        if (ad == 1) {
            if (as == 17 || as == 15 || as == 16 || raw.getArrowShaftSpace() != 0.0) {
                rxn.setReactionArrowType(2);
            } else {
                rxn.setReactionArrowType(0);
            }
        } else if (ad == 2) {
            DPoint3 p1 = raw.getReactionArrowStartPoint();
            DPoint3 p2 = raw.getReactionArrowEndPoint();
            rxn.setReactionArrow(new DPoint3[]{p2, p1});
            if (as == 17 || as == 15 || as == 16 || raw.getArrowShaftSpace() != 0.0) {
                rxn.setReactionArrowType(2);
            } else {
                rxn.setReactionArrowType(0);
            }
        } else if (ad == 3) {
            rxn.setReactionArrowType(1);
        } else if (ad == 4 || ad == 5) {
            rxn.setReactionArrowType(3);
        }
    }

    private void processBondThicknessAndColor(MDocument document, Molecule cmol) {
        ArrayList<MolBondInfo> unprocessedBonds = new ArrayList<MolBondInfo>(this.molBondxes);
        int bondSetCount = 0;
        while (unprocessedBonds.size() > 0) {
            MolBond molBond;
            MolBondInfo molBondInfo = (MolBondInfo)unprocessedBonds.remove(0);
            if (molBondInfo == null || (molBond = molBondInfo.getMolBondByMolAtoms(this.molAtoms)) == null) continue;
            this.processCrossingBond(cmol, molBondInfo, molBond);
            if (bondSetCount == 63) continue;
            boolean isSet = this.setBondFormat(molBond, molBondInfo, document, bondSetCount + 1);
            if (isSet) {
                ++bondSetCount;
            }
            for (int j = unprocessedBonds.size() - 1; j >= 0; --j) {
                MolBondInfo comparedBondInfo = (MolBondInfo)unprocessedBonds.get(j);
                MolBond comparedBond = comparedBondInfo.getMolBondByMolAtoms(this.molAtoms);
                if (comparedBondInfo == null || !this.isSameFormat(molBondInfo, comparedBondInfo)) continue;
                unprocessedBonds.remove(j);
                this.processCrossingBond(cmol, comparedBondInfo, comparedBond);
                if (!isSet) continue;
                comparedBond.setSetSeq(bondSetCount);
            }
        }
    }

    private boolean setBondFormat(MolBond molBond, MolBondInfo molBondInfo, MDocument document, int bondSetIndex) {
        double bondThickness = molBondInfo.getThicknuess();
        Color color = molBondInfo.getColor();
        boolean formatSet = false;
        if (bondThickness != 0.0) {
            molBond.setSetSeq(bondSetIndex);
            document.setBondSetThickness(bondSetIndex, bondThickness);
            formatSet = true;
        }
        if (color != null) {
            if (!formatSet) {
                molBond.setSetSeq(bondSetIndex);
            }
            document.setBondSetRGB(bondSetIndex, color.getRGB());
            formatSet = true;
        } else if (formatSet) {
            document.setBondSetColorMode(bondSetIndex, 2);
        }
        return formatSet;
    }

    private void processCrossingBond(Molecule cmol, MolBondInfo molBondInfo, MolBond molBond) {
        MoleculeGraph moleculegraph;
        int bondIndex;
        if (molBondInfo.isBondCrossed() && (bondIndex = (moleculegraph = cmol.getGraphUnion()).indexOf(molBond)) > 0) {
            MoleculeUtil.arrangeCrossingBonds(molBond, cmol, false);
        }
    }

    private boolean isSameFormat(MolBondInfo bond1, MolBondInfo bond2) {
        boolean flag = false;
        if (bond1 != null && bond2 != null && bond1.getThicknuess() == bond2.getThicknuess()) {
            if (bond1.getColor() != null && bond2.getColor() != null) {
                if (bond1.getColor().equals(bond2.getColor())) {
                    flag = true;
                }
            } else if (bond1.getColor() == null && bond2.getColor() == null) {
                flag = true;
            }
        }
        return flag;
    }

    private void processFormatForAtomAndSupergroup(MDocument document) {
        if (this.molAtoms == null) {
            return;
        }
        ArrayList<MolAtom> unprocessedAtoms = new ArrayList<MolAtom>();
        unprocessedAtoms.addAll(this.molAtoms);
        int atomSetCount = 0;
        while (unprocessedAtoms.size() > 0 && atomSetCount < 63) {
            MolAtom actAtom = (MolAtom)unprocessedAtoms.remove(0);
            boolean isSet = this.setAtomFormat(actAtom, document, atomSetCount + 1);
            if (isSet) {
                ++atomSetCount;
            }
            for (int j = unprocessedAtoms.size() - 1; j >= 0; --j) {
                MolAtom comparedAtom = (MolAtom)unprocessedAtoms.get(j);
                if (comparedAtom == null || !this.isSameFormat(actAtom, comparedAtom)) continue;
                unprocessedAtoms.remove(j);
                if (!isSet) continue;
                comparedAtom.setSetSeq(atomSetCount);
            }
        }
    }

    private boolean setAtomFormat(MolAtom atom, MDocument document, int atomSetIndex) {
        Color color;
        boolean formatSet = false;
        String type = "Arial";
        String storedType = (String)this.objectManager.getValueByKey(atom, "atom_font");
        if (storedType != null) {
            type = storedType;
            formatSet = true;
        }
        int style = 0;
        Integer storedStyle = (Integer)this.objectManager.getValueByKey(atom, "atom_style");
        if (storedStyle != null) {
            style = storedStyle;
            formatSet = true;
        }
        int size = 12;
        Integer storedSize = (Integer)this.objectManager.getValueByKey(atom, "atom_size");
        if (storedSize != null) {
            size = storedSize / 10;
            formatSet = true;
        }
        if (formatSet) {
            atom.setSetSeq(atomSetIndex);
            MFont mFont = new MFont(type, style, size);
            document.setAtomSetFont(atomSetIndex, mFont);
        }
        if ((color = (Color)this.objectManager.getValueByKey(atom, "atom_color")) != null) {
            if (!formatSet) {
                atom.setSetSeq(atomSetIndex);
            }
            formatSet = true;
            document.setAtomSetRGB(atomSetIndex, color.getRGB());
        } else if (formatSet) {
            document.setAtomSetColorMode(atomSetIndex, 2);
        }
        return formatSet;
    }

    private boolean isSameFormat(MolAtom molAtom1, MolAtom molAtom2) {
        return molAtom1 != null && molAtom2 != null && this.checkMolAtomColor(molAtom1, molAtom2) && this.checkMolAtomFont(molAtom1, molAtom2) && this.checkMolAtomStyle(molAtom1, molAtom2) && this.checkMolAtomSize(molAtom1, molAtom2);
    }

    private boolean checkMolAtomSize(MolAtom molAtom1, MolAtom molAtom2) {
        Integer size1 = (Integer)this.objectManager.getValueByKey(molAtom1, "atom_size");
        Integer size2 = (Integer)this.objectManager.getValueByKey(molAtom2, "atom_size");
        return size1 != null && size1.equals(size2) || size1 == null && size2 == null;
    }

    private boolean checkMolAtomStyle(MolAtom molAtom1, MolAtom molAtom2) {
        Integer style1 = (Integer)this.objectManager.getValueByKey(molAtom1, "atom_style");
        Integer style2 = (Integer)this.objectManager.getValueByKey(molAtom2, "atom_style");
        return style1 != null && style1.equals(style2) || style1 == null && style2 == null;
    }

    private boolean checkMolAtomFont(MolAtom molAtom1, MolAtom molAtom2) {
        String font1 = (String)this.objectManager.getValueByKey(molAtom1, "atom_font");
        String font2 = (String)this.objectManager.getValueByKey(molAtom2, "atom_font");
        return font1 != null && font1.equals(font2) || font1 == null && font2 == null;
    }

    private boolean checkMolAtomColor(MolAtom molAtom1, MolAtom molAtom2) {
        Color color1 = (Color)this.objectManager.getValueByKey(molAtom1, "atom_color");
        Color color2 = (Color)this.objectManager.getValueByKey(molAtom2, "atom_color");
        return color1 != null && color1.equals(color2) || color1 == null && color2 == null;
    }

    private List<MBracket> getMrvBrackets(List<Coordinate> bracketList1, List<Coordinate> bracketList2, int bracketPenWith, int bracketStyle, Color bracketColor) {
        ArrayList<MBracket> brackets = new ArrayList<MBracket>();
        int j = 0;
        if (bracketList2 != null) {
            int bracketList2Size = bracketList2.size();
            for (int i = 0; i < bracketList2Size / 2 + bracketList2Size % 2; ++i) {
                MBracket mBracket = new MBracket();
                mBracket.setType(bracketStyle == 0 ? 1 : 0);
                mBracket.setBracketOrientation(5);
                double thickness = MolBondInfo.round((double)bracketPenWith * 0.009142857142857144, 2);
                if (thickness > 0.064) {
                    mBracket.setThickness(thickness);
                }
                mBracket.setLineColor(bracketColor);
                MPoint[] points = new MPoint[4];
                if (i != bracketList2Size / 2 + bracketList2Size % 2 - 1 || bracketList2Size % 2 == 0) {
                    points[0] = new MPoint(Coordinate.getXOfMrv(bracketList2.get(j).getX()), Coordinate.getYOfMrv(bracketList2.get(j).getY()), 0.0);
                    points[1] = new MPoint(Coordinate.getXOfMrv(bracketList1.get(j + 1).getX()), Coordinate.getYOfMrv(bracketList1.get(j + 1).getY()), 0.0);
                    points[2] = new MPoint(Coordinate.getXOfMrv(bracketList2.get(j + 1).getX()), Coordinate.getYOfMrv(bracketList2.get(j + 1).getY()), 0.0);
                    points[3] = new MPoint(Coordinate.getXOfMrv(bracketList1.get(j).getX()), Coordinate.getYOfMrv(bracketList1.get(j).getY()), 0.0);
                    j += 2;
                } else {
                    points[0] = new MPoint(Coordinate.getXOfMrv(bracketList2.get(j).getX()), Coordinate.getYOfMrv(bracketList2.get(j).getY()), 0.0);
                    points[1] = new MPoint(Coordinate.getXOfMrv(bracketList1.get(j).getX()), Coordinate.getYOfMrv(bracketList1.get(j).getY()), 0.0);
                    points[2] = new MPoint(Coordinate.getXOfMrv(bracketList1.get(j).getX()), Coordinate.getYOfMrv(bracketList1.get(j).getY()), 0.0);
                    points[3] = new MPoint(Coordinate.getXOfMrv(bracketList1.get(j).getX()), Coordinate.getYOfMrv(bracketList1.get(j).getY()), 0.0);
                }
                mBracket.setPoints(points);
                brackets.add(mBracket);
            }
        }
        return brackets;
    }

    private boolean isMPolyline(int typeNumber) {
        boolean isGenericMPolyline = false;
        switch (typeNumber) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 24: 
            case 25: {
                if (!this.mPolylineInfoMap.containsKey((MPolyline)this.currentObject)) {
                    this.mPolylineInfoMap.put((MPolyline)this.currentObject, new MPolylineInfo());
                }
                isGenericMPolyline = true;
            }
        }
        return isGenericMPolyline;
    }
}

