/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.skcimport;

import chemaxon.marvin.io.formats.skc.utils.ChemUtil;
import chemaxon.marvin.io.formats.skc.utils.Coordinate;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;

public class SkcReaderHelper {
    private int currentParseStepLength;
    private static final int PO_MINUS = -1;
    private static final int PO_VALUE = 1;
    private static final int PT_VALUE = 2;
    private static final int BASIC_BIT_VALUE = 5;
    private long position = 0L;
    private DataInputStream in;
    private int length;

    private int getWidthOrHight(int minuend) {
        int subtrahend = this.parseSingleCharacterData();
        return minuend > subtrahend ? minuend - subtrahend : subtrahend - minuend;
    }

    private boolean isMaxByteValue(int byteValue) {
        return byteValue == ChemUtil.getMinContrastValue(5, 1);
    }

    private int getAvailabelByteValue(int byteValue) {
        return byteValue == ChemUtil.getMaxContrastValue(5) ? -1 : byteValue;
    }

    private int getDataTypeValue() {
        int byteValue = this.parseByteTypeData();
        if (this.isMaxByteValue(byteValue)) {
            byteValue = ChemUtil.getMinContrastValue(5, 2) + this.parseByteTypeData();
        }
        return this.getAvailabelByteValue(byteValue);
    }

    protected final int parseTypeOfData() {
        int typeValue = this.getDataTypeValue();
        this.parseTotalLengthOfData();
        return typeValue;
    }

    protected final int parseByteTypeData() {
        return this.parseDigitalData(1);
    }

    private int parseTotalLengthOfData() {
        this.currentParseStepLength = this.parseSingleCharacterData() - 2;
        return this.currentParseStepLength;
    }

    protected final int parseSingleCharacterData() {
        return this.parseDigitalData(2);
    }

    protected final void setParsePoint(long length) {
        this.setPosition(length);
    }

    protected final long getParsePoint() {
        return this.getPosition();
    }

    private int parseDigitalData(int type) {
        switch (type) {
            case 1: {
                return this.read();
            }
            case 2: {
                return this.readInt16();
            }
        }
        return 0;
    }

    protected final String parseCommentData(int skipLenth) {
        String str = null;
        int baseLen = this.parseByteTypeData();
        if (skipLenth > baseLen) {
            str = this.parseBasicData(baseLen);
        } else {
            str = this.parseBasicData(skipLenth + -1);
            this.parseSkip(baseLen - skipLenth);
        }
        return str;
    }

    protected final void parseSkip(int step) {
        if (step > 0) {
            this.seek(step);
        }
    }

    protected final boolean isParseFileEnd() {
        return this.getPosition() >= (long)this.getLength();
    }

    protected final Color parseColorData() {
        return new Color(this.parseByteTypeData(), this.parseByteTypeData(), this.parseByteTypeData());
    }

    protected final Color parseBracketColor() {
        Color empty = Color.black;
        empty = new Color(this.parseByteTypeData(), this.parseByteTypeData(), this.parseByteTypeData());
        this.parseByteTypeData();
        return empty;
    }

    protected final String parseStringData() {
        return this.parseBasicData(this.parseByteTypeData());
    }

    protected final void skipSomeDataForParsing() {
        this.parseSkip(this.currentParseStepLength);
    }

    protected final int prase16HData() {
        return this.parseSingleCharacterData();
    }

    protected final int parseLongTypeData() {
        return this.readInt32();
    }

    protected final double praseFloatTypeData() {
        return this.readSingle();
    }

    protected final Coordinate parseCoordinateData() {
        return new Coordinate(this.praseFloatTypeData(), this.praseFloatTypeData());
    }

    protected final Coordinate[] getGraphicsPoint3dsArray() {
        this.parseByteTypeData();
        this.parseByteTypeData();
        int size = this.parseByteTypeData();
        this.parseByteTypeData();
        Coordinate[] pointdArray = new Coordinate[size];
        for (int i = 0; i < size; ++i) {
            pointdArray[i] = new Coordinate(this.parseCoordinateTypeData());
        }
        return pointdArray;
    }

    protected final Coordinate parseCoordinateTypeData() {
        return new Coordinate(this.parseSingleCharacterData(), this.parseSingleCharacterData());
    }

    protected final byte[] parseByteArrayData(int length) {
        byte[] array = new byte[length];
        this.read(array, 0, length);
        return array;
    }

    private String parseBasicData(int length) {
        byte[] b = new byte[length];
        this.read(b, 0, length);
        return new String(b);
    }

    protected final Rectangle parseRectangleData() {
        int x = this.parseSingleCharacterData();
        int y = this.parseSingleCharacterData();
        return new Rectangle(x, y, this.getWidthOrHight(x), this.getWidthOrHight(y));
    }

    protected final void parseInitialization(DataInputStream dataInputStream) {
        this.in = dataInputStream;
    }

    private int read() {
        ++this.position;
        int ret = 0;
        try {
            ret = this.in.read();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read the file.\n" + e.getMessage());
        }
        return ret;
    }

    private int getLength() {
        if (this.length == 0) {
            try {
                this.length = this.in.available();
            }
            catch (IOException e) {
                throw new RuntimeException("Can't read the file.\n" + e.getMessage());
            }
        }
        return this.length;
    }

    private void read(byte[] b, int off, int len) {
        try {
            this.position += (long)len;
            this.in.read(b, off, len);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private long getPosition() {
        return this.position;
    }

    private int readInt16() {
        int b1 = this.read();
        int b2 = this.read();
        int integer = b2 << 8 | b1;
        return integer;
    }

    private void seek(int size) {
        try {
            this.position += (long)size;
            this.in.skipBytes(size);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private double readSingle() {
        return Float.intBitsToFloat(this.readInt32());
    }

    private void setPosition(long l) {
        this.position = l;
    }

    private int readInt32() {
        int i = 0;
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        int ch4 = this.read();
        i = ch1 | ch2 << 8 | ch3 << 16 | ch4 << 24;
        return i;
    }
}

