/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils;

import chemaxon.marvin.io.formats.skc.utils.MolBondInfo;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRectangle;
import java.awt.Color;

public class MPolylineInfo {
    private double arrowLength = 0.0;
    private double arrowWidth = 0.0;
    private int arrowDir = 0;
    private int arrowStyle = 0;
    private Color penColor = null;
    private Color fillColor = null;
    private double thickness = 0.0;

    public void setArrowLength(double arrowLength) {
        this.arrowLength = arrowLength;
    }

    public void setArrowWidth(double arrowWidth) {
        this.arrowWidth = arrowWidth;
    }

    public void setArrowDir(int arrowDir) {
        this.arrowDir = arrowDir;
    }

    public void setArrowStyle(int arrowStyle) {
        this.arrowStyle = arrowStyle;
    }

    public void setPenColor(Color penColor) {
        this.penColor = penColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public void handleGraphicsGenericLines(MPolyline mPolyline) {
        double arrowLength = this.arrowLength / 12.5;
        double arrowWidth = this.arrowWidth / 10.0;
        int arrowDir = this.arrowDir;
        int arrowStyle = this.arrowStyle;
        if (arrowDir == 0) {
            mPolyline.setArrowFlags(MPolyline.HEAD, MPolyline.ARROW_HALF_MASK);
        } else if (arrowDir == 1) {
            if (arrowStyle >= 1 && arrowStyle <= 5 || arrowStyle >= 15 && arrowStyle <= 17) {
                mPolyline.setArrowWidth(MPolyline.HEAD, arrowWidth);
                mPolyline.setArrowLength(MPolyline.HEAD, arrowLength);
            }
            if (arrowStyle >= 10 && arrowStyle <= 14) {
                mPolyline.setArrowWidth(MPolyline.HEAD, arrowWidth);
                mPolyline.setArrowLength(MPolyline.HEAD, arrowLength);
                mPolyline.setArrowFlags(MPolyline.HEAD, MPolyline.ARROW_HALF_LEFT);
            }
        } else if (arrowDir == 2) {
            if (arrowStyle >= 1 && arrowStyle <= 5 || arrowStyle >= 15 && arrowStyle <= 17) {
                mPolyline.setArrowWidth(MPolyline.TAIL, arrowWidth);
                mPolyline.setArrowLength(MPolyline.TAIL, arrowLength);
                mPolyline.setArrowFlags(MPolyline.TAIL, MPolyline.ARROW_BACK_FLAG);
            }
            if (arrowStyle >= 10 && arrowStyle <= 14) {
                mPolyline.setArrowWidth(MPolyline.TAIL, arrowWidth);
                mPolyline.setArrowLength(MPolyline.TAIL, arrowLength);
                mPolyline.setArrowFlags(MPolyline.TAIL, 5);
            }
        } else if (arrowDir == 3) {
            if (arrowStyle >= 1 && arrowStyle <= 5 || arrowStyle >= 15 && arrowStyle <= 17) {
                mPolyline.setArrowWidth(MPolyline.HEAD, arrowWidth);
                mPolyline.setArrowLength(MPolyline.HEAD, arrowLength);
                mPolyline.setArrowWidth(MPolyline.TAIL, arrowWidth);
                mPolyline.setArrowLength(MPolyline.TAIL, arrowLength);
                mPolyline.setArrowFlags(MPolyline.TAIL, MPolyline.ARROW_BACK_FLAG);
            }
            if (arrowStyle >= 10 && arrowStyle <= 14) {
                mPolyline.setArrowWidth(MPolyline.HEAD, arrowWidth);
                mPolyline.setArrowLength(MPolyline.HEAD, arrowLength);
                mPolyline.setArrowWidth(MPolyline.TAIL, arrowWidth);
                mPolyline.setArrowLength(MPolyline.TAIL, arrowLength);
                mPolyline.setArrowFlags(MPolyline.HEAD, MPolyline.ARROW_HALF_LEFT);
                mPolyline.setArrowFlags(MPolyline.TAIL, 5);
            }
        } else if (arrowDir == 4 || arrowDir == 5) {
            if (arrowStyle >= 1 && arrowStyle <= 5) {
                mPolyline.setArrowWidth(MPolyline.HEAD, arrowWidth);
                mPolyline.setArrowLength(MPolyline.HEAD, arrowLength);
                mPolyline.setArrowWidth(MPolyline.TAIL, arrowWidth);
                mPolyline.setArrowLength(MPolyline.TAIL, arrowLength);
                mPolyline.setArrowFlags(MPolyline.TAIL, MPolyline.ARROW_BACK_FLAG);
            } else if (arrowStyle >= 10 && arrowStyle <= 14) {
                mPolyline.setArrowWidth(MPolyline.HEAD, arrowWidth);
                mPolyline.setArrowLength(MPolyline.HEAD, arrowLength);
                mPolyline.setArrowWidth(MPolyline.TAIL, arrowWidth);
                mPolyline.setArrowLength(MPolyline.TAIL, arrowLength);
                mPolyline.setArrowFlags(MPolyline.HEAD, MPolyline.ARROW_HALF_LEFT);
                mPolyline.setArrowFlags(MPolyline.TAIL, 5);
            }
        }
        if (this.fillColor != null && mPolyline instanceof MRectangle) {
            ((MRectangle)mPolyline).setLineColor(this.penColor);
            ((MRectangle)mPolyline).setBackground(this.fillColor);
        } else {
            mPolyline.setColor(this.penColor);
        }
        double thickness = MolBondInfo.round(this.thickness * 0.009142857142857144, 2);
        if (thickness > 0.064) {
            mPolyline.setThickness(thickness);
        }
    }
}

