/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils;

import chemaxon.marvin.io.formats.skc.utils.text.TextStyleMark;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MTextAttributes;
import chemaxon.struc.graphics.MTextBox;
import java.awt.Color;
import java.awt.Font;

public class MTextBoxInfo {
    private Color color = null;
    private TextStyleMark textStyleMark = null;

    public void setColor(Color color) {
        this.color = color;
    }

    public void setStyleAndStateInfo(TextStyleMark textStyleMark) {
        this.textStyleMark = textStyleMark;
    }

    public MTextAttributes handleTextBox(MTextBox mTextBox) {
        int setbits = 0;
        double dy = 0.0;
        double scale = 1.0;
        int style = 0;
        if (this.textStyleMark == null) {
            return null;
        }
        if (this.textStyleMark.isBold()) {
            setbits = 32;
            style = 1;
        }
        if (this.textStyleMark.isUnderLine()) {
            // empty if block
        }
        if (this.textStyleMark.isSublevelScale() || this.textStyleMark.isSublevelAdy()) {
            ++setbits;
            setbits += 128;
            setbits += 512;
        }
        if (this.textStyleMark.getTextFont() != null) {
            setbits += 4;
        }
        if (this.textStyleMark.getFontSizeValue() != -1) {
            setbits += 16;
        }
        if (this.textStyleMark.isItalic()) {
            setbits += 64;
            style |= 2;
        }
        int subl = 0;
        if (this.textStyleMark.isSublevelScale()) {
            subl = -1;
            dy = -0.4;
            scale = 0.7;
        }
        if (this.textStyleMark.isSublevelAdy()) {
            subl = 1;
            dy = 0.6f;
            scale = 0.7;
        }
        String fontName = this.textStyleMark.getTextFont().getFontName();
        while (fontName.endsWith(";")) {
            fontName = this.textStyleMark.getTextFont().getFontName().substring(0, fontName.length() - 1);
        }
        Font font = new Font(fontName, style, this.textStyleMark.getFontSizeValue() / 2);
        MFont mFont = new MFont(font);
        MTextAttributes attributes = new MTextAttributes(setbits, subl, this.color, mFont, scale, 0.0, dy);
        return attributes;
    }
}

