/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

public class MolBondInfo
extends MolBond {
    private static final long serialVersionUID = -2639220247814554297L;
    private static final int DOUBLE_CIS_OR_TRANS_MASK = 192;
    private static final int SINGLE_UP = 1;
    private static final int DOUBLE_CIS_OR_TRANS = 3;
    private static final int SINGLE_UP_OR_DOWN = 4;
    private static final int SINGLE_DOWN = 6;
    private static final int ORDER_8 = 8;
    private static final int TOPOLOGY_RING = 1;
    private static final int TOPOLOGY_CHAIN = 2;
    private static final int REACTION_CHANGE = 8;
    private static final int REACTION_NOT_CENTER = -1;
    private static final int REACTION_CENTER = 1;
    private static final int REACTION_MAKE_OR_BREAK = 4;
    private static final int REACTION_MAKE_AND_CHANGE = 12;
    private int atom1Number = -1;
    private int atom2Number = -1;
    private MolBond molBond = null;
    private double thicknuess = 0.0;
    private boolean isBondCrossed = false;
    private int rxnCenter = 0;
    private int qtopo = 0;
    private int stereoType = 0;
    private int type = Integer.MAX_VALUE;
    private boolean stereoCare = false;
    private Color color = null;
    private MolBond molBondInMolecule = null;
    public static final double MRV_BASE_THICKNESS = 0.064;
    private boolean stereoBoldBondFlag = false;

    public void setStereoBoldBondFlag(boolean stereoBondFlag) {
        this.stereoBoldBondFlag = stereoBondFlag;
    }

    private MolBondInfo(MolBond molBond) {
        super(molBond);
        this.molBond = molBond;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    public void setRxnCenter(int rxnCenter) {
        this.rxnCenter = rxnCenter;
    }

    public void setQtopo(int qtopo) {
        this.qtopo = qtopo;
    }

    public void setStereoType(int stereoType) {
        this.stereoType = stereoType;
    }

    public void setStereoCare(boolean stereoCare) {
        this.stereoCare = stereoCare;
    }

    public int getAtom1Number() {
        return this.atom1Number;
    }

    public void setAtom1Number(int atom1Number) {
        this.atom1Number = atom1Number;
    }

    public int getAtom2Number() {
        return this.atom2Number;
    }

    public void setAtom2Number(int atom2Number) {
        this.atom2Number = atom2Number;
    }

    public MolBond getMolBond() {
        return this.molBond;
    }

    public void setMolBond(MolBond molBond) {
        this.molBond = molBond;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getThicknuess() {
        return this.thicknuess;
    }

    public void setThicknuess(double thicknuess) {
        this.thicknuess = thicknuess;
    }

    public boolean isBondCrossed() {
        return this.isBondCrossed;
    }

    public void setBondCrossed(boolean isBondCrossed) {
        this.isBondCrossed = isBondCrossed;
    }

    public MolBond getMolBondInMolecule() {
        return this.molBondInMolecule;
    }

    public MolBond getMolBondByMolAtoms(List<MolAtom> molAtoms) {
        if (this.molBondInMolecule == null) {
            MolAtom ma1 = molAtoms.get(this.atom1Number);
            MolAtom ma2 = molAtoms.get(this.atom2Number);
            if (ma1 != null && ma2 != null) {
                boolean isBoldBond;
                boolean bl = isBoldBond = this.type == Integer.MAX_VALUE && this.stereoType == 1 && this.stereoBoldBondFlag;
                if (isBoldBond) {
                    this.molBondInMolecule = new MolBond(ma1, ma2, 0x40000001);
                } else {
                    this.populateBondPropertesData(this.molBond);
                    this.molBondInMolecule = this.molBond.cloneBond(ma1, ma2);
                }
            }
        }
        return this.molBondInMolecule;
    }

    private void populateBondPropertesData(MolBond molBond) {
        if (this.stereoCare) {
            molBond.setFlags(512);
        } else {
            molBond.setFlags(this.getMolBondFlag(molBond.getFlags()));
        }
        if (this.type != Integer.MAX_VALUE) {
            molBond.setType(this.type == 8 ? 0 : this.type);
        }
    }

    private int getMolBondFlag(int orgFlag) {
        int flag = orgFlag;
        int stereo = this.stereoType;
        int topology = this.qtopo;
        int reactioncenter = this.rxnCenter;
        if (stereo == 1) {
            flag = orgFlag | 0x10;
        }
        if (stereo == 6) {
            flag = orgFlag | 0x20;
        }
        if (stereo == 3) {
            flag = 0xC0 | orgFlag;
        }
        if (stereo == 4) {
            flag = orgFlag | 0x20 | 0x10;
        }
        if (topology == 1) {
            flag |= 0x400;
        }
        if (topology == 2) {
            flag |= 0x800;
        }
        if (reactioncenter == 1) {
            flag |= 0x1000;
        }
        if (reactioncenter == 8) {
            flag |= 0x3000;
        }
        if (reactioncenter == 12) {
            flag |= 0x4000;
        }
        if (reactioncenter == 4) {
            flag |= 0x2000;
        }
        if (reactioncenter == -1) {
            flag |= 0x5000;
        }
        if (orgFlag == 8) {
            flag = 0;
        }
        return flag;
    }

    public static final MolBondInfo createMolBond() {
        MolBond bond = new MolBond(new MolAtom(0.0, 0.0), new MolAtom(0.0, 0.0));
        return new MolBondInfo(bond);
    }

    public static double round(double num, int digit) {
        NumberFormat formate = NumberFormat.getNumberInstance(Locale.US);
        formate.setMaximumFractionDigits(digit);
        return Double.valueOf(formate.format(num));
    }

    public static int getMolBondType(int order) {
        return order == 8 ? 0 : order;
    }

    public static int getBondStereo(int flag) {
        int stereoType = flag & 0xF0;
        int stereo = 0;
        if (stereoType == 48) {
            stereo = 4;
        }
        if (stereoType == 16) {
            stereo = 1;
        }
        if (stereoType == 32) {
            stereo = 6;
        }
        if (stereoType == 192) {
            stereo = 3;
        }
        return stereo;
    }

    public static int getBondOrder(int type) {
        return type == 0 ? 8 : type;
    }

    public static int getTopology(int flag) {
        int topology = 0;
        if (1024 == (flag & 0x400)) {
            topology = 1;
        }
        if (2048 == (flag & 0x800)) {
            topology = 2;
        }
        return topology;
    }

    public static int getSkcBondReactionStatus(int flag) {
        int reactionStatus = flag & 0xF000;
        int reaction = 0;
        if (reactionStatus == 12288) {
            reaction = 8;
        }
        if (reactionStatus == 16384) {
            reaction = 12;
        }
        if (reactionStatus == 8192) {
            reaction = 4;
        }
        if (reactionStatus == 20480) {
            reaction = -1;
        }
        if (reactionStatus == 4096) {
            reaction = 1;
        }
        return reaction;
    }
}

