/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils;

import chemaxon.marvin.io.formats.skc.utils.Segment;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Sgroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SgroupBeanInfo
implements Serializable {
    private static final long serialVersionUID = 5776994285220996828L;
    private Map<Integer, List<MolAtom>> pathes;
    private Sgroup sgroup;
    private Segment fragment;
    private boolean processed = false;
    private Map<Sgroup, SgroupBeanInfo> childrenSGroupInfos = new HashMap<Sgroup, SgroupBeanInfo>();

    public Map<Integer, List<MolAtom>> getPathes() {
        return this.pathes;
    }

    public void setPathes(Map<Integer, List<MolAtom>> pathes) {
        this.pathes = pathes;
    }

    public Sgroup getSgroup() {
        return this.sgroup;
    }

    public void setSgroup(Sgroup sgroup) {
        this.sgroup = sgroup;
    }

    public Segment getFragment() {
        return this.fragment;
    }

    public void setFragment(Segment fragment) {
        this.fragment = fragment;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isChildrenProcessed() {
        boolean flag = true;
        if (!this.childrenSGroupInfos.isEmpty()) {
            for (SgroupBeanInfo si : this.childrenSGroupInfos.values()) {
                if (si.isProcessed()) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }

    public void addChildSgroupInfo(SgroupBeanInfo sgroupInfo) {
        this.childrenSGroupInfos.put(sgroupInfo.getSgroup(), sgroupInfo);
    }

    public boolean hasChildSgroups() {
        return this.childrenSGroupInfos.size() > 0;
    }

    public void connectPathes(Set<Integer> pathIdes, Integer newPathId) {
        if (this.pathes != null && !this.pathes.isEmpty()) {
            ArrayList newPath = new ArrayList();
            boolean flag = false;
            for (Integer i : pathIdes) {
                if (!this.pathes.keySet().contains(i)) continue;
                flag = true;
                newPath.addAll(this.pathes.get(i));
                this.pathes.remove(i);
            }
            if (flag) {
                this.pathes.put(newPathId, newPath);
            }
        }
    }
}

