/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils;

import chemaxon.marvin.io.formats.skc.utils.MolBondInfo;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SgroupInfo
extends Sgroup {
    private static final long serialVersionUID = 1L;
    private boolean expandedFlag;
    private int sgroupType;
    private int subType;
    private int multiplier;
    private int maxRepetition;
    private String connectivity;
    private String subscript;
    private Map<String, Object> carrierMap = new HashMap<String, Object>();
    private List<MolAtom> molAtoms = new ArrayList<MolAtom>();
    private List<MolBondInfo> molBondInfoes = new ArrayList<MolBondInfo>();
    private String superAtomSgroupText;
    private String sgroupTypeStr;

    public SgroupInfo(Molecule arg0, int arg1) {
        super(arg0, arg1);
    }

    public void addMolAtomToSgroup(MolAtom molAtom) {
        if (molAtom != null && !this.molAtoms.contains(molAtom)) {
            this.molAtoms.add(molAtom);
        }
    }

    public void addMolAtomsToSgroup(List<MolAtom> molAtomList) {
        if (molAtomList != null && !molAtomList.isEmpty()) {
            for (MolAtom ma : molAtomList) {
                if (ma == null || this.molAtoms.contains(ma)) continue;
                this.molAtoms.add(ma);
            }
        }
    }

    public void addMolBondInfoToSgroupInfo(MolBondInfo molBondInfo) {
        if (molBondInfo != null && !this.molBondInfoes.contains(molBondInfo)) {
            this.molBondInfoes.add(molBondInfo);
        }
    }

    public void addMolBondInfoesToSgroupInfo(List<MolBondInfo> molBondInfoList) {
        if (molBondInfoList != null && !molBondInfoList.isEmpty()) {
            for (MolBondInfo mb : molBondInfoList) {
                if (mb == null || this.molBondInfoes.contains(mb)) continue;
                this.molBondInfoes.add(mb);
            }
        }
    }

    public boolean isExpandedFlag() {
        return this.expandedFlag;
    }

    public void setExpandedFlag(boolean expandedFlag) {
        this.expandedFlag = expandedFlag;
    }

    @Override
    public int getSubType() {
        return this.subType;
    }

    @Override
    public void setSubType(int subType) {
        this.subType = subType;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    public int getMaxRepetition() {
        return this.maxRepetition;
    }

    public void setMaxRepetition(int maxRepetition) {
        this.maxRepetition = maxRepetition;
    }

    public String getSgroupConnectivity() {
        return this.connectivity;
    }

    public void setSgroupConnectivity(String connectivity) {
        this.connectivity = connectivity;
    }

    @Override
    public String getSubscript() {
        return this.subscript;
    }

    @Override
    public void setSubscript(String subscript) {
        this.subscript = subscript;
    }

    public Object getPropertyFromCarrier(String key) {
        return this.carrierMap.get(key);
    }

    public void addPropertyToCarrier(String key, Object value) {
        this.carrierMap.put(key, value);
    }

    public void removePropertyFromCarrier(String key) {
        this.carrierMap.remove(key);
    }

    public List<MolAtom> getMolAtoms() {
        return this.molAtoms;
    }

    public List<MolBondInfo> getMolBondInfoes() {
        return this.molBondInfoes;
    }

    public int getSgroupType() {
        return this.sgroupType;
    }

    public void setSgroupType(int sgroupType) {
        this.sgroupType = sgroupType;
    }

    public String getSuperAtomSgroupText() {
        return this.superAtomSgroupText;
    }

    public void setSuperAtomSgroupText(String superAtomSgroupText) {
        this.superAtomSgroupText = superAtomSgroupText;
    }

    public String getSgroupTypeStr() {
        return this.sgroupTypeStr;
    }

    public void setSgroupTypeStr(String sgroupTypeStr) {
        this.sgroupTypeStr = sgroupTypeStr;
    }

    public String toSgroupInfoString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("\nMolAtom ::" + this.molAtoms);
        sb.append("\n MolBondx ::" + this.molBondInfoes);
        return sb.toString();
    }
}

