/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils;

import chemaxon.marvin.io.formats.skc.utils.Segment;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SuperatomSgroupUtil {
    private static final int EXPANDED = 0;
    private static final int CONTRACT = 1;
    private static final int EXPANDED_AND_CONTRACT = 2;
    private Map<MolBond, List<Sgroup>> bridgeBondSgroupMap = new HashMap<MolBond, List<Sgroup>>();
    private Map<MolAtom, List<MolBond>> superatomAndAcrossBondMap = new HashMap<MolAtom, List<MolBond>>();
    private Map<Object, List<Object>> superAtomMap = new HashMap<Object, List<Object>>();
    private Map<SelectionMolecule, List<Sgroup>> smSgroupMap = new HashMap<SelectionMolecule, List<Sgroup>>();
    private Map<Sgroup, Boolean> sgroupContractOrExpandedFlagMap = new HashMap<Sgroup, Boolean>();
    private Map<MolBond, MolBond> abbreviationBondsMap = new HashMap<MolBond, MolBond>();
    private Map<Object, DPoint3> originalDPoint3Map = new HashMap<Object, DPoint3>();

    public SuperatomSgroupUtil() {
    }

    public SuperatomSgroupUtil(Map<Sgroup, Boolean> sgroupContractOrExpandedFlagMap, Map<Object, DPoint3> originalDPoint3Map) {
        this.sgroupContractOrExpandedFlagMap = sgroupContractOrExpandedFlagMap;
        this.originalDPoint3Map = originalDPoint3Map;
    }

    public MolBond getAbbreviationBond(MolBond oldBond) {
        return this.abbreviationBondsMap.get(oldBond);
    }

    public Map<MolAtom, List<MolBond>> getSuperatomAndAcrossBondMap() {
        return this.superatomAndAcrossBondMap;
    }

    public Map<Object, List<Object>> getSuperAtomMap() {
        return this.superAtomMap;
    }

    public List<List<MolAtom>> getAllComponentsFromObjects(List<Object> objects) {
        ArrayList<MolAtom> molAtoms = new ArrayList<MolAtom>();
        if (objects != null && !objects.isEmpty()) {
            for (Object ob : objects) {
                if (!(ob instanceof MolAtom)) continue;
                molAtoms.add((MolAtom)ob);
            }
        }
        return this.getAllComponentsFromAtomList(molAtoms);
    }

    public boolean isNeedCleanMolecule(Molecule mol) {
        boolean flag = false;
        List<List<MolAtom>> components = this.getAllComponentsFromAtomList(Arrays.asList(mol.getAtomArray()));
        if (mol.getSgroupCount() > 0) {
            ArrayList<Sgroup> superSgroups = new ArrayList<Sgroup>();
            for (Sgroup sgroup : mol.getSgroupArray()) {
                if (sgroup.getType() != 0) continue;
                superSgroups.add(sgroup);
            }
            if (!superSgroups.isEmpty()) {
                for (List<MolAtom> component : components) {
                    List<MolBond> bridgeBonds = this.getSuperSgroupBridgeBonds(component, superSgroups);
                    if (bridgeBonds == null || bridgeBonds.isEmpty()) continue;
                    flag = true;
                    break;
                }
            }
        }
        return flag;
    }

    public List<Object> getFinalTopObjectsOfSegment(List<List<MolAtom>> components, List<Sgroup> superSgroups, List<Object> oldObjects) {
        HashMap componentSgroupsMap = new HashMap();
        ArrayList<List<MolAtom>> orderKeys = new ArrayList<List<MolAtom>>();
        for (int i = 0; i < components.size(); ++i) {
            List<MolAtom> component = components.get(i);
            for (int j = 0; j < superSgroups.size(); ++j) {
                MolAtom[] mas;
                Sgroup sg = superSgroups.get(j);
                int sameCount = 0;
                for (MolAtom molAtom : mas = sg.getAtomArray()) {
                    if (!component.contains(molAtom)) continue;
                    ++sameCount;
                }
                if (sameCount == 0 || sameCount != mas.length) continue;
                if (componentSgroupsMap.containsKey(component)) {
                    ((List)componentSgroupsMap.get(component)).add(sg);
                    continue;
                }
                ArrayList<Sgroup> sgs = new ArrayList<Sgroup>();
                sgs.add(sg);
                componentSgroupsMap.put(component, sgs);
                orderKeys.add(component);
            }
        }
        ArrayList<Object> resultObjectList = new ArrayList<Object>();
        if (!componentSgroupsMap.isEmpty()) {
            for (int i = 0; i < orderKeys.size(); ++i) {
                List component = (List)orderKeys.get(i);
                List<Object> objects = this.getObjectsOfTopSegment(component, (List)componentSgroupsMap.get(component), oldObjects);
                resultObjectList.addAll(objects);
            }
        }
        return resultObjectList;
    }

    public List<Sgroup> getSuperSgroupsOfSeleMole(SelectionMolecule selectMol, SelectionMolecule[] sms, Molecule mol) {
        if (sms != null && sms.length > 0) {
            for (SelectionMolecule sm : sms) {
                this.findSuperSgroupsOfSelecMol(sm, mol);
            }
        }
        List<Sgroup> sgroups = null;
        if (!this.smSgroupMap.isEmpty() && this.smSgroupMap.containsKey(selectMol)) {
            sgroups = this.smSgroupMap.get(selectMol);
        }
        return sgroups;
    }

    public Map<MoleculeGraph, List<List<MolAtom>>> getComponentsOfSeleMolecule(MoleculeGraph[] sms, Molecule mol) {
        HashMap<MoleculeGraph, List<List<MolAtom>>> componentMap = new HashMap<MoleculeGraph, List<List<MolAtom>>>();
        ArrayList<MolAtom> hasProcessedAtoms = new ArrayList<MolAtom>();
        if (sms != null && sms.length > 0) {
            for (MoleculeGraph selectMol : sms) {
                MolAtom[] atomsNoRepeat = selectMol.getAtomArray();
                ArrayList<ArrayList<MolAtom>> result = new ArrayList<ArrayList<MolAtom>>();
                if (atomsNoRepeat != null && atomsNoRepeat.length != 0) {
                    for (int i = atomsNoRepeat.length - 1; i > 0; --i) {
                        MolAtom cAtom = atomsNoRepeat[i];
                        if (this.hasProcessed(hasProcessedAtoms, cAtom)) continue;
                        ArrayList<MolAtom> atomsInPath = new ArrayList<MolAtom>();
                        this.findConnectedAtom(cAtom, atomsInPath, hasProcessedAtoms);
                        result.add(atomsInPath);
                    }
                }
                componentMap.put(selectMol, result);
            }
        }
        return componentMap;
    }

    public void rebuildSpecialSuperSgroup(Segment segment, List<List<MolAtom>> components) {
        List<Object> objects = segment.getObjects();
        List<Sgroup> specialSuperSgroups = this.getSpecialSuperSgroups(objects, components);
        if (specialSuperSgroups != null && !specialSuperSgroups.isEmpty()) {
            this.integrateSuperAndSegment(segment, specialSuperSgroups);
        } else {
            for (int i = 0; i < objects.size(); ++i) {
                Object object = objects.get(i);
                if (!(object instanceof Segment)) continue;
                this.rebuildSpecialSuperSgroup((Segment)object, components);
            }
        }
    }

    private void findSuperSgroupsOfSelecMol(SelectionMolecule sm, Molecule mol) {
        Sgroup[] sgroups = mol.getSgroupArray();
        ArrayList<Sgroup> superSgroupList = new ArrayList<Sgroup>();
        if (sgroups != null && sgroups.length > 0) {
            for (Sgroup sgroup : sgroups) {
                MolAtom[] mas;
                boolean flag = false;
                if (sgroup.getType() != 0) continue;
                for (MolAtom ma : mas = sgroup.getAtomArray()) {
                    if (!sm.contains(ma)) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                superSgroupList.add(sgroup);
                flag = false;
            }
        }
        if (!superSgroupList.isEmpty()) {
            this.smSgroupMap.put(sm, superSgroupList);
        }
    }

    private List<List<MolAtom>> getAllComponentsFromAtomList(List<MolAtom> molAtoms) {
        ArrayList<MolAtom> hasProcessedAtoms = new ArrayList<MolAtom>();
        ArrayList<List<MolAtom>> result = new ArrayList<List<MolAtom>>();
        if (molAtoms != null && !molAtoms.isEmpty()) {
            for (int i = molAtoms.size() - 1; i > 0; --i) {
                MolAtom cAtom = molAtoms.get(i);
                if (this.hasProcessed(hasProcessedAtoms, cAtom)) continue;
                ArrayList<MolAtom> atomsInPath = new ArrayList<MolAtom>();
                this.findConnectedAtom(cAtom, atomsInPath, hasProcessedAtoms);
                result.add(atomsInPath);
            }
        }
        return result;
    }

    private List<Object> getObjectsOfTopSegment(List<MolAtom> component, List<Sgroup> sgroups, List<Object> oldObjects) {
        int state = this.getStateOfExpandedOrContract(sgroups);
        List<Object> reusltObjects = new ArrayList<Object>();
        switch (state) {
            case 1: 
            case 2: {
                List<MolBond> bridgeBonds = this.getSuperSgroupBridgeBonds(component, sgroups);
                reusltObjects = this.processContractSuperSgroupWithBridge(component, sgroups, oldObjects, bridgeBonds);
                break;
            }
            case 0: {
                reusltObjects = this.processExpandedSuperSgroup(component, sgroups);
            }
        }
        return reusltObjects;
    }

    private List<Object> processExpandedSuperSgroup(List<MolAtom> component, List<Sgroup> sgroups) {
        ArrayList<Object> reusltObjects = new ArrayList<Object>();
        if (sgroups.size() >= 2) {
            List<MolBond> bonds = this.getMolBondsByMolAtoms(component);
            reusltObjects.addAll(component);
            reusltObjects.addAll(bonds);
            reusltObjects.addAll(sgroups);
        } else {
            Sgroup sgroup = sgroups.get(0);
            List<MolAtom> aomts = Arrays.asList(sgroup.getAtomArray());
            boolean flag = this.isConponentContainAllSgroupAtoms(component, aomts);
            if (flag) {
                List<MolBond> bonds = this.getMolBondsByMolAtoms(aomts);
                Segment atomBondSegment = new Segment();
                atomBondSegment.getObjects().addAll(aomts);
                atomBondSegment.getObjects().addAll(bonds);
                reusltObjects.add(atomBondSegment);
            } else {
                List<MolBond> bonds = this.getMolBondsByMolAtoms(component);
                reusltObjects.addAll(component);
                reusltObjects.addAll(bonds);
            }
            reusltObjects.addAll(sgroups);
        }
        return reusltObjects;
    }

    private int getStateOfExpandedOrContract(List<Sgroup> sgroups) {
        int expandedCount = 0;
        int contranctCount = 0;
        int result = 0;
        for (int i = 0; i < sgroups.size(); ++i) {
            Sgroup sgroup = sgroups.get(i);
            if (this.sgroupContractOrExpandedFlagMap.get(sgroup).booleanValue()) {
                ++expandedCount;
                continue;
            }
            ++contranctCount;
        }
        if (expandedCount > 0 && contranctCount > 0) {
            result = 2;
        } else if (contranctCount > 0) {
            result = 1;
        }
        return result;
    }

    private List<MolBond> getMolBondsByMolAtoms(List<MolAtom> molAtoms) {
        ArrayList<MolBond> mbList = new ArrayList<MolBond>();
        for (MolAtom molAtom : molAtoms) {
            int bc = molAtom.getBondCount();
            for (int i = 0; i < bc; ++i) {
                MolBond mb = molAtom.getBond(i);
                if (mbList.contains(mb)) continue;
                mbList.add(mb);
            }
        }
        return mbList;
    }

    private boolean isConponentContainAllSgroupAtoms(List<MolAtom> component, List<MolAtom> sgroupAomts) {
        boolean flag = false;
        int sameCount = 0;
        for (MolAtom ma : sgroupAomts) {
            if (!component.contains(ma)) continue;
            ++sameCount;
        }
        if (sameCount != 0 && sameCount == component.size()) {
            flag = true;
        }
        return flag;
    }

    private List<Object> processContractSuperSgroupWithBridge(List<MolAtom> component, List<Sgroup> sgroups, List<Object> oldObjects, List<MolBond> bridgeBonds) {
        ArrayList<Object> reusltObjects = new ArrayList<Object>();
        ArrayList<MolAtom> outsideAtomsOfSgroup = new ArrayList<MolAtom>();
        ArrayList<MolBond> outsideBondsOfSgroup = new ArrayList<MolBond>();
        ArrayList<MolAtom> superAtomList = new ArrayList<MolAtom>();
        ArrayList<MolAtom> sgroupAtoms = new ArrayList<MolAtom>();
        for (Sgroup sgroup : sgroups) {
            if (this.isExpanded(sgroup)) continue;
            sgroupAtoms.addAll(Arrays.asList(sgroup.getAtomArray()));
        }
        HashMap<Sgroup, MolAtom> sgroupSuperAtomMap = new HashMap<Sgroup, MolAtom>();
        ArrayList<Sgroup> tempSgroups = new ArrayList<Sgroup>();
        for (int i = 0; i < sgroups.size(); ++i) {
            Sgroup sgroup = sgroups.get(i);
            if (!this.isExpanded(sgroup)) {
                SuperatomSgroup superSgroup = (SuperatomSgroup)sgroup;
                SgroupAtom sa = superSgroup.getSuperAtom();
                DPoint3 dp3 = this.originalDPoint3Map.get(sgroup);
                MolAtom superAtom = new MolAtom(dp3.x, dp3.y);
                superAtom.setAtno(272);
                superAtom.setAliasstr(sa.getSymbol());
                superAtomList.add(superAtom);
                sgroupSuperAtomMap.put(sgroup, superAtom);
            }
            for (int k = 0; k < component.size(); ++k) {
                MolAtom ma = component.get(k);
                if (sgroupAtoms.contains(ma) || outsideAtomsOfSgroup.contains(ma)) continue;
                outsideAtomsOfSgroup.add(ma);
                this.collectOutsideBond(ma, outsideBondsOfSgroup);
            }
            tempSgroups.add(sgroup);
        }
        int bbSize = bridgeBonds.size();
        MolBond nextBridgeBond = null;
        MolBond nextNewOutsideBond = null;
        for (int i = 0; i < bbSize; ++i) {
            MolBond currentBridgeBond = bridgeBonds.get(i);
            List<Sgroup> sameBridgeBondSgroups = this.bridgeBondSgroupMap.get(currentBridgeBond);
            Sgroup sgroup1 = sameBridgeBondSgroups.get(0);
            Sgroup sgroup2 = sameBridgeBondSgroups.get(1);
            tempSgroups.remove(sgroup1);
            tempSgroups.remove(sgroup2);
            MolBond currentNewOutsideBond = currentBridgeBond.cloneBond((MolAtom)sgroupSuperAtomMap.get(sgroup1), (MolAtom)sgroupSuperAtomMap.get(sgroup2));
            outsideBondsOfSgroup.add(currentNewOutsideBond);
            boolean flag = i + 1 == bbSize;
            for (int k = 0; k < sameBridgeBondSgroups.size(); ++k) {
                Sgroup superSgroup = sameBridgeBondSgroups.get(k);
                MolAtom superAtom = (MolAtom)sgroupSuperAtomMap.get(superSgroup);
                List<MolAtom> curentSgroupAtoms = Arrays.asList(superSgroup.getAtomArray());
                ArrayList<MolBond> abbrevAtchBonds = new ArrayList<MolBond>();
                ArrayList<MolBond> crossedBonds = new ArrayList<MolBond>();
                if (outsideBondsOfSgroup.size() > 0) {
                    for (int j = 0; j < outsideBondsOfSgroup.size(); ++j) {
                        MolBond mb;
                        MolBond molBond = (MolBond)outsideBondsOfSgroup.get(j);
                        MolAtom ma1 = molBond.getAtom1();
                        MolAtom ma2 = molBond.getAtom2();
                        if (curentSgroupAtoms.contains(ma1) && !curentSgroupAtoms.contains(ma2)) {
                            mb = molBond.cloneBond(ma2, superAtom);
                            abbrevAtchBonds.add(mb);
                            outsideBondsOfSgroup.set(j, mb);
                            crossedBonds.add(molBond);
                            continue;
                        }
                        if (curentSgroupAtoms.contains(ma2) && !curentSgroupAtoms.contains(ma1)) {
                            mb = molBond.cloneBond(ma1, superAtom);
                            abbrevAtchBonds.add(mb);
                            outsideBondsOfSgroup.set(j, mb);
                            crossedBonds.add(molBond);
                            continue;
                        }
                        if (nextBridgeBond != null && nextNewOutsideBond != null && k == 0) {
                            if (crossedBonds.isEmpty() || !crossedBonds.contains(nextBridgeBond)) {
                                crossedBonds.add(nextBridgeBond);
                            }
                            if (abbrevAtchBonds.isEmpty() || !abbrevAtchBonds.contains(nextNewOutsideBond)) {
                                abbrevAtchBonds.add(nextNewOutsideBond);
                            }
                        }
                        if (crossedBonds.isEmpty() || !crossedBonds.contains(currentBridgeBond)) {
                            crossedBonds.add(currentBridgeBond);
                        }
                        if (!abbrevAtchBonds.isEmpty() && abbrevAtchBonds.contains(currentNewOutsideBond)) continue;
                        abbrevAtchBonds.add(currentNewOutsideBond);
                    }
                }
                if (crossedBonds != null && crossedBonds.size() > 0) {
                    List<Object> objectList = this.getNewObjectListForBridge(superSgroup, curentSgroupAtoms, crossedBonds);
                    this.superAtomMap.put(superAtom, objectList);
                    this.superatomAndAcrossBondMap.put(superAtom, abbrevAtchBonds);
                } else {
                    this.superAtomMap.put(superAtom, this.getObjectsForComponentIsSuperSgroup(oldObjects));
                    this.superatomAndAcrossBondMap.put(superAtom, abbrevAtchBonds);
                }
                if (!flag) break;
            }
            nextBridgeBond = currentBridgeBond;
            nextNewOutsideBond = currentNewOutsideBond;
        }
        HashMap<MolBond, MolBond> oldAndNewBondMap = new HashMap<MolBond, MolBond>();
        ArrayList<Sgroup> expandedSgroupList = new ArrayList<Sgroup>();
        if (!tempSgroups.isEmpty()) {
            for (Sgroup superSgroup : tempSgroups) {
                if (this.sgroupContractOrExpandedFlagMap.get(superSgroup).booleanValue()) {
                    expandedSgroupList.add(superSgroup);
                    continue;
                }
                MolAtom superAtom = (MolAtom)sgroupSuperAtomMap.get(superSgroup);
                List<MolAtom> curentSgroupAtoms = Arrays.asList(superSgroup.getAtomArray());
                ArrayList<MolBond> abbrevAtchBonds = new ArrayList<MolBond>();
                ArrayList<MolBond> crossedBonds = new ArrayList<MolBond>();
                if (!outsideBondsOfSgroup.isEmpty()) {
                    for (int i = 0; i < outsideBondsOfSgroup.size(); ++i) {
                        MolBond mb;
                        MolBond molBond = (MolBond)outsideBondsOfSgroup.get(i);
                        MolAtom ma1 = molBond.getAtom1();
                        MolAtom ma2 = molBond.getAtom2();
                        if (curentSgroupAtoms.contains(ma1) && !curentSgroupAtoms.contains(ma2)) {
                            mb = molBond.cloneBond(ma2, superAtom);
                            abbrevAtchBonds.add(mb);
                            outsideBondsOfSgroup.set(i, mb);
                            oldAndNewBondMap.put(molBond, mb);
                            crossedBonds.add(molBond);
                            continue;
                        }
                        if (!curentSgroupAtoms.contains(ma2) || curentSgroupAtoms.contains(ma1)) continue;
                        mb = molBond.cloneBond(superAtom, ma1);
                        abbrevAtchBonds.add(mb);
                        outsideBondsOfSgroup.set(i, mb);
                        oldAndNewBondMap.put(molBond, mb);
                        crossedBonds.add(molBond);
                    }
                }
                if (crossedBonds != null && crossedBonds.size() > 0) {
                    List<Object> objectList = this.getNewObjectListForBridge(superSgroup, curentSgroupAtoms, crossedBonds);
                    this.superAtomMap.put(superAtom, objectList);
                    this.superatomAndAcrossBondMap.put(superAtom, abbrevAtchBonds);
                    continue;
                }
                this.superAtomMap.put(superAtom, this.getObjectsForComponentIsSuperSgroup(oldObjects));
                this.superatomAndAcrossBondMap.put(superAtom, abbrevAtchBonds);
            }
        }
        for (int i = outsideAtomsOfSgroup.size() - 1; i >= 0; --i) {
            MolAtom ma = (MolAtom)outsideAtomsOfSgroup.get(i);
            DPoint3 dp3 = this.originalDPoint3Map.get(ma);
            ma.setXYZ(dp3.x, dp3.y, dp3.z);
            reusltObjects.add(ma);
        }
        reusltObjects.addAll(outsideBondsOfSgroup);
        if (!expandedSgroupList.isEmpty()) {
            List<MolBond> brevBonds = this.getAllAbbreviationBonds(expandedSgroupList);
            for (MolBond molBond : brevBonds) {
                if (!oldAndNewBondMap.containsKey(molBond)) continue;
                this.abbreviationBondsMap.put(molBond, (MolBond)oldAndNewBondMap.get(molBond));
            }
        }
        reusltObjects.addAll(superAtomList);
        if (!expandedSgroupList.isEmpty()) {
            for (Sgroup sgroup : expandedSgroupList) {
                reusltObjects.add(sgroup);
            }
        }
        return reusltObjects;
    }

    private List<MolBond> getAllAbbreviationBonds(List<Sgroup> expandedSgroupList) {
        ArrayList<MolBond> resultBonds = new ArrayList<MolBond>();
        if (!expandedSgroupList.isEmpty()) {
            for (Sgroup sg : expandedSgroupList) {
                List<MolAtom> mas = Arrays.asList(sg.getAtomArray());
                for (MolAtom ma : mas) {
                    int bc = ma.getBondCount();
                    for (int i = 0; i < bc; ++i) {
                        MolBond mb = ma.getBond(i);
                        MolAtom otherAtom = mb.getOtherAtom(ma);
                        if (mas.contains(otherAtom) || resultBonds.contains(mb)) continue;
                        resultBonds.add(mb);
                    }
                }
            }
        }
        return resultBonds;
    }

    private List<Object> getObjectsForComponentIsSuperSgroup(List<Object> oldObjects) {
        ArrayList<Object> objects = new ArrayList<Object>();
        Segment atomBondSegment = new Segment();
        Segment superSgroupSegment = new Segment();
        for (Object object : oldObjects) {
            if (object instanceof MolAtom || object instanceof MolBond) {
                atomBondSegment.getObjects().add(object);
                continue;
            }
            superSgroupSegment.getObjects().add(object);
        }
        objects.add(atomBondSegment);
        objects.addAll(superSgroupSegment.getObjects());
        return objects;
    }

    private boolean isExpanded(Sgroup sgroup) {
        boolean flag = false;
        if (this.sgroupContractOrExpandedFlagMap.get(sgroup) != null) {
            flag = this.sgroupContractOrExpandedFlagMap.get(sgroup);
        }
        return flag;
    }

    private List<MolBond> getSuperSgroupBridgeBonds(List<MolAtom> component, List<Sgroup> sgroups) {
        ArrayList<MolBond> bridgeBonds = new ArrayList<MolBond>();
        ArrayList componentBonds = new ArrayList();
        for (int k = 0; k < component.size(); ++k) {
            MolAtom ma = component.get(k);
            int bc = ma.getBondCount();
            for (int i = 0; i < bc; ++i) {
                MolBond mb = ma.getBond(i);
                if (componentBonds.contains(mb) || !this.isExistBridgeBond(mb, sgroups) || bridgeBonds.contains(mb)) continue;
                bridgeBonds.add(mb);
            }
        }
        int sgroupSize = sgroups.size();
        ArrayList<MolBond> orderBridgeBonds = new ArrayList<MolBond>(sgroupSize - 1);
        if (!bridgeBonds.isEmpty()) {
            for (int i = 0; i < sgroupSize; ++i) {
                Sgroup sgroup = sgroups.get(i);
                for (MolBond bridgeBond : bridgeBonds) {
                    if (!this.getAllBondsOfSuperSgroup(sgroup).contains(bridgeBond) || orderBridgeBonds.contains(bridgeBond)) continue;
                    orderBridgeBonds.add(bridgeBond);
                }
            }
        }
        return orderBridgeBonds;
    }

    private List<MolBond> getAllBondsOfSuperSgroup(Sgroup sgroup) {
        MolAtom[] atoms;
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        for (MolAtom ma : atoms = sgroup.getAtomArray()) {
            int mbc = ma.getBondCount();
            for (int i = 0; i < mbc; ++i) {
                MolBond mb = ma.getBond(i);
                if (bonds.contains(mb)) continue;
                bonds.add(mb);
            }
        }
        return bonds;
    }

    private boolean isExistBridgeBond(MolBond molBond, List<Sgroup> sgroups) {
        boolean flag;
        MolBond bridgeBond = molBond;
        MolAtom ma1 = molBond.getAtom1();
        MolAtom ma2 = molBond.getAtom2();
        int count = 0;
        ArrayList<Sgroup> sgroupList = new ArrayList<Sgroup>();
        for (int i = 0; i < sgroups.size(); ++i) {
            Sgroup sg = sgroups.get(i);
            List<MolAtom> molAtoms = Arrays.asList(sg.getAtomArray());
            if (this.isNestWithOtherSuperSgroup(sg, sgroups) || !molAtoms.contains(ma1) && !molAtoms.contains(ma2) || this.isExpanded(sg)) continue;
            ++count;
            sgroupList.add(sg);
        }
        boolean bl = flag = count >= 2;
        if (flag) {
            this.bridgeBondSgroupMap.put(bridgeBond, sgroupList);
        }
        return flag;
    }

    private boolean isNestWithOtherSuperSgroup(Sgroup sgroup, List<Sgroup> sgroups) {
        boolean flag = false;
        Sgroup parentSgroup = sgroup.getParentSgroup();
        int csc = sgroup.getChildSgroupCount();
        for (int i = 0; i < csc; ++i) {
            Sgroup childSgroup = sgroup.getChildSgroup(i);
            if (!sgroups.contains(childSgroup)) continue;
            flag = true;
            break;
        }
        return flag || sgroups.contains(parentSgroup);
    }

    private List<Object> getNewObjectListForBridge(Sgroup sgroup, List<MolAtom> curentSgroupAtoms, List<MolBond> crossedBonds) {
        ArrayList<Object> objectList = new ArrayList<Object>();
        if (!crossedBonds.isEmpty()) {
            MolBond mb;
            ArrayList<MolAtom> maList = new ArrayList<MolAtom>();
            ArrayList<MolBond> mbList = new ArrayList<MolBond>();
            for (int i = 0; i < curentSgroupAtoms.size(); ++i) {
                MolAtom molAtom = curentSgroupAtoms.get(i);
                maList.add(molAtom);
                int bc = molAtom.getBondCount();
                for (int j = 0; j < bc; ++j) {
                    mb = molAtom.getBond(j);
                    if (mbList.contains(mb)) continue;
                    mbList.add(mb);
                }
            }
            HashMap<MolAtom, MolBond> specialAtomBondMap = new HashMap<MolAtom, MolBond>();
            HashMap<MolAtom, MolAtom> specialAtomAtomMap = new HashMap<MolAtom, MolAtom>();
            ArrayList<MolAtom> orderList = new ArrayList<MolAtom>();
            for (int i = 0; i < crossedBonds.size(); ++i) {
                mb = crossedBonds.get(i);
                MolAtom ma1 = mb.getAtom1();
                MolAtom ma2 = mb.getAtom2();
                if (!maList.contains(ma1) && maList.contains(ma2)) {
                    specialAtomBondMap.put(ma1, mb);
                    orderList.add(ma1);
                    specialAtomAtomMap.put(ma1, ma2);
                }
                if (!maList.contains(ma2) && maList.contains(ma1)) {
                    specialAtomBondMap.put(ma2, mb);
                    orderList.add(ma2);
                    specialAtomAtomMap.put(ma2, ma1);
                }
                mbList.remove(mb);
            }
            objectList.addAll(mbList);
            if (!specialAtomBondMap.isEmpty()) {
                for (MolAtom ma : orderList) {
                    objectList.add(ma);
                    MolBond mb2 = (MolBond)specialAtomBondMap.get(ma);
                    objectList.add(mb2);
                    this.abbreviationBondsMap.put(mb2, mb2);
                }
            }
            for (int i = 0; i < maList.size(); ++i) {
                objectList.add(maList.get(i));
            }
            objectList.add(sgroup);
        }
        return objectList;
    }

    private void collectOutsideBond(MolAtom ma, List<MolBond> outsideBondsOfSgroup) {
        int bc = ma.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond mb = ma.getBond(i);
            if (outsideBondsOfSgroup.contains(mb)) continue;
            outsideBondsOfSgroup.add(mb);
        }
    }

    private boolean hasProcessed(List<MolAtom> hasProcessedAtoms, MolAtom cAtom) {
        if (hasProcessedAtoms == null || hasProcessedAtoms.size() == 0) {
            return false;
        }
        return hasProcessedAtoms.contains(cAtom);
    }

    private List<MolAtom> findConnectedAtom(MolAtom atom, List<MolAtom> selectedAtoms, List<MolAtom> hasProcessedAtoms) {
        if (atom != null && !selectedAtoms.contains(atom) && !hasProcessedAtoms.contains(atom)) {
            selectedAtoms.add(atom);
            hasProcessedAtoms.add(atom);
            for (int i = 0; i < atom.getBondCount(); ++i) {
                MolBond bond = atom.getBond(i);
                this.findConnectedAtom(bond.getOtherAtom(atom), selectedAtoms, hasProcessedAtoms);
            }
        }
        return selectedAtoms;
    }

    private List<Sgroup> getSpecialSuperSgroups(List<Object> objects, List<List<MolAtom>> components) {
        ArrayList<Sgroup> sgroups = new ArrayList<Sgroup>();
        for (Object ob : objects) {
            Sgroup sg;
            if (!(ob instanceof Sgroup) || (sg = (Sgroup)ob).getType() != 0 || !this.isContainedByConponent(sg, components)) continue;
            sgroups.add(sg);
        }
        return sgroups;
    }

    private boolean isContainedByConponent(Sgroup sgroup, List<List<MolAtom>> components) {
        boolean flag = false;
        MolAtom[] sgroupMolAtoms = sgroup.getAtomArray();
        for (List<MolAtom> component : components) {
            int sameCount = 0;
            for (MolAtom ma : sgroupMolAtoms) {
                if (!component.contains(ma)) continue;
                ++sameCount;
            }
            if (sameCount == 0 || sameCount != component.size()) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void integrateSuperAndSegment(Segment segment, List<Sgroup> superSgroups) {
        List<Object> objects = segment.getObjects();
        for (Object obj : objects) {
            if (!(obj instanceof Segment)) continue;
            this.addSuperSgroupToSegment(segment, (Segment)obj, superSgroups);
        }
    }

    private void addSuperSgroupToSegment(Segment tomSegment, Segment segment, List<Sgroup> superSgroups) {
        List<MolAtom> atoms = segment.getMolAtoms();
        for (Sgroup sgroup : superSgroups) {
            MolAtom[] atomArray = sgroup.getAtomArray();
            int sameCount = 0;
            for (MolAtom molAtom : atomArray) {
                if (!atoms.contains(molAtom)) continue;
                ++sameCount;
            }
            if (sameCount == 0 || sameCount != atoms.size()) continue;
            segment.getObjects().add(sgroup);
            tomSegment.getObjects().remove(sgroup);
        }
    }
}

