/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils.text;

import chemaxon.marvin.io.formats.skc.utils.text.TextBaseData;
import chemaxon.marvin.io.formats.skc.utils.text.TextChecker;
import chemaxon.marvin.io.formats.skc.utils.text.TextFont;
import chemaxon.marvin.io.formats.skc.utils.text.TextStyleMark;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextData {
    private String fontName;
    private Map<String, TextFont> textFontMap = new HashMap<String, TextFont>();
    private List<TextStyleMark> textStyleMarkList = new ArrayList<TextStyleMark>();
    private List<TextBaseData> textBaseDataList = new ArrayList<TextBaseData>();

    public Map<String, TextFont> getFextFontMap() {
        return this.textFontMap;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public List<TextBaseData> getTextBaseDataList() {
        return this.textBaseDataList;
    }

    public boolean isCanAddTextBaseData(String textContent) {
        boolean flag = true;
        try {
            this.textBaseDataList.add(new TextBaseData(textContent, new TextStyleMark(this.getTextStyleMark())));
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public TextStyleMark getTextStyleMark() {
        if (this.textStyleMarkList.size() == 0 && this.fontName != null) {
            this.textStyleMarkList.add(new TextStyleMark(this.textFontMap.get(this.fontName)));
        }
        return this.textStyleMarkList.size() >= 1 ? this.textStyleMarkList.get(this.textStyleMarkList.size() - 1) : null;
    }

    public TextData createNewTextDataObject(String textContent) {
        TextData textData = new TextData();
        if (new TextChecker(textData, this.getSymol(textContent, new char[]{' ', '\t', '\r', '\n', '\u0000'})).parse()) {
            return textData;
        }
        return textData;
    }

    private String getSymol(String s, char[] trimc) {
        int last = s.length() - 1;
        if (s != null && s.length() != 0 && trimc != null && trimc.length != 0) {
            int i = s.length() - 1;
            while (i >= 0 && this.charInCharArray(s.charAt(i), trimc)) {
                last = i--;
            }
        }
        return s.substring(0, last + 1);
    }

    private boolean charInCharArray(char c, char[] chars) {
        boolean ret = false;
        for (char ch : chars) {
            if (ch != c) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

