/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.smiles;

import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.QueryBond;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import java.io.IOException;
import java.util.BitSet;

public class SmilesImportX {
    static boolean readReac(SmilesImport that, String smiles, Molecule mol) throws IOException {
        RxnMolecule rxmol = null;
        RgMolecule rgmol = null;
        if (mol instanceof RxnMolecule) {
            rxmol = (RxnMolecule)mol;
        } else if (mol instanceof RgMolecule) {
            rgmol = (RgMolecule)mol;
            Molecule m = rgmol.getRoot();
            if (m instanceof RxnMolecule) {
                rxmol = (RxnMolecule)m;
            } else {
                MPropertyContainer p = mol.properties();
                rxmol = new RxnMolecule();
                rgmol.setRoot(rxmol);
                MPropertyContainer n = rgmol.properties();
                String[] props = p.getKeys();
                for (int i = 0; i < props.length; ++i) {
                    n.set(props[i], p.get(props[i]));
                }
            }
            rgmol.setDim(0);
            rgmol.setInputFormat(mol.getInputFormat());
        }
        if (rxmol == null) {
            throw new MolFormatException("Cannot import reaction SMILES into non-reaction molecule");
        }
        rxmol.setDim(0);
        String[] ss = new String[3];
        int rindex1 = that.reactionIndex1;
        int rindex2 = that.reactionIndex2;
        int rindex3 = that.reactionIndex3;
        ss[0] = smiles.substring(0, rindex1);
        ss[1] = smiles.substring(rindex2 + 1, rindex3);
        ss[2] = smiles.substring(rindex1 + 1, rindex2);
        boolean ret = true;
        boolean doubleBondFixes = false;
        boolean molHasRing = false;
        boolean fbi = false;
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            int k = 0;
            while (k >= 0 && j < ss[i].length()) {
                String s = null;
                k = ss[i].indexOf(62, j);
                s = k >= 0 ? ss[i].substring(j, k) : ss[i].substring(j);
                j = k + 1;
                Molecule m = new Molecule();
                that.initStereo(s);
                ret &= that.readMol0(s, m);
                doubleBondFixes |= that.doubleBondFixes;
                molHasRing |= that.molHasRing;
                if (m.isAbsStereo()) {
                    rxmol.setAbsStereo(true);
                }
                int fc = m.getFragCount();
                int ac = m.getAtomCount();
                int ec = m.getBondCount();
                int[] fids = m.getFragIds();
                for (int l = 0; l < fc; ++l) {
                    int n;
                    Molecule frag = new Molecule();
                    frag.setDim(0);
                    int id = -1;
                    for (n = 0; n < ac && id < 0; ++n) {
                        if (fids[n] < 0) continue;
                        id = fids[n];
                    }
                    for (n = 0; n < ac; ++n) {
                        if (fids[n] != id) continue;
                        frag.add(m.getAtom(n));
                        fids[n] = -1;
                    }
                    for (n = 0; n < ec; ++n) {
                        MolBond e = m.getBond(n);
                        if (!frag.contains(e.getAtom1())) continue;
                        frag.add(e);
                    }
                    frag.setInputFormat(rxmol.getInputFormat());
                    rxmol.addComponent(frag, i);
                }
                j = k + 1;
            }
        }
        int n = that.fieldBeginIndex = smiles.length() > rindex3 ? rindex3 + 1 : 0;
        if (rgmol != null) {
            rgmol.setRoot(rxmol);
            if (rxmol.isAbsStereo()) {
                rgmol.setAbsStereo(true);
            }
        }
        that.doubleBondFixes = doubleBondFixes;
        that.molHasRing = molHasRing;
        return ret;
    }

    static void setupQueryStringsForCT(MoleculeGraph m, String smiles, int[] smilesBondIndex) {
        int n = 0;
        for (int i = 0; i < m.getBondCount(); ++i) {
            if (SmilesImport.checkUpDownBondInQueryString(m.getBond(i).getQuerystr()) == -1) continue;
            ++n;
        }
        int[] querybondIdx = new int[n];
        n = 0;
        for (int i = 0; i < m.getBondCount(); ++i) {
            String qStr = m.getBond(i).getQuerystr();
            if (SmilesImport.checkUpDownBondInQueryString(qStr) == -1) continue;
            querybondIdx[n++] = i;
        }
        BitSet alreadyFoundIdx = new BitSet(smiles.length());
        for (int i = 0; i < querybondIdx.length; ++i) {
            int strPos;
            int strPos2;
            QueryBond b = (QueryBond)m.getBond(querybondIdx[i]);
            String qStr = b.getQuerystr();
            int startIdx = smiles.indexOf(qStr);
            while (alreadyFoundIdx.get(startIdx)) {
                startIdx = smiles.indexOf(qStr, startIdx + 1);
            }
            alreadyFoundIdx.set(startIdx);
            int doubleBondcharIdx = -1;
            if (startIdx - 2 >= 0 && smiles.charAt(startIdx - 2) == '=') {
                doubleBondcharIdx = startIdx - 2;
            } else if (startIdx - 3 >= 0 && smiles.charAt(startIdx - 3) == '=') {
                doubleBondcharIdx = startIdx - 3;
            }
            if (doubleBondcharIdx == -1 && startIdx - 2 >= 0 && smiles.charAt(startIdx - 2) == ']' && (strPos2 = SmilesImportX.findMatching(smiles, startIdx - 1, '[', ']', -1)) - 1 >= 0 && smiles.charAt(strPos2 - 1) == '=') {
                doubleBondcharIdx = strPos2 - 1;
            }
            if (doubleBondcharIdx == -1 && startIdx - 3 >= 0 && smiles.charAt(startIdx - 3) == ']' && (strPos2 = SmilesImportX.findMatching(smiles, startIdx - 2, '[', ']', -1)) - 1 >= 0 && smiles.charAt(strPos2 - 1) == '=') {
                doubleBondcharIdx = strPos2 - 1;
            }
            if (doubleBondcharIdx != -1) {
                SmilesImportX.locateCTBondBefore(m, smiles, doubleBondcharIdx, smilesBondIndex);
            }
            int endIdx = startIdx + qStr.length() - 1;
            doubleBondcharIdx = -1;
            if (startIdx - 1 >= 0 && smiles.charAt(startIdx - 1) == '(' && (strPos = SmilesImportX.findMatching(smiles, startIdx, ')', '(', 1)) != -1 && strPos + 1 < smiles.length() && smiles.charAt(strPos + 1) == '=') {
                doubleBondcharIdx = strPos + 1;
                b.setQuerystr(SmilesImportX.flipBondInString(qStr));
            }
            if (doubleBondcharIdx == -1 && endIdx + 2 < smiles.length() && smiles.charAt(endIdx + 2) == '=') {
                doubleBondcharIdx = endIdx + 2;
            }
            if (doubleBondcharIdx == -1 && endIdx + 1 < smiles.length() && smiles.charAt(endIdx + 1) == '[' && (strPos = SmilesImportX.findMatching(smiles, endIdx, ']', '[', 1)) != -1 && strPos + 1 < smiles.length() && smiles.charAt(strPos + 1) == '=') {
                doubleBondcharIdx = strPos + 1;
            }
            if (doubleBondcharIdx == -1) continue;
            SmilesImportX.locateCTBondAfter(m, smiles, doubleBondcharIdx, smilesBondIndex);
        }
    }

    private static void locateCTBondBefore(MoleculeGraph m, String s, int dPos, int[] smiBondIdx) {
        int sl = s.length();
        for (int i = dPos - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '/') {
                if (!(m.getBond(smiBondIdx[sl - i]) instanceof QueryBond)) continue;
                QueryBond b = (QueryBond)m.getBond(smiBondIdx[sl - i]);
                if (b.getQuerystr() == null) {
                    b.setQuerystr(String.valueOf(c));
                }
                return;
            }
            if (c == ']') {
                i = SmilesImportX.findMatching(s, i, '[', ']', -1);
                continue;
            }
            if (c != ')') continue;
            i = SmilesImportX.findMatching(s, i, '(', ')', -1) - 2;
        }
    }

    private static void locateCTBondAfter(MoleculeGraph m, String s, int dPos, int[] smiBondIdx) {
        int sl = s.length();
        for (int i = dPos + 1; i < sl; ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '/') {
                boolean isSingle;
                if (!(m.getBond(smiBondIdx[sl - i]) instanceof QueryBond)) continue;
                QueryBond b = (QueryBond)m.getBond(smiBondIdx[i]);
                boolean bl = isSingle = b.getType() == 1;
                if (b.getQuerystr() == null) {
                    b.setQuerystr(String.valueOf(c));
                }
                if (isSingle) {
                    b.setFlags(1, 15);
                }
                return;
            }
            if (c == '[' && (i = SmilesImportX.findMatching(s, i + 1, ']', '[', 1)) == -1) break;
        }
    }

    private static int findMatching(String s, int start, char match, char inc, int dir) {
        int nb = 0;
        for (int j = start; j >= 0 && j < s.length(); j += dir) {
            if (s.charAt(j) == match) {
                if (nb == 0) {
                    return j;
                }
                --nb;
                continue;
            }
            if (s.charAt(j) != inc) continue;
            ++nb;
        }
        return -1;
    }

    private static String flipBondInString(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '/') {
                chars[i] = 92;
                continue;
            }
            if (c != '\\') continue;
            chars[i] = 47;
        }
        return new String(chars);
    }

    public static void joinCommonRxnComponents(RxnMolecule rxn) {
        SelectionMolecule merged;
        Molecule m2;
        int j;
        int componentID;
        Molecule m1;
        int i;
        for (i = 0; i < rxn.getReactantCount(); ++i) {
            m1 = rxn.getReactant(i);
            if (m1 == null || (componentID = m1.getAtom(0).getQPropAsInt("c")) < 0) continue;
            for (j = i + 1; j < rxn.getReactantCount(); ++j) {
                m2 = rxn.getReactant(j);
                if (m2 == null || componentID != m2.getAtom(0).getQPropAsInt("c")) continue;
                merged = new SelectionMolecule();
                merged.fuse(m1, false);
                merged.fuse(m2, false);
                rxn.mergeComponentParts(merged, 0, true);
            }
        }
        for (i = 0; i < rxn.getAgentCount(); ++i) {
            m1 = rxn.getAgent(i);
            if (m1 == null || (componentID = m1.getAtom(0).getQPropAsInt("c")) < 0) continue;
            for (j = i + 1; j < rxn.getAgentCount(); ++j) {
                m2 = rxn.getAgent(j);
                if (m2 == null || componentID != m2.getAtom(0).getQPropAsInt("c")) continue;
                merged = new SelectionMolecule();
                merged.fuse(m1, false);
                merged.fuse(m2, false);
                rxn.mergeComponentParts(merged, 2, true);
            }
        }
        for (i = 0; i < rxn.getProductCount(); ++i) {
            m1 = rxn.getProduct(i);
            if (m1 == null || (componentID = m1.getAtom(0).getQPropAsInt("c")) < 0) continue;
            for (j = i + 1; j < rxn.getProductCount(); ++j) {
                m2 = rxn.getProduct(j);
                if (m2 == null || componentID != m2.getAtom(0).getQPropAsInt("c")) continue;
                merged = new SelectionMolecule();
                merged.fuse(m1, false);
                merged.fuse(m2, false);
                rxn.mergeComponentParts(merged, 1, true);
            }
        }
    }
}

