/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.tripos;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class AtomTypeAssign {
    private static final double SP3MAX = 1.9896753472735356;
    private static final double SPMIN = 2.792526803190927;
    private static final double MAY_BE_SP2 = 2.129301687433082;
    private String[] types;
    private boolean[] isorg;
    private int[] redo;
    Molecule mol;

    public AtomTypeAssign(Molecule m) {
        String type;
        int a;
        int nedges;
        MolAtom atom;
        int i;
        int na = m.getAtomCount();
        this.types = new String[na];
        this.mol = m;
        this.isorg = new boolean[na];
        this.redo = new int[na];
        for (i = 0; i < na; ++i) {
            atom = m.getAtom(i);
            nedges = atom.getBondCount();
            a = atom.getAtno();
            if (atom.isQuery()) {
                type = "X";
                continue;
            }
            type = atom.getSymbol();
            this.isorg[i] = a == 1 || a >= 6 && a <= 8 || a == 15 || a == 16;
            int freeox = this.countFreeOx(m, i);
            if (a == 1) {
                MolAtom other;
                type = "H";
                if (nedges == 1 && (other = atom.getLigand(0)).getAtno() == 6) {
                    type = "HC";
                }
            } else if (this.isorg[i]) {
                MolBond bl;
                MolBond bk;
                if (nedges == 4) {
                    switch (a) {
                        case 5: {
                            type = freeox >= 3 ? "Bac" : (freeox >= 1 ? "Box" : "B");
                            break;
                        }
                        case 6: {
                            type = "C3";
                            break;
                        }
                        case 7: {
                            type = freeox >= 1 ? "Nox" : "N3+";
                            break;
                        }
                        case 15: {
                            type = freeox >= 2 ? "Pac" : (freeox == 1 ? "Pox" : "P3+");
                            break;
                        }
                        case 16: {
                            type = freeox >= 3 ? "Sac" : (freeox >= 1 ? "Sox" : "S");
                        }
                    }
                } else if (nedges == 3) {
                    double angle3;
                    double angle2;
                    bk = atom.getBond(0);
                    bl = atom.getBond(1);
                    MolBond bm = atom.getBond(2);
                    double angle1 = this.bondAngle(atom, bk, bl);
                    boolean small = (angle1 + (angle2 = this.bondAngle(atom, bk, bm)) + (angle3 = this.bondAngle(atom, bl, bm))) / 3.0 < 1.9896753472735356;
                    switch (a) {
                        case 5: {
                            type = freeox >= 1 ? "Box" : "B";
                            break;
                        }
                        case 6: {
                            type = small ? "C3" : (freeox >= 2 ? "Cac" : "C2");
                            break;
                        }
                        case 7: {
                            type = small ? "N3" : (freeox >= 2 ? "Ntr" : "Npl");
                            break;
                        }
                        case 16: {
                            type = freeox >= 1 ? "Sox" : "S3+";
                        }
                    }
                } else if (nedges == 2) {
                    bk = atom.getBond(0);
                    double angle1 = this.bondAngle(atom, bk, bl = atom.getBond(1));
                    boolean sp3max = angle1 <= 1.9896753472735356;
                    boolean spmin = angle1 <= 2.792526803190927;
                    boolean maybes2 = angle1 < 2.129301687433082;
                    switch (a) {
                        case 6: {
                            if (sp3max) {
                                type = "C3";
                                this.redo[i] = 1;
                                break;
                            }
                            if (spmin) {
                                type = "C2";
                                this.redo[i] = 3;
                                break;
                            }
                            type = "C1";
                            break;
                        }
                        case 7: {
                            if (sp3max) {
                                type = "N3";
                                this.redo[i] = 2;
                                break;
                            }
                            type = spmin ? "Npl" : "N1";
                            break;
                        }
                        case 8: {
                            type = "O3";
                            break;
                        }
                        case 16: {
                            type = "S3";
                        }
                    }
                }
            }
            this.types[i] = type;
        }
        for (i = 0; i < na; ++i) {
            atom = m.getAtom(i);
            nedges = atom.getBondCount();
            a = atom.getAtno();
            if (nedges != 1) continue;
            MolBond b1 = atom.getBond(0);
            double l1 = b1.getLength();
            MolAtom atom1 = b1.getOtherAtom(atom);
            int a1 = atom1.getAtno();
            int j = m.indexOf(atom1);
            String type2 = this.types[i];
            String type1 = this.types[j];
            switch (a) {
                case 6: {
                    if ("C".equals(type2)) {
                        type2 = type1.startsWith("C1") && l1 <= 1.22 ? "C1" : (a1 == 6 && l1 <= 1.41 ? "C2" : "C3");
                    }
                    if (a1 != 7) break;
                    if (l1 <= 1.37) {
                        type2 = "C2";
                        break;
                    }
                    type2 = "C3";
                    break;
                }
                case 7: {
                    if (!"N".equals(type2)) break;
                    if (type1.startsWith("C1") && l1 <= 1.2) {
                        type2 = "N1";
                        break;
                    }
                    if ((type1.startsWith("C2") || type1.startsWith("C3")) && l1 > 1.38 || type1.startsWith("N3") && l1 > 1.43 || type1.startsWith("Npl") && l1 > 1.41) {
                        type2 = "N3";
                        break;
                    }
                    type2 = "Npl";
                    break;
                }
                case 8: {
                    if (!"O".equals(type2)) break;
                    if ("Cac Pac Sac Ntr".indexOf(type1) != -1) {
                        type2 = "O-";
                        break;
                    }
                    if ("Nox Pox Sox".indexOf(type1) != -1) {
                        type2 = "O2";
                        break;
                    }
                    if (a1 == 6 && l1 <= 1.3) {
                        type2 = "O2";
                        type1 = "C2";
                        this.redo[j] = 0;
                        break;
                    }
                    if ("As".equals(type1) && l1 <= 1.685) {
                        type2 = "O2";
                        break;
                    }
                    type2 = "O3";
                    break;
                }
                case 16: {
                    if (!"S".equals(type2)) break;
                    if (a1 == 15) {
                        type2 = "S2";
                        break;
                    }
                    if (a1 == 6 && l1 <= 1.76) {
                        type2 = "S2";
                        type1 = "C2";
                        this.redo[j] = 0;
                        break;
                    }
                    type2 = "As".equals(type1) && l1 <= 2.11 ? "S2" : "S3";
                }
            }
            this.types[i] = type2;
            this.types[j] = type1;
        }
        for (i = 0; i < na; ++i) {
            atom = m.getAtom(i);
            nedges = atom.getBondCount();
            a = atom.getAtno();
            type = this.types[i];
            switch (this.redo[i]) {
                case 1: {
                    MolBond b;
                    int k;
                    for (k = 0; k < nedges; ++k) {
                        b = atom.getBond(k);
                        MolAtom atomj = b.getOtherAtom(atom);
                        int aj = atomj.getAtno();
                        double l = b.getLength();
                        if (!(l <= 1.42 && aj == 6) && (!(l <= 1.41) || aj != 7)) continue;
                        type = "C2";
                    }
                    for (k = 0; k < nedges; ++k) {
                        b = atom.getBond(k);
                        MolAtom atomj = b.getOtherAtom(atom);
                        int aj = atomj.getAtno();
                        double l = b.getLength();
                        if (!(l > 1.53 && aj == 6 || l > 1.46 && aj == 7) && (!(l > 1.44) || aj != 8)) continue;
                        type = "C3";
                    }
                    break;
                }
                case 2: {
                    MolBond b;
                    int k;
                    for (k = 0; k < nedges; ++k) {
                        b = atom.getBond(k);
                        MolAtom atomj = b.getOtherAtom(atom);
                        int aj = atomj.getAtno();
                        double l = b.getLength();
                        if (!(l <= 1.38 && aj == 6) && (!(l <= 1.32) || aj != 7)) continue;
                        type = "Npl";
                    }
                    break;
                }
                case 3: {
                    MolBond b;
                    int k;
                    boolean flag = false;
                    for (k = 0; k < nedges; ++k) {
                        b = atom.getBond(k);
                        MolAtom atomj = b.getOtherAtom(atom);
                        int aj = atomj.getAtno();
                        double l = b.getLength();
                        if (!(l <= 1.42 && aj == 6) && (!(l <= 1.41) || aj != 7)) continue;
                        type = "C2";
                        flag = true;
                    }
                    if (flag) break;
                    for (k = 0; k < nedges; ++k) {
                        b = atom.getBond(k);
                        MolAtom atomj = b.getOtherAtom(atom);
                        int aj = atomj.getAtno();
                        double l = b.getLength();
                        if (!(l > 1.53 && aj == 6 || l > 1.46 && aj == 7 || l > 1.44 && aj == 8) && (!(l > 1.45) || aj != 6 || flag)) continue;
                        type = "C3";
                        flag = true;
                    }
                    break;
                }
            }
            this.types[i] = type;
        }
        for (i = 0; i < na; ++i) {
            if (!"C2".equals(this.types[i])) continue;
            boolean flag = false;
            MolAtom atom2 = m.getAtom(i);
            int nedges2 = atom2.getBondCount();
            int a2 = atom2.getAtno();
            for (int k = 0; k < nedges2; ++k) {
                MolBond b = atom2.getBond(k);
                MolAtom atomj = b.getOtherAtom(atom2);
                int aj = atomj.getAtno();
                int j = m.indexOf(atomj);
                if ("C3 DC HC N3 N3+ O3".indexOf(this.types[j]) != -1 || "Pac Sac Sox C1 S3 Cac".indexOf(this.types[j]) != -1) continue;
                flag = true;
            }
            if (flag) continue;
            this.types[i] = "C3";
        }
        for (i = 0; i < na; ++i) {
            String typej;
            int k;
            MolAtom atom3 = m.getAtom(i);
            int nedges3 = atom3.getBondCount();
            a = atom3.getAtno();
            boolean no_plus = true;
            boolean protonated = true;
            String type3 = this.types[i];
            if ("N3".equals(type3)) {
                for (k = 0; k < nedges3; ++k) {
                    MolAtom atomj = atom3.getLigand(k);
                    int aj = atomj.getAtno();
                    int j = m.indexOf(atomj);
                    typej = this.types[j];
                    if (nedges3 == 2 && "Car C2 Sox Sac Pac So2 ".indexOf(typej.concat(" ")) != -1) {
                        protonated = false;
                        type3 = "Npl";
                        break;
                    }
                    if ("C3".equals(typej) || aj == 1) continue;
                    protonated = false;
                }
                if (protonated) {
                    type3 = "N3+";
                }
            } else if ("C2".equals(type3)) {
                int j;
                int k2;
                int n = 0;
                for (k2 = 0; k2 < nedges3; ++k2) {
                    MolAtom atomj = atom3.getLigand(k2);
                    j = m.indexOf(atomj);
                    typej = this.types[j];
                    if ("Npl N2 Ng+ ".indexOf(typej.concat(" ")) == -1) continue;
                    ++n;
                }
                if (n == 3) {
                    type3 = "C+";
                    for (k2 = 0; k2 < nedges3; ++k2) {
                        MolAtom atomj = atom3.getLigand(k2);
                        j = m.indexOf(atomj);
                        this.types[j] = "Ng+";
                    }
                }
            } else if ("Cac".equals(type3)) {
                for (k = 0; k < nedges3; ++k) {
                    MolAtom atomj = atom3.getLigand(k);
                    int j = m.indexOf(atomj);
                    if (!this.types[j].startsWith("O") || this.countHeavy(atomj) != 1) continue;
                    this.types[j] = "O-";
                }
            }
            this.types[i] = type3;
        }
    }

    private int countHeavy(MolAtom a) {
        int n = 0;
        for (int i = a.getBondCount() - 1; i >= 0; --i) {
            MolAtom neighbor = a.getLigand(i);
            if (neighbor.getAtno() <= 1) continue;
            ++n;
        }
        return n;
    }

    private int countFreeOx(Molecule m, int i) {
        MolAtom atom = m.getAtom(i);
        int count = 0;
        for (int j = 0; j < atom.getBondCount(); ++j) {
            MolAtom other = atom.getLigand(j);
            if (other.getAtno() != 8 || this.countHeavy(other) != 1) continue;
            ++count;
        }
        return count;
    }

    public String getType(int i) {
        return this.types[i];
    }

    private double bondAngle(MolAtom b, MolBond b1, MolBond b2) {
        double dist = b1.getLength() * b2.getLength();
        if (dist >= 5.0E-8) {
            MolAtom a = b1.getOtherAtom(b);
            MolAtom c = b2.getOtherAtom(b);
            double costheta = ((a.getX() - b.getX()) * (c.getX() - b.getX()) + (a.getY() - b.getY()) * (c.getY() - b.getY()) + (a.getZ() - b.getZ()) * (c.getZ() - b.getZ())) / dist;
            if (costheta > -0.99995) {
                return Math.acos(costheta);
            }
        }
        return Math.PI;
    }
}

