/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.tripos;

import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.formats.AbstractMRecordReader;
import chemaxon.struc.MPropertyContainer;
import java.io.IOException;
import java.io.InputStream;

public class Mol2RecordReader
extends AbstractMRecordReader {
    public Mol2RecordReader(InputStream istr, String opts) throws IOException {
        super(istr, opts);
    }

    @Override
    public MRecord nextRecord() throws MRecordParseException, IOException {
        return this.nextRecord(false);
    }

    @Override
    public MRecord skipRecord() throws MRecordParseException, IOException {
        return this.nextRecord(true);
    }

    private MRecord nextRecord(boolean skip) throws MRecordParseException, IOException {
        String line;
        boolean insidemol = false;
        StringBuffer sb = skip ? null : new StringBuffer();
        long startpos = this.getFilePointer();
        int lineno = this.getLineCount();
        int n = 0;
        while ((line = this.readLine()) != null) {
            if (line.startsWith("@<TRIPOS>MOLECULE")) {
                if (insidemol) {
                    this.putBackLine();
                    return this.endMolecule(sb != null ? sb.toString() : null, startpos, lineno);
                }
                insidemol = true;
            }
            this.appendLine(sb, line);
            ++n;
        }
        return n != 0 ? this.endMolecule(sb != null ? sb.toString() : null, startpos, lineno) : null;
    }

    private MRecord endMolecule(String str, long startpos, int lineno) {
        boolean skip = str == null;
        int[] map = this.endRecord(skip);
        MPropertyContainer pc = skip ? null : new MPropertyContainer();
        long endpos = this.getFilePointer();
        return new MRecord(startpos, endpos, lineno, str, pc, map);
    }
}

