/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.tripos;

import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.tripos.AtomTypeAssign;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SybylExport
extends MolExportModule {
    private static Hashtable atomtypes = new Hashtable();

    @Override
    public Object convert(Molecule mol) {
        mol = this.preconvert(mol);
        StringBuffer s = this.stringBuffer;
        s.setLength(0);
        AtomTypeAssign ata = new AtomTypeAssign(mol);
        int na = mol.getAtomCount();
        this.appendRight(na, 4, ' ');
        s.append(" MOL");
        this.appendRight(mol.getName(), 20, ' ');
        this.appendRight("0", 12, ' ');
        s.append("\n");
        for (int i = 0; i < na; ++i) {
            MolAtom a = mol.getAtom(i);
            this.appendRight(i + 1, 4, ' ');
            Integer itype = (Integer)atomtypes.get(ata.getType(i));
            int type = itype == null ? 0 : itype;
            this.appendRight(type, 4, ' ');
            this.appendRight(a.getX());
            this.appendRight(a.getY());
            this.appendRight(a.getZ());
            s.append(a.getSymbol());
            s.append("\n");
        }
        int nb = mol.getBondCount();
        this.appendRight(nb, 4, ' ');
        s.append(" MOL\n");
        for (int i = 0; i < nb; ++i) {
            MolBond b = mol.getBond(i);
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            int j1 = mol.indexOf(a1);
            int j2 = mol.indexOf(a2);
            this.appendRight(i + 1, 4, ' ');
            this.appendRight(j1 + 1, 4, ' ');
            this.appendRight(j2 + 1, 4, ' ');
            s.append("         ");
            int t = b.getType();
            if (t == 4) {
                t = 5;
            }
            this.appendRight(t, 4, ' ');
            s.append("\n");
        }
        s.append("   0 MOL\n");
        return s.toString();
    }

    private void appendRight(double t) {
        int iy;
        double y = Math.abs(t);
        int b = (int)(10000.0 * (y - (double)(iy = (int)y)) + 0.5);
        if (b == 10000) {
            ++iy;
        }
        String sb = "0000".concat(String.valueOf(b));
        int l = sb.length();
        String r = String.valueOf(iy).concat(".");
        r = r.concat(sb.substring(l - 4, l));
        r = (t < 0.0 ? "    -" : "     ").concat(r);
        l = r.length();
        this.stringBuffer.append(r.substring(l - 9, l));
    }

    static {
        StringTokenizer st = new StringTokenizer(" X 26 Mn 26 Fe 26 Li 26 Du 26 C3 1 C2 2 C1 4 Cac 2 Cbl 2 C- 1 N3+ 31 N3 5 N2 19 Npl 19 Naz 6 N1 7 Nox 6 Ntr 6 Ng+ 31 O3 8 Oes 8 O2 9 O- 9 S3 10 S 10 S3+ 10 S2 18 Sac 29 So2 30 Sox 30 Bac 26 Box 26 B 26 P3 12 Pac 12 Pox 12 P3+ 12 P 12 HC 13 H- 13 H 13 DC 13 D 13 F 16 Cl 15 Br 14 I 17 Ge 26 Sn 26 Pb 26 Se 26 Te 26 O 8 Lp 20 C. 2 NC 6 N2+ 6 Z0 26 HO 13 H+ 13 HN 13 Cx 1 W 26 Car 3 Nar 11 Nam 28 Na 21 K 22 Ca 23 Al 25 Si 27 OCO2 32 C+ 33 Pd 26 Pt 26 Ni 26 Cu 26 N4 31 C 1 V 0 Zn 0 Cany 33 Nany 33 Oany 33 Sany 33 Rar 33 R 33 Nr 33 Oco2 9 So 30");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            Integer i = Integer.valueOf(st.nextToken());
            atomtypes.put(s, i);
        }
    }
}

