/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.tripos;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.StringTokenizer;

public class SybylImport
extends MolImportModule {
    private String line;
    private int indx;
    private MolInputStream istream;
    private static int[] atypes = new int[35];

    @Override
    public void initMolImport(MolInputStream is) throws IOException {
        this.istream = is;
    }

    @Override
    public boolean readMol(Molecule mol) throws IOException {
        int linecount = 1;
        MolInputStream mis = this.istream;
        try {
            this.indx = 0;
            this.line = mis.readLine();
            if (this.line == null || this.line.length() < 28) {
                return false;
            }
            int na = this.atoi(4);
            mol.clearForImport("sybyl");
            mol.setName(this.line.substring(8, 28).trim());
            boolean allinorigin = true;
            for (int i = 0; i < na; ++i) {
                boolean inorigin;
                this.indx = 0;
                ++linecount;
                this.line = mis.readLine();
                if (this.line == null || this.line.length() < 36) {
                    throw new MolFormatException(String.valueOf(linecount) + ": atom " + "line too short");
                }
                int atype = Integer.parseInt(this.line.substring(4, 8).trim());
                double x = Double.valueOf(this.line.substring(8, 17));
                double y = Double.valueOf(this.line.substring(17, 26));
                double z = Double.valueOf(this.line.substring(26, 35));
                boolean bl = inorigin = x > -5.0E-5 && x < 5.0E-5 && y > -5.0E-5 && y < 5.0E-5;
                if (z < -5.0E-5 || z > 5.0E-5) {
                    mol.setDim(3);
                    inorigin = false;
                }
                if (allinorigin && !inorigin) {
                    allinorigin = false;
                }
                boolean charge = false;
                String aaa = this.line.substring(35);
                int atno = 0;
                if (atype >= 0 && atype < atypes.length) {
                    atno = atypes[atype];
                }
                if (atno == 0) {
                    atno = MolAtom.numOf(aaa);
                }
                if (atno == 0) {
                    throw new MolFormatException(String.valueOf(linecount) + ": unknown atom type \"" + aaa + "\"");
                }
                MolAtom a = mol.reuseAtom(atno, i);
                a.setForSpecIsotopeSymbol(aaa);
                a.setXYZ(x, y, z);
            }
            if (allinorigin) {
                mol.setDim(0);
            }
            this.indx = 0;
            ++linecount;
            this.line = mis.readLine();
            if (this.line == null || this.line.length() < 4) {
                throw new MolFormatException(String.valueOf(linecount) + ": line too short");
            }
            int nb = this.atoi(4);
            for (int j = 0; j < nb; ++j) {
                ++linecount;
                this.indx = 0;
                this.line = mis.readLine();
                if (this.line == null || this.line.length() < 25) {
                    throw new MolFormatException(String.valueOf(linecount) + ": bond " + "line too short");
                }
                int i = this.atoi(4);
                int i1 = this.atoi(4) - 1;
                int i2 = this.atoi(4) - 1;
                int t = this.atoi(13);
                if (t == 5) {
                    t = 4;
                }
                if (i1 < 0 || i1 >= na || i1 < 0 || i1 >= na || t < 1 || t > 4 && t != 8) {
                    throw new MolFormatException(String.valueOf(linecount) + ": bond error");
                }
                MolBond b = new MolBond(mol.getAtom(i1), mol.getAtom(i2), t);
                mol.add(b);
            }
            this.indx = 0;
            ++linecount;
            this.line = mis.readLine();
            if (this.line == null || this.line.length() < 4) {
                throw new MolFormatException(String.valueOf(linecount) + ": line too short");
            }
            int n0 = this.atoi(4);
            if (n0 != 0) {
                throw new MolFormatException(String.valueOf(linecount) + ": wrong last line");
            }
            mol.endReuse(na);
        }
        catch (NumberFormatException e) {
            throw new MolFormatException(String.valueOf(linecount) + ": error in line");
        }
        mol.valenceCheck();
        return true;
    }

    @Override
    public Molecule createMol() {
        return new Molecule();
    }

    public boolean isSkippingSupported() {
        return false;
    }

    public boolean skipMol() {
        return false;
    }

    public boolean skipToNext() {
        return false;
    }

    private int atoi(int w) {
        int i = this.indx;
        if (this.line.length() < i + w) {
            return 0;
        }
        String s = this.line;
        while (s.charAt(i) == ' ') {
            ++i;
            --w;
        }
        this.indx = i + w;
        return Integer.parseInt(s.substring(i, this.indx));
    }

    static {
        StringTokenizer st = new StringTokenizer("0 6 6 6 6 7 7 7 8 8 16 7 15 1 35 17 9 53 16 7 0 11 19 20 3 13 0 14 7 16 16 7 6 6 6 ");
        int i = 0;
        while (st.hasMoreElements()) {
            SybylImport.atypes[i] = Integer.parseInt(st.nextToken());
            ++i;
        }
    }
}

