/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.vectgraphics;

import chemaxon.marvin.io.formats.vectgraphics.VectGraphicsExport;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.pdf.PDFGraphics2D;

public class PdfExport
extends VectGraphicsExport {
    public PdfExport() throws ClassNotFoundException, UnsupportedClassVersionError {
        super("PDF", "org.freehep.graphicsio.pdf.PDFGraphics2D");
    }

    @Override
    protected VectorGraphics newVectorGraphics(OutputStream out, Dimension d) {
        return new PDFGraphics2D(out, d);
    }

    @Override
    public Object callback(String method, Object arg) {
        PDFGraphics2D pg2d = null;
        if (method.equals("createPdfDocument")) {
            Object[] args = (Object[])arg;
            OutputStream out = (OutputStream)args[0];
            Dimension d = (Dimension)args[1];
            Boolean mpage = (Boolean)args[2];
            VectorGraphics vg = this.newVectorGraphics(out, d);
            if (!(vg instanceof PDFGraphics2D)) {
                return null;
            }
            pg2d = (PDFGraphics2D)vg;
            pg2d.setMultiPage(mpage.booleanValue());
            pg2d.startExport();
            return pg2d;
        }
        if (method.equals("openPage")) {
            Object[] args = (Object[])arg;
            if (!(args[0] instanceof PDFGraphics2D)) {
                return null;
            }
            pg2d = (PDFGraphics2D)args[0];
            Dimension d = (Dimension)args[1];
            String pageNum = (String)args[2];
            try {
                pg2d.openPage(d, pageNum);
            }
            catch (IOException ioex) {
                return ioex;
            }
        } else if (method.equals("closePage")) {
            pg2d = (PDFGraphics2D)arg;
            try {
                pg2d.closePage();
            }
            catch (IOException ioex) {
                return ioex;
            }
        } else if (method.equals("endExport")) {
            pg2d = (PDFGraphics2D)arg;
            pg2d.endExport();
        } else {
            return super.callback(method, arg);
        }
        return null;
    }
}

