/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.vmn;

import chemaxon.common.util.ByteVector;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.MRecordReader;
import chemaxon.marvin.io.formats.vmn.VMNData;
import chemaxon.struc.MPropertyContainer;
import chemaxon.util.ConfigUtils;
import chemaxon.util.ConversionUtil;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.logging.Logger;

public class VMNRecord
extends MRecord {
    private static final Logger logger = Logger.getLogger(VMNRecord.class.getName());
    private static final String NL = "\n";
    private static final String TAB = "\t";
    private static final int BUFFER_SIZE = 128;
    private byte[] bytes = new byte[128];
    private ByteVector mbytes = null;
    private CharsetDecoder asciiDecoder = Charset.forName("US-ASCII").newDecoder();
    VMNData data = null;
    int elementCount = 0;
    String userID = null;
    String molID = null;
    String molFormula = null;
    String fileSegment = null;
    int formulaType = 0;
    int associatedStructureCount = 0;
    char replacementFlag = (char)32;
    int groupCount = 0;
    Group[] groups = null;
    GroupConnection[] groupConnections = null;
    PositionVariation[] positionVariations = null;
    Moiety[] moieties = null;
    AtomAttribute[] atomAttributes = null;

    private static MRecordReader.Position getPosition(MolInputStream mis) {
        return new MRecordReader.Position(1, 1);
    }

    public VMNRecord() {
    }

    public VMNRecord(MolInputStream mis, boolean skip) throws MRecordParseException, IOException {
        try {
            this.read(mis, skip);
        }
        catch (Exception e) {
            logger.throwing("VMNRecord", "VMNRecord", e);
            throw new MRecordParseException(VMNRecord.getPosition(mis), "VMN record reading failed: " + e.getMessage(), e);
        }
    }

    private void read(MolInputStream mis, boolean skip) throws MRecordParseException, IOException {
        this.fileStartPosition = mis.getFilePointer();
        if (!skip) {
            this.properties = new MPropertyContainer();
            this.mbytes = new ByteVector();
        }
        DataInputStream is = new DataInputStream(mis);
        this.parse(is);
        if (!skip) {
            String amn = this.readAMN(is, mis.getPath());
            if (amn != null) {
                this.data = new VMNData(amn);
            }
            this.setMolBytes(this.mbytes.toArray());
        }
        this.fileEndPosition = mis.getFilePointer();
    }

    private String readAMN(DataInputStream is, String path) throws IOException {
        if (path != null) {
            String amnpath;
            String string = amnpath = path.endsWith(".VMN") ? path.substring(0, path.length() - 4) + ".AMN" : path.substring(0, path.length() - 4) + ".amn";
            if (new File(amnpath).exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(amnpath));
                String amn = ConfigUtils.getContent(reader);
                this.mbytes.addElements("AMN:".getBytes("ASCII"));
                int len = ConversionUtil.joinToBytes(this.bytes, amn.length());
                assert (len >= 0 && len <= 4);
                while (len < 4) {
                    this.bytes[len++] = 0;
                }
                this.mbytes.addElements(this.bytes, 0, 4);
                this.mbytes.addElements(amn.getBytes("ASCII"));
                return amn;
            }
        } else {
            int n = is.available();
            if (n > 8 && "AMN:".equals(this.readString(is, 4))) {
                is.readFully(this.bytes, 0, 4);
                if (this.mbytes != null) {
                    this.mbytes.addElements(this.bytes, 0, 4);
                }
                int amnlen = ConversionUtil.joinToInt(this.bytes, 4);
                return this.readString(is, amnlen);
            }
        }
        return null;
    }

    private void parse(DataInputStream is) throws MRecordParseException, IOException {
        this.elementCount = this.readInt(is);
        this.userID = this.readString(is, 8);
        this.molID = this.readString(is, 12);
        this.molFormula = this.readString(is, 64);
        this.fileSegment = this.readString(is, 32);
        this.formulaType = this.readInt(is);
        if (this.formulaType == 2) {
            this.associatedStructureCount = this.readInt(is);
        }
        this.replacementFlag = this.readString(is, 1).charAt(0);
        this.groupCount = this.readInt(is);
        this.groups = new Group[this.groupCount];
        for (int i = 0; i < this.groupCount; ++i) {
            this.groups[i] = new Group();
            this.parse(this.groups[i], is);
        }
        int groupConnectionCount = this.readInt(is);
        this.groupConnections = new GroupConnection[groupConnectionCount];
        for (int i = 0; i < groupConnectionCount; ++i) {
            this.groupConnections[i] = new GroupConnection();
            this.parse(this.groupConnections[i], is);
        }
        int undefAttachmentCount = this.readInt(is);
        this.positionVariations = new PositionVariation[undefAttachmentCount];
        for (int i = 0; i < undefAttachmentCount; ++i) {
            this.positionVariations[i] = new PositionVariation();
            this.parse(this.positionVariations[i], is);
        }
        int moietyCount = this.readInt(is);
        this.moieties = new Moiety[moietyCount];
        for (int i = 0; i < moietyCount; ++i) {
            this.moieties[i] = new Moiety();
            this.parse(this.moieties[i], is);
        }
        int atomAttributeCount = this.readInt(is);
        this.atomAttributes = new AtomAttribute[atomAttributeCount];
        for (int i = 0; i < atomAttributeCount; ++i) {
            this.atomAttributes[i] = new AtomAttribute();
            this.parse(this.atomAttributes[i], is);
        }
    }

    private void parse(Group group, DataInputStream is) throws MRecordParseException, IOException {
        group.ID = this.readInt(is);
        group.undocData = this.readInt(is);
        int atomCount = this.readInt(is);
        group.atoms = new Atom[atomCount];
        for (int i = 0; i < atomCount; ++i) {
            group.atoms[i] = new Atom();
            this.parse(group.atoms[i], is);
        }
    }

    private void parse(Atom atom, DataInputStream is) throws MRecordParseException, IOException {
        atom.type = this.readString(is, 4).trim();
        atom.charge = this.readInt(is);
        atom.implHCount = this.readInt(is);
        atom.X = this.readInt(is);
        atom.Y = this.readInt(is);
        int bondCount = this.readInt(is);
        atom.bonds = new Bond[bondCount];
        for (int i = 0; i < bondCount; ++i) {
            atom.bonds[i] = new Bond();
            this.parse(atom.bonds[i], is);
        }
    }

    private void parse(Bond bond, DataInputStream is) throws MRecordParseException, IOException {
        bond.ligand = this.readInt(is);
        bond.type = this.readInt(is);
        bond.stereo = this.readInt(is);
    }

    private void parse(GroupConnection groupConnection, DataInputStream is) throws MRecordParseException, IOException {
        groupConnection.child = this.readInt(is);
        groupConnection.childAtom = this.readInt(is);
        groupConnection.parent = this.readInt(is);
        groupConnection.parentAtom = this.readInt(is);
    }

    private void parse(PositionVariation attachment, DataInputStream is) throws MRecordParseException, IOException {
        int atomCount = this.readInt(is);
        attachment.atoms = new int[atomCount];
        for (int i = 0; i < atomCount; ++i) {
            attachment.atoms[i] = this.readInt(is);
        }
        int groupCount = this.readInt(is);
        attachment.groups = new int[groupCount];
        for (int i = 0; i < groupCount; ++i) {
            attachment.groups[i] = this.readInt(is);
        }
    }

    private void parse(Moiety moiety, DataInputStream is) throws MRecordParseException, IOException {
        moiety.firstAtom = this.readInt(is);
        moiety.minCoefficient = this.readInt(is);
        moiety.maxCoefficient = this.readInt(is);
    }

    private void parse(AtomAttribute atomAttribute, DataInputStream is) throws MRecordParseException, IOException {
        atomAttribute.type = this.readString(is, 2);
        atomAttribute.group = this.readInt(is);
        atomAttribute.atom = this.readInt(is);
        atomAttribute.value = this.readInt(is);
    }

    private String readString(DataInputStream is, int len) throws IOException {
        if (len > this.bytes.length) {
            this.bytes = new byte[len];
        }
        is.readFully(this.bytes, 0, len);
        if (this.mbytes != null) {
            this.mbytes.addElements(this.bytes, 0, len);
        }
        return this.readString(this.bytes, len);
    }

    private String readString(byte[] bytes, int len) throws IOException {
        VMNRecord.replaceUnreadableBytes(bytes, len);
        return this.asciiDecoder.decode(ByteBuffer.wrap(bytes, 0, len)).toString();
    }

    private static void replaceUnreadableBytes(byte[] bytes, int len) {
        for (int i = 0; i < len; ++i) {
            byte c = bytes[i];
            if (bytes[i] >= 32 || bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 13) continue;
            logger.finer("Unreadable byte found, replacing by space.");
            bytes[i] = 32;
        }
    }

    private int readInt(DataInputStream is) throws IOException {
        is.readFully(this.bytes, 0, 2);
        if (this.mbytes != null) {
            this.mbytes.addElements(this.bytes, 0, 2);
        }
        int value = ConversionUtil.joinToInt(this.bytes, 2);
        if ((this.bytes[1] & 0x80) != 0) {
            value -= 65536;
        }
        return value;
    }

    @Override
    public String getString() {
        return this.getAsString(false);
    }

    public String toString() {
        return this.getAsString(true);
    }

    private String getAsString(boolean debug) {
        StringBuffer b = new StringBuffer();
        b.append((debug ? "elementCount: " : "") + this.elementCount + NL);
        b.append((debug ? "userID: " : "") + this.userID + NL);
        b.append((debug ? "molID: " : "") + this.molID + NL);
        b.append((debug ? "molFormula: " : "") + this.molFormula + NL);
        b.append((debug ? "fileSegment: " : "") + this.fileSegment + NL);
        b.append((debug ? "formulaType: " : "") + this.formulaType + NL);
        b.append((debug ? "associatedStructureCount: " : "") + this.associatedStructureCount + NL);
        b.append((debug ? "replacementFlag: " : "") + this.replacementFlag + NL);
        b.append((debug ? "groupCount: " : "") + this.groupCount + NL);
        b.append(NL);
        if (debug) {
            b.append("Groups:\n");
        }
        for (Group group : this.groups) {
            b.append(this.getAsString(group, debug) + NL);
        }
        b.append(NL);
        b.append((debug ? "groupConnectionCount: " : "") + this.groupConnections.length + NL);
        if (debug) {
            b.append("Child\tChNode\tParent\tPNode\n");
        }
        for (GroupConnection conn : this.groupConnections) {
            b.append("" + conn.child + TAB + conn.childAtom + TAB + conn.parent + TAB + conn.parentAtom + NL);
        }
        b.append(NL);
        b.append((debug ? "posvarCount: " : "") + this.positionVariations.length + NL);
        if (debug) {
            b.append("Position variations:\n");
        }
        for (PositionVariation posvar : this.positionVariations) {
            b.append(this.getAsString(posvar, debug) + NL);
        }
        b.append(NL);
        b.append((debug ? "moietyCount: " : "") + this.moieties.length + NL);
        if (debug) {
            b.append("Moieties:\n");
        }
        for (Moiety moiety : this.moieties) {
            b.append(this.getAsString(moiety, debug) + NL);
        }
        b.append(NL);
        b.append((debug ? "attributeCount: " : "") + this.atomAttributes.length + NL);
        if (debug) {
            b.append("Attributes:\n");
        }
        for (AtomAttribute atomAttribute : this.atomAttributes) {
            b.append(VMNRecord.getAsString(atomAttribute, debug) + NL);
        }
        b.append(NL);
        return new String(b);
    }

    private String getAsString(Group group, boolean debug) {
        StringBuffer b = new StringBuffer();
        b.append((debug ? "ID: " : "") + group.ID + NL);
        b.append((debug ? "undocData: " : "") + group.undocData + NL);
        b.append((debug ? "atomCount: " : "") + group.atoms.length + NL);
        b.append(NL);
        int k = 0;
        for (Atom atom : group.atoms) {
            if (debug) {
                b.append("Atom: " + ++k + " in group: " + group.ID + NL);
            }
            b.append(this.getAsString(atom, debug) + NL);
        }
        return new String(b);
    }

    private String getAsString(Atom atom, boolean debug) {
        StringBuffer b = new StringBuffer();
        b.append((debug ? "type: " : "") + atom.type + NL);
        b.append((debug ? "charge: " : "") + atom.charge + NL);
        b.append((debug ? "implHCount: " : "") + atom.implHCount + NL);
        b.append((debug ? "X: " : "") + atom.X + NL);
        b.append((debug ? "Y: " : "") + atom.Y + NL);
        b.append((debug ? "bondCount: " : "") + atom.bonds.length + NL);
        b.append(NL);
        for (Bond bond : atom.bonds) {
            b.append(this.getAsString(bond, debug) + NL);
        }
        return new String(b);
    }

    private String getAsString(Bond bond, boolean debug) {
        StringBuffer b = new StringBuffer();
        b.append((debug ? "ligand: " : "") + bond.ligand + NL);
        b.append((debug ? "type: " : "") + bond.type + NL);
        b.append((debug ? "stereo: " : "") + bond.stereo + NL);
        return new String(b);
    }

    private String getAsString(PositionVariation posvar, boolean debug) {
        StringBuffer b = new StringBuffer();
        b.append((debug ? "atomCount: " : "") + posvar.atoms.length + NL);
        b.append((debug ? "atoms: " : "") + NL);
        for (int atom : posvar.atoms) {
            b.append(atom + " ");
        }
        b.append((debug ? "groupCount: " : "") + posvar.groups.length + NL);
        b.append((debug ? "groups: " : "") + NL);
        for (int group : posvar.groups) {
            b.append(group + " ");
        }
        return new String(b);
    }

    private String getAsString(Moiety moiety, boolean debug) {
        StringBuffer b = new StringBuffer();
        b.append((debug ? "firstAtom: " : "") + moiety.firstAtom + NL);
        b.append((debug ? "minCoefficient: " : "") + moiety.minCoefficient + NL);
        b.append((debug ? "maxCoefficient: " : "") + moiety.maxCoefficient + NL);
        return new String(b);
    }

    private static String getAsString(AtomAttribute atomAttribute, boolean debug) {
        StringBuffer b = new StringBuffer();
        b.append((debug ? "type: " : "") + atomAttribute.type + NL);
        b.append((debug ? "group: " : "") + atomAttribute.group + NL);
        b.append((debug ? "atom: " : "") + atomAttribute.atom + NL);
        b.append((debug ? "value: " : "") + atomAttribute.value + NL);
        return new String(b);
    }

    static class AtomAttribute {
        String type = null;
        int group = 0;
        int atom = 0;
        int value = 0;

        AtomAttribute() {
        }

        public String toString() {
            return VMNRecord.getAsString(this, true);
        }
    }

    static class Moiety {
        int firstAtom = 0;
        int minCoefficient = 0;
        int maxCoefficient = 0;

        Moiety() {
        }
    }

    static class PositionVariation {
        int[] atoms = null;
        int[] groups = null;

        PositionVariation() {
        }
    }

    static class GroupConnection {
        int child = 0;
        int childAtom = 0;
        int parent = 0;
        int parentAtom = 0;

        GroupConnection() {
        }

        public String toString() {
            return "child: " + this.child + " childAtom: " + this.childAtom + " parent: " + this.parent + " parentAtom: " + this.parentAtom;
        }
    }

    static class Bond {
        int ligand = -1;
        int type = 0;
        int stereo = 0;

        Bond() {
        }
    }

    static class Atom {
        String type = null;
        int charge = 0;
        int implHCount = 0;
        int X = 0;
        int Y = 0;
        Bond[] bonds = null;
        ArrayList<Attribute> attributes = null;

        Atom() {
        }

        void addAttribute(String type, int value) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(new Attribute(type, value));
        }

        int getAttributeValue(String type) {
            if (this.attributes == null) {
                return -1;
            }
            for (Attribute a : this.attributes) {
                if (!a.type.equals(type)) continue;
                return a.value;
            }
            return -1;
        }

        static class Attribute {
            String type = null;
            int value;

            Attribute(String type, int value) {
                this.type = type;
                this.value = value;
            }
        }
    }

    static class Group {
        int ID = 0;
        int undocData = 0;
        Atom[] atoms = null;

        Group() {
        }
    }
}

