/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.xyz;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.modules.BondsFromCoords;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class XYZImport
extends MolImportModule {
    private String currentLine;
    private int currentColumn;
    private int lineCount;
    protected MolInputStream istream;
    protected BondsFromCoords bondsFromCoords;

    @Override
    public void setOptions(String opts) {
        this.bondsFromCoords = new BondsFromCoords();
        this.bondsFromCoords.initParser();
        if (opts != null) {
            int i = 0;
            while (i < opts.length()) {
                char c = opts.charAt(i);
                int j = this.bondsFromCoords.parseOption(opts, i);
                if (j != i) {
                    i = j;
                    continue;
                }
                ++i;
            }
        }
    }

    @Override
    public void initMolImport(MolInputStream is) throws IOException {
        this.istream = is;
    }

    @Override
    public boolean readMol(Molecule mol) throws IOException {
        try {
            int i;
            String l;
            do {
                if ((l = this.readLine()) != null) continue;
                return false;
            } while ((l = l.trim()).length() != 0 && l.charAt(0) == '#');
            int na = -1;
            String name = "";
            String energystr = null;
            if (l.length() > 0) {
                na = this.readInteger();
                if (na < 0) {
                    throw new MolFormatException("Atom count is negative: " + na);
                }
                l = this.readLine();
                if (l == null) {
                    throw new MolFormatException("Cannot read molecule name line in XYZ file");
                }
                i = l.indexOf(9);
                if (i < 0) {
                    i = l.length();
                } else {
                    String s = l.substring(i + 1).trim();
                    if (s.length() != 0) {
                        try {
                            Double.valueOf(s);
                            energystr = s;
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                }
            } else {
                return false;
            }
            name = l.substring(0, i).trim();
            l = this.readLine();
            mol.clearForImport("xyz");
            mol.setName(name);
            if (energystr != null) {
                mol.setProperty("Energy", energystr);
            }
            mol.setDim(3);
            String[] sym = new String[1];
            i = 0;
            while (l != null) {
                int atno = this.readAtno(sym);
                double x = this.readCoordinate();
                double y = this.readCoordinate();
                double z = this.readCoordinate();
                MolAtom a = mol.reuseAtom(atno, i);
                a.setForSpecIsotopeSymbol(sym[0]);
                a.setXYZ(x, y, z);
                l = i < na - 1 || na < 0 ? this.readLine() : null;
                ++i;
            }
            if (na >= 0 && na != i) {
                throw new MolFormatException("File truncated, only " + i + " atoms be read from " + na);
            }
            mol.endReuse(i);
            this.bondsFromCoords.calc(mol);
        }
        catch (NumberFormatException e) {
            throw new MolFormatException("Invalid number");
        }
        return true;
    }

    @Override
    public Molecule createMol() {
        return new Molecule();
    }

    protected void readws() {
        int i;
        String l = this.currentLine;
        for (i = this.currentColumn; i < l.length(); ++i) {
            char c = l.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            this.currentColumn = i;
            return;
        }
        this.currentColumn = i;
    }

    protected int findWordEnd() {
        int i;
        String l = this.currentLine;
        for (i = this.currentColumn; i < l.length(); ++i) {
            char c = l.charAt(i);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') continue;
            return i;
        }
        return i;
    }

    private int readAtno(String[] sym) {
        this.readws();
        String l = this.currentLine;
        int start = this.currentColumn;
        int end = this.findWordEnd();
        if (start < end) {
            String c0 = l.substring(start, start + 1).toUpperCase();
            int j = end > start + 2 ? start + 2 : end;
            String s = c0 + l.substring(start + 1, j);
            int atno = MolAtom.numOf(s);
            sym[0] = s;
            if (atno == 0) {
                sym[0] = s = c0 + l.substring(start + 1, end).toLowerCase();
                atno = MolAtom.numOf(s);
            }
            if (atno == 0 && j == start + 2) {
                sym[0] = c0;
                atno = MolAtom.numOf(c0);
            }
            this.currentColumn = end;
            return atno;
        }
        sym[0] = null;
        return 0;
    }

    protected int readInteger() throws IOException {
        this.readws();
        int i = this.currentColumn;
        int j = this.findWordEnd();
        if (i < j) {
            try {
                String s = this.currentLine.substring(i, j);
                this.currentColumn = j;
                return Integer.valueOf(s);
            }
            catch (NumberFormatException ex) {
                throw new MolFormatException("Cannot read an integer");
            }
        }
        throw new MolFormatException("Integer missing");
    }

    protected double readCoordinate() throws IOException {
        return this.readCoordinate(false);
    }

    protected double readCoordinate(boolean readLineIfMissing) throws IOException {
        this.readws();
        int i = this.currentColumn;
        int j = this.findWordEnd();
        if (i < j) {
            try {
                String s = this.currentLine.substring(i, j);
                this.currentColumn = j;
                return Double.valueOf(s);
            }
            catch (NumberFormatException ex) {
                throw new MolFormatException("Cannot read a coordinate");
            }
        }
        if (readLineIfMissing && this.readLine() != null) {
            return this.readCoordinate(false);
        }
        throw new MolFormatException("Coordinate missing");
    }

    protected String readLine() throws IOException {
        ++this.lineCount;
        this.currentColumn = 0;
        this.currentLine = this.istream.readLine();
        return this.currentLine;
    }
}

