/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.xyz;

import chemaxon.formats.recognizer.XYZRecognizer;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.formats.AbstractMRecordReader;
import chemaxon.struc.MPropertyContainer;
import java.io.IOException;
import java.io.InputStream;

public class XYZRecordReader
extends AbstractMRecordReader {
    public XYZRecordReader(InputStream istr, String opts) throws IOException {
        super(istr, opts);
    }

    @Override
    public MRecord nextRecord() throws MRecordParseException, IOException {
        String line;
        long startpos = this.getFilePointer();
        int lineno = this.getLineCount();
        boolean insidemol = false;
        StringBuffer sb = new StringBuffer();
        while ((line = this.readLine()) != null) {
            if (XYZRecognizer.isXYZAtomLine(line)) {
                insidemol = true;
            } else if (insidemol) {
                insidemol = false;
                this.putBackLine();
                return this.endMolecule(sb.toString(), startpos, lineno);
            }
            this.appendLine(sb, line);
        }
        return sb.length() != 0 ? this.endMolecule(sb.toString(), startpos, lineno) : null;
    }

    @Override
    public MRecord skipRecord() throws MRecordParseException, IOException {
        String line;
        long startpos = this.getFilePointer();
        int lineno = this.getLineCount();
        boolean insidemol = false;
        int n = 0;
        while ((line = this.readLine()) != null) {
            if (XYZRecognizer.isXYZAtomLine(line)) {
                insidemol = true;
            } else if (insidemol) {
                insidemol = false;
                this.putBackLine();
                return this.endMolecule(null, startpos, lineno);
            }
            ++n;
        }
        return n != 0 ? this.endMolecule(null, startpos, lineno) : null;
    }

    protected MRecord endMolecule(String str, long startpos, int lineno) {
        return this.endMolecule(str, str == null ? null : new MPropertyContainer(), startpos, lineno);
    }

    protected MRecord endMolecule(String str, MPropertyContainer pc, long startpos, int lineno) {
        int[] map = this.endRecord(str == null);
        long endpos = this.getFilePointer();
        return new MRecord(startpos, endpos, lineno, str, pc, map);
    }
}

