/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.image.encoder;

import chemaxon.marvin.io.image.encoder.ImageEncoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;

public final class JpegEncoder
extends ImageEncoder {
    private int quality = 90;

    public JpegEncoder() {
        this.writerFormatStr = "jpg";
    }

    @Override
    protected ImageWriteParam createImageWriterParam() throws IOException {
        ImageWriteParam wparam = super.createImageWriterParam();
        if (wparam.canWriteCompressed()) {
            wparam.setCompressionMode(2);
            wparam.setCompressionQuality((float)this.quality / 100.0f);
            if (this.getCompressionType() != null) {
                wparam.setCompressionType(this.getCompressionType());
            }
        }
        return wparam;
    }

    @Override
    protected IIOMetadata createIIOMetaData() throws IOException {
        return this.createIIOMetaData(false);
    }

    public void setQuality(int q) {
        if (q < 0 || q > 100) {
            throw new IllegalArgumentException("The quality value set to JPEGExport is not between 0 and 100.");
        }
        this.quality = q;
    }

    public int getQuality() {
        return this.quality;
    }

    @Override
    public BufferedImage createImage(BufferedImage image) {
        BufferedImage img = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D g = img.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        return img;
    }
}

