/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.image.exporter;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.common.util.ColorParser;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.formats.MolExporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.image.ImageExportIface;
import chemaxon.marvin.paint.DispOptConsts;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.MolImageSize;
import chemaxon.marvin.util.text.MStringTokenizer;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MRArrow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;

public class ImageExport
extends MolExportModule
implements ImageExportIface {
    protected final int DEFAULT_SIZE = 200;
    protected Color backgroundColor;
    public boolean saveSource = false;
    private String molSource = "";
    private int backgroundColorCode;
    private boolean transparency;
    private Rectangle imageSize;
    private double imageScale;
    private double maxScale = 0.0;
    private int implicitH;
    private int colorScheme;
    private boolean setColoringEnabled;
    private int renderingStyle;
    private double atomSize;
    private double bondSpacing;
    private double wireThickness;
    private double stickThickness;
    private double ballRadius;
    private boolean antialiasing;
    private boolean downwedge_mdl;
    private boolean atommapVisible;
    private boolean atomnumbersVisible;
    private boolean atompropsVisible;
    private boolean valencePropVisible;
    private boolean ligandErrorVisible;
    private boolean atomSymbolVisible;
    private boolean lonepairsVisible;
    private boolean ezVisible;
    private int chiralitySupport;
    private int anybond;
    private Color[] atomSetColors;
    private Color[] bondSetColors;
    private Color[] extraLabelSetColors;
    private boolean lonepairAutoCalc;
    private int carbonVisibility;
    private boolean grinvVisible;
    private boolean bondLengthVisible;
    private boolean valenceErrorVisible;
    private boolean absLabelVisible;
    private MFont atomFont;
    private boolean rgroupsVisible;
    private String ligandOrderVisible;
    private String coordinateBondStyle;
    private String coordinateBondStyleAtMulticenter;

    @Override
    public Object open(String fmtopts, MPropertyContainer props) throws MolExportException {
        this.imageSize = new Rectangle(-1, -1);
        this.imageScale = -1.0;
        this.backgroundColorCode = -1;
        this.backgroundColor = null;
        this.implicitH = -1;
        this.colorScheme = -1;
        this.setColoringEnabled = false;
        this.renderingStyle = -1;
        this.atomSize = 0.4;
        this.bondSpacing = 0.18;
        this.wireThickness = 0.064;
        this.stickThickness = 0.1;
        this.ballRadius = 0.5;
        this.transparency = false;
        this.antialiasing = true;
        this.downwedge_mdl = true;
        this.atommapVisible = false;
        this.atomnumbersVisible = false;
        this.atompropsVisible = false;
        this.valencePropVisible = false;
        this.ligandErrorVisible = false;
        this.atomSymbolVisible = true;
        this.lonepairsVisible = false;
        this.ezVisible = false;
        this.chiralitySupport = 0;
        this.anybond = 0;
        this.atomSetColors = null;
        this.bondSetColors = null;
        this.extraLabelSetColors = null;
        this.lonepairAutoCalc = true;
        this.carbonVisibility = 0x10000000;
        this.grinvVisible = false;
        this.bondLengthVisible = false;
        this.valenceErrorVisible = false;
        this.absLabelVisible = false;
        this.atomFont = null;
        this.rgroupsVisible = true;
        this.ligandOrderVisible = "showOnlyWithDefinition";
        this.coordinateBondStyle = "arrow";
        this.coordinateBondStyleAtMulticenter = "hashed";
        super.open(fmtopts, props);
        Rectangle d = this.imageSize;
        if (d.width < 0 && d.height >= 0) {
            d.width = d.height;
        }
        if (d.height < 0 && d.width >= 0) {
            d.height = d.width;
        }
        if (d.width < 0 && this.imageScale < 0.0) {
            d.height = 200;
            d.width = 200;
        }
        return null;
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        char c;
        int j;
        for (j = i; j < opts.length() && " ,\n\r\t".indexOf(c = opts.charAt(j)) < 0; ++j) {
        }
        String lopt = opts.substring(i, j);
        if (lopt.startsWith("H_")) {
            String s = lopt.substring(2);
            j = ImageExport.findArrayIndex(s, DispOptConsts.IMPLICITH_LEVELS);
            if (j >= 0) {
                this.implicitH = j;
                return i + lopt.length();
            }
            return i;
        }
        j = ImageExport.findArrayIndex(lopt, DispOptConsts.COLOR_SCHEMES);
        if (j >= 0) {
            this.colorScheme = j >= 0 ? j << 6 : -1;
            return i + lopt.length();
        }
        j = ImageExport.findArrayIndex(lopt, DispOptConsts.RENDERING_STYLES);
        if (j >= 0) {
            this.renderingStyle = j >= 0 ? j << 17 : -1;
            return i + lopt.length();
        }
        if (lopt.startsWith("setcolors:")) {
            this.setColoringEnabled = true;
            MStringTokenizer mst = new MStringTokenizer(lopt.substring(10), ':', '\u0000');
            this.atomSetColors = new Color[64];
            this.bondSetColors = new Color[64];
            this.extraLabelSetColors = new Color[64];
            while (mst.hasMoreTokens()) {
                Color c2;
                int seq;
                String s = mst.nextToken();
                if (s.startsWith("a")) {
                    seq = ImageExport.readSetSeq(s);
                    this.atomSetColors[seq] = c2 = ColorParser.parseColor(mst.nextToken());
                    continue;
                }
                if (s.startsWith("b")) {
                    seq = ImageExport.readSetSeq(s);
                    this.bondSetColors[seq] = c2 = ColorParser.parseColor(mst.nextToken());
                    continue;
                }
                if (s.startsWith("l")) {
                    seq = ImageExport.readSetSeq(s);
                    this.extraLabelSetColors[seq] = c2 = ColorParser.parseColor(mst.nextToken());
                    continue;
                }
                throw new IllegalArgumentException("setcolors:" + s + " is neither an atom (a) nor a bond (b) set color" + " definition");
            }
            return i + lopt.length();
        }
        j = ImageExport.nextOpt(opts, i, "setcolors");
        if (j > i) {
            this.setColoringEnabled = true;
            return j;
        }
        if (lopt.startsWith("chiral_")) {
            int l = -1;
            String s = lopt.substring(7);
            for (int k = 0; k < DispOptConsts.RS_OPTIONS.length; ++k) {
                if (!DispOptConsts.RS_OPTIONS[k].equals(s)) continue;
                l = k << 14;
                break;
            }
            if (l < 0) {
                throw new IllegalArgumentException("Bad chirality support value \"" + s + "\"");
            }
            this.chiralitySupport = l;
            return i + lopt.length();
        }
        if (lopt.startsWith("anybond_")) {
            int l = -1;
            int plength = "anybond_".length();
            String s = lopt.substring(plength);
            for (int k = 0; k < DispOptConsts.ANYBOND_STYLES.length; ++k) {
                if (!DispOptConsts.ANYBOND_STYLES[k].equals(s)) continue;
                l = k << 21;
                break;
            }
            if (l < 0) {
                throw new IllegalArgumentException("Bad any bond style value \"" + s + "\"");
            }
            this.anybond = l;
            return i + lopt.length();
        }
        if (lopt.startsWith("downwedge_")) {
            int plength = "downwedge_".length();
            String s = lopt.substring(plength);
            if (s.equals("mdl")) {
                this.downwedge_mdl = true;
            } else if (s.equals("daylight")) {
                this.downwedge_mdl = false;
            } else {
                throw new IllegalArgumentException("Bad down wedge style value \"" + s + "\"");
            }
            return i + lopt.length();
        }
        if (lopt.startsWith("maxscale")) {
            try {
                this.maxScale = Double.valueOf(lopt.substring(8));
                return i + lopt.length();
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Bad maxscale parameter \"" + lopt.substring(8) + "\"");
            }
        }
        if (lopt.startsWith("scale")) {
            try {
                double scale = Double.valueOf(lopt.substring(5));
                if (scale > 0.0) {
                    this.imageScale = scale;
                    return i + lopt.length();
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            throw new IllegalArgumentException("Bad scale parameter \"" + lopt.substring(5) + "\"");
        }
        if (lopt.startsWith("atsiz")) {
            try {
                double x = Double.valueOf(lopt.substring(5));
                if (x > 0.0) {
                    this.atomSize = x;
                    return i + lopt.length();
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            throw new IllegalArgumentException("Bad atom size (atsiz) parameter \"" + lopt.substring(5) + "\"");
        }
        if (lopt.startsWith("bondw")) {
            try {
                double x = Double.valueOf(lopt.substring(5));
                if (x > 0.0) {
                    this.bondSpacing = x;
                    return i + lopt.length();
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            throw new IllegalArgumentException("Bad bond width (bondw) parameter \"" + lopt.substring(5) + "\"");
        }
        if (lopt.startsWith("wireThickness")) {
            int plength = "wireThickness".length();
            try {
                double x = Double.valueOf(lopt.substring(plength));
                if (x > 0.0) {
                    this.wireThickness = x;
                    return i + lopt.length();
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            throw new IllegalArgumentException("Bad bond thickness in wireframe mode (wireThickness) parameter \"" + lopt.substring(plength) + "\"");
        }
        if (lopt.startsWith("stickThickness")) {
            int plength = "stickThickness".length();
            try {
                double x = Double.valueOf(lopt.substring(plength));
                if (x > 0.0) {
                    this.stickThickness = x;
                    return i + lopt.length();
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            throw new IllegalArgumentException("Bad stick diamater for ball and stick mode (stickThickness) parameter \"" + lopt.substring(plength) + "\"");
        }
        if (lopt.startsWith("ballRadius")) {
            int plength = "ballRadius".length();
            try {
                double x = Double.valueOf(lopt.substring(plength));
                if (x > 0.0) {
                    this.ballRadius = x;
                    return i + lopt.length();
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            throw new IllegalArgumentException("Bad ball radius for ball and stick mode (ballRadius) parameter \"" + lopt.substring(plength) + "\"");
        }
        j = ImageExport.nextOpt(opts, i, "transbg");
        if (j > i) {
            this.transparency = true;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "noantialias");
        if (j > i) {
            this.antialiasing = false;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "amap");
        if (j > i) {
            this.atommapVisible = true;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "noatsym");
        if (j > i) {
            this.atomSymbolVisible = false;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "anum");
        if (j > i) {
            this.atomnumbersVisible = true;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "aprop");
        if (j > i) {
            this.atompropsVisible = true;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "valprop");
        if (j > i) {
            this.valencePropVisible = true;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "liganderr");
        if (j > i) {
            this.ligandErrorVisible = true;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "lpexpl");
        if (j > i) {
            this.lonepairAutoCalc = false;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "lp");
        if (j > i) {
            this.lonepairsVisible = true;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "ez");
        if (j > i) {
            this.ezVisible = true;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "grinvVisible");
        if (j > i) {
            this.grinvVisible = true;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "bondLengthVisible");
        if (j > i) {
            this.bondLengthVisible = true;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "valenceErrorVisible");
        if (j > i) {
            this.valenceErrorVisible = true;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "absLabelVisible");
        if (j > i) {
            this.absLabelVisible = true;
            return j;
        }
        j = ImageExport.nextOpt(opts, i, "noRGroups");
        if (j > i) {
            this.rgroupsVisible = false;
            return j;
        }
        if (lopt.startsWith("atomFont:")) {
            int k = j = i + lopt.length();
            if (opts.charAt(j) == " ".charAt(0)) {
                char c3;
                for (k = j; k < opts.length() && ",\n\r\t".indexOf(c3 = opts.charAt(k)) < 0; ++k) {
                }
            }
            this.atomFont = (lopt = opts.substring(i + "atomFont".length() + 1, k)).indexOf("-") >= 0 ? new MFont(lopt) : null;
            return k;
        }
        if (lopt.startsWith("cv_")) {
            int l = -1;
            int plength = "cv_".length();
            String s = lopt.substring(plength);
            for (int k = 0; k < DispOptConsts.CARBON_VIS_STYLES.length; ++k) {
                if (!DispOptConsts.CARBON_VIS_STYLES[k].equals(s)) continue;
                l = k << 28;
                break;
            }
            if (l < 0) {
                throw new IllegalArgumentException("Incorrect carbon visibility style value \"" + s + "\"");
            }
            this.carbonVisibility = l;
            return i + lopt.length();
        }
        if (lopt.startsWith("ligandOrderVisibility_")) {
            String val = lopt.substring("ligandOrderVisibility_".length());
            if (val.equalsIgnoreCase("withDef")) {
                val = "showOnlyWithDefinition";
            }
            this.ligandOrderVisible = val;
            return i + lopt.length();
        }
        if (lopt.startsWith("coordBondStyle_")) {
            String val = lopt.substring("coordBondStyle_".length());
            if (!val.equalsIgnoreCase("solid")) {
                val = "arrow";
            }
            this.coordinateBondStyle = val.toLowerCase();
            return i + lopt.length();
        }
        if (lopt.startsWith("coordBondStyleAtMulticenter_")) {
            String val = lopt.substring("coordBondStyleAtMulticenter_".length());
            if (!val.equalsIgnoreCase("solid")) {
                val = "hashed";
            }
            this.coordinateBondStyleAtMulticenter = val.toLowerCase();
            return i + lopt.length();
        }
        int ii = super.parseOption(opts, i);
        if (ii != i) {
            return ii;
        }
        char c4 = opts.charAt(i);
        if (c4 == "w".charAt(0)) {
            j = ImageExport.findEndInt(opts, i + 1);
            long k = ImageExport.readLong(opts, i + 1, j, 10, "Image width (w)");
            if (k < 0L) {
                throw new IllegalArgumentException("Negative image width (w)");
            }
            i = j;
            this.imageSize.width = (int)k;
        } else if (c4 == "h".charAt(0)) {
            j = ImageExport.findEndInt(opts, i + 1);
            long k = ImageExport.readLong(opts, i + 1, j, 10, "Image height (h)");
            if (k < 0L) {
                throw new IllegalArgumentException("Negative image height (h)");
            }
            i = j;
            this.imageSize.height = (int)k;
        } else if (c4 == '#') {
            j = ImageExport.findEndHex(opts, i + 1);
            long k = ImageExport.readLong(opts, i + 1, j, 16, "Color");
            int w = j - i - 1;
            if (k < 0L || k > 0xFFFFFFFFL || w != 6 && w != 8) {
                throw new IllegalArgumentException("Invalid color specification \"" + opts.substring(i, j) + "\"");
            }
            this.backgroundColorCode = (int)(k & 0xFFFFFFFFFFFFFFFFL);
            if (w == 6) {
                this.backgroundColorCode |= 0xFF000000;
            }
            this.backgroundColor = new Color(this.backgroundColorCode, w != 6);
            i = j;
        }
        return i;
    }

    public String modifyFormat(String origformat) {
        return origformat;
    }

    public byte[] doExportImage(Object image, MProgressMonitor pmon) throws MolExportException {
        return null;
    }

    protected Object makeImage(Dimension size) throws MolExportException {
        CallbackIface creator = (CallbackIface)MarvinModule.load("CreateImage", null);
        if (creator == null) {
            throw new MolExportException("Cannot load CreateImage module");
        }
        Object[] args = new Object[]{size, new Integer(this.backgroundColorCode)};
        Object img = creator.callback(null, args);
        return img;
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        Molecule m = this.preconvert(mol);
        MolPainter p = new MolPainter(new MolPainterCommon());
        Dimension dim = this.initPainter(p, m);
        Object img = this.makeImage(dim);
        this.paint(m, p, img, dim);
        return img;
    }

    @Override
    @Deprecated
    public MolImageSize getImageSize(Molecule mol, String fmtopts) throws MolExportException {
        mol = this.preconvert(mol);
        this.open(fmtopts);
        MolPainter p = new MolPainter(new MolPainterCommon());
        Dimension size = this.initPainter(p, mol);
        return new MolImageSize(size.width, size.height, p.getScale());
    }

    @Override
    @Deprecated
    public void drawMolecule(Graphics2D g, Molecule mol, String fmtopts) throws MolExportException {
        mol = this.preconvert(mol);
        this.open(fmtopts);
        MolPainter p = new MolPainter(new MolPainterCommon());
        this.initPainter(p, mol);
        MDocument doc = mol.getDocument();
        if (doc != null) {
            p.paintDocument(g, doc, null);
        } else {
            p.paintMolecule(g, mol);
        }
    }

    @Override
    @Deprecated
    public void drawDocument(Graphics2D g, MDocument doc, String fmtopts) throws MolExportException {
        Molecule mol = (Molecule)doc.getMainMoleculeGraph();
        mol = this.preconvert(mol);
        this.open(fmtopts);
        MolPainter p = new MolPainter(new MolPainterCommon());
        this.initPainter(p, mol);
        p.paintDocument(g, doc, null);
    }

    public void setMolSource(String source) {
        this.molSource = source;
    }

    public String getMolSource() {
        return this.molSource;
    }

    @Override
    protected Molecule preconvert(Molecule mol) {
        MDocument doc;
        RgMolecule rm;
        Molecule m = super.preconvert(mol, false);
        if (this.saveSource) {
            try {
                this.setMolSource(MolExporter.exportToFormat(m, "mrv"));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("The molecule source can not be added to the Image, structure can not be exported to mrv format. Please fix the structure, or disable source exporting to image with the \"nosource\".", e);
            }
        } else {
            this.setMolSource("");
        }
        if (m.getDocument() == null && m instanceof RgMolecule && (rm = (RgMolecule)m).getRoot() instanceof RxnMolecule) {
            new MDocument(rm);
            RxnMolecule root = (RxnMolecule)rm.getRoot();
            MRArrow arrow = root.getReactionArrow(true);
            arrow.setType(0);
        }
        if (m.getSgroupCount() != 0) {
            if (m == mol) {
                doc = mol.getDocument();
                m = doc != null ? doc.cloneMainMolecule() : mol.cloneMolecule();
            }
            m.setGUIContracted(true);
        }
        if (m.getDim() < 2) {
            if (m == mol) {
                doc = mol.getDocument();
                m = doc != null ? doc.cloneMainMolecule() : mol.cloneMolecule();
            }
            Cleaner.clean(m, 2, null);
        }
        return m;
    }

    protected void paint(Molecule mol, MolPainter p, Object img, Dimension dimension) {
        Graphics g = img instanceof Graphics ? (Graphics)img : ((Image)img).getGraphics();
        MDocument doc = mol.getDocument();
        MolPainterCommon mpc = p.getCommon();
        if (mpc != null) {
            Color bg = p.getBackground();
            mpc.fillUnsetSetPaletteInDoc(mol, bg);
        }
        if (g.getClip() == null) {
            g.setClip(0, 0, dimension.width, dimension.height);
        }
        if (doc != null) {
            p.paintDocument((Graphics2D)g, doc, null);
        } else {
            p.paintMolecule((Graphics2D)g, mol);
        }
    }

    protected final Dimension initPainter(MolPainter p, Molecule mol) {
        double scale;
        int i;
        MDocument doc;
        MolPainterCommon common = p.getCommon();
        Color bg = this.backgroundColor;
        if (bg == null) {
            this.backgroundColorCode = -1;
            if (this.transparency) {
                this.backgroundColorCode = 0xFFFFFF;
            }
            bg = new Color(this.backgroundColorCode, true);
        } else if (this.transparency && bg.getTransparency() == 1) {
            bg = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 0);
            this.backgroundColorCode = 0 | bg.getRGB();
        }
        p.setBackground(bg);
        p.setTransparent(this.transparency);
        int opts = 0;
        opts |= this.implicitH < 0 ? 2 : this.implicitH;
        opts |= this.colorScheme < 0 ? 64 : this.colorScheme;
        opts = this.setColoringEnabled ? (opts |= 0x100) : (opts &= 0xFFFFFEFF);
        opts = this.renderingStyle < 0 ? (opts |= 0) : (opts |= this.renderingStyle);
        opts |= this.chiralitySupport;
        int e = this.ezVisible ? 65536 : 0;
        opts = opts & 0xFFFEFFFF | e;
        opts |= this.anybond;
        opts |= this.carbonVisibility;
        opts |= 0x400;
        if (this.rgroupsVisible) {
            opts |= 0x4000000;
        }
        int h = this.atomSymbolVisible ? 1024 : 0;
        opts = opts & 0xFFFFFBFF | h;
        common.setDispopts(opts, 879740355);
        common.setBondSpacing(this.bondSpacing);
        common.setWireThickness(this.wireThickness);
        common.setStickThickness(this.stickThickness);
        common.setBallRadius(this.ballRadius);
        common.setDownWedge(this.downwedge_mdl ? "mdl" : "daylight");
        common.setAtomMappingVisible(this.atommapVisible);
        common.setAtomNumbersVisible(this.atomnumbersVisible);
        common.setAtomPropertiesVisible(this.atompropsVisible);
        common.setValencePropertyVisible(this.valencePropVisible);
        common.setLigandErrorVisible(this.ligandErrorVisible);
        common.setLonePairsVisible(this.lonepairsVisible);
        common.setLonePairsAutoCalc(this.lonepairAutoCalc);
        common.setGrinvVisible(this.grinvVisible);
        common.setLigandOrderVisibility(this.ligandOrderVisible);
        common.setLigandErrorVisible(this.ligandErrorVisible);
        common.setCoordinateBondStyle(this.coordinateBondStyle);
        common.setCoordinateBondStyleAtMulticenter(this.coordinateBondStyleAtMulticenter);
        common.setDispopts(this.bondLengthVisible ? 8192 : 0, 8192);
        if (this.valenceErrorVisible) {
            common.setErrorVisible(true);
        }
        common.setValenceErrorVisible(this.valenceErrorVisible);
        common.setAbsLabelVisible(this.absLabelVisible);
        if (this.atomFont != null) {
            common.setBaseFont(this.atomFont.getAWTFont());
        }
        common.setDispQuality(this.antialiasing ? 1 : 0);
        if (this.atomSetColors != null) {
            doc = mol.getDocument();
            if (doc == null) {
                doc = new MDocument(mol);
            }
            for (i = 0; i < this.atomSetColors.length; ++i) {
                if (this.atomSetColors[i] == null) continue;
                common.setAtomSetColor(i, this.atomSetColors[i]);
                doc.setAtomSetRGB(i, this.atomSetColors[i].getRGB());
            }
        }
        if (this.bondSetColors != null) {
            doc = mol.getDocument();
            if (doc == null) {
                doc = new MDocument(mol);
            }
            for (i = 0; i < this.bondSetColors.length; ++i) {
                if (this.bondSetColors[i] == null) continue;
                common.setBondSetColor(i, this.bondSetColors[i]);
                doc.setAtomSetRGB(i, this.bondSetColors[i].getRGB());
            }
        }
        if (this.extraLabelSetColors != null) {
            doc = mol.getDocument();
            if (doc == null) {
                doc = new MDocument(mol);
            }
            for (i = 0; i < this.extraLabelSetColors.length; ++i) {
                if (this.extraLabelSetColors[i] == null) continue;
                doc.setExtraLabelSetRGBs(i, this.extraLabelSetColors[i].getRGB());
            }
        }
        p.setAtomSize(this.atomSize);
        p.setCentralized(true);
        p.setBoundsFor(mol, false, false);
        Dimension d = new Dimension(this.imageSize.width, this.imageSize.height);
        double d2 = scale = this.imageScale < 0.0 ? p.maxScale(d) : this.imageScale;
        if (this.maxScale > 0.0 && scale > this.maxScale) {
            scale = this.maxScale;
        }
        p.setScale(scale);
        if (this.imageSize.width < 0) {
            Rectangle r = p.getBounds();
            d = new Dimension(r.width, r.height);
            p.setScreen(d);
        } else {
            p.setScreen(d);
        }
        return d;
    }

    protected static int findEndInt(String opt, int i) {
        for (int j = i; j < opt.length(); ++j) {
            char c = opt.charAt(j);
            if (c >= '0' && c <= '9') continue;
            return j;
        }
        return opt.length();
    }

    protected static int findEndHex(String opt, int i) {
        for (int j = i; j < opt.length(); ++j) {
            char c = opt.charAt(j);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'Z') continue;
            return j;
        }
        return opt.length();
    }

    protected static long readLong(String opt, int begin, int end, int radix, String err) throws IllegalArgumentException {
        String s = "";
        if (end > begin) {
            s = opt.substring(begin, end);
            try {
                return Long.parseLong(s, radix);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(err + " argument \"" + s + "\" is not a decimal integer");
            }
        }
        throw new IllegalArgumentException(err + " argument is missing");
    }

    protected static int findArrayIndex(String s, String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(s)) continue;
            return i;
        }
        return -1;
    }

    private static int readSetSeq(String str) {
        return Integer.parseInt(str.substring(1));
    }

    protected boolean isAlphaChannelEnabled() {
        Color c = new Color(this.backgroundColorCode, true);
        return this.transparency || c.getTransparency() != 1;
    }
}

