/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.image.exporter;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.image.encoder.PngEncoder;
import chemaxon.marvin.io.image.exporter.ImageExport;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class PngExport
extends ImageExport {
    public int bitsPerPixel;
    private static final long[] validBitrates = new long[]{1L, 2L, 4L, 8L, 24L, 32L};

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        Image img = (Image)super.convert(mol);
        return this.convert(img);
    }

    public Object convert(Image img) throws MolExportException {
        if (this.isAlphaChannelEnabled()) {
            this.bitsPerPixel = 32;
        }
        return this.encodeImage(img);
    }

    @Override
    public Object open(String fmtopts, MPropertyContainer props) throws MolExportException {
        this.bitsPerPixel = 32;
        return super.open(fmtopts, props);
    }

    @Override
    public byte[] doExportImage(Object img, MProgressMonitor pmon) {
        return this.encodeImage(img);
    }

    private byte[] encodeImage(Object img) {
        PngEncoder encoder = new PngEncoder();
        encoder.setImage((BufferedImage)img);
        if (this.saveSource) {
            encoder.setMolSource(this.getMolSource());
        }
        encoder.setBitDepth(this.bitsPerPixel);
        try {
            return encoder.encode();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        int ii = super.parseOption(opts, i);
        if (ii != i) {
            return ii;
        }
        char c = opts.charAt(i);
        if (c == 'b') {
            int j = PngExport.findEndInt(opts, i + 1);
            long k = PngExport.readLong(opts, i + 1, j, 10, "Bits/pixel");
            boolean contains = false;
            for (int idx = 0; idx < validBitrates.length && !contains; ++idx) {
                contains = validBitrates[idx] == k;
            }
            if (!contains) {
                throw new IllegalArgumentException("Invalid bits/pixel option \"" + opts.substring(i, j) + "\". Valid values are 1, 2, 4, 8, 24, 32");
            }
            this.bitsPerPixel = (int)k;
            i = j;
        } else {
            int j;
            for (j = i; j < opts.length() && " ,\n\r\t".indexOf(c = opts.charAt(j)) < 0; ++j) {
            }
            String lopt = opts.substring(i, j);
            if (lopt.equalsIgnoreCase("nosource")) {
                this.saveSource = false;
            }
            i += lopt.length();
        }
        return i;
    }
}

