/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.image.importer;

import chemaxon.common.util.ByteVector;
import chemaxon.formats.MFileFormat;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.util.OSRA;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class ImageImportModule
extends MolImportModule {
    private MolImportModule importer = null;
    private boolean initialized = false;

    @Override
    public boolean readMol(Molecule m) throws MolFormatException, IOException {
        return this.importer == null ? false : this.importer.readMol(m);
    }

    @Override
    public Molecule createMol() {
        return this.importer == null ? new Molecule() : this.importer.createMol();
    }

    @Override
    public void setOptions(String options) throws IllegalArgumentException {
        if (this.importer != null) {
            this.importer.setOptions(options);
        }
    }

    @Override
    public void initMolImport(MRecord record, String fname) throws MolFormatException, IOException {
        String dataStr = record.getString();
        String enc = record.getEncoding();
        byte[] moldata = enc != null ? dataStr.getBytes(record.getEncoding()) : dataStr.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(moldata);
        this.initMolImport(new MolInputStream((InputStream)bais, record.getFormat(), enc, fname));
    }

    @Override
    public synchronized void initMolImport(MolInputStream is) throws MolFormatException, IOException {
        if (this.initialized) {
            return;
        }
        MolInputStream molSourceStream = null;
        List<String> availableFormats = Arrays.asList("osraimage", "jpeg", "png", "ppm", "svg");
        if (availableFormats.contains(is.getFormat())) {
            IOException ex;
            byte[] molSource;
            block14: {
                molSource = null;
                ex = null;
                if (!is.getFormat().equals("osraimage")) {
                    try {
                        molSource = this.readSourceFromImage(is);
                    }
                    catch (IOException e) {
                        ex = e;
                    }
                }
                if (molSource == null || molSource.length == 0) {
                    this.importer = MFileFormat.SDF.createImportModule();
                    try {
                        if ("svg".equals(is.getFormat())) {
                            throw new IOException("Svg file does not contain the molecule source.");
                        }
                        if (OSRA.isAvailable()) {
                            molSource = OSRA.readSDFFromStream(is);
                            break block14;
                        }
                        ex = new IOException("OSRA is not available on your computer.", ex);
                    }
                    catch (IOException e) {
                        String errorMessage = "An error occured in the OSRA software\nThe problem can be one of the following common problems:\n- OSRA can not open small images, and molecules (less than 6 atoms)\n- OSRA can not open all image file types perfectly, in some cases conversion to png file format helps\n- to open a pdf/ps file Adobe Acrobat Reader/Ghostscript has to be installed\n";
                        ex = new IOException(errorMessage, e);
                    }
                } else {
                    this.importer = MFileFormat.MRV.createImportModule();
                }
            }
            if (molSource == null || ex != null) {
                if (ex != null) {
                    throw ex;
                }
                throw new MolFormatException("Molecule could not be imported from this image:" + is.getPath());
            }
            molSourceStream = new MolInputStream(new ByteArrayInputStream(molSource));
        }
        if (this.importer != null) {
            this.importer.initMolImport(molSourceStream);
        }
        this.initialized = true;
    }

    protected byte[] readSourceFromImage(InputStream stream) throws IOException {
        return null;
    }

    @Override
    public boolean isDocumentImporter() {
        return this.importer == null ? false : this.importer.isDocumentImporter();
    }

    @Override
    public MDocument readDocument(MDocument doc) throws IOException {
        return this.importer == null ? null : this.importer.readDocument(doc);
    }

    @Override
    public int getLineCount() {
        return this.importer == null ? 0 : this.importer.getLineCount();
    }

    protected byte[] getStreamData(InputStream stream) throws IOException {
        ByteVector v = new ByteVector();
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        stream.mark(Integer.MAX_VALUE);
        byte[] buf = new byte[100];
        while (stream.read(buf) != -1) {
            v.addElements(buf);
        }
        stream.reset();
        byte[] data = v.toArray();
        return data;
    }
}

