/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.smol;

import chemaxon.marvin.io.BitInputStream;
import chemaxon.struc.WSmolecule;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class SmoleculeReader {
    private static final int[] CODE_ATNO;
    private static final String[] SPARSEPROP_SET_METHOD;
    private static final int[] SPARSEPROP_A_FLAG;
    private BitInputStream bitReader;

    public SmoleculeReader(InputStream is) {
        this.open(is);
    }

    public void open(InputStream is) {
        this.bitReader = new BitInputStream(is);
    }

    public WSmolecule read(WSmolecule proto, boolean reuse) throws IOException {
        WSmolecule m;
        int na = 0;
        int aflags = 0;
        int nb = 0;
        try {
            na = this.bitReader.read(15);
            aflags = this.bitReader.read(31);
        }
        catch (EOFException ex) {
            return null;
        }
        if ((aflags & 1) != 0) {
            nb = this.bitReader.read(15);
        }
        if (reuse) {
            m = proto;
            m.reset(aflags);
        } else {
            m = proto.newInstance(na, nb, aflags);
        }
        this.readAtomTypes(m, na);
        if (nb != 0) {
            this.readBonds(m, nb);
        }
        if ((aflags & 0x20) != 0) {
            this.readImplicitH(m);
        }
        if ((aflags & 0x80) != 0) {
            this.readValence(m);
        }
        if ((aflags & 0x100) != 0) {
            this.readAtomMap(m);
        }
        if ((aflags & 2) != 0) {
            this.readCharge(m);
        }
        if ((aflags & 4) != 0) {
            this.readRadical(m);
        }
        if ((aflags & 8) != 0) {
            this.readHybridization(m);
        }
        if ((aflags & 0x10) != 0) {
            this.readMassno(m);
        }
        if ((aflags & 0x200) != 0) {
            this.readRgroup(m);
        }
        if ((aflags & 0xC00) != 0) {
            this.readAtomStereo(m);
        }
        this.bitReader.skipFractionalByte();
        return m;
    }

    private void readAtomTypes(WSmolecule m, int na) throws IOException {
        for (int i = 0; i < na; ++i) {
            int code = this.bitReader.read(2);
            int atno = CODE_ATNO[code];
            if (atno == 0) {
                atno = this.bitReader.read(31);
            }
            m.addAtom(atno);
        }
    }

    private void readBonds(WSmolecule m, int nb) throws IOException {
        int nbits = SmoleculeReader.readNBits(this.bitReader);
        for (int i = 0; i < nb; ++i) {
            int a1 = this.bitReader.read(nbits);
            int a2 = this.bitReader.read(nbits);
            int t = this.bitReader.read(2);
            if (t == 0) {
                t = this.bitReader.read(31);
            }
            m.addBond(a1, a2, t);
        }
    }

    private static int readCompressedInt(BitInputStream r, int nbits1, int specval, int nbits2) throws IOException {
        int v = r.read(nbits1);
        if (v == specval) {
            v = r.read(nbits2);
        }
        return v;
    }

    private int readNBits2IfNeeded(BitInputStream r) throws IOException {
        return r.readBoolean() ? SmoleculeReader.readNBits(r) : 0;
    }

    private void readImplicitH(WSmolecule m) throws IOException {
        int nbits2 = this.readNBits2IfNeeded(this.bitReader);
        for (int i = 0; i < m.getAtomCount(); ++i) {
            int v = SmoleculeReader.readCompressedInt(this.bitReader, 2, 3, nbits2);
            m.setImplicitHcount(i, v);
        }
    }

    private void readValence(WSmolecule m) throws IOException {
        int nbits2 = this.readNBits2IfNeeded(this.bitReader);
        for (int i = 0; i < m.getAtomCount(); ++i) {
            int v = SmoleculeReader.readCompressedInt(this.bitReader, 3, 7, nbits2);
            m.setValence(i, v);
        }
    }

    private void readAtomMap(WSmolecule m) throws IOException {
        int na = m.getAtomCount();
        int nvalbits = this.bitReader.read(5) + 1;
        for (int atom = 0; atom < na; ++atom) {
            int v = this.bitReader.read(nvalbits);
            m.setAtomMap(atom, v);
        }
    }

    private void readCharge(WSmolecule m) throws IOException {
        int nidxbits = SmoleculeReader.readNBits(this.bitReader);
        int min = SmoleculeReader.readMin(this.bitReader);
        int nvalbits = SmoleculeReader.readNBits(this.bitReader);
        int n = this.bitReader.read(nidxbits) + 1;
        for (int i = 0; i < n; ++i) {
            int atom = this.bitReader.read(nidxbits);
            int v = this.bitReader.read(nvalbits) + min;
            m.setCharge(atom, v);
        }
    }

    private void readRadical(WSmolecule m) throws IOException {
        int nidxbits = SmoleculeReader.readNBits(this.bitReader);
        int min = SmoleculeReader.readMin(this.bitReader);
        int nvalbits = SmoleculeReader.readNBits(this.bitReader);
        int n = this.bitReader.read(nidxbits) + 1;
        for (int i = 0; i < n; ++i) {
            int atom = this.bitReader.read(nidxbits);
            int v = this.bitReader.read(nvalbits) + min;
            m.setRadical(atom, v);
        }
    }

    private void readHybridization(WSmolecule m) throws IOException {
        int nidxbits = SmoleculeReader.readNBits(this.bitReader);
        int min = SmoleculeReader.readMin(this.bitReader);
        int nvalbits = SmoleculeReader.readNBits(this.bitReader);
        int n = this.bitReader.read(nidxbits) + 1;
        for (int i = 0; i < n; ++i) {
            int atom = this.bitReader.read(nidxbits);
            int v = this.bitReader.read(nvalbits) + min;
            m.setHybridizationState(atom, v);
        }
    }

    private void readMassno(WSmolecule m) throws IOException {
        int nidxbits = SmoleculeReader.readNBits(this.bitReader);
        int min = SmoleculeReader.readMin(this.bitReader);
        int nvalbits = SmoleculeReader.readNBits(this.bitReader);
        int n = this.bitReader.read(nidxbits) + 1;
        for (int i = 0; i < n; ++i) {
            int atom = this.bitReader.read(nidxbits);
            int v = this.bitReader.read(nvalbits) + min;
            m.setMassno(atom, v);
        }
    }

    private void readRgroup(WSmolecule m) throws IOException {
        int nidxbits = SmoleculeReader.readNBits(this.bitReader);
        int min = SmoleculeReader.readMin(this.bitReader);
        int nvalbits = SmoleculeReader.readNBits(this.bitReader);
        int n = this.bitReader.read(nidxbits) + 1;
        for (int i = 0; i < n; ++i) {
            int atom = this.bitReader.read(nidxbits);
            int v = this.bitReader.read(nvalbits) + min;
            m.setRgroupId(atom, v);
        }
    }

    private void readAtomStereo(WSmolecule m) throws IOException {
        int nidxbits = this.bitReader.read(5) + 1;
        int min = SmoleculeReader.readMin(this.bitReader);
        int nvalbits = this.bitReader.read(5) + 1;
        int n = this.bitReader.read(nidxbits) + 1;
        for (int i = 0; i < n; ++i) {
            int atom = this.bitReader.read(nidxbits);
            int v = this.bitReader.read(nvalbits) + min;
            m.setAtomStereo(atom, v);
        }
    }

    private static int readNBits(BitInputStream r) throws IOException {
        return r.read(5) + 1;
    }

    private static int readMin(BitInputStream r) throws IOException {
        int nminbits = r.read(5) + 1;
        int negative = r.read(1);
        int min = r.read(nminbits);
        return negative == 1 ? -min : min;
    }

    static {
        SPARSEPROP_SET_METHOD = new String[0];
        SPARSEPROP_A_FLAG = new int[0];
        CODE_ATNO = new int[4];
        SmoleculeReader.CODE_ATNO[1] = 1;
        SmoleculeReader.CODE_ATNO[2] = 6;
        SmoleculeReader.CODE_ATNO[3] = 8;
    }
}

