/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.smol;

import chemaxon.marvin.io.BitOutputStream;
import chemaxon.struc.Smolecule;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SmoleculeWriter {
    private static final int[] ATNO_CODE;
    private BitOutputStream bitWriter;
    private static final String[] SPARSEPROP_GET_METHOD;
    private static final int[] SPARSEPROP_A_FLAG;
    private static final int[] SPARSEPROP_NO_VALUE;
    private int[] sparsePropCount = new int[SPARSEPROP_GET_METHOD.length];
    private int[] sparsePropMin = new int[SPARSEPROP_GET_METHOD.length];
    private int[] sparsePropMax = new int[SPARSEPROP_GET_METHOD.length];
    private int[][] sparsePropIndices = new int[SPARSEPROP_GET_METHOD.length][];
    private int[][] sparsePropValues = new int[SPARSEPROP_GET_METHOD.length][];

    public SmoleculeWriter(OutputStream os) {
        this.bitWriter = new BitOutputStream(os);
    }

    public void write(Smolecule m) throws IOException {
        int i;
        int na = m.getAtomCount();
        int nb = m.getBondCount();
        int aflags = m.getArrayFlags();
        int maxAtomMap = this.maxAtomMap(m);
        if (maxAtomMap == 0) {
            aflags &= 0xFFFFFEFF;
        }
        this.bitWriter.write(na, 15);
        try {
            for (i = 0; i < SPARSEPROP_GET_METHOD.length; ++i) {
                if (this.sparseAtomProperty(m, i)) continue;
                aflags &= ~SPARSEPROP_A_FLAG[i];
            }
        }
        catch (InvocationTargetException ex) {
            IOException t = new IOException("cannot write atom properties");
            t.initCause(ex);
            throw t;
        }
        catch (NoSuchMethodException ex) {
            IOException t = new IOException("cannot write atom properties");
            t.initCause(ex);
            throw t;
        }
        catch (IllegalAccessException ex) {
            IOException t = new IOException("cannot write atom properties");
            t.initCause(ex);
            throw t;
        }
        this.bitWriter.write(aflags, 31);
        if ((aflags & 1) != 0) {
            this.bitWriter.write(nb, 15);
        }
        this.writeAtomTypes(m);
        if (nb != 0 && (aflags & 1) != 0) {
            this.writeBonds(m);
        }
        if ((aflags & 0x20) != 0) {
            this.writeImplicitH(m);
        }
        if ((aflags & 0x80) != 0) {
            this.writeValence(m);
        }
        if ((aflags & 0x100) != 0) {
            this.writeAtomMap(m, maxAtomMap);
        }
        for (i = 0; i < this.sparsePropCount.length; ++i) {
            if (this.sparsePropCount[i] == 0) continue;
            this.writeSparseAtomProperty(na, i);
        }
        this.bitWriter.byteAlign();
    }

    public void close() throws IOException {
        this.bitWriter.close();
    }

    private void writeAtomTypes(Smolecule m) throws IOException {
        int na = m.getAtomCount();
        for (int i = 0; i < na; ++i) {
            int atno = m.getAtomType(i);
            int code = ATNO_CODE[atno];
            if (code == 0) {
                code = atno << 2;
                this.bitWriter.write(0, 2);
                this.bitWriter.write(atno, 31);
                continue;
            }
            this.bitWriter.write(code, 2);
        }
    }

    private void writeBonds(Smolecule m) throws IOException {
        int na = m.getAtomCount();
        int nb = m.getBondCount();
        int nbits = na > 1 ? BitOutputStream.countBits(na - 1) : 1;
        this.bitWriter.write(nbits - 1, 5);
        for (int i = 0; i < nb; ++i) {
            this.bitWriter.write(m.getAtom1(i), nbits);
            this.bitWriter.write(m.getAtom2(i), nbits);
            int t = m.getBondFlags(i);
            if (t >= 1 && t <= 3) {
                this.bitWriter.write(t, 2);
                continue;
            }
            this.bitWriter.write(0, 2);
            this.bitWriter.write(t, 31);
        }
    }

    private static void writeCompressedInt(BitOutputStream w, int v, int nbits1, int specval, int nbits2) throws IOException {
        if (v < specval) {
            w.write(v, nbits1);
        } else {
            w.write(specval, nbits1);
            w.write(v, nbits2);
        }
    }

    private static int writeNBits2IfNeeded(BitOutputStream w, int max, int specval) throws IOException {
        if (max >= specval) {
            w.writeBoolean(true);
            int nbits2 = BitOutputStream.countBits(max);
            w.write(nbits2 - 1, 5);
            return nbits2;
        }
        w.writeBoolean(false);
        return 0;
    }

    private void writeImplicitH(Smolecule m) throws IOException {
        int na = m.getAtomCount();
        int max = 0;
        for (int i = 0; i < na; ++i) {
            int v = m.getImplicitHcount(i);
            if (v <= max) continue;
            max = v;
        }
        int nbits2 = SmoleculeWriter.writeNBits2IfNeeded(this.bitWriter, max, 3);
        for (int i = 0; i < na; ++i) {
            int v = m.getImplicitHcount(i);
            SmoleculeWriter.writeCompressedInt(this.bitWriter, v, 2, 3, nbits2);
        }
    }

    private void writeValence(Smolecule m) throws IOException {
        int na = m.getAtomCount();
        int max = 0;
        for (int i = 0; i < na; ++i) {
            int v = m.getValence(i);
            if (v <= max) continue;
            max = v;
        }
        int nbits2 = SmoleculeWriter.writeNBits2IfNeeded(this.bitWriter, max, 7);
        for (int i = 0; i < na; ++i) {
            int v = m.getValence(i);
            SmoleculeWriter.writeCompressedInt(this.bitWriter, v, 3, 7, nbits2);
        }
    }

    private int maxAtomMap(Smolecule m) {
        int na = m.getAtomCount();
        int max = 0;
        for (int atom = 0; atom < na; ++atom) {
            int v = m.getAtomMap(atom);
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    private void writeAtomMap(Smolecule m, int max) throws IOException {
        int na = m.getAtomCount();
        int nvalbits = max > 1 ? BitOutputStream.countBits(max) : 1;
        this.bitWriter.write(nvalbits - 1, 5);
        for (int i = 0; i < na; ++i) {
            this.bitWriter.write(m.getAtomMap(i), nvalbits);
        }
    }

    private boolean sparseAtomProperty(Smolecule m, int i) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        int na = m.getAtomCount();
        int n = 0;
        int[] indices = this.sparsePropIndices[i];
        int[] values = this.sparsePropValues[i];
        int min = 0;
        int max = 0;
        if (indices == null || indices.length < na) {
            indices = new int[na];
            this.sparsePropIndices[i] = indices;
            values = new int[na];
            this.sparsePropValues[i] = values;
        }
        Method method = Smolecule.class.getMethod(SPARSEPROP_GET_METHOD[i], Integer.TYPE);
        int no_value = SPARSEPROP_NO_VALUE[i];
        for (int atom = 0; atom < na; ++atom) {
            Object o = method.invoke((Object)m, new Integer(atom));
            int v = (Integer)o;
            if (v == no_value) continue;
            indices[n] = atom;
            values[n] = v;
            if (v > max) {
                max = v;
            }
            if (v < min) {
                min = v;
            }
            ++n;
        }
        this.sparsePropCount[i] = n;
        this.sparsePropMin[i] = min;
        this.sparsePropMax[i] = max;
        return n != 0;
    }

    private void writeSparseAtomProperty(int na, int i) throws IOException {
        int nidxbits = na > 1 ? BitOutputStream.countBits(na - 1) : 1;
        this.bitWriter.write(nidxbits - 1, 5);
        int[] indices = this.sparsePropIndices[i];
        int[] values = this.sparsePropValues[i];
        int min = this.sparsePropMin[i];
        int max = this.sparsePropMax[i];
        int range = max - min;
        int absmin = Math.abs(min);
        int nminbits = absmin > 1 ? BitOutputStream.countBits(absmin) : 1;
        this.bitWriter.write(nminbits - 1, 5);
        this.bitWriter.write(min >= 0 ? 0 : 1, 1);
        this.bitWriter.write(absmin, nminbits);
        int nvalbits = range > 1 ? BitOutputStream.countBits(range) : 1;
        this.bitWriter.write(nvalbits - 1, 5);
        int n = this.sparsePropCount[i];
        this.bitWriter.write(n - 1, nidxbits);
        for (int j = 0; j < n; ++j) {
            this.bitWriter.write(indices[j], nidxbits);
            this.bitWriter.write(values[j] - min, nvalbits);
        }
    }

    static {
        SPARSEPROP_GET_METHOD = new String[]{"getCharge", "getRadical", "getHybridizationState", "getMassno", "getRgroupId", "getAtomStereo"};
        SPARSEPROP_A_FLAG = new int[]{2, 4, 8, 16, 512, 3072};
        SPARSEPROP_NO_VALUE = new int[]{0, 0, 0, 0, 0, 0};
        ATNO_CODE = new int[256];
        SmoleculeWriter.ATNO_CODE[1] = 1;
        SmoleculeWriter.ATNO_CODE[6] = 2;
        SmoleculeWriter.ATNO_CODE[8] = 3;
    }
}

