/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling;

import chemaxon.calculations.clean.Clean3D;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.build.fafuse.FuseBuilder;
import chemaxon.marvin.modelling.debug.StdErrVerbosePrinter;
import chemaxon.marvin.modelling.debug.Tracer;
import chemaxon.marvin.modelling.debug.VerbosePrinter;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.GradientOptimization;

public class CleanArgs {
    public static boolean OPT_DOPROGRESSBAR_HACK = false;
    public static Tracer cltracer = null;
    public static long startTimeInMillis = 0L;
    public static int verboseLevel = 0;
    private static int verboseIndent = 0;
    static StdErrVerbosePrinter vp = null;
    public static boolean CLEANER_REINVOKED = false;
    public static final double[] OPT_LIMITS_VALUES = new double[]{0.01, 0.001, 1.0E-4, 1.0E-5};
    public static final String[] OPT_LIMITS_NAMES = new String[]{"very loose ", "normal     ", "strict     ", "very strict"};
    public static int OPT_LIMITS_LASTOPT = 1;
    public static int OPT_LIMITS_LASTOPTCA = 1;
    public static int OPT_LIMITS_PREOPT = 1;
    public static final double OPT_LIMIT_VALUE_VERYLOOSE = 0.01;
    public static final double OPT_LIMIT_VALUE_NORMAL = 0.001;
    public static final double OPT_LIMIT_VALUE_STRICT = 1.0E-4;
    public static final double OPT_LIMIT_VALUE_VERYSTRICT = 1.0E-5;
    public static final double OPT_LIMITS_LASTBUILDOPT = 1.0;
    public static boolean OPT_FUSEBUILD_DOHIN23HACK = true;
    public static int OPT_FUSEBUILD_DEFAULT_INIT_CONFCOUNT = 3;
    public static int OPT_FUSEBUILD_DEFAULT_MAX_CONFCOUNT = 729;
    public static boolean OPT_CLEAN_SKIPDBLOOKUP = true;
    public static final int FRAGSEQUENCE_ORIGINALBALANCEDFRAGS = 1;
    public static final int FRAGSEQUENCE_ORIGINALUNBALANCEDFRAGS = 2;
    public static int OPT_FRAGSEQUENCE = 1;
    public static final int OPTIMIZER_ISOPT = 1;
    public static final int OPTIMIZER_GRADOPT = 2;
    public static int OPT_OPTIMIZERTOUSE = 2;
    public static boolean OPT_DEBUG_USEORIGCOORDINATES = true;

    public static void resetReinvokeDependents() {
        verboseLevel = 0;
        verboseIndent = 0;
        startTimeInMillis = System.currentTimeMillis();
    }

    public static void reset() {
        cltracer = null;
        OPT_FUSEBUILD_DEFAULT_INIT_CONFCOUNT = 9;
        OPT_FUSEBUILD_DEFAULT_MAX_CONFCOUNT = 279;
        OPT_CLEAN_SKIPDBLOOKUP = true;
        OPT_DEBUG_USEORIGCOORDINATES = true;
        OPT_LIMITS_LASTOPT = 1;
        OPT_LIMITS_LASTOPTCA = 1;
        OPT_LIMITS_PREOPT = 1;
        OPT_DOPROGRESSBAR_HACK = false;
        OPT_OPTIMIZERTOUSE = 2;
        OPT_FRAGSEQUENCE = 1;
    }

    public static String getFormattedElapsedTime() {
        long t = System.currentTimeMillis() - startTimeInMillis;
        long min = t / 60000L;
        long s = t - min * 60000L;
        long sec = s / 1000L;
        long ms = s % 1000L;
        return min + ":" + TextUtils.formatNumber((int)sec, 2, '0') + "." + TextUtils.formatNumber((int)ms, 3, '0');
    }

    public static int getVerboseLevel() {
        return verboseLevel;
    }

    private static void printIndents() {
        for (int i = 0; i < verboseIndent; ++i) {
            System.err.print(" ");
        }
    }

    public static void verboseInc(String s) {
        CleanArgs.printIndents();
        System.err.println(s);
        verboseIndent += 2;
        debugPrintout d = CleanArgs.getDebug();
        if (d != null) {
            d.println(">>> " + s, true);
        }
    }

    public static void verboseDec(String s) {
        if ((verboseIndent -= 2) < 0) {
            System.err.println("too many verboseDec()");
            verboseIndent = 0;
        }
        CleanArgs.printIndents();
        System.err.println(s);
        debugPrintout d = CleanArgs.getDebug();
        if (d != null) {
            d.println("<<< " + s, true);
        }
    }

    public static void verbose(String s) {
        CleanArgs.verbose(s, null);
    }

    public static void verbose(String s, String detail) {
        CleanArgs.printIndents();
        if (detail == null) {
            System.err.println(s);
        } else {
            System.err.println(s + " " + detail);
        }
        debugPrintout d = CleanArgs.getDebug();
        if (d != null) {
            d.println(s, true, detail);
        }
    }

    public static VerbosePrinter getVerbosePrinter(String title) {
        return CleanArgs.getVerbosePrinter(title, false);
    }

    public static void setVP(StdErrVerbosePrinter v) {
        vp = v;
    }

    public static VerbosePrinter getVerbosePrinter(String title, boolean forceStderr) {
        while (vp != null && vp.isClosed()) {
            vp = vp.getParent();
        }
        if (vp == null) {
            if (!CleanArgs.doVerbose() && !forceStderr) {
                return null;
            }
            vp = new StdErrVerbosePrinter(CleanArgs.getDebug());
            vp.print(title);
        }
        StdErrVerbosePrinter ret = null;
        if (vp != null) {
            boolean nodebug = CleanArgs.getDebug() == null;
            ret = (StdErrVerbosePrinter)vp.incDetail(title, nodebug);
            ret.setDebugPrinter(CleanArgs.getDebug());
        }
        return ret;
    }

    public static boolean doVerbose() {
        return verboseLevel > 0;
    }

    public static boolean doVerbose(int myLevel) {
        return verboseLevel >= myLevel;
    }

    public static debugPrintout getDebug() {
        if (cltracer == null) {
            return null;
        }
        debugPrintout ret = cltracer.getDebug();
        if (ret == null) {
            return null;
        }
        if (ret.getWillPrint()) {
            return ret;
        }
        return null;
    }

    public static void reportError(String s) {
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose(s);
        }
        if (cltracer != null) {
            cltracer.reportError(0, s);
        }
    }

    public static void reportException(String msg, Exception e) {
        CleanArgs.verbose(msg + ": " + e.getMessage());
        e.printStackTrace();
        if (cltracer != null) {
            cltracer.reportException(e);
        }
    }

    public static Tracer getTracer() {
        return cltracer;
    }

    public static void checkToPrintHelpMessage(String opts) {
        if (opts.length() > 0 && (opts.charAt(0) == 'h' || opts.indexOf(63) >= 0)) {
            System.err.println(CleanArgs.getDefaultHelpMessage());
        }
    }

    public static String getDefaultHelpMessage() {
        int i;
        CleanSettings defaultSettings = new CleanSettings(null, null);
        String ret = "Clean 3D options:\n\nHELP:\n   Help shown if option string contains character ? or starts with character h\n\nGENERAL FORMAT:\n   Option string contains OPTIONS which may have mandatory or optional ARGUMENTS.\n   OPTIONS given between [ ]. ARGUMENTS for options given between { }.\n   For one-character length options or one-digit length option arguments brackets\n   can be omitted. (e.g. ...[c]{1}{1}... and ...c11... will be equivalent)\n\nBASIC OPTIONS:\n\n   [c]           Cleaner to use in STEP 5                    (case insensitive)\n      Argument 1: cleaning method to use\n       {0}:           Simple cleaner\n       {1}:           Old cleaner (not supported, not recomended)\n       {2}:           Do not generate 3D coordinates, no clean \n       {3}: (default) New cleaner\n      Argument 2: skip clean for 3D molecules\n       {0}: (default) Force clean for every molecule\n       {1}:           Skip clean for 3D molecules. Only molecules with\n                      3D geometry will be skipped.\n      Example:          ...c31...  Run new cleaner only for non-3D molecules\n                        ...c0...   Run simple cleaner only for all molecules\n                        ...c01...  Run simple cleaner only for non-3D molecules\n\n   [L]           Set optimization criteria                   (case insensitive)\n      The given limit is used when optimizing the generated/given structures.\n      Note that giving option [L] itself does not necessary invokes optimization.\n      Possible optimization limit values:\n";
        for (i = 0; i < OPT_LIMITS_NAMES.length; ++i) {
            ret = ret + "       {" + i + "}:           " + OPT_LIMITS_NAMES[i] + "          (limit=" + OPT_LIMITS_VALUES[i] + ")\n";
        }
        ret = ret + "      Argument 1:   Final optimization limit                (default: 1)\n" + "\n" + "   [E]           Store Dreiding energy in SDF properties     (case insensitive)\n" + "      If no clean3D error occured the Dreiding energy for each fragment will be\n" + "      calculated in STEP8 and their sum will be placed to the sdf property with\n" + "      ID \"Energy\" of molecule.\n" + "      If clean3D with new cleaner invoked and failed, store \"CLEAN3D_FAILED\"\n" + "      instead.\n" + "      If clean3D execution aborted (for example because of time limit) then\n" + "      store \"CLEAN3D_ABORTED\".\n" + "\n" + "   [timelimit]   Modify default time limit for cleaning      (case insensitive)\n" + "      Argument 1: time limit for cleaning in sec. Use 0 for no timelimit.\n" + "      Example:         [timelimit]{600} cleaner will give up after 10 minutes\n" + "                       [timelimit]0     cleaner will not give up due to timeout\n" + "      Default values:\n" + "           2 minutes for normal clean process\n" + "           5 minutes for conformational analysis\n" + "\n" + "   [timestamp]   Store time stamps into SDF propety strings. (case insensitive)\n" + "      Timestamps and relative time measurement info will be stored into SDF\n" + "      property strings.\n" + "      Stored absolute time stamps:\n" + "       ID=\"TIMESTAMP_beforeclean\" absolute time (see later) before cleaning\n" + "                                  process\n" + "       ID=\"TIMESTAMP_afterclean\"  absolute time (see later) after cleaning\n" + "                                  process\n" + "       Timestamps represents the time in millisecunds elapsed since\n" + "       midnight, January 1, 1970 UTC (see java.lang.System.currentTimeMillis())\n" + "      Stored relative time measurements:\n" + "       ID=\"CLEAN3D_time\"          length of the cleaning process (in ms)\n" + "                                    This is the difference of the two stored\n" + "                                    timestamps.\n" + "      Note that these values are based on system time, so actual cpu (process)\n" + "      time may differ significantly.\n" + "\n" + "   [ca]          Conformational analysis                     (case insensitive)\n" + "         Fill a specific molecule property with conformers found.\n" + "         For compatibility reasons, [ca] option will invoke Cleaner strategy 5.\n" + "      Argument 1: Reported conformer count\n" + "                  When using cleaner 3 at most this many conformers will be\n" + "                  stored. Use -1 for request all of the generated conformers.\n" + "                  Note that if invoked without valid license this parameter\n" + "                  is forced to value 1.\n" + "      Argument 2: Generated conformer count\n" + "                  When using cleaner 3 try to generate at least this many\n" + "                  conformers. Use -1 to generate all possible conformers\n" + "                  WARNING! Using -1 easily can lead to run out of memory for\n" + "                  most structures.\n" + "\n" + "   [hyperfine]   Use sophisticated low-energy conformer prediction\n" + "                  When using cleaner 3 at each build step several MD\n" + "                  calculations followed by tight geometry optimization\n" + "                  processes will be invoked on all the generated structures\n" + "                  WARRNING! Using this feature the generation time can be\n" + "                  extremly high.\n" + "\n" + "   [diversity]   Use custom diversity criterion\n" + "      Argument 1: Diversity limit for conformer equivalence check\n" + "                  The diversity limit will be used as minimal RMSD between\n" + "                  valid conformers. The default value is 0.1 (Angstrom)\n" + "\n" + "   [prehydrogenize] Hydrogenize                              (case insensitive)\n" + "       Add explicit hydrogenes to molecule before cleaning.\n" + "\n" + "   [o]           Optimization in STEP 7                      (case insensitive)\n" + "      Argument 1: Optimization\n" + "       {0}: (default) No optimization in STEP 7\n" + "       {1}:           Use Dreiding in STEP 7\n" + "      Argument 2: Write Dreiding energy \n" + "       {0}: (default) No energy calculation STEP 8\n" + "       {1}:           Write Dreiding energy in STEP 8\n" + "      Argument 3: Optimization criteria\n";
        for (i = 0; i < OPT_LIMITS_NAMES.length; ++i) {
            ret = ret + "       {" + i + "}: " + (i == defaultSettings.getOptLimitFinalopt() ? "(default)" : "         ") + " " + OPT_LIMITS_NAMES[i] + "\n";
        }
        ret = ret + "   [verbose]     Print verbose messages                      (case insensitive)\n" + "       Print verbose messages to std err during execution.\n" + "       Note that environmental variable " + "chemaxon_clean3d_options_verbose" + "\n" + "       is checked and verbose settings stored in it processed.\n" + "       Argument 1: verbosity level for all messages (optional)\n" + "                   Use a value greater than 1 to increase default minimal\n" + "                   verbosity level\n" + "       Further argument pair(s) can be specified to fine tune verbose settings.\n" + "         Argument 2,4,...: specific verbose printer\n";
        for (CleanSettings.Verbosers v : CleanSettings.Verbosers.values()) {
            ret = ret + "           {" + v.getName() + "}: " + v.getDesc() + "\n";
        }
        ret = ret + "         Argument 3,5,...: specific verbose printer verbose level\n";
        return ret;
    }

    public static String getHelpMessage(FuseBuilder.CleanParams defParams, int sect) {
        return null;
    }

    public static String getHelpMessage(FuseBuilder.CleanParams defParams) {
        CleanSettings defaultSettings = new CleanSettings(null, null);
        String ret = "Clean 3D options:\n\nHELP:\n   help shown if option string contains character ? or starts with character h\n\nSTRUCTURED OPTION EVALUATION:\n   - Option string interpreted as a set of OPTIONS. Each option can have zero or\n     more ARGUMENTS.   \n   - An alphabetic character or an alphanumeric string between [ ] pairs\n     interpreted as OPTION. \n   - A numeric character or an alphanumeric string between { } pairs interpreted\n     as ARGUMENT (belonging to the last OPTION)\n\n   In a formal way:\n          OPTION_STRING = ( OPTIONS (ARGUMENTS)* )*\n          OPTION        = [ a-z | A-Z ] | '[' [ a-z | A-Z | 0-9 ]* ']'\n          ARGUMENT      = [ 0-9 ] | '{' [ a-z | A-Z | 0-9 | +-_ ]* '}'\n\nCLEAN3D EXECUTION\n   STEP 1: Optional show of this help\n   STEP 2: Test for debug/trace printout switch [trace]. If found, evaluate\n           its optional arguments.\n   STEP 3: Evaluate option string\n           After evalution, if no clean strategy was specified in the option\n           string, set the default one. (See option [S]). This is equivalent\n           the append of [S]{1} or S1 to the end of the option string.\n   STEP 4  Hydrogenize molecule (if required, see later)\n   STEP 5: Run cleaner (if required, see later)\n   STEP 6: Hydrogenize molecule (if required, see later)\n   STEP 7: Run Dreiding optimization (if required, see later)\n   STEP 8: Calculate Dreiding energy for each fragment, if required. Write to\n           STDERR and/or place their sum into SDF property.\n\nOPTIONS AND THEIR ARGUMENTS:\n   note: brackets ('[',']','{','}') can be ignored if one character option name\n         or one digit option parameter is enclosed by them.\n         example:  ...ab1[c]{2}d34e... is equivalent with ...ab1c2d34e...\n\n   [S]           Set clean strategy                            (case sensitive)\n      Set parameters for specific clean strategies. The parameters are set at\n      the evalution of S option.\n      Argument 1: Strategy ID\n       {0}:           No strategy, leave parameters on default values\n                      After the evalution process, do not set default strategy.\n       {fast}:\n       {1}: (default) Default clean.\n                      Used for fast 3D generation. Tries fast generation, if\n                      fails, uses higher thresolds. Accept any structure.\n                      The default strategy is set after the option string\n                      evalution when it no contains any  S option.\n       {nofaulty}:\n       {2}:           Same as {fast} with no acceptance of faulty structures.\n                       Fragments failed left intact.\n       {fine}:\n       {3}:           Fine generation, finds low energy conformer\n       {conformers}:\n       {4}:           Conformational analysis, fill conformer info field\n       {5}:           Fast only generation, return if fails\n\n   [P]           Print clean failed structures to std. err.    (case sensitive)\n                 Disable print feature or change format\n      Argument 1: Print format (chemaxon.struc.Molecule.toFormat argument)\n                  If argument not given, disable print feature\n       {smiles}   (default) Use smiles format\n       {mol}                Use mol format\n\n\n   [o]           Optimization in STEP 7                      (case insensitive)\n      Argument 1: Optimization\n       {0}: (default) No optimization in STEP 7\n       {1}:           Use Dreiding in STEP 7\n      Argument 2: Write Dreiding energy \n       {0}: (default) No energy calculation STEP 8\n       {1}:           Write Dreiding energy in STEP 8\n      Argument 3: Optimization criteria\n";
        for (int i = 0; i < OPT_LIMITS_NAMES.length; ++i) {
            ret = ret + "       {" + i + "}: " + (i == defaultSettings.getOptLimitFinalopt() ? "(default)" : "         ") + " " + OPT_LIMITS_NAMES[i] + "\n";
        }
        ret = ret + "       This optimization criteria also can be set with option [L].\n" + "\n" + "   [compatible]  Run compatible option string evaluation     (case insensitive)\n" + "         Compatible option string evaluation will be executed to first argument\n" + "\n" + "  DEBUG RELATED OPTIONS:\n" + "\n" + "   [trace]       Switch on code trace/debug printouts        (case insensitive)\n" + "\n" + "   [skipbuild]   Skip structure build                        (case insensitive)\n" + "       The build cycle will be skipped.\n" + "\n" + "   The following low level cleaner parameters can be set:\n" + "\n" + "   [CPminmet]    Minimal required metrid at proximity check    (case sensitive)\n" + "       { <double value for OPT_CP_MINMET> }\n" + "       default value: " + Clean3D.OPT_CP_MINMET + "\n" + "\n" + "   [CPeps]       EPS value for floating point operations       (case sensitive)\n" + "       { <double value for OPT_CP_EPS> }\n" + "       default value: " + Clean3D.OPT_CP_EPS + "\n" + "\n" + "   [CPonet]      Stop placement after one processed torsion    (case sensitive)\n" + "       { <boolean value for OPT_CP_ONETORSION> }\n" + "       default value: " + Clean3D.OPT_CP_ONETORSION + "\n" + "\n" + "   Iterative low-level parameters\n" + "   The cleaner can try iterative parameter refinement in case no structure can\n" + "   be generated with a given set of parameters.\n" + "\n" + "   [nextparamset]                                            (case insensitive)\n" + "   [np]                                                      (case insensitive)\n" + "       Copy the last state of paramset. The following paramset related options\n" + "       will apply to the next level of paramsets.\n" + "\n" + "   [acceptfault]                                             (case insensitive)\n" + "       Accept any generated structure.\n" + "\n" + "   [CPfargmulti] Default fragment multiplicity                 (case sensitive)\n" + "   [fm]                                                      (case insensitive)\n" + "       Note that setting cleaner strategy will overwrite these settings.\n" + "       { <integer value for OPT_CP_FRAGMULTI_CHAIN> }\n" + "             current value: " + defParams.OPT_CP_FRAGMULTI_CHAIN + "\n" + "       { <integer value for OPT_CP_FRAGMULTI_RING> }\n" + "             current value: " + defParams.OPT_CP_FRAGMULTI_RING + "\n" + "       { <integer value for OPT_CP_FRAGMULTI_RINGBEFORECLOSE> }\n" + "             current value: " + defParams.OPT_CP_FRAGMULTI_RINGBEFORECLOSE + "\n" + "\n";
        return ret;
    }

    public static class VerboseAdapter
    implements GradientOptimization.VerbosePrinter {
        @Override
        public void print(String s) {
            CleanArgs.verbose(s);
        }

        @Override
        public void print(int i) {
            CleanArgs.verbose("" + i);
        }

        @Override
        public void print(double d) {
        }

        @Override
        public void print(boolean b) {
        }

        @Override
        public void println() {
        }

        @Override
        public void println(String s) {
        }

        @Override
        public void println(int i) {
        }

        @Override
        public void println(double d) {
        }

        @Override
        public void println(boolean b) {
        }
    }
}

