/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling;

import chemaxon.calculations.clean.Clean3D;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.debug.MMDiagnosticObserverImpl;
import chemaxon.marvin.modelling.debug.SimpleVerbosePrinter;
import chemaxon.marvin.modelling.debug.StdErrSimpleVerbosePrinter;
import chemaxon.marvin.modelling.debug.VerbosePrinter;
import chemaxon.marvin.modelling.diag.Instrumentation;
import chemaxon.marvin.modelling.mm.MMDiagnosticObserver;
import chemaxon.marvin.modelling.util.ProgressTools;
import chemaxon.marvin.modelling.util.SimpleCanceller;
import chemaxon.marvin.modelling.util.Stopper;
import chemaxon.marvin.modelling.util.TimeoutCancellerImpl;
import chemaxon.marvin.modelling.util.U;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.Molecule;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.Vector;

public class CleanSettings {
    private final Map<Verbosers, SimpleVerbosePrinter> verbosePrinters;
    public static final String VERBOSE_CFG_ENV = "chemaxon_clean3d_options_verbose";
    private VerbosePrinter vp = null;
    public static final boolean RELEASE_MODE_SET = true;
    public static final boolean MODFUNC_DUMP_OPTIONSTRING = false;
    public static final boolean MODFUNC_FORCE_VERBOSE = false;
    public static final int DREIDING_OLD_OPT3D_DREIDING = 1;
    public static final int DREIDING_NEW_MM_DREIDING = 2;
    public static final int FORCEFIELD_TO_USE = 2;
    public static final int FORCEFIELD_ANGLE_COSTERM = 1;
    public static final int FORCEFIELD_ANGLE_QUADTERM = 2;
    public static final int FORCEFIELD_ANGLE_MQUADTERM = 3;
    private int forcefieldNonLinAngleMethod = 3;
    private int forcefieldLinAngleMethod = 3;
    private double forcefieldNonLingAngleDF = 150.0;
    private double forcefieldAngleLowerInterval = 20.0;
    public static final int FORCEFIELD_DIHEDRAL_DOWNSCALE_NONE = 1;
    public static final int FORCEFIELD_DIHEDRAL_DOWNSCALE_QUAD = 2;
    private double forcefieldDihedralDownscaleAnglelimit = 160.0;
    private int forcefieldDihedralDonwnscaleMethod = 2;
    public static final int FORCEFIELD_INVERSION_DOWNSCALE_NONE = 1;
    public static final int FORCEFIELD_INVERSION_DOWNSCALE_QUAD = 2;
    private double forcefieldInversionDownscaleAnglelimit = 160.0;
    private int forcefieldInversionDownscaleMethod = 2;
    public static final int FORCEFIELD_INVERSION_QUADTERM = 1;
    public static final int FORCEFIELD_INVERSION_MQUADTERM = 2;
    private int forcefieldInversionMethod = 2;
    private static String[] FORCEFIELD_ANGLE_LABELS = new String[]{null, "cos", "quad", "mquad"};
    private static String[] FORCEFIELD_INVERSION_LABELS = new String[]{null, "quad", "mquad"};
    private static String[] FORCEFIELD_DIHEDRALDS_LABELS = new String[]{null, "none", "quad"};
    private static String[] FORCEFIELD_INVERSIONDS_LABELS = new String[]{null, "none", "quad"};
    public static final boolean BUILDCOMMAND_DUMPHYPERFINEDEBUG = false;
    public static final boolean MYMOLECULE_SKIPCTINSMALLRING = true;
    public static final boolean MYMOLECULE_SKIPTRANSINSMALLRING = true;
    public static final boolean MYMOLECULE_WRITESMILESINCTERROR = false;
    public static final boolean FRAGMENT_SINGLEBONDEDMULTILIGANDANCHOR = true;
    public static final boolean FRAGMENT_PROXIMITYCHECKSANGLE = true;
    public static final boolean FRAGMENT_DUMPRINGCRITICALS = false;
    public static final double FRAGMENT_RINGCRITICALLIMIT = 0.72;
    public static final double FRAGMENT_DEFSP3MAXBONDANGLE = 3.0543261909900763;
    public static final double FRAGMENT_DEFSP3MINOOPANGLE = 0.4363323129985824;
    public static final double FRAGMENT_DEFSP3MINOPTLIMIT = 0.01;
    public static final boolean FRAGMENT_DUMPSLOWOPTIMIZE = false;
    public static final boolean FRAGMENT_DUMPFLAWEDOPTIMIZE = false;
    public static final boolean FRAGMENT_DUMPNOTCONVERGEDOPTIMIZE = false;
    public static final boolean FRAGMENT_DUMPSTERICERROROPTIMIZED = false;
    public static final long FRAGMENT_DUMPSLOWOPTIMIZE_TIMELIMT = 5000L;
    public static final double FFFUSE_MINSEP = 0.2;
    public static final boolean MODFUNC_DUMP_STEREOCRITERIA = false;
    public static final boolean MODFUNC_VERBOSE_STEREOCRITERIAPARSING = false;
    public static final String MODFUNC_DUMP_FAILED_FORMAT = "smiles";
    public static final int BUILDCOMMAND_MAXLIGHTBUILDCOUNT = 1;
    public static final double BUILDCOMMAND_DEFAULTRMSD = 0.1;
    public static final double BUILDCOMMAND_DENERGYLIMIT = 200.0;
    public static final boolean DIRECTFRAGMENTBUILDER_FALLBACKTOSFASTENABLED = false;
    public static final int BUILDCOMMAND_DEFAULTOPTCR = 0;
    public static final double BUILDCOMMAND_DEFAULTOPTLIMITVALUE = CleanArgs.OPT_LIMITS_VALUES[0];
    private int hyperfineMDStepCount = 50;
    private int hyperfineMDTemperature = 250;
    private int optLimitFinalopt = 1;
    private double finalRMSDLimit = 0.1;
    private double finalDEnergy = 200.0;
    private static String diagOptsHelpMessage = null;
    public Stopper OPT_stopper_equivalences = null;
    public Stopper OPT_stopper_Fusebuilder_makecoords = null;
    public Stopper OPT_stopper_Buildsequence_construct = null;
    public Stopper OPT_stopper_Fragclean_FFFaftercheck = null;
    public Stopper OPT_stopper_MD = null;
    public Stopper OPT_stopper_Optimization = null;
    private static final String STOPPERLABEL_OPT_stopper_equivalences = "CLEAN3D.EQTime";
    private static final String STOPPERLABEL_OPT_stopper_Fusebuilder_makecoords = "CLEAN3D.FuseBuilder.Makecoords";
    private static final String STOPPERLABEL_OPT_stopper_Buildsequence_construct = "CLEAN3D.Buildsequence.Construct";
    private static final String STOPPERLABEL_OPT_stopper_Fragclean_FFFaftercheck = "CLEAN3D.FragClean.FFFAftercheck";
    private static final String STOPPERLABEL_OPT_stopper_MD = "CLEAN3D.MD";
    private static final String STOPPERLABEL_OPT_stopper_Optimization = "CLEAN3D.Optimization";
    private static final String[] STOPPERLABELS = new String[]{"CLEAN3D.EQTime", "CLEAN3D.FuseBuilder.Makecoords", "CLEAN3D.Buildsequence.Construct", "CLEAN3D.FragClean.FFFAftercheck", "CLEAN3D.MD", "CLEAN3D.Optimization"};
    private Vector stoppers = null;
    private boolean optionEgiven = false;
    private boolean optionTimestampGiven = false;
    private boolean optionDiaginfoGiven = false;
    private boolean optionPrehydrogenizeGiven = false;
    private boolean optionCheckGradientsGiven = false;
    public static final int CHECKGRADIENT_ONLYSTDERR = 1;
    public static final int CHECKGRADIENT_SAVEFIRST = 2;
    public static final int CHECKGRADIENT_SAVEALL = 3;
    private int checkGradientBehavior = 2;
    private boolean checkGradientSkipNum = false;
    public static final int CLEANER_TO_USE_FUSECLEANER = 0;
    public static final int CLEANER_TO_USE_MINKOWSKI = 1;
    public static final int CLEANER_TO_USE_NOCLEAN = 2;
    public static final int CLEANER_TO_USE_NEWCLEANER = 3;
    public static final int CLEANER_TO_USE_DEFAULT = 3;
    public static final String[] CLEANER_LABELS = new String[]{"simple", "minkowski", "no", "default"};
    public static final String[] CLEANER_DESCRIPTIONS = new String[]{"Simple cleaner", "Old cleaner (minkowski based build, not supported, not recommended)", "Do not generate 3D coordinates, no clean", "New cleaner"};
    private boolean optionCleanerToUseSet = false;
    private int optionCleanerToUse = 3;
    public static final int FORCE_CLEAN_ALL = 0;
    public static final int FORCE_CLEAN_NON3DONLY = 1;
    private int optionCleanForce = 0;
    private boolean optimizeResults = false;
    private boolean optionHyperfineGiven = false;
    private BitSet forcefieldDisableComponents = null;
    MMDiagnosticObserverImpl mmdi = null;
    private boolean optionCAGiven = false;
    private int generatedConformerCount = 1;
    private int reportedConformerCount = 1;
    int verboseLevel = 0;
    private boolean optionTimelimitGiven = false;
    private long optionTimelimitValue = 0L;
    private MProgressMonitor pmon = null;
    private ProgressTools.MProgressMonitorHolder pmonh = null;
    private SimpleCanceller canceller = null;
    private boolean cancellerInited = false;
    private Molecule orig = null;
    private String origInSmiles = null;
    private long constructTimeStamp = -1L;
    private long finalTimeStamp = -1L;
    private long memoryOnConstruct = -1L;
    private long memoryOnFinal = -1L;
    private String optionString = null;
    private Instrumentation ins = null;

    public SimpleVerbosePrinter getVerbosePrinter(Verbosers verboser) throws IllegalStateException {
        if (this.verbosePrinters == null) {
            throw new IllegalStateException("VerbosePrinters not initialized.");
        }
        SimpleVerbosePrinter ret = this.verbosePrinters.get((Object)verboser);
        if (ret == null) {
            throw new IllegalStateException("VerbosePrinters does not contain " + (Object)((Object)verboser));
        }
        return ret;
    }

    private static int lookupForcefieldAngleLabel(String label) {
        for (int i = 0; i < FORCEFIELD_ANGLE_LABELS.length; ++i) {
            if (FORCEFIELD_ANGLE_LABELS[i] == null || !FORCEFIELD_ANGLE_LABELS[i].equalsIgnoreCase(label)) continue;
            return i;
        }
        return -1;
    }

    private static int lookupForcefieldInversionLabel(String label) {
        for (int i = 0; i < FORCEFIELD_INVERSION_LABELS.length; ++i) {
            if (FORCEFIELD_INVERSION_LABELS[i] == null || !FORCEFIELD_INVERSION_LABELS[i].equalsIgnoreCase(label)) continue;
            return i;
        }
        return -1;
    }

    private static int lookupForcefieldDihedralDSLabel(String label) {
        for (int i = 0; i < FORCEFIELD_DIHEDRALDS_LABELS.length; ++i) {
            if (FORCEFIELD_DIHEDRALDS_LABELS[i] == null || !FORCEFIELD_DIHEDRALDS_LABELS[i].equalsIgnoreCase(label)) continue;
            return i;
        }
        return -1;
    }

    private static int lookupForcefieldInversionDSLabel(String label) {
        for (int i = 0; i < FORCEFIELD_INVERSIONDS_LABELS.length; ++i) {
            if (FORCEFIELD_INVERSIONDS_LABELS[i] == null || !FORCEFIELD_INVERSIONDS_LABELS[i].equalsIgnoreCase(label)) continue;
            return i;
        }
        return -1;
    }

    public int getForcefieldNonLinAngleMethod() {
        return this.forcefieldNonLinAngleMethod;
    }

    public int getForcefieldLinAngleMethod() {
        return this.forcefieldLinAngleMethod;
    }

    public double getForceFieldAngleDf() {
        return this.forcefieldNonLingAngleDF;
    }

    public double getForceFieldAngleLowerInterval() {
        return this.forcefieldAngleLowerInterval;
    }

    public int getForceFieldInversionMethod() {
        return this.forcefieldInversionMethod;
    }

    public int getForceFieldDihedralDSMethod() {
        return this.forcefieldDihedralDonwnscaleMethod;
    }

    public double getForceFieldDihedralDSAngle() {
        return this.forcefieldDihedralDownscaleAnglelimit;
    }

    public int getForceFieldInversionDSMethod() {
        return this.forcefieldInversionDownscaleMethod;
    }

    public double getForceFieldInversionDSAngle() {
        return this.forcefieldInversionDownscaleAnglelimit;
    }

    public int getHyperfineMDSterpCount() {
        return this.hyperfineMDStepCount;
    }

    public int getHyperfineMDTemperature() {
        return this.hyperfineMDTemperature;
    }

    public int getOptLimitFinalopt() {
        return this.optLimitFinalopt;
    }

    public void setOptLimitFinalopt(int l) {
        this.optLimitFinalopt = l;
    }

    public double getOptLimitFinaloptValue() {
        return CleanArgs.OPT_LIMITS_VALUES[this.optLimitFinalopt];
    }

    public double getFinalRMSDLimit() {
        return this.finalRMSDLimit;
    }

    public double getFinalDEnergy() {
        return this.finalDEnergy;
    }

    private static String getDiagOptsHelpMessage() {
        if (diagOptsHelpMessage == null) {
            diagOptsHelpMessage = "Help on Clean3D diagnostic options\n\nNote that using these diagnostic/fine tuning options are reserved for test and\ndebug purposes. Using these options can affect the performance and accuracy of\nthe results. Some of these options can alter the input/output structures, can\nwrite diagnostic messages and/or files during execution.\n\nGENERAL FORMAT:\n   The diagnostic options are passed in the same option string using the same\n   format as the standard options. (For details, see \"molconvert -H3D\")\n\nDIAGNOSTIC OPTIONS:\n   [help] Print detailed help                                 (case insensitive)\n      When option [help] given the standard (print by molconvert -H3D) and this\n      diagnostic help will be printed to the standard error.\n\n   [diaginfo] Store diagnostic properties                     (case insensitive)\n      When this option given Clean3D will store some time measurement info and\n      flags into the given structure as SDF string properties.\n\n   [checkgradients] Check numerical/analytical gradients      (case insensitive)\n      Argument 1: save conformers with gradient mismatch\n       {none}:            No structure will be saved\n       {first}: (default) Only the first conformer will be saved for every\n                          structure\n       {all}:             Every conformer will be saved\n      Argument 2: disable numeric gradient check\n       {skipnum}          Skip numeric gradient check. In this case only NaN/Inf\n                          gradient values will be checked\n      Check analytical gradients against computated numerical gradients during\n      optimization process at every gradient calculation. Note that using this\n      options have significant impact on performance and due to the simple check\n      used a reported mismatch does not necessary meens that the analytical\n      gradienst are flawed.\n\n   [angleterm] Parameters for force field angle energy term   (case insensitive)\n      Argument 1: Energy term to use for non-linear equilibrium angles\n      Argument 2: Energy term to use for linear equilibrium angles\n        {mquad}:    Quadaratic component with zero slope at 180 deg\n        {quad}:     Quadaratic component\n        {cos}:      Sqare of cosine angle difference\n      Argument 3: Angle limit where the modified quadratic angle component\n                  starts to converge to zero slope (in degrees)\n\n   [dihedralds] Parameters for dihedral energy term downscale (case insensitive)\n      Argument 1: Downscale method\n        {none}:     Use unmodified (cosine) dihedral energy term\n        {quad}:     Use quadratic slope to downscale when connected bond angle\n                    Is near to linear.\n      Argument 2: Connected bond angle limit where the downscale factor starts\n                  to converge to zero (in degrees)\n\n   [invterm] Parameters for force field inversion energy term (case insensitive)\n      Argument 1: Energy term to use\n        {quad}:     Quadratic term\n        {mquad}:    Modified quadratic\n\n   [invds] Parameters for inversion energy term downscale     (case insensitive)\n      Argument 1: Downscale method\n        {none}:     Do not downscale inversion energy term\n        {quad}:     Use quadratic slope to downscale when any participant bond\n                    angle is near to linear.\n      Argument 2: Bond angle limit where the downscale factor starts to converge\n                  to zero (in degrees)\n\n   [disableffcomponent] Disable FF components                 (case insensitive)\n      Disable forcefield components for debug/diagnostic purpose.\n      Possible argument values:\n         {bond}:      Bond length\n         {angle}:     Bond angle\n         {dihedral}:  Dihedral\n         {inversion}: Inversion\n         {vdw}:       Longrange\n\n    [disabletune] Disable specific FF tunes                   {case insensitive}\n       Disable specific FF tune for debug/diagnostic purpose. Multiple\n       [disabletune] options can be given.\n       Argument 1: Tune short name to disable.\n";
            String[] tsn = MMDiagnosticObserver.getTuneShortNames();
            for (int i = 0; i < tsn.length; ++i) {
                int idi = MMDiagnosticObserver.getTuneID(tsn[i]);
                diagOptsHelpMessage = diagOptsHelpMessage + "         {" + tsn[i] + "}: " + MMDiagnosticObserver.getTuneDescription(idi) + " (" + idi + ")\n";
            }
        }
        return diagOptsHelpMessage;
    }

    private void reportOptionError(String cause) {
        System.err.println("ERROR IN OPTIONS: " + cause);
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("ERROR IN OPTIONS: " + cause);
        }
        throw new UnsupportedOperationException(cause);
    }

    private void processOptionDiversity(int ca, String arg1s) {
        if (ca == 0) {
            this.reportOptionError("No diversity limit given for option [diversity]. Use a float not smaller than 0.1");
            return;
        }
        try {
            double d = Double.parseDouble(arg1s);
            if (d < 0.1) {
                this.reportOptionError("Given diversity limit " + d + " is less than 0.1. Use a float not smaller than 0.1");
            }
            this.finalRMSDLimit = d;
            if (this.finalRMSDLimit > 0.101) {
                this.finalDEnergy = -1.0;
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Diversity limit set to " + d);
            }
        }
        catch (Exception e) {
            this.reportOptionError("Unable to parse diversity limit \"" + arg1s + "\"");
        }
        if (ca > 1) {
            this.reportOptionError("More than 1 argument given for option [diversity]. ");
        }
    }

    public void storeProperties(int cleanState) {
        block13: {
            block12: {
                if (this.finalTimeStamp < 0L) {
                    this.finalTimeStamp = System.currentTimeMillis();
                }
                if (this.optionTimestampGiven) {
                    this.orig.setProperty("TIMESTAMP_beforeclean", "" + this.constructTimeStamp);
                    this.orig.setProperty("TIMESTAMP_afterclean", "" + this.finalTimeStamp);
                    this.orig.setProperty("CLEAN3D_time", "" + (this.finalTimeStamp - this.constructTimeStamp));
                } else {
                    this.orig.setProperty("TIMESTAMP_beforeclean", null);
                    this.orig.setProperty("TIMESTAMP_afterclean", null);
                    this.orig.setProperty("CLEAN3D_time", null);
                }
                if (this.mmdi != null) {
                    this.mmdi.fillCollected(this.orig);
                }
                if (!this.optionDiaginfoGiven) break block12;
                this.memoryOnFinal = Runtime.getRuntime().totalMemory();
                for (int i = 0; i < this.stoppers.size(); ++i) {
                    Stopper s = (Stopper)this.stoppers.get(i);
                    if (!s.isStartInvoked()) continue;
                    this.orig.setProperty(s.getLabel(), s.toString());
                }
                this.orig.setProperty("CLEAND3D_TotalMemory_before_clean", "" + this.memoryOnConstruct);
                this.orig.setProperty("CLEAND3D_TotalMemory_after_clean", "" + this.memoryOnFinal);
                this.orig.setProperty("CLEAND3D_TotalMemory_difference", "" + (this.memoryOnFinal - this.memoryOnConstruct));
                this.orig.setProperty("CLEAN3D_OPTIONSTRING", this.optionString);
                this.orig.setProperty("CLEAN3D_totalvdwcount", "" + Clean3D.OPT_counter_dreidingvdwcount);
                if (this.ins != null) {
                    this.ins.storeFlags(this.orig);
                }
                switch (cleanState) {
                    case 1: {
                        this.orig.setProperty("CLEAN3D_STATUS", "CLEAN3D_OK");
                        break block13;
                    }
                    case 2: {
                        this.orig.setProperty("CLEAN3D_STATUS", "CLEAN3D_FAILED");
                        break block13;
                    }
                    case 3: {
                        this.orig.setProperty("CLEAN3D_STATUS", "CLEAN3D_ABORTED");
                        break block13;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            for (int i = 0; i < STOPPERLABELS.length; ++i) {
                this.orig.setProperty(STOPPERLABELS[i], null);
            }
            this.orig.setProperty("CLEAND3D_TotalMemory_before_clean", null);
            this.orig.setProperty("CLEAND3D_TotalMemory_after_clean", null);
            this.orig.setProperty("CLEAND3D_TotalMemory_difference", null);
            this.orig.setProperty("CLEAN3D_OPTIONSTRING", null);
            this.orig.setProperty("CLEAN3D_totalvdwcount", null);
            this.orig.setProperty("CLEAN3D_STATUS", null);
        }
    }

    public boolean isOptionEgiven() {
        return this.optionEgiven;
    }

    public boolean isOptionPrehydrogenizeGiven() {
        return this.optionPrehydrogenizeGiven;
    }

    public boolean isOptionCheckGradientsGiven() {
        return this.optionCheckGradientsGiven;
    }

    public int getCheckGradientBehavior() {
        return this.checkGradientBehavior;
    }

    public boolean isCheckGradientSkipNum() {
        return this.checkGradientSkipNum;
    }

    public int getOptionCleanerToUse() {
        return this.optionCleanerToUse;
    }

    public int getOptionCleanForce() {
        return this.optionCleanForce;
    }

    private void processOptionTimestamp(int ca) {
        if (ca != 0) {
            this.reportOptionError("Option [Timestamp] (Store timestamps before/after clean in property) does not accept parameter(s).");
            return;
        }
        this.optionTimestampGiven = true;
    }

    private void processOptionE(int ca) {
        if (ca != 0) {
            this.reportOptionError("Option [E] (Store energy in property) does not accept parameter(s).");
            return;
        }
        this.optionEgiven = true;
    }

    private void processOptionPrehydrogenize(int ca) {
        if (ca != 0) {
            this.reportOptionError("Option [prehydrogenize] (Add explicit hydrogenes) does not accept parameter(s).");
            return;
        }
        this.optionPrehydrogenizeGiven = true;
    }

    public void setCleanerToUse(int value) {
        if (this.optionCleanerToUseSet) {
            this.reportOptionError("Cleaner to use option already set.");
            return;
        }
        this.optionCleanerToUseSet = true;
        this.optionCleanerToUse = value;
    }

    private void processOptionC(int ca, String arg1s, String arg2s) {
        if (this.optionCleanerToUseSet) {
            this.reportOptionError("Cleaner to use option already set.");
            return;
        }
        this.optionCleanerToUseSet = true;
        if (ca == 0) {
            this.reportOptionError("No argument given for option [c]. We recommend to use the default value 3 or {" + CLEANER_LABELS[3] + "}");
            return;
        }
        if (ca > 0) {
            boolean found = false;
            for (int i = 0; i < CLEANER_LABELS.length; ++i) {
                if (!arg1s.equalsIgnoreCase(CLEANER_LABELS[i]) && !arg1s.equalsIgnoreCase("" + i)) continue;
                found = true;
                this.optionCleanerToUse = i;
                break;
            }
            if (!found) {
                int i;
                StringBuffer msg = new StringBuffer(100);
                msg.append("First argument - cleaner selection - (");
                msg.append(arg1s);
                msg.append(") given for option [c] is invalid. Use one of");
                for (i = 0; i < CLEANER_LABELS.length; ++i) {
                    msg.append(" ");
                    msg.append(i);
                }
                msg.append(" or");
                for (i = 0; i < CLEANER_LABELS.length; ++i) {
                    msg.append(" {");
                    msg.append(CLEANER_LABELS[i]);
                    msg.append("}");
                }
                msg.append(".");
                this.reportOptionError(msg.toString());
                return;
            }
            if (this.optionCleanerToUse == 1) {
                System.err.println("WARNING! Using old cleaner not recommended.");
            }
        }
        if (ca > 1) {
            if (arg2s.equalsIgnoreCase("0")) {
                this.optionCleanForce = 0;
            } else if (arg2s.equalsIgnoreCase("1")) {
                this.optionCleanForce = 1;
            } else {
                this.reportOptionError("Second, optional argument - force clean 3D for already 3D structures - (" + arg2s + ") given " + "for option [c] is invalid. Use nothing or 1 or 2.");
                return;
            }
        }
        if (ca > 2) {
            this.reportOptionError("Too many arguments (" + ca + ") given for option [c]. " + "Use 1 or 2 arguments.");
            return;
        }
    }

    public boolean isOptimizeResultsRequired() {
        return this.optimizeResults;
    }

    private void processOptionL(int ca, String arg1s) {
        if (ca == 0) {
            this.reportOptionError("No optimization limit given for option [L]. Use an integer between 0 and " + (CleanArgs.OPT_LIMITS_NAMES.length - 1));
            return;
        }
        if (ca == 1) {
            try {
                int j = Integer.parseInt(arg1s);
                if (j >= 0 && j < CleanArgs.OPT_LIMITS_NAMES.length) {
                    this.optLimitFinalopt = j;
                } else {
                    this.reportOptionError("Invalid optimization limit. Use an integer between 0 and " + (CleanArgs.OPT_LIMITS_NAMES.length - 1));
                }
            }
            catch (Exception e) {
                this.reportOptionError("Unable to parse optimization limit. Use an integer between 0 and " + (CleanArgs.OPT_LIMITS_NAMES.length - 1));
                return;
            }
        }
        if (ca > 1) {
            System.err.println("More than 1 argument given for option [L]. Only the first will be processed.");
        }
    }

    private void processOptionO(int ca, String arg1s, String arg2s, String arg3s) {
        if (ca == 0) {
            this.reportOptionError("No argument given for option [o].");
            return;
        }
        if (arg1s.equalsIgnoreCase("1")) {
            this.optimizeResults = true;
        } else if (!arg1s.equalsIgnoreCase("0")) {
            this.reportOptionError("Invalid first argument given for option [o]. Use {1} to force optimization of resulting structures.");
            return;
        }
        if (ca > 1) {
            if (arg2s.equalsIgnoreCase("1")) {
                this.optionEgiven = true;
            } else if (!arg2s.equalsIgnoreCase("0")) {
                this.reportOptionError("Invalid second argument given for option [o]. Use {1} to store energy in property.");
                return;
            }
        }
        if (ca > 2) {
            int li = -1;
            try {
                li = Integer.parseInt(arg3s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (li < 0 || li >= CleanArgs.OPT_LIMITS_VALUES.length) {
                this.reportOptionError("Invalid third argument given for option [0]. Use an integer value between 0 and " + (CleanArgs.OPT_LIMITS_VALUES.length - 1) + "to set optimization limit for results.");
            } else {
                this.optLimitFinalopt = li;
                if (!this.optimizeResults) {
                    System.err.println("WARNING! Optimization limit set by the third argument of option [o] but optimization of resulting structures is not forced. We recommend to use [o]{1}... to force optimization.");
                }
            }
        }
        if (ca > 3) {
            this.reportOptionError("More than 3 arguments given for option [o].");
            return;
        }
    }

    private void processOptionCheckGradients(int ca, String arg1s, String arg2s) {
        if (ca > 0) {
            if (arg1s.equalsIgnoreCase("no") || arg1s.equalsIgnoreCase("none")) {
                this.checkGradientBehavior = 1;
            } else if (arg1s.equalsIgnoreCase("first") || arg1s.equalsIgnoreCase("one")) {
                this.checkGradientBehavior = 2;
            }
            if (arg1s.equalsIgnoreCase("all")) {
                this.checkGradientBehavior = 3;
            } else {
                this.reportOptionError("Parameter for option [checkgradients] incorrect. Use no parameter or none/first/all.");
                return;
            }
        }
        if (ca > 1) {
            if (arg2s.equalsIgnoreCase("skipnum")) {
                this.checkGradientSkipNum = true;
            } else {
                this.reportOptionError("Second parameter for option [checkgradients] incorrect. Use {skipnum} or less than two parameters");
                return;
            }
        }
        if (ca > 2) {
            this.reportOptionError("Option [checkgradients] (Check numerical/analytical gradients) accepts 0,1 or 2 parameter (none/all/first)/(skipnum).");
            return;
        }
        this.optionCheckGradientsGiven = true;
    }

    public boolean isOptionHyperfineGiven() {
        return this.optionHyperfineGiven;
    }

    private void processOptionHyperfine(int ca, String arg1s, String arg2s) {
        this.optionHyperfineGiven = true;
        if (ca > 0) {
            try {
                this.hyperfineMDStepCount = Integer.parseInt(arg1s);
            }
            catch (Exception e) {
                this.reportOptionError("ERROR: Cannot parse step count \"" + arg1s + "\" for option [hyperfine] ");
                return;
            }
        }
        if (ca > 1) {
            try {
                this.hyperfineMDTemperature = Integer.parseInt(arg2s);
            }
            catch (Exception e) {
                this.reportOptionError("ERROR: Cannot parse temperature \"" + arg2s + "\" for option [hyperfine] ");
                return;
            }
        }
        if (ca > 2) {
            this.reportOptionError("Option [hyperfine] accepts at most 2 parameters (MD step count, MD temperature).");
            return;
        }
    }

    private void processOptionDiaginfo(int ca) {
        Stopper s;
        if (ca != 0) {
            this.reportOptionError("Option [diaginfo] (Store diagnostic info) does not accept parameter(s).");
            return;
        }
        this.optionEgiven = true;
        this.optionTimestampGiven = true;
        this.optionDiaginfoGiven = true;
        this.stoppers = new Vector();
        this.OPT_stopper_Buildsequence_construct = s = new Stopper(false, STOPPERLABEL_OPT_stopper_Buildsequence_construct);
        this.stoppers.add(s);
        this.OPT_stopper_Fragclean_FFFaftercheck = s = new Stopper(false, STOPPERLABEL_OPT_stopper_Fragclean_FFFaftercheck);
        this.stoppers.add(s);
        this.OPT_stopper_Fusebuilder_makecoords = s = new Stopper(false, STOPPERLABEL_OPT_stopper_Fusebuilder_makecoords);
        this.stoppers.add(s);
        this.OPT_stopper_MD = s = new Stopper(false, STOPPERLABEL_OPT_stopper_MD);
        this.stoppers.add(s);
        this.OPT_stopper_Optimization = s = new Stopper(false, STOPPERLABEL_OPT_stopper_Optimization);
        this.stoppers.add(s);
        this.OPT_stopper_equivalences = s = new Stopper(false, STOPPERLABEL_OPT_stopper_equivalences);
        this.stoppers.add(s);
        this.memoryOnConstruct = Runtime.getRuntime().totalMemory();
        this.ins = new Instrumentation();
        if (this.mmdi == null) {
            this.mmdi = new MMDiagnosticObserverImpl();
        }
        this.mmdi.doCollectAssociatedTunes();
    }

    public BitSet getForceFieldDisableComponent() {
        return this.forcefieldDisableComponents;
    }

    private void processOptionDisableFFComponent(int ca, String arg1s, String arg2s, String arg3s, String arg4s, String arg5s) {
        if (ca == 0) {
            this.reportOptionError("ERROR: No component given to DisableFFComponent.");
            return;
        }
        String[] args = new String[]{arg1s, arg2s, arg3s, arg4s, arg5s};
        this.forcefieldDisableComponents = new BitSet();
        for (int i = 0; i < ca; ++i) {
            if (args[i].equalsIgnoreCase("bond")) {
                this.forcefieldDisableComponents.set(0);
                continue;
            }
            if (args[i].equalsIgnoreCase("angle")) {
                this.forcefieldDisableComponents.set(1);
                continue;
            }
            if (args[i].equalsIgnoreCase("dihedral")) {
                this.forcefieldDisableComponents.set(2);
                continue;
            }
            if (args[i].equalsIgnoreCase("inversion")) {
                this.forcefieldDisableComponents.set(3);
                continue;
            }
            if (args[i].equalsIgnoreCase("vdw")) {
                this.forcefieldDisableComponents.set(4);
                continue;
            }
            this.reportOptionError("Unknown component to disable: " + args[i]);
            return;
        }
    }

    private void processOptionDisableTune(int ca, String arg1s) {
        if (ca != 1) {
            this.reportOptionError("ERROR: [disabletune] requires 1 argument.");
            return;
        }
        int tid = -1;
        try {
            tid = MMDiagnosticObserver.getTuneID(arg1s);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reportOptionError("ERROR: ivalid argument for [disabletune]:" + arg1s);
            return;
        }
        if (this.mmdi == null) {
            this.mmdi = new MMDiagnosticObserverImpl();
        }
        this.mmdi.disableTune(tid);
    }

    public MMDiagnosticObserver getMMDiagnosticObserver() {
        return this.mmdi;
    }

    public boolean isOptionCAGiven() {
        return this.optionCAGiven;
    }

    public int getGeneratedConformerCount() {
        return this.generatedConformerCount;
    }

    public int getReportedConformerCount() {
        return this.reportedConformerCount;
    }

    public void setSingleReportedConformer() {
        this.reportedConformerCount = 1;
    }

    private void processOptionCA(int ca, String arg1s, String arg2s) {
        this.optionCAGiven = true;
        if (ca == 0) {
            System.err.println("Warning! Option [ca] (generate conformers and store them in property) is given without conformer count argument. Default conformer count (" + this.generatedConformerCount + ") will be applied.");
            return;
        }
        if (ca > 0) {
            try {
                this.reportedConformerCount = Integer.parseInt(arg1s);
                if (this.reportedConformerCount < 1) {
                    this.reportedConformerCount = 0x3FFFFFFF;
                    System.err.println("Warning! Generate ALL conformers. This can run out of memory!");
                }
                this.generatedConformerCount = this.reportedConformerCount;
            }
            catch (Exception e) {
                this.reportOptionError("ERROR: Cannot parse reported conformer count \"" + arg1s + "\" for option [ca] ");
                return;
            }
        }
        if (ca > 1) {
            try {
                this.generatedConformerCount = Integer.parseInt(arg2s);
                if (this.generatedConformerCount < this.reportedConformerCount) {
                    System.err.println("Warning! The value of reported conformer count parameter for option [ca] is smaller than the value of generated conformer count. Value of " + this.reportedConformerCount + " will be used.");
                    this.generatedConformerCount = this.reportedConformerCount;
                }
            }
            catch (Exception e) {
                this.reportOptionError("ERROR: Cannot parse expected conformer count \"" + arg2s + "\" for option [ca] ");
                return;
            }
        }
        if (ca > 2) {
            this.reportOptionError("More than 2 arguments used for option [ca]");
            return;
        }
    }

    public boolean doVerbose() {
        return this.verboseLevel != 0;
    }

    public VerbosePrinter getVerbosePrinter(String title) {
        return CleanArgs.getVerbosePrinter(title);
    }

    public VerbosePrinter getVerbosePrinter(String title, boolean force) {
        return CleanArgs.getVerbosePrinter(title, force);
    }

    public void verbose(String s) {
        if (!this.doVerbose()) {
            return;
        }
        if (this.vp != null) {
            this.vp.print(s);
        }
    }

    public void verbose(String s, String detail) {
        if (!this.doVerbose()) {
            return;
        }
        if (this.vp != null) {
            this.vp.print(s, detail);
        }
    }

    private void processOptionV(int ca, String arg1s) {
        ++this.verboseLevel;
        ++CleanArgs.verboseLevel;
        if (this.vp == null) {
            this.vp = this.getVerbosePrinter("root");
        }
    }

    private void processOptionVV(int ca, String arg1s) {
        this.verboseLevel += 2;
        CleanArgs.verboseLevel += 2;
        if (this.vp == null) {
            this.vp = this.getVerbosePrinter("root");
        }
    }

    private void processOptionAngleTerm(int ca, String arg1s, String arg2s, String arg3s) {
        if (ca != 3) {
            this.reportOptionError("Error: Option [angleterm] requires three parameters: [angleterm]{ nonlineq: cos|quad|mquad }{ lineq: cos|quad|mquad }{ quadangleinterval }");
            return;
        }
        this.forcefieldNonLinAngleMethod = CleanSettings.lookupForcefieldAngleLabel(arg1s);
        if (this.forcefieldNonLinAngleMethod == -1) {
            this.reportOptionError("Error: Unable to parse energy term specification for non-linear equilibrium bond angles. Use \"cos\" \"quad\" or \"mquad\".");
            return;
        }
        this.forcefieldLinAngleMethod = CleanSettings.lookupForcefieldAngleLabel(arg2s);
        if (this.forcefieldLinAngleMethod == -1) {
            this.reportOptionError("Error: Unable to parse energy term specification for linear equilibrium bond angles. Use \"cos\" \"quad\" or \"mquad\".");
            return;
        }
        try {
            this.forcefieldNonLingAngleDF = Double.parseDouble(arg3s);
        }
        catch (Exception e) {
            this.reportOptionError("Unable to parse angle interval given: " + arg3s);
            return;
        }
        if (this.forcefieldNonLingAngleDF < 130.0 || this.forcefieldNonLingAngleDF >= 180.0) {
            this.reportOptionError("Angle interval " + this.forcefieldNonLingAngleDF + " is out of range. Use a value not smaller than 130 deg");
            return;
        }
    }

    private void processOptionInvTerm(int ca, String arg1s) {
        if (ca != 1) {
            this.reportOptionError("Error: Option [invterm] requires one parameter: [invterm]{ quad|mquad }");
            return;
        }
        this.forcefieldInversionMethod = CleanSettings.lookupForcefieldInversionLabel(arg1s);
        if (this.forcefieldInversionMethod == -1) {
            this.reportOptionError("Error: Unable to parse energy term specification. Use \"quad\" or \"mquad\".");
            return;
        }
    }

    private void processOptionDihedralDS(int ca, String arg1s, String arg2s) {
        if (ca != 2) {
            this.reportOptionError("ERROR: Option [dihedralds] requires two arguments.");
            return;
        }
        this.forcefieldDihedralDonwnscaleMethod = CleanSettings.lookupForcefieldDihedralDSLabel(arg1s);
        if (this.forcefieldDihedralDonwnscaleMethod < 0) {
            this.reportOptionError("ERROR: Unable to parse downscale method in option [dihedralds]: " + arg1s);
            return;
        }
        try {
            this.forcefieldDihedralDownscaleAnglelimit = Double.parseDouble(arg2s);
        }
        catch (Exception e) {
            this.reportOptionError("Unable to parse angle interval given: " + arg2s);
            return;
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("[dihedralds] Downscale method: {" + FORCEFIELD_DIHEDRALDS_LABELS[this.forcefieldDihedralDonwnscaleMethod] + "} with angle limit " + this.forcefieldDihedralDownscaleAnglelimit + " (in deg.) set.");
        }
    }

    private void processOptionInvDS(int ca, String arg1s, String arg2s) {
        if (ca != 2) {
            this.reportOptionError("ERROR: Option [invds]] requires two arguments.");
            return;
        }
        this.forcefieldInversionDownscaleMethod = CleanSettings.lookupForcefieldInversionDSLabel(arg1s);
        if (this.forcefieldInversionDownscaleMethod < 0) {
            this.reportOptionError("ERROR: Unable to parse downscale method in option [invds]: " + arg1s);
            return;
        }
        try {
            this.forcefieldInversionDownscaleAnglelimit = Double.parseDouble(arg2s);
        }
        catch (Exception e) {
            this.reportOptionError("Unable to parse angle interval given: " + arg2s);
            return;
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("[invds] Downscale method: {" + FORCEFIELD_INVERSIONDS_LABELS[this.forcefieldInversionMethod] + "} with angle limit " + this.forcefieldInversionDownscaleAnglelimit + " (in deg.) set.");
        }
    }

    private boolean processOptionS(int ca, String arg1s) {
        if (ca == 0) {
            this.reportOptionError("ERROR: No clean strategy given for option [S]");
            return false;
        }
        if (ca > 1) {
            this.reportOptionError("ERROR: More than one argument used for option [S]");
            return false;
        }
        if (arg1s.equals("4") || arg1s.equals("conformers")) {
            if (!this.optionCAGiven) {
                this.optionCAGiven = true;
                this.reportedConformerCount = 20;
                this.generatedConformerCount = 20;
            }
            return true;
        }
        return false;
    }

    private boolean processOptionTimelimit(int ca, String arg1s) {
        if (ca == 0) {
            this.reportOptionError("ERROR: No time limit value given for option [timelimit].");
            return false;
        }
        if (ca > 1) {
            this.reportOptionError("ERROR: More than one argument used for option [timelimit]");
            return false;
        }
        try {
            double d = Double.parseDouble(arg1s);
            if (!U.isDoubleOK(d)) {
                this.reportOptionError("Error in timelimit value: " + arg1s);
                return false;
            }
            this.optionTimelimitValue = d > 0.0 ? Math.round(d * 1000.0) : 0L;
            this.optionTimelimitGiven = true;
        }
        catch (Exception e) {
            this.reportOptionError("Cannot read timelimit from " + arg1s);
            return false;
        }
        return true;
    }

    private void processOptionHelp(int ca) {
        if (ca != 0) {
            this.reportOptionError("ERROR: Option [help] does not accept parameter(s).");
            return;
        }
        System.err.println("Standard and diagnostic help");
        System.err.println("============================");
        System.err.println();
        System.err.println("Note that the default Clean3D help is accessibble using\"molconvert -H3D\"");
        System.err.println();
        System.err.println(CleanArgs.getDefaultHelpMessage());
        System.err.println(CleanSettings.getDiagOptsHelpMessage());
    }

    private void processOptionVerbose(String[] opt) {
        EnumMap<Verbosers, StdErrSimpleVerbosePrinter> newMap = new EnumMap<Verbosers, StdErrSimpleVerbosePrinter>(Verbosers.class);
        int level = 1;
        if (opt.length > 1) {
            try {
                level = Integer.parseInt(opt[1]);
            }
            catch (NumberFormatException e) {
                this.reportOptionError("Option [verbose] first argument must be an integer. Given: " + opt[1]);
            }
        }
        for (Verbosers v : Verbosers.values()) {
            newMap.put(v, new StdErrSimpleVerbosePrinter(level, v.getName()));
        }
        for (int pos = 2; pos < opt.length; ++pos) {
            Verbosers fv = null;
            for (Verbosers v : Verbosers.values()) {
                if (!v.getName().equalsIgnoreCase(opt[pos])) continue;
                fv = v;
                break;
            }
            if (fv == null) {
                this.reportOptionError("Invalid verboser " + opt[pos]);
            }
            int l = 1;
            if (++pos < opt.length) {
                try {
                    l = Integer.parseInt(opt[pos]);
                }
                catch (NumberFormatException e) {
                    this.reportOptionError("Verboser level must be an integer. Given: " + opt[pos]);
                }
            }
            if (((SimpleVerbosePrinter)newMap.get((Object)fv)).getMaxEnabledLevel() >= l) continue;
            newMap.put(fv, new StdErrSimpleVerbosePrinter(l, fv.getName()));
        }
        for (Verbosers v : Verbosers.values()) {
            SimpleVerbosePrinter oldvp = this.verbosePrinters.get((Object)v);
            SimpleVerbosePrinter newvp = (SimpleVerbosePrinter)newMap.get((Object)v);
            if (newvp == null) continue;
            if (oldvp == null) {
                this.verbosePrinters.put(v, newvp);
                continue;
            }
            if (oldvp.getMaxEnabledLevel() >= newvp.getMaxEnabledLevel()) continue;
            this.verbosePrinters.put(v, newvp);
        }
    }

    private boolean processOption(String[] opt) {
        String arg5s;
        String co = opt.length > 0 ? opt[0] : "";
        int ca = opt.length - 1;
        String arg1s = ca >= 1 ? opt[1] : "";
        String arg2s = ca >= 2 ? opt[2] : "";
        String arg3s = ca >= 3 ? opt[3] : "";
        String arg4s = ca >= 4 ? opt[4] : "";
        String string = arg5s = ca >= 5 ? opt[5] : "";
        if (this.vp != null) {
            this.vp.print("Processing option " + co, "ca=" + ca + " {" + arg1s + "}{" + arg2s + "}{" + arg3s + "}{" + arg4s + "}{" + arg5s + "}");
        }
        if (co.equalsIgnoreCase("ca")) {
            this.processOptionCA(ca, arg1s, arg2s);
            return true;
        }
        if (co.equalsIgnoreCase("l")) {
            this.processOptionL(ca, arg1s);
            return true;
        }
        if (co.equalsIgnoreCase("diversity")) {
            this.processOptionDiversity(ca, arg1s);
            return true;
        }
        if (co.equalsIgnoreCase("e")) {
            this.processOptionE(ca);
            return true;
        }
        if (co.equalsIgnoreCase("timestamp")) {
            this.processOptionTimestamp(ca);
            return true;
        }
        if (co.equalsIgnoreCase("diaginfo")) {
            this.processOptionDiaginfo(ca);
            return true;
        }
        if (co.equalsIgnoreCase("checkgradients") || co.equalsIgnoreCase("checkgradient")) {
            this.processOptionCheckGradients(ca, arg1s, arg2s);
            return true;
        }
        if (co.equalsIgnoreCase("prehydrogenize") || co.equalsIgnoreCase("hydrogenize")) {
            this.processOptionPrehydrogenize(ca);
            return true;
        }
        if (co.equalsIgnoreCase("c")) {
            this.processOptionC(ca, arg1s, arg2s);
            return true;
        }
        if (co.equalsIgnoreCase("o")) {
            this.processOptionO(ca, arg1s, arg2s, arg3s);
            return true;
        }
        if (co.equalsIgnoreCase("s")) {
            return this.processOptionS(ca, arg1s);
        }
        if (co.equalsIgnoreCase("v")) {
            this.processOptionV(ca, arg1s);
            return true;
        }
        if (co.equalsIgnoreCase("vv")) {
            this.processOptionVV(ca, arg1s);
            return true;
        }
        if (co.equalsIgnoreCase("timelimit")) {
            this.processOptionTimelimit(ca, arg1s);
            return true;
        }
        if (co.equalsIgnoreCase("hyperfine") || co.equalsIgnoreCase("hiperfine")) {
            this.processOptionHyperfine(ca, arg1s, arg2s);
            return true;
        }
        if (co.equalsIgnoreCase("help")) {
            this.processOptionHelp(ca);
            return true;
        }
        if (co.equalsIgnoreCase("angleterm")) {
            this.processOptionAngleTerm(ca, arg1s, arg2s, arg3s);
            return true;
        }
        if (co.equalsIgnoreCase("dihedralds")) {
            this.processOptionDihedralDS(ca, arg1s, arg2s);
            return true;
        }
        if (co.equalsIgnoreCase("invterm")) {
            this.processOptionInvTerm(ca, arg1s);
            return true;
        }
        if (co.equalsIgnoreCase("invds")) {
            this.processOptionInvDS(ca, arg1s, arg2s);
            return true;
        }
        if (co.equalsIgnoreCase("disableffcomponent")) {
            this.processOptionDisableFFComponent(ca, arg1s, arg2s, arg3s, arg4s, arg5s);
            return true;
        }
        if (co.equalsIgnoreCase("disabletune")) {
            this.processOptionDisableTune(ca, arg1s);
            return true;
        }
        if (co.equalsIgnoreCase("verbose")) {
            this.processOptionVerbose(opt);
            return true;
        }
        if (this.vp != null) {
            this.vp.print("NOT FOUND");
        }
        return false;
    }

    public String[][] tokenizeOptions(String opts) {
        if (opts == null) {
            return new String[0][];
        }
        Vector<String[]> optv = new Vector<String[]>();
        String[][] opt = TextUtils.tokenizeOptions(opts, null);
        for (int i = 0; i < opt.length; ++i) {
            optv.add(opt[i]);
            if (opt[i][0].equalsIgnoreCase("v")) {
                this.processOptionV(-1, null);
                continue;
            }
            if (!opt[i][0].equalsIgnoreCase("vv")) continue;
            this.processOptionVV(-1, null);
        }
        if (this.vp != null) {
            this.vp.print("Processing option string: " + opts);
        }
        Vector<String[]> ret = new Vector<String[]>();
        for (int i = 0; i < optv.size(); ++i) {
            String[] optvs = (String[])optv.get(i);
            if (this.processOption(optvs)) continue;
            ret.add(optvs);
        }
        String[][] rets = new String[ret.size()][];
        for (int i = 0; i < ret.size(); ++i) {
            rets[i] = (String[])ret.get(i);
        }
        if (this.optionDiaginfoGiven) {
            this.optionString = opts;
        }
        return rets;
    }

    private void initCancellerProgress() {
        long timeoutInMs = this.optionTimelimitValue;
        if (!this.optionTimelimitGiven) {
            timeoutInMs = CleanArgs.cltracer != null ? 0x6DDD00L : (this.optionCAGiven ? 300000L : 120000L);
        }
        if (timeoutInMs <= 0L && this.pmon == null) {
            this.cancellerInited = true;
            this.canceller = null;
            return;
        }
        TimeoutCancellerImpl toc = new TimeoutCancellerImpl(timeoutInMs);
        if (this.pmon != null) {
            ProgressTools.MProgressMonitorHolder pmh;
            this.pmonh = pmh = new ProgressTools.MProgressMonitorHolder(this.pmon, "Clean3D progress", toc);
            CallbackIface cb = new CallbackIface(){
                boolean inited = false;
                double max = 1.0E7;
                double cur = 0.0;

                @Override
                public Object callback(String method, Object arg) {
                    if (!this.inited) {
                        pmh.init((int)this.max);
                        this.inited = true;
                    } else {
                        this.cur += (this.max - this.cur) * 0.002;
                        if (this.cur > this.max) {
                            this.cur = this.max;
                        }
                    }
                    pmh.set((int)this.cur);
                    return null;
                }
            };
            toc.setPing100ms(cb);
        }
        this.canceller = toc;
    }

    public void closeProgress() {
        if (this.pmonh != null) {
            this.pmonh.close();
        }
    }

    public SimpleCanceller getCanceller() {
        if (!this.cancellerInited) {
            this.initCancellerProgress();
            this.cancellerInited = true;
        }
        return this.canceller;
    }

    public CleanSettings(Molecule orig, MProgressMonitor progressMonitor) {
        this.orig = orig;
        this.constructTimeStamp = System.currentTimeMillis();
        this.pmon = progressMonitor;
        this.verbosePrinters = new EnumMap<Verbosers, SimpleVerbosePrinter>(Verbosers.class);
        for (Verbosers v : Verbosers.values()) {
            this.verbosePrinters.put(v, new StdErrSimpleVerbosePrinter(0, v.name));
        }
        String verboseProp = null;
        try {
            verboseProp = System.getenv(VERBOSE_CFG_ENV);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (verboseProp != null) {
            boolean malformed = false;
            String[][] vopt = TextUtils.tokenizeOptions("[verbose]" + verboseProp, null);
            if (vopt != null) {
                if (vopt.length > 1) {
                    malformed = true;
                }
                for (int i = 0; i < vopt.length; ++i) {
                    if (!vopt[i][0].equalsIgnoreCase("verbose")) continue;
                    try {
                        this.processOptionVerbose(vopt[i]);
                        continue;
                    }
                    catch (Exception e) {
                        malformed = true;
                    }
                }
            }
            if (malformed) {
                System.err.println("WARNING! Malformed environmental variable name=\"chemaxon_clean3d_options_verbose\" value=\"" + verboseProp + "\"");
                System.err.println("Execution will not stop, verbose configuration might be incomplete.");
            }
        }
    }

    public String getSourceSmiles() {
        if (this.orig == null) {
            return null;
        }
        if (this.origInSmiles == null) {
            this.origInSmiles = this.orig.toFormat("smiles:-H");
        }
        return this.origInSmiles;
    }

    public Instrumentation getInst() {
        return this.ins;
    }

    public static enum Verbosers {
        GENERAL("GENERAL", "General 3D coordinate generation specific messages"),
        HYPERFINE("HYPERFINE", "Hyperfine specific messages"),
        CONFANAL("CONFANAL", "Finding multiple conformers specific messages");

        String name;
        String desc;

        private Verbosers(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

