/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling;

import chemaxon.marvin.modelling.debug.debugPrintout;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.StringTokenizer;

public class TextUtils {
    private static DecimalFormat myFormatter = null;
    static DecimalFormat f = new DecimalFormat("0.###################");

    public static String formatTimeSMMM(long time) {
        StringBuffer ret = new StringBuffer(10);
        ret.append(time / 1000L);
        ret.append(".");
        String fr = String.valueOf(time % 1000L);
        for (int i = 3; i > fr.length(); --i) {
            ret.append('0');
        }
        ret.append(fr);
        return ret.toString();
    }

    public static String formatNumber(int number, int digits) {
        return TextUtils.formatNumber(number, digits, ' ');
    }

    public static String formatNumber(int number, int digits, char leftPaddingChar) {
        return TextUtils.formatNumber(number, digits, leftPaddingChar, null);
    }

    public static String formatNumber(int number, int digits, char leftPaddingChar, String optionalRightPadding) {
        StringBuffer b = new StringBuffer(digits);
        String s = Integer.toString(number);
        if (s.length() < digits && optionalRightPadding != null) {
            s = s + optionalRightPadding.substring(0, Math.min(optionalRightPadding.length(), digits - s.length()));
        }
        for (int i = s.length(); i < digits; ++i) {
            b.append(leftPaddingChar);
        }
        b.append(s);
        return b.toString();
    }

    public static String formatNumberCenter(int number, int digits, char paddingChar) {
        int i;
        StringBuffer b = new StringBuffer(digits);
        String s = Integer.toString(number);
        int lpc = (digits - s.length()) / 2;
        int rpc = digits - s.length() - lpc;
        for (i = 0; i < lpc; ++i) {
            b.append(paddingChar);
        }
        b.append(s);
        for (i = 0; i < rpc; ++i) {
            b.append(paddingChar);
        }
        return b.toString();
    }

    public static String formatNumber(double number, int totalLength, int validDigits, int fracPlaces) {
        int i;
        StringBuffer ret = new StringBuffer(totalLength);
        ret.append(TextUtils.formatNumber(number, validDigits));
        int dp = ret.indexOf(".");
        if (dp == -1) {
            for (i = 0; i <= fracPlaces && ret.length() < totalLength - 1; ++i) {
                ret.append(' ');
            }
        } else {
            for (i = fracPlaces - dp + ret.length() - 1; i <= fracPlaces && ret.length() < totalLength - 1; ++i) {
                ret.append(' ');
            }
        }
        while (ret.length() < totalLength) {
            ret.insert(0, ' ');
        }
        return ret.toString();
    }

    public static String formatNumber(double number, int validDigits) {
        String ret = f.format(number);
        if (ret.startsWith("0.") || ret.startsWith("-0.")) {
            for (int i = 0; i < ret.length(); ++i) {
                char ci = ret.charAt(i);
                if (!Character.isDigit(ci) || ci == '0') continue;
                return ret.substring(0, Math.min(ret.length(), i + validDigits));
            }
            return ret;
        }
        int endc = 0;
        int valids = 0;
        for (int i = 0; i < ret.length(); ++i) {
            char ci = ret.charAt(i);
            if (Character.isDigit(ci)) {
                ++valids;
            }
            if (ci == '.') {
                if (valids >= validDigits) break;
                endc = Math.min(ret.length(), i + validDigits - valids + 1);
                break;
            }
            endc = i + 1;
        }
        return ret.substring(0, endc);
    }

    public static String formatNumber(double number) {
        String out;
        char[] outc;
        if (Double.isNaN(number)) {
            return "NaN";
        }
        if (Double.isInfinite(number)) {
            return "Inf";
        }
        if (myFormatter == null) {
            myFormatter = new DecimalFormat("00.000");
        }
        if ((outc = (out = (number < 0.0 ? "" : " ") + myFormatter.format(number)).toCharArray()).length >= 7) {
            int n = outc[1] = outc[1] == '0' ? 32 : outc[1];
            if (outc[6] == '0') {
                outc[6] = 32;
                if (outc[5] == '0') {
                    outc[5] = 32;
                    if (outc[4] == '0') {
                        outc[4] = 32;
                        outc[3] = 32;
                    }
                }
            }
            if (outc[1] == ' ') {
                outc[1] = outc[0];
                outc[0] = 32;
            }
            out = String.valueOf(outc);
        }
        return out;
    }

    public static String[] split(String ins) {
        if (ins == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(ins, ",");
        int s = tok.countTokens();
        String[] ret = new String[s];
        for (int i = 0; i < s; ++i) {
            ret[i] = tok.nextToken().trim();
        }
        return ret;
    }

    public static String[][] tokenizeOptions(String s, debugPrintout debug) {
        if (s == null) {
            return new String[0][0];
        }
        int i = 0;
        int[] ct = new int[s.length()];
        int[] num = new int[s.length()];
        boolean optionFound = false;
        int opts = 0;
        int paramNo = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '[') {
                optionFound = true;
                paramNo = 0;
                ++i;
                while (i < s.length() && s.charAt(i) != ']') {
                    ct[i] = 1;
                    num[i] = opts;
                    ++i;
                }
                ++i;
                ++opts;
                continue;
            }
            if (TextUtils.isAlphabeticCharacter(c)) {
                optionFound = true;
                paramNo = 0;
                ct[i] = 1;
                num[i] = opts++;
                ++i;
                continue;
            }
            if (c == '{') {
                ++i;
                while (i < s.length() && s.charAt(i) != '}') {
                    if (optionFound) {
                        ct[i] = 2;
                        num[i] = paramNo;
                    }
                    ++i;
                }
                ++i;
                ++paramNo;
                continue;
            }
            if (TextUtils.isDigit(c)) {
                if (optionFound) {
                    ct[i] = 2;
                    num[i] = paramNo++;
                }
                ++i;
                continue;
            }
            if (c != '?') {
                System.err.println("Non recognized option character: " + c);
            }
            ++i;
        }
        String[][] ret = new String[opts][];
        i = 0;
        for (opts = 0; i < s.length() && opts < ret.length; ++opts) {
            int k;
            int j;
            while (i < s.length() && ct[i] != 1) {
                ++i;
            }
            int params = 1;
            for (j = i; j < s.length() && (ct[j] != 1 || num[j] <= num[i]); ++j) {
                if (ct[j] != 2) continue;
                params = num[j] + 2;
            }
            ret[opts] = new String[params];
            for (k = 0; k < params; ++k) {
                ret[opts][k] = "";
            }
            for (j = i; j < s.length() && (ct[j] != 1 || num[j] <= num[i]); ++j) {
                if (ct[j] == 1) {
                    ret[opts][0] = ret[opts][0] + s.charAt(j);
                    continue;
                }
                if (ct[j] != 2 || (k = num[j] + 1) >= ret[opts].length) continue;
                ret[opts][k] = ret[opts][k] + s.charAt(j);
            }
            i = j;
        }
        while (opts < ret.length) {
            ret[opts] = new String[1];
            ret[opts][0] = "";
            ++opts;
            if (debug == null) continue;
            debug.reportError("Option string tokenization error");
        }
        if (debug != null) {
            debug.incLevel("Tokenized options");
            debug.println("Option string: " + s);
            debug.print("<TABLE BORDER=1><TR><TD><B>Option string:</B></TD>");
            for (i = 0; i < s.length(); ++i) {
                debug.print("<TD>" + s.charAt(i) + "</TD>");
            }
            debug.print("</TR><TR><TD><B>Character ID</B><BR>0: ignored<BR>1: Name<BR>2: argument</TD>");
            for (i = 0; i < s.length(); ++i) {
                debug.print("<TD>" + ct[i] + "</TD>");
            }
            debug.print("</TR><TR><TD><B>Number</B>");
            for (i = 0; i < s.length(); ++i) {
                debug.print("<TD>" + num[i] + "</TD>");
            }
            debug.println("</TR></TABLE>");
            int maxp = 0;
            for (i = 0; i < ret.length; ++i) {
                if (ret[i].length <= maxp) continue;
                maxp = ret[i].length;
            }
            debug.print("<TABLE BORDER=1><TR><TD></TD><TD><B>Option name:</B></TD><TD COLSPAN=" + maxp + "><B>Option arguments:</B></TD>");
            for (i = 0; i < ret.length; ++i) {
                debug.print("<TR><TD>" + i + "</TD><TD>" + ret[i][0] + "</TD>");
                for (int j = 1; j < ret[i].length; ++j) {
                    debug.print("<TD>" + ret[i][j] + "</TD>");
                }
                debug.print("</TR>");
            }
            debug.println("</TABLE>");
            debug.decLevel();
        }
        return ret;
    }

    public static boolean isAlphabeticCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isAlphaNumericCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isURL(String s) {
        try {
            URL u = new URL(s);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return s.trim().startsWith("www") && s.lastIndexOf(".") != s.indexOf(".") && s.trim().split(" ").length == 1;
        }
    }
}

