/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.formats.MolExporter;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.build.BuildCommand;
import chemaxon.marvin.modelling.build.BuildSequence;
import chemaxon.marvin.modelling.build.FragClean;
import chemaxon.marvin.modelling.debug.SimpleVerbosePrinter;
import chemaxon.marvin.modelling.debug.VerbosePrinter;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.diag.Instrumentation;
import chemaxon.marvin.modelling.struc.ConformersDescriptor;
import chemaxon.marvin.modelling.struc.Fragment;
import chemaxon.marvin.modelling.struc.FragmentConformer;
import chemaxon.marvin.modelling.struc.FragmentPool;
import chemaxon.marvin.modelling.struc.Multiconformer;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.IntSet;
import chemaxon.marvin.modelling.util.ProgressMonitor;
import chemaxon.marvin.modelling.util.ProgressTools;
import chemaxon.marvin.modelling.util.SimpleCanceller;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.Molecule;
import java.util.Vector;

public abstract class BuildCommandBase
implements Multiconformer {
    private boolean useHBonds = false;
    Fragment fragment = null;
    private double minrmsd = 0.1;
    private double optLimit = CleanSettings.BUILDCOMMAND_DEFAULTOPTLIMITVALUE;
    private double denergylimit = 200.0;
    private boolean skipProxBlenEqCheck = false;
    private int state = 0;
    public static final int STATE_CREATED = 0;
    public static final int STATE_SUCCES = 1;
    public static final int STATE_FAIL = 2;
    public static final int STATE_CANCEL = 3;
    private boolean buildInProgress = false;
    private double[][][] coordinates;
    private double[][][] lastCoordinates;
    private double[] energies;
    private double[] lastEnergies;
    private double[][][] lastReportedCoordinates = null;
    private double[] lastReportedEnergies = null;
    CleanSettings cleanSettings = null;
    SimpleVerbosePrinter verbosePrinter = null;
    FragmentPool poolRawGeneratedConformers = null;
    FragmentPool poolFilteredConformers = null;
    FragmentPool poolSoftErrorBeforeOptimization = null;
    FragmentPool poolSoftErrorAfterOptimization = null;
    FragmentPool poolHardError = null;
    FragmentPool poolStereoError = null;
    Vector registeredConformers = null;
    private int stateLastInvokeBuild = 0;
    private BuildEffort lastInvokeBuildEffort = null;
    private boolean fallbackEnabled = true;
    private BuildCommandBase fallbackCommand = null;
    boolean requestFallback = false;
    private int maxBuildCounter = -1;
    private ProgressMonitor pm = null;
    private ProgressMonitor ownpm = null;
    private Vector subtreeWeights = new Vector();
    private double ownWeight;
    private SimpleCanceller canceller = null;
    Vector subtrees = new Vector();
    private BuildCommand parentCommand = null;

    public void setUseHBonds(boolean b) {
        this.useHBonds = b;
    }

    abstract myMolecule getOrigMol();

    abstract BuildSequence.Build getCommand();

    public Fragment getFragment() {
        if (this.fragment == null) {
            this.fragment = new Fragment(this.getOrigMol(), this.getCommand().getAtoms(), this.getCommand().getAnchAtoms(), this.getCommand().getFragmentStereo(this.cleanSettings), this.cleanSettings);
            this.fragment.setUseHBondsInDreiding(this.useHBonds);
        }
        return this.fragment;
    }

    public int[] getAtomList() {
        return this.getCommand().getAtoms();
    }

    public void setMinRMSD(double d) {
        this.minrmsd = d;
    }

    public double getMinRMSD() {
        return this.minrmsd;
    }

    public double getOptLimit() {
        return this.optLimit;
    }

    public void setOptLimit(double value) {
        this.optLimit = value;
    }

    public void setDenergyLimit(double d) {
        this.denergylimit = d;
    }

    public double getDenergyLimit() {
        return this.denergylimit;
    }

    public boolean getSkipProxBlenEqCheck() {
        return this.skipProxBlenEqCheck;
    }

    public void doSkipProxBlenEqCheck() {
        this.skipProxBlenEqCheck = true;
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.printB("Set doSkipProx....");
        }
    }

    private void setState(int state) {
        if (state == 3 || state == 2) {
            this.lastCoordinates = null;
            this.lastEnergies = null;
        }
        this.state = state;
    }

    public int getState() {
        if (this.buildInProgress) {
            throw new UnsupportedOperationException("Build in progress");
        }
        return this.state;
    }

    public String getStateString() {
        return BuildCommandBase.getStateString(this.getState());
    }

    public static String getStateString(int s) {
        switch (s) {
            case 3: {
                return "CANCEL";
            }
            case 0: {
                return "CREATED";
            }
            case 2: {
                return "FAIL";
            }
            case 1: {
                return "SUCCES";
            }
        }
        return "ERROR: nuknown state " + s;
    }

    public BuildCommandBase(CleanSettings settings) {
        this.cleanSettings = settings;
        this.canceller = settings.getCanceller();
    }

    @Override
    public double[][][] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public double[] getEnergies() {
        return this.energies;
    }

    @Override
    public int getAtomCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getConfCount() {
        if (this.coordinates == null) {
            return 0;
        }
        return this.coordinates.length;
    }

    @Override
    public double[][] getCoordinates(int confid) {
        return this.coordinates[confid];
    }

    @Override
    public void applyConfPerm(int[] confperm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCoordinates(double[][][] coordinates) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEnergies(double[] energies) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeConformer(int confid) {
        throw new UnsupportedOperationException();
    }

    protected void registerCoordinates(double[][][] coords) {
        if (this.lastReportedCoordinates != null) {
            System.err.println("WARNING: Multiple invocation of registerCoordinates()");
            throw new UnsupportedOperationException();
        }
        this.lastReportedCoordinates = coords;
    }

    protected void registerEnergies(double[] e) {
        if (this.lastReportedEnergies != null) {
            System.err.println("WARNING: Multiple invocation of registerEnergies()");
            throw new UnsupportedOperationException();
        }
        this.lastReportedEnergies = e;
        if (this.lastReportedCoordinates != null && this.lastReportedCoordinates.length != this.lastReportedEnergies.length) {
            System.err.println("WARNING: Reported coordinate and energy count and mismatch.");
            throw new UnsupportedOperationException();
        }
    }

    public double[][][] getMoreCoordinates() {
        if (this.getState() != 1) {
            return null;
        }
        return this.lastCoordinates;
    }

    public double[] getMoreEnergies() {
        if (this.getState() != 1) {
            return null;
        }
        return this.lastEnergies;
    }

    protected void reportFilteredConformers(int news) {
        debugPrintout debug = CleanArgs.getDebug();
        this.lastCoordinates = new double[news][][];
        this.lastEnergies = new double[news];
        this.poolFilteredConformers.sortByEnergy();
        for (int i = 0; i < news; ++i) {
            FragmentConformer fc = this.poolFilteredConformers.remove(0);
            this.lastCoordinates[i] = fc.getCoordinates();
            this.lastEnergies[i] = fc.getEnergy();
        }
        if (this.coordinates == null) {
            if (debug != null) {
                debug.println("coordinates = lastCoordinates");
            }
            this.coordinates = this.lastCoordinates;
            this.energies = this.lastEnergies;
        } else {
            int i;
            if (debug != null) {
                debug.println("merge lasts");
            }
            if (this.coordinates.length != this.energies.length) {
                System.err.println("WARNING! coordinates-energy size inconsistency!");
            }
            double[][][] newCoordinates = new double[this.coordinates.length + news][][];
            double[] newEnergies = new double[this.energies.length + news];
            int j = 0;
            for (i = 0; i < this.coordinates.length; ++i) {
                newCoordinates[j] = this.coordinates[i];
                newEnergies[j++] = this.energies[i];
            }
            for (i = 0; i < this.lastCoordinates.length; ++i) {
                newCoordinates[j] = this.lastCoordinates[i];
                newEnergies[j++] = this.lastEnergies[i];
            }
            this.coordinates = newCoordinates;
            this.energies = newEnergies;
        }
    }

    public void registerConformer(FragmentConformer fc) {
        if (this.registeredConformers == null) {
            this.registeredConformers = new Vector();
        }
        this.registeredConformers.add(fc);
    }

    private int fillRawPool(FragmentPool pool) {
        int i;
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.printB("fillRawPool(). Size before: " + pool.size());
        }
        if (this.lastReportedCoordinates == null && this.registeredConformers == null) {
            if (debug != null) {
                debug.println("no last reported");
            }
            return 0;
        }
        int ret = 0;
        if (this.lastReportedCoordinates != null) {
            ret += this.lastReportedCoordinates.length;
            for (i = 0; i < this.lastReportedCoordinates.length; ++i) {
                FragmentConformer fc = null;
                fc = this.lastReportedEnergies == null ? new FragmentConformer(this.getFragment(), this.lastReportedCoordinates[i]) : new FragmentConformer(this.getFragment(), this.lastReportedCoordinates[i], this.lastReportedEnergies[i]);
                pool.addConformer(fc);
            }
        }
        if (this.registeredConformers != null) {
            for (i = 0; i < this.registeredConformers.size(); ++i) {
                pool.addConformer((FragmentConformer)this.registeredConformers.get(i));
            }
            ret += this.registeredConformers.size();
            this.registeredConformers.removeAllElements();
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Additional registered conformers added");
            }
        }
        if (debug != null) {
            pool.printout("Last repored coordinates (" + pool.size() + ")", debug);
        }
        this.lastReportedCoordinates = null;
        this.lastReportedEnergies = null;
        return ret;
    }

    protected int getStateLastInvokeBuild() {
        return this.stateLastInvokeBuild;
    }

    protected int callInvokeBuild(int expectedConformers, BuildEffort effort, boolean reportAll) {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.printB("callInvokeBuild( " + expectedConformers + "," + effort.toString() + ")");
        }
        if (this.stateLastInvokeBuild == 3 || effort.isCancelled()) {
            if (debug != null) {
                debug.println("return state cancelled");
            }
            return 0;
        }
        if (this.stateLastInvokeBuild == 2 && !this.lastInvokeBuildEffort.isNarrowerThan(effort)) {
            if (debug != null) {
                debug.println("return fail. previous failed on " + this.lastInvokeBuildEffort.toString());
            }
            return 0;
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Pools state", this.poolStateToString());
        }
        this.stateLastInvokeBuild = this.invokeBuild(expectedConformers, effort);
        this.lastInvokeBuildEffort = effort;
        if (this.stateLastInvokeBuild == 3 || effort.isCancelled()) {
            if (debug != null) {
                debug.println("Cancelled");
            }
            return 3;
        }
        int n = 0;
        n = this.skipProxBlenEqCheck ? this.fillRawPool(this.poolFilteredConformers) : this.fillRawPool(this.poolRawGeneratedConformers);
        if (this.stateLastInvokeBuild == 2 || n == 0) {
            if (debug != null) {
                debug.println("Fail: state=" + this.stateLastInvokeBuild + " n=" + n);
            }
            return 0;
        }
        if (this.skipProxBlenEqCheck) {
            return n;
        }
        int r = this.poolRawGeneratedConformers.removeDuplicates(this, null, this.getDenergyLimit(), this.getMinRMSD(), this.cleanSettings);
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Removed " + r + " duplicates from raw pool");
        }
        this.poolRawGeneratedConformers.sortByEnergy();
        int nn = this.poolRawGeneratedConformers.filterSteric(this.poolFilteredConformers, this.poolSoftErrorBeforeOptimization, this.poolHardError, this.poolStereoError, effort.canceller, !reportAll && this.poolFilteredConformers.getOptimizeOnAddon() ? expectedConformers : -1, this.cleanSettings);
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Pools state", this.poolStateToString());
        }
        return n;
    }

    public void disableFallback() {
        if (CleanArgs.verboseLevel > 0) {
            CleanArgs.verbose("Disable fallback.");
        }
        this.fallbackEnabled = false;
    }

    public String poolStateToString() {
        return "poolFiltered: " + (this.poolFilteredConformers == null ? "NULL" : this.poolFilteredConformers.size() + " conf") + "<BR>" + "poolRawGenerated: " + (this.poolRawGeneratedConformers == null ? "NULL" : this.poolRawGeneratedConformers.size() + " conf") + "<BR>" + "poolSoftEBefore:  " + (this.poolSoftErrorBeforeOptimization == null ? "NULL" : this.poolSoftErrorBeforeOptimization.size() + " conf") + "<BR>" + "poolSoftEAfter:   " + (this.poolSoftErrorAfterOptimization == null ? "NULL" : this.poolSoftErrorAfterOptimization.size() + " conf") + "<BR>" + "poolHardE:        " + (this.poolHardError == null ? "NULL" : this.poolHardError.size() + " conf") + "<BR>" + "poolStereoE:      " + (this.poolStereoError == null ? "NULL" : this.poolStereoError.size() + " conf");
    }

    abstract boolean hasDirectBuildChildFailed();

    protected boolean hasDirectFragmentBuildChildFailed_0() {
        if (this.fallbackCommand != null) {
            return this.fallbackCommand.hasDirectFragmentBuildChildFailed_0();
        }
        return this.hasDirectBuildChildFailed();
    }

    protected abstract int fetchCoordinates(int var1, boolean var2, boolean var3, boolean var4, debugPrintout var5, BuildEffort var6);

    abstract int invokeBuild(int var1, BuildEffort var2);

    public int build(int expectedConformers, BuildEffort effort) {
        return this.build(expectedConformers, false, false, false, effort);
    }

    public int build(int expectedConformers, boolean reportAll, boolean flushPreselect, boolean optimizeAll, BuildEffort effort) {
        this.buildInProgress = true;
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("build( " + expectedConformers + ", ... )", "expectedConformers=" + expectedConformers + "<BR>" + "reportAll=" + reportAll + "<BR>" + "flushPreselect=" + flushPreselect + "<BR>" + "optimizeAll=" + optimizeAll + "<BR>" + "effort=" + effort.toString());
        }
        debugPrintout debug = CleanArgs.getDebug();
        this.setState(2);
        if (this.canceller != null && this.canceller.isCancelled()) {
            this.setState(3);
            this.buildInProgress = false;
            return this.getState();
        }
        if (this.maxBuildCounter >= 0) {
            if (this.maxBuildCounter == 0) {
                if (debug != null) {
                    debug.println("MAXBUILDCOUNTER=0, report fail");
                }
                if (this.cleanSettings.getInst() != null) {
                    this.cleanSettings.getInst().addFlag(new Instrumentation.MaxBuildCounterReachedFlag());
                }
                this.setState(2);
                this.buildInProgress = false;
                return this.getState();
            }
            --this.maxBuildCounter;
            if (debug != null) {
                debug.println("MAXBUILDCOUNTER=" + this.maxBuildCounter);
            }
        }
        int g = 0;
        long starttime = 0L;
        if (debug != null) {
            g = debug.beginGroup();
            String name = null;
            name = U.calcClassShortName(this);
            debug.incLevel(name);
            starttime = System.currentTimeMillis();
        }
        if (this.fallbackCommand == null) {
            int fcState;
            if (this.poolFilteredConformers == null) {
                this.poolFilteredConformers = new FragmentPool(this.getFragment(), optimizeAll && !this.getSkipProxBlenEqCheck(), this.getOptLimit(), optimizeAll && !this.getSkipProxBlenEqCheck(), this.getDenergyLimit(), this.getMinRMSD(), true);
            }
            if (this.poolRawGeneratedConformers == null) {
                this.poolRawGeneratedConformers = new FragmentPool(this.getFragment());
            }
            if (this.getFragment().isStereoSpecified() && this.poolStereoError == null) {
                this.poolStereoError = new FragmentPool(this.getFragment());
            }
            if (this.getSkipProxBlenEqCheck()) {
                int confct;
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Skip checks, call invoke build directly");
                }
                fcState = (confct = this.callInvokeBuild(expectedConformers, effort, reportAll)) > 0 ? 1 : 2;
            } else {
                fcState = this.fetchCoordinates(expectedConformers, reportAll, flushPreselect, optimizeAll, debug, effort);
            }
            this.setState(fcState);
            if (fcState == 1) {
                int news = this.poolFilteredConformers.size();
                this.poolFilteredConformers.sortByEnergy();
                if (!reportAll && news > expectedConformers) {
                    news = expectedConformers;
                }
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Report filtered conformers " + news);
                }
                this.reportFilteredConformers(news);
            }
            if (fcState == 2 && (this.getCoordinates() == null || this.getCoordinates().length == 0)) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Fail before any valid structure");
                }
                if (effort.isAllowFusebuildFB()) {
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("Effort enables fallback, sign require. FallbackEnabled=" + this.fallbackEnabled);
                    }
                    this.requestFallback = true;
                } else if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Effort disables fallback.");
                }
            }
        } else if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Fallback required, skip fetchCoordinates");
        }
        if (this.canceller != null && this.canceller.isCancelled()) {
            this.setState(3);
            this.buildInProgress = false;
            return this.getState();
        }
        if (this.requestFallback && this.fallbackEnabled) {
            if (CleanArgs.verboseLevel > 0) {
                CleanArgs.verbose("Processing fallback request.");
            }
            if (!this.hasDirectFragmentBuildChildFailed_0()) {
                if (CleanArgs.verboseLevel > 0) {
                    CleanArgs.verbose("Fallback situation in structure: ");
                    try {
                        CleanArgs.verbose(this.getOrigMol().getOriginalMolCopy().toFormat("smiles"));
                    }
                    catch (Exception e) {
                        System.err.println("Structure print failed.");
                        if (e.getMessage() != null) {
                            System.err.println("Exception: " + e.getMessage());
                        }
                        e.printStackTrace();
                    }
                    CleanArgs.verbose("Actual fragment: ");
                    try {
                        CleanArgs.verbose(this.getFragment().getFragMol().getOriginalMolCopy().toFormat("smiles"));
                    }
                    catch (Exception e) {
                        System.err.println("Structure print failed.");
                        if (e.getMessage() != null) {
                            System.err.println("Exception: " + e.getMessage());
                        }
                        e.printStackTrace();
                    }
                }
                this.requestFallback = false;
                if (debug != null) {
                    debug.printBC("Create fallback command");
                }
                BuildSequence.BuildFrag newcmd = new BuildSequence.BuildFrag(new IntSet(this.getCommand().getAtoms()), new IntSet(this.getCommand().getAnchAtoms()), new IntSet(this.getCommand().getNonAnchAtoms()), this.getCommand().getMol(), this.getCommand().getWholeStereo());
                if (debug != null) {
                    debug.printBC("Create build command");
                }
                this.fallbackCommand = FragClean.createDirectBuildCommand(null, this.cleanSettings, newcmd, this.getCommand().getMol(), debug);
                this.fallbackCommand.disableFallback();
                if (this.fallbackCommand == null) {
                    if (CleanArgs.verboseLevel > 0) {
                        CleanArgs.verbose("Fallback command not created.");
                    }
                    this.setState(2);
                    this.buildInProgress = false;
                    return this.getState();
                }
            } else {
                if (CleanArgs.verboseLevel > 0) {
                    CleanArgs.verbose("Will not fall back to direct build: direct fragment build child failed");
                }
                if (debug != null) {
                    debug.printBC("No fall back to direct build");
                }
            }
        }
        if (this.fallbackCommand != null) {
            int fbState = this.fallbackCommand.build(expectedConformers, reportAll, flushPreselect, optimizeAll, effort);
            this.coordinates = this.fallbackCommand.getCoordinates();
            this.energies = this.fallbackCommand.getEnergies();
            this.lastCoordinates = this.fallbackCommand.getMoreCoordinates();
            this.lastEnergies = this.fallbackCommand.getMoreEnergies();
            this.setState(fbState);
        }
        this.buildInProgress = false;
        if (debug != null) {
            debug.decLevel();
            debug.println("<B>" + this.getStateString() + "</B> in <B>" + (System.currentTimeMillis() - starttime) + "</B> ms");
            if (this.getState() == 1) {
                this.getFragment().getFragMol().place3DApplets("All coordinates", this.getCoordinates(), null);
                if (this.getCoordinates().length != this.getMoreCoordinates().length) {
                    this.getFragment().getFragMol().place3DApplets("More coordinates", this.getMoreCoordinates(), null);
                }
            }
            debug.endGroup(g);
        }
        return this.getState();
    }

    public int doHyperfine() {
        int i;
        VerbosePrinter vp = this.cleanSettings.getVerbosePrinter("Hyperfine", false);
        SimpleVerbosePrinter svp = this.cleanSettings.getVerbosePrinter(CleanSettings.Verbosers.HYPERFINE);
        Object fo = null;
        MolExporter me = null;
        this.lastCoordinates = null;
        this.lastEnergies = null;
        Fragment f = this.getFragment();
        myMolecule m = f.getFragMol();
        debugPrintout debug = CleanArgs.getDebug();
        Vector<double[][]> newc = new Vector<double[][]>();
        Vector<Double> newe = new Vector<Double>();
        double[][][] c = this.getCoordinates();
        if (vp != null) {
            vp.print("Entering hyperfine with " + c.length + " conformers");
        }
        if (svp.isVerbosityLevelEnabled(1)) {
            svp.print(1, "Starting hyperfine on " + c.length + " initial conformers");
        }
        double[] e = f.calcDreiding(c);
        for (i = 0; i < c.length; ++i) {
            VerbosePrinter vps = null;
            if (vp != null) {
                vps = vp.incDetail("Process conformer " + i + " E=" + e[i]);
            }
            if (svp.isVerbosityLevelEnabled(2)) {
                svp.print(2, "  Process initial conformer " + i + " initial E[" + i + "]=" + TextUtils.formatNumber(e[i]));
            }
            if (debug != null) {
                m.place3DApplet("Conformer " + i + " E=" + e[i], c[i]);
            }
            if (me != null) {
                Molecule mm = m.getOriginalMolCopy().cloneMolecule();
                mm.setProperty("CLEAN3D.HYPERFINE", "Original conformer " + i + " with energy " + e[i]);
                ConformersDescriptor.writeCoords(mm, c[i]);
                try {
                    me.write(mm);
                }
                catch (Exception ex) {
                    System.err.println("Unable to append to file");
                }
            }
            boolean newloop = false;
            int mdc = 0;
            while (newloop || mdc < 4) {
                boolean converged;
                ++mdc;
                double[][] cc = U.clone(c[i]);
                if (vps != null) {
                    vps.print("Run MD #" + mdc);
                }
                f.runControlledMD(cc, this.cleanSettings.getHyperfineMDSterpCount(), this.cleanSettings.getHyperfineMDTemperature(), this.cleanSettings);
                if (me != null) {
                    Molecule mm = m.getOriginalMolCopy().cloneMolecule();
                    mm.setProperty("CLEAN3D.HYPERFINE", "After MM returnerd");
                    ConformersDescriptor.writeCoords(mm, cc);
                    try {
                        me.write(mm);
                    }
                    catch (Exception ex) {
                        System.err.println("Unable to append to file");
                    }
                }
                if (vps != null) {
                    vps.print("MD returned. E=" + f.calcDreiding(cc));
                }
                double limit = 1.0E-4;
                double l2 = CleanArgs.OPT_LIMITS_VALUES[this.cleanSettings.getOptLimitFinalopt()];
                if (l2 < limit) {
                    limit = l2;
                }
                if (vps != null) {
                    vps.print("Optimize with limit=" + limit);
                }
                if (!(converged = f.optimizeDreiding(cc, limit))) {
                    if (vps == null) continue;
                    vps.print("Optimizer not converged.");
                    continue;
                }
                if (me != null) {
                    Molecule mm = m.getOriginalMolCopy().cloneMolecule();
                    mm.setProperty("CLEAN3D.HYPERFINE", "After optimized. Converged=" + converged);
                    ConformersDescriptor.writeCoords(mm, cc);
                    try {
                        me.write(mm);
                    }
                    catch (Exception ex) {
                        System.err.println("Unable to append to file");
                    }
                }
                double opte = f.calcDreiding(cc);
                if (vps != null) {
                    vps.print("Optimized. E=" + opte);
                }
                if (debug != null) {
                    m.place3DApplet("After OPT E=" + opte, cc);
                }
                if (this.canceller != null && this.canceller.isCancelled()) {
                    if (vp != null) {
                        vp.print("CANCEL, return");
                    }
                    if (me != null) {
                        try {
                            me.close();
                        }
                        catch (Exception ex) {
                            System.err.println("Unable to close MolExproter.");
                        }
                    }
                    this.setState(3);
                    return this.getState();
                }
                if (vps != null) {
                    vps.print("Check for equivalences");
                }
                newloop = true;
                for (int j = 0; j < newc.size(); ++j) {
                    double[][] cs = (double[][])newc.get(j);
                    boolean equivalents = f.isEquivalent(cc, cs, this.minrmsd);
                    if (!equivalents) continue;
                    double storede = (Double)newe.get(j);
                    if (vps != null) {
                        vps.print("Equivalent with previously found #" + j + " previous E=" + storede + " new E=" + opte);
                    }
                    newloop = false;
                    boolean replace = false;
                    if (storede > opte) {
                        replace = true;
                        newc.set(j, cc);
                        newe.set(j, new Double(opte));
                        if (vps != null) {
                            vps.print("Overwritten previous with smaller energy new");
                        }
                        if (!svp.isVerbosityLevelEnabled(2)) break;
                        svp.print(2, "    (Already identified conformer found with lower energy) E'[" + j + "]=" + TextUtils.formatNumber(opte));
                        break;
                    }
                    if (!svp.isVerbosityLevelEnabled(3)) break;
                    svp.print(3, "    (No new conformer) Equivalent with conformer " + j);
                    break;
                }
                if (!newloop) continue;
                newc.add(cc);
                newe.add(new Double(opte));
                mdc = 0;
                if (vps != null) {
                    vps.print("New conformer; add as " + newc.size());
                }
                if (!svp.isVerbosityLevelEnabled(2)) continue;
                svp.print(2, "    Identified new conformer. E'[" + (newc.size() - 1) + "]=" + TextUtils.formatNumber(opte));
            }
        }
        this.coordinates = new double[newc.size()][][];
        for (i = 0; i < newc.size(); ++i) {
            this.coordinates[i] = (double[][])newc.get(i);
        }
        this.energies = f.calcDreiding(this.coordinates);
        if (debug != null) {
            debug.decLevel();
            f.getFragMol().place3DApplets("Results", this.coordinates, null);
        }
        if (vp != null) {
            vp.print("Hyperfine done. Generated " + newc.size() + " coordinates");
        }
        if (svp.isVerbosityLevelEnabled(1)) {
            svp.print(1, "Identified " + newc.size() + " conformers");
        }
        if (me != null) {
            try {
                me.close();
            }
            catch (Exception ex) {
                System.err.println("Unable to close MolExproter.");
            }
        }
        return this.getState();
    }

    abstract void initProgressMonitor();

    public void setVerbosePrinter(SimpleVerbosePrinter verbosePrinter) {
        if (this.verbosePrinter != null) {
            throw new IllegalMonitorStateException("Verbose printer can be set once.");
        }
        this.verbosePrinter = verbosePrinter;
    }

    public void setProgressMonitor(ProgressMonitor pm) {
        this.pm = pm;
        this.initProgressMonitor();
        if (this.subtrees != null) {
            int n = 1 + this.subtrees.size();
            double[] weights = new double[n];
            weights[n - 1] = this.ownWeight;
            for (int i = 0; i < n - 1; ++i) {
                weights[i] = (Double)this.subtreeWeights.get(i);
            }
            ProgressMonitor[] pms = ProgressTools.forkPM(pm, weights, null);
            this.ownpm = pms[n - 1];
            for (int i = 0; i < n - 1; ++i) {
                ((BuildCommand)this.subtrees.get(i)).setProgressMonitor(pms[i]);
            }
        }
    }

    public void setCanceller(SimpleCanceller c) {
        this.canceller = c;
        if (this.subtrees != null) {
            for (int i = 0; i < this.subtrees.size(); ++i) {
                ((BuildCommand)this.subtrees.get(i)).setCanceller(this.canceller);
            }
        }
    }

    public boolean isCancelled() {
        if (this.canceller != null && this.canceller.isCancelled()) {
            if (CleanArgs.verboseLevel > 0) {
                CleanArgs.verbose("Cancelled");
            }
            this.setState(3);
            return true;
        }
        return false;
    }

    public SimpleCanceller getCanceller() {
        return this.canceller;
    }

    protected void setParentCommand(BuildCommand parent) {
        if (this.parentCommand != null) {
            System.err.println("ERROR! Reinvoking setParentCommand()");
        }
        this.parentCommand = parent;
    }

    public BuildCommand getParentCommand() {
        return this.parentCommand;
    }

    protected void addSubtree(BuildCommand subtree) {
        this.subtrees.add(subtree);
    }

    public static class BuildEffort
    implements SimpleCanceller {
        private boolean allowNewBuildRun = false;
        private boolean allowOptimization = false;
        private boolean allowMD = false;
        private boolean allowFusebuildFB = false;
        private SimpleCanceller canceller = null;
        public BuildEffort LIGHTEST;
        public BuildEffort HEAVYEST;

        public BuildEffort(boolean newBuildRun, boolean optimization, boolean md, boolean fusefb, SimpleCanceller c) {
            this(newBuildRun, optimization, md, fusefb, c, null, null);
            this.LIGHTEST = new BuildEffort(false, false, false, false, c, null, null);
            this.HEAVYEST = new BuildEffort(true, true, true, true, c, null, null);
            this.LIGHTEST.LIGHTEST = this.LIGHTEST;
            this.LIGHTEST.HEAVYEST = this.HEAVYEST;
            this.HEAVYEST.LIGHTEST = this.LIGHTEST;
            this.HEAVYEST.HEAVYEST = this.HEAVYEST;
        }

        protected BuildEffort(boolean newBuildRun, boolean optimization, boolean md, boolean fusebfb, SimpleCanceller c, BuildEffort li, BuildEffort he) {
            this.allowMD = md;
            this.allowNewBuildRun = newBuildRun;
            this.allowOptimization = optimization;
            this.allowFusebuildFB = false;
            this.canceller = c;
            this.LIGHTEST = li;
            this.HEAVYEST = he;
        }

        public boolean isAllowReThrow() {
            return true;
        }

        public boolean isAllowMD() {
            return this.allowMD;
        }

        public boolean isAllowNewBuildRun() {
            return this.allowNewBuildRun;
        }

        public boolean isAllowOptimization() {
            return this.allowOptimization;
        }

        public boolean isAllowFusebuildFB() {
            return this.allowFusebuildFB;
        }

        public String toString() {
            String ret = "";
            if (this.equals(this.HEAVYEST)) {
                ret = ret + "HEAVYEST: ";
            }
            if (this.equals(this.LIGHTEST)) {
                ret = ret + "LIGHTEST: ";
            }
            if (this.isAllowOptimization()) {
                ret = ret + "+optimization ";
            }
            if (this.isAllowMD()) {
                ret = ret + "+MD ";
            }
            if (this.isAllowFusebuildFB()) {
                ret = ret + "+FusebuildFB ";
            }
            if (this.isAllowNewBuildRun()) {
                ret = ret + "+NewBuildRun ";
            }
            return ret;
        }

        public boolean isNarrowerThan(BuildEffort e) {
            if (!this.isAllowMD() && e.isAllowMD()) {
                return true;
            }
            if (!this.isAllowNewBuildRun() && e.isAllowNewBuildRun()) {
                return true;
            }
            if (!this.isAllowOptimization() && e.isAllowOptimization()) {
                return true;
            }
            return !this.isAllowFusebuildFB() && e.isAllowFusebuildFB();
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.allowNewBuildRun ? 1 : 0);
            hash = 79 * hash + (this.allowOptimization ? 1 : 0);
            hash = 79 * hash + (this.allowMD ? 1 : 0);
            hash = 79 * hash + (this.allowFusebuildFB ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BuildEffort)) {
                return false;
            }
            BuildEffort e = (BuildEffort)obj;
            if (this.isAllowMD() != e.isAllowMD()) {
                return false;
            }
            if (this.isAllowNewBuildRun() != e.isAllowNewBuildRun()) {
                return false;
            }
            if (this.isAllowOptimization() != e.isAllowOptimization()) {
                return false;
            }
            return this.isAllowFusebuildFB() == e.isAllowFusebuildFB();
        }

        @Override
        public boolean isCancelled() {
            if (this.canceller == null) {
                return false;
            }
            return this.canceller.isCancelled();
        }
    }
}

