/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.build.BuildCommand;
import chemaxon.marvin.modelling.build.BuildCommandBase;
import chemaxon.marvin.modelling.build.BuildSequence;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.struc.Substructure3DSearch;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.struc.Molecule;

public class BuildCommandProxy
extends BuildCommand {
    private BuildCommand baseCommand = null;
    private BuildSequence.Build cmd = null;
    private int[] permTable = null;
    private int[] secondPerm = null;
    int reportedConformerCount = 0;

    @Override
    boolean hasDirectBuildChildFailed() {
        return this.baseCommand.hasDirectFragmentBuildChildFailed_0();
    }

    public BuildCommandProxy(BuildCommand parentCommand, BuildCommand baseCommand, BuildSequence.ProxyBuild cmd) {
        super(baseCommand.cleanSettings);
        this.baseCommand = baseCommand;
        this.cmd = cmd;
        this.permTable = cmd.getAtomperm();
        this.setParentCommand(parentCommand);
        this.addSubtree(baseCommand);
        this.doSkipProxBlenEqCheck();
    }

    @Override
    void initProgressMonitor() {
    }

    @Override
    myMolecule getOrigMol() {
        return this.baseCommand.getOrigMol();
    }

    @Override
    BuildSequence.Build getCommand() {
        return this.cmd;
    }

    @Override
    int invokeBuild(int expectedConformerCount, BuildCommandBase.BuildEffort effort) {
        if (CleanArgs.verboseLevel > 0) {
            CleanArgs.verboseInc("Proxy invoked");
        }
        int state = this.invokeBuild_0(expectedConformerCount, effort);
        if (CleanArgs.verboseLevel > 0) {
            CleanArgs.verboseDec("Done:" + BuildCommandProxy.getStateString(state));
        }
        return state;
    }

    int invokeBuild_0(int expectedConformerCount, BuildCommandBase.BuildEffort effort) {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.printB("Proxy invokeBuild()");
        }
        double[][][] baseconfs = this.baseCommand.getCoordinates();
        int baseConfCount = 0;
        if (baseconfs != null) {
            baseConfCount = baseconfs.length;
        }
        if (baseConfCount <= this.reportedConformerCount) {
            if (debug != null) {
                debug.printB("Invoke unerlying build");
            }
            int ret = this.baseCommand.build(expectedConformerCount - baseConfCount + this.reportedConformerCount, effort);
            if (debug != null) {
                // empty if block
            }
            if (ret != 1) {
                return ret;
            }
        }
        baseconfs = this.baseCommand.getCoordinates();
        baseConfCount = 0;
        if (baseconfs != null) {
            baseConfCount = baseconfs.length;
        }
        if (baseConfCount <= this.reportedConformerCount) {
            System.err.println("Warning! Inconsystent proxy build command.");
            return 2;
        }
        if (debug != null) {
            debug.println("Report " + (baseConfCount - this.reportedConformerCount) + " cached conformers");
        }
        double[][][] newc = new double[baseConfCount - this.reportedConformerCount][][];
        double[] newe = new double[baseConfCount - this.reportedConformerCount];
        double[] basee = this.baseCommand.getEnergies();
        for (int i = 0; i < newc.length; ++i) {
            if (this.secondPerm == null) {
                if (debug != null) {
                    debug.printBC("Generating second permutation");
                }
                myMolecule basemol = this.baseCommand.getFragment().getFragMol();
                Molecule cxbasemol = basemol.getOriginalMolCopy();
                myMolecule thismol = this.getFragment().getFragMol();
                Molecule cxthismol = thismol.getOriginalMolCopy();
                double[][] baseconf = baseconfs[this.reportedConformerCount + i];
                Substructure3DSearch gSSS = new Substructure3DSearch();
                gSSS.setMolecules(cxbasemol, cxthismol);
                gSSS.setQueryCoordinates(baseconf);
                gSSS.setIgnoreExactMatching(false);
                gSSS.setIgnoreGeometryConstraints(false);
                if (!gSSS.findFirst()) {
                    if (debug != null) {
                        debug.printBC("Remap error");
                        basemol.place3DApplet("Basemol actual", baseconf);
                    }
                    System.err.println("Remap error 1.");
                    throw new IndexOutOfBoundsException();
                }
                this.secondPerm = gSSS.getResult();
                if (debug != null) {
                    debug.printBC("Geometry mapping was succesful.");
                    basemol.place3DApplet("Basemol actual", baseconf);
                    double[][] permconf = new double[this.secondPerm.length][];
                    for (int j = 0; j < this.secondPerm.length; ++j) {
                        permconf[j] = (double[])baseconfs[this.reportedConformerCount + i][this.secondPerm[j]].clone();
                    }
                    thismol.place3DApplet("Permutated", permconf);
                }
            }
            newc[i] = new double[this.permTable.length][];
            newe[i] = basee[this.reportedConformerCount + i];
            if (this.secondPerm.length != this.permTable.length || this.permTable.length != this.getFragment().getFragMol().a) {
                System.err.println("Consistency error in proxy");
                throw new NullPointerException();
            }
            for (int j = 0; j < this.secondPerm.length; ++j) {
                newc[i][this.secondPerm[j]] = (double[])baseconfs[this.reportedConformerCount + i][j].clone();
            }
        }
        this.registerCoordinates(newc);
        this.registerEnergies(newe);
        this.reportedConformerCount = baseConfCount;
        return 1;
    }
}

